/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.Environment;
import com.sleepycat.je.Transaction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BDBUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(BDBUtils.class);
    public static final DatabaseConfig DEFAULT_DATABASE_CONFIG = new DatabaseConfig().setTransactional(true).setAllowCreate(true);
    private static final Pattern NON_REP_JE_PARAM_PATTERN = Pattern.compile("^je\\.(?!rep\\.).*");
    private static final Pattern REP_JE_PARAM_PATTERN = Pattern.compile("^je\\.rep\\..*");

    public static void abortTransactionSafely(Transaction tx, EnvironmentFacade environmentFacade) {
        try {
            if (tx != null) {
                tx.abort();
            }
        }
        catch (RuntimeException e) {
            environmentFacade.handleDatabaseException("Cannot abort transaction", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void runCleaner(Environment environment) {
        if (environment == null || !environment.isValid()) {
            return;
        }
        boolean cleanerWasRunning = Boolean.parseBoolean(environment.getConfig().getConfigParam("je.env.runCleaner"));
        try {
            if (cleanerWasRunning) {
                environment.getConfig().setConfigParam("je.env.runCleaner", Boolean.FALSE.toString());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Cleaning logs");
            }
            boolean cleaned = false;
            while (environment.cleanLog() > 0) {
                cleaned = true;
            }
            if (cleaned) {
                LOGGER.debug("Cleaned log");
                CheckpointConfig force = new CheckpointConfig();
                force.setForce(true);
                environment.checkpoint(force);
                LOGGER.debug("Checkpoint force complete");
            }
        }
        finally {
            if (cleanerWasRunning) {
                environment.getConfig().setConfigParam("je.env.runCleaner", Boolean.TRUE.toString());
            }
        }
    }

    public static Map<String, String> getReplicatedEnvironmentConfigurationParameters(ConfiguredObject<?> object) {
        return Collections.unmodifiableMap(BDBUtils.getContextSettingsWithNameMatchingRegExpPattern(object, REP_JE_PARAM_PATTERN));
    }

    public static Map<String, String> getEnvironmentConfigurationParameters(ConfiguredObject<?> object) {
        Map<String, String> parameters = BDBUtils.getContextSettingsWithNameMatchingRegExpPattern(object, NON_REP_JE_PARAM_PATTERN);
        if (!parameters.containsKey("je.maxMemory") && !parameters.containsKey("je.maxMemoryPercent")) {
            parameters.put("je.maxMemory", String.valueOf(0xA00000L));
        }
        return Collections.unmodifiableMap(parameters);
    }

    private static Map<String, String> getContextSettingsWithNameMatchingRegExpPattern(ConfiguredObject<?> object, Pattern pattern) {
        HashMap<String, String> targetMap = new HashMap<String, String>();
        for (String name : object.getContextKeys(false)) {
            if (!pattern.matcher(name).matches()) continue;
            String contextValue = (String)object.getContextValue(String.class, name);
            targetMap.put(name, contextValue);
        }
        return targetMap;
    }

    public static CacheMode getCacheMode(ConfiguredObject<?> object) {
        if (object.getContextKeys(false).contains("qpid.bdb.cache_mode")) {
            try {
                return (CacheMode)object.getContextValue(CacheMode.class, "qpid.bdb.cache_mode");
            }
            catch (IllegalArgumentException iae) {
                LOGGER.warn("Failed to parse {} as {}", new Object[]{object.getContextValue(String.class, "qpid.bdb.cache_mode"), CacheMode.class, iae});
            }
        }
        return EnvironmentFacade.CACHE_MODE_DEFAULT;
    }

    public static <T> T getContextValue(ConfiguredObject<?> parent, Class<T> paremeterClass, String parameterName, T defaultValue) {
        if (parent.getContextKeys(false).contains(parameterName)) {
            return (T)parent.getContextValue(paremeterClass, parameterName);
        }
        return defaultValue;
    }
}

