/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.FileBasedSettings;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.MessageStoreProvider;
import org.apache.qpid.server.store.SizeMonitoringSettings;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.berkeleydb.AbstractBDBMessageStore;
import org.apache.qpid.server.store.berkeleydb.AbstractBDBPreferenceStore;
import org.apache.qpid.server.store.berkeleydb.BDBConfiguredObjectRecord;
import org.apache.qpid.server.store.berkeleydb.BDBUtils;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacade;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacadeFactory;
import org.apache.qpid.server.store.berkeleydb.StandardEnvironmentFacadeFactory;
import org.apache.qpid.server.store.berkeleydb.entry.HierarchyKey;
import org.apache.qpid.server.store.berkeleydb.tuple.ConfiguredObjectBinding;
import org.apache.qpid.server.store.berkeleydb.tuple.HierarchyKeyBinding;
import org.apache.qpid.server.store.berkeleydb.tuple.UUIDTupleBinding;
import org.apache.qpid.server.store.handler.ConfiguredObjectRecordHandler;
import org.apache.qpid.server.store.preferences.PreferenceRecord;
import org.apache.qpid.server.store.preferences.PreferenceStore;
import org.apache.qpid.server.store.preferences.PreferenceStoreUpdater;
import org.apache.qpid.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BDBConfigurationStore
implements MessageStoreProvider,
DurableConfigurationStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(BDBConfigurationStore.class);
    public static final int VERSION = 9;
    private static final String CONFIGURED_OBJECTS_DB_NAME = "CONFIGURED_OBJECTS";
    private static final String CONFIGURED_OBJECT_HIERARCHY_DB_NAME = "CONFIGURED_OBJECT_HIERARCHY";
    private State _state = State.CLOSED;
    private final Object _lock = new Object();
    private final EnvironmentFacadeFactory _environmentFacadeFactory;
    private final ProvidedBDBMessageStore _providedMessageStore = new ProvidedBDBMessageStore();
    private final ProvidedBDBPreferenceStore _providedPreferenceStore = new ProvidedBDBPreferenceStore();
    private EnvironmentFacade _environmentFacade;
    private ConfiguredObject<?> _parent;
    private final Class<? extends ConfiguredObject> _rootClass;

    public BDBConfigurationStore(Class<? extends ConfiguredObject> rootClass) {
        this(new StandardEnvironmentFacadeFactory(), rootClass);
    }

    public BDBConfigurationStore(EnvironmentFacadeFactory environmentFacadeFactory, Class<? extends ConfiguredObject> rootClass) {
        this._environmentFacadeFactory = environmentFacadeFactory;
        this._rootClass = rootClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ConfiguredObject<?> parent) {
        Object object = this._lock;
        synchronized (object) {
            if (this._state == State.OPEN && this._parent == parent) {
                this._state = State.CONFIGURED;
            } else if (this._state == State.CONFIGURED && this._parent == parent) {
                this._state = State.CONFIGURED;
            } else {
                this.changeState(State.CLOSED, State.CONFIGURED);
                this._parent = parent;
                if (this._environmentFacade == null) {
                    this._environmentFacade = this._environmentFacadeFactory.createEnvironmentFacade(parent);
                } else {
                    throw new IllegalStateException("The database have been already opened as message store");
                }
            }
        }
    }

    public String getState() {
        return this._state.toString();
    }

    public void upgradeStoreStructure() throws StoreException {
        try {
            this._environmentFacade.upgradeIfNecessary(this._parent);
        }
        catch (RuntimeException e) {
            throw this._environmentFacade.handleDatabaseException("Cannot upgrade store", e);
        }
    }

    public boolean openConfigurationStore(ConfiguredObjectRecordHandler handler, ConfiguredObjectRecord ... initialRecords) {
        this.changeState(State.CONFIGURED, State.OPEN);
        try {
            Collection<? extends ConfiguredObjectRecord> records = this.doVisitAllConfiguredObjectRecords();
            boolean empty = records.isEmpty();
            if (empty) {
                records = Arrays.asList(initialRecords);
                Transaction txn = null;
                try {
                    txn = this._environmentFacade.beginTransaction(null);
                    for (ConfiguredObjectRecord configuredObjectRecord : records) {
                        this.update(true, configuredObjectRecord, txn);
                    }
                    txn.commit();
                    txn = null;
                }
                catch (RuntimeException runtimeException) {
                    throw this._environmentFacade.handleDatabaseException("Error updating configuration details within the store: " + runtimeException, runtimeException);
                }
                finally {
                    if (txn != null) {
                        BDBUtils.abortTransactionSafely(txn, this._environmentFacade);
                    }
                }
            }
            for (ConfiguredObjectRecord configuredObjectRecord : records) {
                handler.handle(configuredObjectRecord);
            }
            return empty;
        }
        catch (RuntimeException e) {
            throw this._environmentFacade.handleDatabaseException("Cannot visit configured object records", e);
        }
    }

    public void reload(ConfiguredObjectRecordHandler handler) {
        this.assertState(State.OPEN);
        try {
            Collection<? extends ConfiguredObjectRecord> records = this.doVisitAllConfiguredObjectRecords();
            for (ConfiguredObjectRecord configuredObjectRecord : records) {
                handler.handle(configuredObjectRecord);
            }
        }
        catch (RuntimeException e) {
            throw this._environmentFacade.handleDatabaseException("Cannot visit configured object records", e);
        }
    }

    private Collection<? extends ConfiguredObjectRecord> doVisitAllConfiguredObjectRecords() {
        HashMap<UUID, BDBConfiguredObjectRecord> configuredObjects = new HashMap<UUID, BDBConfiguredObjectRecord>();
        try (Cursor objectsCursor = this.getConfiguredObjectsDb().openCursor(null, null);){
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            while (objectsCursor.getNext(key, value, LockMode.READ_UNCOMMITTED) == OperationStatus.SUCCESS) {
                UUID id = (UUID)UUIDTupleBinding.getInstance().entryToObject(key);
                BDBConfiguredObjectRecord configuredObject = (BDBConfiguredObjectRecord)new ConfiguredObjectBinding(id).entryToObject(value);
                configuredObjects.put(configuredObject.getId(), configuredObject);
            }
            try (Cursor hierarchyCursor = this.getConfiguredObjectHierarchyDb().openCursor(null, null);){
                while (hierarchyCursor.getNext(key, value, LockMode.READ_UNCOMMITTED) == OperationStatus.SUCCESS) {
                    ConfiguredObjectRecord parent;
                    HierarchyKey hk = (HierarchyKey)HierarchyKeyBinding.getInstance().entryToObject(key);
                    UUID parentId = (UUID)UUIDTupleBinding.getInstance().entryToObject(value);
                    BDBConfiguredObjectRecord child = (BDBConfiguredObjectRecord)configuredObjects.get(hk.getChildId());
                    if (child == null || (parent = (ConfiguredObjectRecord)configuredObjects.get(parentId)) == null) continue;
                    child.addParent(hk.getParentType(), parent);
                }
            }
        }
        return configuredObjects.values();
    }

    public EnvironmentFacade getEnvironmentFacade() {
        return this._environmentFacade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConfigurationStore() throws StoreException {
        Object object = this._lock;
        synchronized (object) {
            this._state = State.CLOSED;
        }
        if (!this._providedMessageStore.isMessageStoreOpen()) {
            this.closeEnvironment();
        }
    }

    private void closeEnvironment() {
        if (this._environmentFacade != null) {
            try {
                this._environmentFacade.close();
                this._environmentFacade = null;
            }
            catch (RuntimeException e) {
                throw new StoreException("Exception occurred on message store close", (Throwable)e);
            }
        }
    }

    public void create(ConfiguredObjectRecord configuredObject) throws StoreException {
        this.assertState(State.OPEN);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Create " + configuredObject);
        }
        Transaction txn = null;
        try {
            txn = this._environmentFacade.beginTransaction(null);
            this.storeConfiguredObjectEntry(txn, configuredObject);
            txn.commit();
            txn = null;
        }
        catch (RuntimeException e) {
            throw this._environmentFacade.handleDatabaseException("Error creating configured object " + configuredObject + " in database: " + e.getMessage(), e);
        }
        finally {
            if (txn != null) {
                BDBUtils.abortTransactionSafely(txn, this._environmentFacade);
            }
        }
    }

    public UUID[] remove(ConfiguredObjectRecord ... objects) throws StoreException {
        this.assertState(State.OPEN);
        Transaction txn = null;
        try {
            txn = this._environmentFacade.beginTransaction(null);
            ArrayList<UUID> removed = new ArrayList<UUID>(objects.length);
            for (ConfiguredObjectRecord record : objects) {
                if (this.removeConfiguredObject(txn, record) != OperationStatus.SUCCESS) continue;
                removed.add(record.getId());
            }
            txn.commit();
            txn = null;
            UUID[] uUIDArray = removed.toArray(new UUID[removed.size()]);
            return uUIDArray;
        }
        catch (RuntimeException e) {
            throw this._environmentFacade.handleDatabaseException("Error deleting configured objects from database", e);
        }
        finally {
            if (txn != null) {
                BDBUtils.abortTransactionSafely(txn, this._environmentFacade);
            }
        }
    }

    public void update(boolean createIfNecessary, ConfiguredObjectRecord ... records) throws StoreException {
        this.assertState(State.OPEN);
        Transaction txn = null;
        try {
            txn = this._environmentFacade.beginTransaction(null);
            for (ConfiguredObjectRecord record : records) {
                this.update(createIfNecessary, record, txn);
            }
            txn.commit();
            txn = null;
        }
        catch (RuntimeException e) {
            throw this._environmentFacade.handleDatabaseException("Error updating configuration details within the store: " + e, e);
        }
        finally {
            if (txn != null) {
                BDBUtils.abortTransactionSafely(txn, this._environmentFacade);
            }
        }
    }

    private void update(boolean createIfNecessary, ConfiguredObjectRecord record, Transaction txn) throws StoreException {
        boolean isNewRecord;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Updating, creating " + createIfNecessary + " : " + record);
        }
        DatabaseEntry key = new DatabaseEntry();
        UUIDTupleBinding keyBinding = UUIDTupleBinding.getInstance();
        keyBinding.objectToEntry(record.getId(), key);
        DatabaseEntry value = new DatabaseEntry();
        DatabaseEntry newValue = new DatabaseEntry();
        ConfiguredObjectBinding configuredObjectBinding = ConfiguredObjectBinding.getInstance();
        OperationStatus status = this.getConfiguredObjectsDb().get(txn, key, value, LockMode.DEFAULT);
        boolean bl = isNewRecord = status == OperationStatus.NOTFOUND;
        if (status == OperationStatus.SUCCESS || createIfNecessary && isNewRecord) {
            configuredObjectBinding.objectToEntry(record, newValue);
            status = this.getConfiguredObjectsDb().put(txn, key, newValue);
            if (status != OperationStatus.SUCCESS) {
                throw new StoreException("Error updating configuration details within the store: " + status);
            }
            if (isNewRecord) {
                this.writeHierarchyRecords(txn, record);
            }
        } else if (status != OperationStatus.NOTFOUND) {
            throw new StoreException("Error finding configuration details within the store: " + status);
        }
    }

    private void storeConfiguredObjectEntry(Transaction txn, ConfiguredObjectRecord configuredObject) throws StoreException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Storing configured object record: " + configuredObject);
        }
        DatabaseEntry key = new DatabaseEntry();
        UUIDTupleBinding uuidBinding = UUIDTupleBinding.getInstance();
        uuidBinding.objectToEntry(configuredObject.getId(), key);
        DatabaseEntry value = new DatabaseEntry();
        ConfiguredObjectBinding queueBinding = ConfiguredObjectBinding.getInstance();
        queueBinding.objectToEntry(configuredObject, value);
        try {
            OperationStatus status = this.getConfiguredObjectsDb().put(txn, key, value);
            if (status != OperationStatus.SUCCESS) {
                throw new StoreException("Error writing configured object " + configuredObject + " to database: " + status);
            }
            this.writeHierarchyRecords(txn, configuredObject);
        }
        catch (RuntimeException e) {
            throw this._environmentFacade.handleDatabaseException("Error writing configured object " + configuredObject + " to database: " + e.getMessage(), e);
        }
    }

    private void writeHierarchyRecords(Transaction txn, ConfiguredObjectRecord configuredObject) {
        HierarchyKeyBinding hierarchyBinding = HierarchyKeyBinding.getInstance();
        DatabaseEntry hierarchyKey = new DatabaseEntry();
        DatabaseEntry hierarchyValue = new DatabaseEntry();
        for (Map.Entry parent : configuredObject.getParents().entrySet()) {
            hierarchyBinding.objectToEntry(new HierarchyKey(configuredObject.getId(), (String)parent.getKey()), hierarchyKey);
            UUIDTupleBinding.getInstance().objectToEntry(parent.getValue(), hierarchyValue);
            OperationStatus status = this.getConfiguredObjectHierarchyDb().put(txn, hierarchyKey, hierarchyValue);
            if (status == OperationStatus.SUCCESS) continue;
            throw new StoreException("Error writing configured object " + configuredObject + " parent record to database: " + status);
        }
    }

    private OperationStatus removeConfiguredObject(Transaction tx, ConfiguredObjectRecord record) throws StoreException {
        UUID id = record.getId();
        Map parents = record.getParents();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Removing configured object: " + id);
        }
        DatabaseEntry key = new DatabaseEntry();
        UUIDTupleBinding uuidBinding = UUIDTupleBinding.getInstance();
        uuidBinding.objectToEntry(id, key);
        OperationStatus status = this.getConfiguredObjectsDb().delete(tx, key);
        if (status == OperationStatus.SUCCESS) {
            for (String parentType : parents.keySet()) {
                DatabaseEntry hierarchyKey = new DatabaseEntry();
                HierarchyKeyBinding keyBinding = HierarchyKeyBinding.getInstance();
                keyBinding.objectToEntry(new HierarchyKey(record.getId(), parentType), hierarchyKey);
                this.getConfiguredObjectHierarchyDb().delete(tx, hierarchyKey);
            }
        }
        return status;
    }

    public MessageStore getMessageStore() {
        return this._providedMessageStore;
    }

    public PreferenceStore getPreferenceStore() {
        return this._providedPreferenceStore;
    }

    public void onDelete(ConfiguredObject<?> parent) {
        FileBasedSettings fileBasedSettings = (FileBasedSettings)parent;
        String storePath = fileBasedSettings.getStorePath();
        if (storePath != null) {
            File configFile;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Deleting store " + storePath);
            }
            if (!FileUtils.delete((File)(configFile = new File(storePath)), (boolean)true)) {
                LOGGER.info("Failed to delete the store at location " + storePath);
            }
        }
    }

    private Database getConfiguredObjectsDb() {
        return this._environmentFacade.openDatabase(CONFIGURED_OBJECTS_DB_NAME, BDBUtils.DEFAULT_DATABASE_CONFIG);
    }

    private Database getConfiguredObjectHierarchyDb() {
        return this._environmentFacade.openDatabase(CONFIGURED_OBJECT_HIERARCHY_DB_NAME, BDBUtils.DEFAULT_DATABASE_CONFIG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertState(State state) {
        Object object = this._lock;
        synchronized (object) {
            if (this._state != state) {
                throw new IllegalStateException("The store must be in state " + (Object)((Object)state) + " to perform this operation, but it is in state " + (Object)((Object)this._state) + " instead");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(State oldState, State newState) {
        Object object = this._lock;
        synchronized (object) {
            this.assertState(oldState);
            this._state = newState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this._lock;
        synchronized (object) {
            return this._state == State.OPEN;
        }
    }

    private class ProvidedBDBPreferenceStore
    extends AbstractBDBPreferenceStore {
        private ProvidedBDBPreferenceStore() {
        }

        @Override
        public Collection<PreferenceRecord> openAndLoad(PreferenceStoreUpdater updater) throws StoreException {
            return super.openAndLoad(updater);
        }

        @Override
        protected void doDelete() {
        }

        @Override
        protected void doClose() {
        }

        @Override
        protected EnvironmentFacade getEnvironmentFacade() {
            return BDBConfigurationStore.this._environmentFacade;
        }

        @Override
        protected Logger getLogger() {
            return LOGGER;
        }
    }

    class ProvidedBDBMessageStore
    extends AbstractBDBMessageStore {
        private final AtomicBoolean _messageStoreOpen = new AtomicBoolean();
        private long _persistentSizeLowThreshold;
        private long _persistentSizeHighThreshold;
        private ConfiguredObject<?> _parent;

        ProvidedBDBMessageStore() {
        }

        public void openMessageStore(ConfiguredObject<?> parent) {
            if (this._messageStoreOpen.compareAndSet(false, true)) {
                this._parent = parent;
                SizeMonitoringSettings sizeMonitorSettings = (SizeMonitoringSettings)parent;
                this._persistentSizeHighThreshold = sizeMonitorSettings.getStoreOverfullSize();
                this._persistentSizeLowThreshold = sizeMonitorSettings.getStoreUnderfullSize();
                if (this._persistentSizeLowThreshold > this._persistentSizeHighThreshold || this._persistentSizeLowThreshold < 0L) {
                    this._persistentSizeLowThreshold = this._persistentSizeHighThreshold;
                }
            }
        }

        public boolean isMessageStoreOpen() {
            return this._messageStoreOpen.get();
        }

        @Override
        public void closeMessageStore() {
            super.closeMessageStore();
            this._messageStoreOpen.set(false);
        }

        @Override
        public EnvironmentFacade getEnvironmentFacade() {
            return BDBConfigurationStore.this._environmentFacade;
        }

        public void onDelete(ConfiguredObject<?> parent) {
        }

        public String getStoreLocation() {
            return ((FileBasedSettings)BDBConfigurationStore.this._parent).getStorePath();
        }

        public File getStoreLocationAsFile() {
            return new File(this.getStoreLocation());
        }

        @Override
        protected long getPersistentSizeLowThreshold() {
            return this._persistentSizeLowThreshold;
        }

        @Override
        protected long getPersistentSizeHighThreshold() {
            return this._persistentSizeHighThreshold;
        }

        @Override
        protected ConfiguredObject<?> getParent() {
            return this._parent;
        }

        @Override
        protected void checkMessageStoreOpen() {
            if (!this._messageStoreOpen.get()) {
                throw new IllegalStateException("Message store is not open");
            }
        }

        @Override
        protected Logger getLogger() {
            return LOGGER;
        }
    }

    static enum State {
        CLOSED,
        CONFIGURED,
        OPEN;

    }
}

