/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport.websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.transport.AcceptingTransport;
import org.apache.qpid.server.transport.AggregateTicker;
import org.apache.qpid.server.transport.MultiVersionProtocolEngine;
import org.apache.qpid.server.transport.MultiVersionProtocolEngineFactory;
import org.apache.qpid.server.transport.ProtocolEngine;
import org.apache.qpid.server.transport.SchedulingDelayNotificationListener;
import org.apache.qpid.server.transport.ServerNetworkConnection;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.transport.ByteBufferSender;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebSocketProvider
implements AcceptingTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketProvider.class);
    public static final String AMQP_WEBSOCKET_SUBPROTOCOL = "AMQPWSB10";
    public static final String X509_CERTIFICATES = "javax.servlet.request.X509Certificate";
    private final Transport _transport;
    private final SSLContext _sslContext;
    private final AmqpPort<?> _port;
    private final Set<Protocol> _supported;
    private final Protocol _defaultSupportedProtocolReply;
    private final MultiVersionProtocolEngineFactory _factory;
    private Server _server;
    private final long _outboundMessageBufferLimit;
    private final List<ConnectionWrapper> _activeConnections = new CopyOnWriteArrayList<ConnectionWrapper>();
    private final WebSocketIdleTimeoutChecker _idleTimeoutChecker = new WebSocketIdleTimeoutChecker();
    private final AtomicBoolean _closed = new AtomicBoolean();

    WebSocketProvider(Transport transport, SSLContext sslContext, AmqpPort<?> port, Set<Protocol> supported, Protocol defaultSupportedProtocolReply) {
        this._transport = transport;
        this._sslContext = sslContext;
        this._port = port;
        this._supported = supported;
        this._defaultSupportedProtocolReply = defaultSupportedProtocolReply;
        this._outboundMessageBufferLimit = (Long)this._port.getContextValue(Long.class, "qpid.port.amqp.outboundMessageBufferSize");
        this._factory = new MultiVersionProtocolEngineFactory((Broker)this._port.getParent(Broker.class), this._supported, this._defaultSupportedProtocolReply, this._port, this._transport);
    }

    public void start() {
        SelectChannelConnector connector;
        this._idleTimeoutChecker.start();
        this._server = new Server();
        if (this._transport == Transport.WS) {
            connector = new SelectChannelConnector();
        } else if (this._transport == Transport.WSS) {
            SslContextFactory factory = new SslContextFactory(){

                public String[] selectProtocols(String[] enabledProtocols, String[] supportedProtocols) {
                    return SSLUtil.filterEnabledProtocols((String[])enabledProtocols, (String[])supportedProtocols, (List)WebSocketProvider.this._port.getTlsProtocolWhiteList(), (List)WebSocketProvider.this._port.getTlsProtocolBlackList());
                }

                public String[] selectCipherSuites(String[] enabledCipherSuites, String[] supportedCipherSuites) {
                    return SSLUtil.filterEnabledCipherSuites((String[])enabledCipherSuites, (String[])supportedCipherSuites, (List)WebSocketProvider.this._port.getTlsCipherSuiteWhiteList(), (List)WebSocketProvider.this._port.getTlsCipherSuiteBlackList());
                }

                public void customize(SSLEngine sslEngine) {
                    super.customize(sslEngine);
                    this.useCipherOrderIfPossible(sslEngine);
                }

                private void useCipherOrderIfPossible(SSLEngine sslEngine) {
                    if (WebSocketProvider.this._port.getTlsCipherSuiteWhiteList() != null && !WebSocketProvider.this._port.getTlsCipherSuiteWhiteList().isEmpty()) {
                        SSLUtil.useCipherOrderIfPossible((SSLEngine)sslEngine);
                    }
                }
            };
            factory.setSslContext(this._sslContext);
            factory.setNeedClientAuth(this._port.getNeedClientAuth());
            factory.setWantClientAuth(this._port.getWantClientAuth());
            connector = new SslSelectChannelConnector(factory);
        } else {
            throw new IllegalArgumentException("Unexpected transport on port " + this._port.getName() + ":" + this._transport);
        }
        String bindingAddress = null;
        bindingAddress = this._port.getBindingAddress();
        if (bindingAddress != null && !bindingAddress.trim().equals("") && !bindingAddress.trim().equals("*")) {
            connector.setHost(bindingAddress.trim());
        }
        connector.setPort(this._port.getPort());
        this._server.addConnector((Connector)connector);
        WebSocketHandler wshandler = new WebSocketHandler((AbstractConnector)connector){
            final /* synthetic */ AbstractConnector val$connector;
            {
                this.val$connector = abstractConnector;
            }

            public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
                X509Certificate[] certificates;
                X509Certificate certificate = null;
                if (Collections.list(request.getAttributeNames()).contains(WebSocketProvider.X509_CERTIFICATES) && (certificates = (X509Certificate[])request.getAttribute(WebSocketProvider.X509_CERTIFICATES)) != null && certificates.length != 0) {
                    certificate = certificates[0];
                }
                InetSocketAddress remoteAddress = new InetSocketAddress(request.getRemoteHost(), request.getRemotePort());
                InetSocketAddress localAddress = new InetSocketAddress(request.getLocalName(), request.getLocalPort());
                return new AmqpWebSocket(WebSocketProvider.this._transport, localAddress, remoteAddress, certificate, this.val$connector.getThreadPool());
            }
        };
        this._server.setHandler((Handler)wshandler);
        this._server.setSendServerVersion(false);
        wshandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                if (response.isCommitted() || baseRequest.isHandled()) {
                    return;
                }
                baseRequest.setHandled(true);
                response.setStatus(403);
            }
        });
        try {
            this._server.start();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServerScopedRuntimeException((Throwable)e);
        }
    }

    public void close() {
        this._closed.set(true);
        this._idleTimeoutChecker.wakeup();
    }

    public int getAcceptingPort() {
        return this._server == null || this._server.getConnectors() == null || this._server.getConnectors().length == 0 ? this._port.getPort() : this._server.getConnectors()[0].getLocalPort();
    }

    private class WebSocketIdleTimeoutChecker
    extends Thread {
        public WebSocketIdleTimeoutChecker() {
            this.setName("WebSocket Idle Checker: " + WebSocketProvider.this._port);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!WebSocketProvider.this._closed.get()) {
                ConnectionWrapper connectionToTick = null;
                long currentTime = System.currentTimeMillis();
                WebSocketIdleTimeoutChecker webSocketIdleTimeoutChecker = this;
                synchronized (webSocketIdleTimeoutChecker) {
                    long nextTick = Long.MAX_VALUE;
                    for (ConnectionWrapper connection : WebSocketProvider.this._activeConnections) {
                        MultiVersionProtocolEngine engine = connection._protocolEngine;
                        AggregateTicker ticker = engine.getAggregateTicker();
                        long tick = ticker.getTimeToNextTick(currentTime);
                        if (tick <= 0L) {
                            connectionToTick = connection;
                            nextTick = -1L;
                            break;
                        }
                        if (tick >= nextTick) continue;
                        nextTick = tick;
                    }
                    if (nextTick > 0L) {
                        try {
                            this.wait(nextTick);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                    }
                }
                if (connectionToTick == null) continue;
                connectionToTick.tick();
            }
        }

        private synchronized void wakeup() {
            this.notifyAll();
        }
    }

    private class ConnectionWrapper
    implements ServerNetworkConnection,
    ByteBufferSender {
        private final WebSocket.Connection _connection;
        private final SocketAddress _localAddress;
        private final SocketAddress _remoteAddress;
        private final ConcurrentLinkedQueue<QpidByteBuffer> _buffers = new ConcurrentLinkedQueue();
        private final MultiVersionProtocolEngine _protocolEngine;
        private final AtomicLong _usedOutboundMessageSpace = new AtomicLong();
        private final ThreadPool _threadPool;
        private final Runnable _tickJob;
        private Certificate _certificate;
        private long _maxWriteIdleMillis;
        private long _maxReadIdleMillis;

        public ConnectionWrapper(WebSocket.Connection connection, SocketAddress localAddress, SocketAddress remoteAddress, final MultiVersionProtocolEngine protocolEngine, ThreadPool threadPool) {
            this._connection = connection;
            this._localAddress = localAddress;
            this._remoteAddress = remoteAddress;
            this._protocolEngine = protocolEngine;
            this._threadPool = threadPool;
            this._tickJob = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ConnectionWrapper connectionWrapper = ConnectionWrapper.this;
                    synchronized (connectionWrapper) {
                        protocolEngine.getAggregateTicker().tick(System.currentTimeMillis());
                        ConnectionWrapper.this.doWrite();
                    }
                }
            };
        }

        public ByteBufferSender getSender() {
            return this;
        }

        public void start() {
        }

        public boolean isDirectBufferPreferred() {
            return false;
        }

        public void send(QpidByteBuffer msg) {
            if (msg.remaining() > 0) {
                this._buffers.add(msg.duplicate());
            }
            msg.position(msg.limit());
        }

        public void flush() {
        }

        public void close() {
            this._connection.close();
        }

        public SocketAddress getRemoteAddress() {
            return this._remoteAddress;
        }

        public SocketAddress getLocalAddress() {
            return this._localAddress;
        }

        public void setMaxWriteIdleMillis(long millis) {
            this._maxWriteIdleMillis = millis;
        }

        public void setMaxReadIdleMillis(long millis) {
            this._maxReadIdleMillis = millis;
        }

        public Principal getPeerPrincipal() {
            return this._certificate instanceof X509Certificate ? ((X509Certificate)this._certificate).getSubjectDN() : null;
        }

        public Certificate getPeerCertificate() {
            return this._certificate;
        }

        public long getMaxReadIdleMillis() {
            return this._maxReadIdleMillis;
        }

        public long getMaxWriteIdleMillis() {
            return this._maxWriteIdleMillis;
        }

        public void addSchedulingDelayNotificationListeners(SchedulingDelayNotificationListener listener) {
        }

        public void removeSchedulingDelayNotificationListeners(SchedulingDelayNotificationListener listener) {
        }

        public void reserveOutboundMessageSpace(long size) {
            if (this._usedOutboundMessageSpace.addAndGet(size) > WebSocketProvider.this._outboundMessageBufferLimit) {
                this._protocolEngine.setMessageAssignmentSuspended(true, false);
            }
        }

        public String getTransportInfo() {
            return this._connection.getProtocol();
        }

        public long getScheduledTime() {
            return 0L;
        }

        void setPeerCertificate(Certificate certificate) {
            this._certificate = certificate;
        }

        public synchronized void doWrite() {
            QpidByteBuffer buf;
            int size = 0;
            ArrayList<QpidByteBuffer> toBeWritten = new ArrayList<QpidByteBuffer>(this._buffers.size());
            while ((buf = this._buffers.poll()) != null) {
                size += buf.remaining();
                toBeWritten.add(buf);
            }
            byte[] data = new byte[size];
            int offset = 0;
            for (QpidByteBuffer tmp : toBeWritten) {
                int remaining = tmp.remaining();
                tmp.get(data, offset, remaining);
                tmp.dispose();
                offset += remaining;
            }
            if (size > 0) {
                try {
                    this._connection.sendMessage(data, 0, size);
                }
                catch (IOException e) {
                    LOGGER.info("Exception on write: {}", (Object)e.getMessage());
                    this.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void doWork() {
            this._protocolEngine.clearWork();
            try {
                this._protocolEngine.setIOThread(Thread.currentThread());
                this._protocolEngine.setMessageAssignmentSuspended(true, true);
                Iterator iter = this._protocolEngine.processPendingIterator();
                while (iter.hasNext()) {
                    ((Runnable)iter.next()).run();
                }
                this.doWrite();
                WebSocketProvider.this._idleTimeoutChecker.wakeup();
                this._protocolEngine.setMessageAssignmentSuspended(false, true);
            }
            finally {
                this._protocolEngine.setIOThread(null);
            }
        }

        public void tick() {
            this._threadPool.dispatch(this._tickJob);
        }
    }

    private class AmqpWebSocket
    implements WebSocket,
    WebSocket.OnBinaryMessage {
        private final SocketAddress _localAddress;
        private final SocketAddress _remoteAddress;
        private final Certificate _userCertificate;
        private final ThreadPool _threadPool;
        private volatile MultiVersionProtocolEngine _protocolEngine;
        private volatile ConnectionWrapper _connectionWrapper;

        private AmqpWebSocket(Transport transport, SocketAddress localAddress, SocketAddress remoteAddress, Certificate userCertificate, ThreadPool threadPool) {
            this._localAddress = localAddress;
            this._remoteAddress = remoteAddress;
            this._userCertificate = userCertificate;
            this._threadPool = threadPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(byte[] data, int offset, int length) {
            ConnectionWrapper connectionWrapper = this._connectionWrapper;
            synchronized (connectionWrapper) {
                this._protocolEngine.clearWork();
                try {
                    this._protocolEngine.setIOThread(Thread.currentThread());
                    this._protocolEngine.setMessageAssignmentSuspended(true, true);
                    Iterator iter = this._protocolEngine.processPendingIterator();
                    while (iter.hasNext()) {
                        ((Runnable)iter.next()).run();
                    }
                    for (QpidByteBuffer qpidByteBuffer : QpidByteBuffer.asQpidByteBuffers((byte[])data, (int)offset, (int)length)) {
                        this._protocolEngine.received(qpidByteBuffer);
                        qpidByteBuffer.dispose();
                    }
                    this._connectionWrapper.doWrite();
                    this._protocolEngine.setMessageAssignmentSuspended(false, true);
                }
                finally {
                    this._protocolEngine.setIOThread(null);
                }
            }
            WebSocketProvider.this._idleTimeoutChecker.wakeup();
        }

        public void onOpen(WebSocket.Connection connection) {
            this._protocolEngine = WebSocketProvider.this._factory.newProtocolEngine(this._remoteAddress);
            connection.setMaxBinaryMessageSize(0);
            connection.setMaxIdleTime(0);
            this._connectionWrapper = new ConnectionWrapper(connection, this._localAddress, this._remoteAddress, this._protocolEngine, this._threadPool);
            this._connectionWrapper.setPeerCertificate(this._userCertificate);
            this._protocolEngine.setNetworkConnection((ServerNetworkConnection)this._connectionWrapper);
            this._protocolEngine.setWorkListener((Action)new Action<ProtocolEngine>(){

                public void performAction(ProtocolEngine object) {
                    AmqpWebSocket.this._threadPool.dispatch(new Runnable(){

                        @Override
                        public void run() {
                            AmqpWebSocket.this._connectionWrapper.doWork();
                        }
                    });
                }
            });
            WebSocketProvider.this._activeConnections.add(this._connectionWrapper);
            WebSocketProvider.this._idleTimeoutChecker.wakeup();
        }

        public void onClose(int closeCode, String message) {
            this._protocolEngine.closed();
            WebSocketProvider.this._activeConnections.remove(this._connectionWrapper);
            WebSocketProvider.this._idleTimeoutChecker.wakeup();
        }
    }
}

