/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.transport.ByteBufferSender;
import org.apache.qpid.transport.FrameSizeObserver;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.ProtocolDelegate;
import org.apache.qpid.transport.ProtocolError;
import org.apache.qpid.transport.ProtocolEvent;
import org.apache.qpid.transport.ProtocolEventSender;
import org.apache.qpid.transport.ProtocolHeader;
import org.apache.qpid.transport.SegmentType;
import org.apache.qpid.transport.Struct;
import org.apache.qpid.transport.codec.BBEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Disassembler
implements ProtocolEventSender,
ProtocolDelegate<Void>,
FrameSizeObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(Disassembler.class);
    private final ByteBufferSender _sender;
    private final Object _sendlock = new Object();
    private volatile int _maxPayload;
    private static final ThreadLocal<BBEncoder> _encoder = new ThreadLocal<BBEncoder>(){

        @Override
        public BBEncoder initialValue() {
            return new BBEncoder(4096);
        }
    };

    public Disassembler(ByteBufferSender sender, int maxFrame) {
        this._sender = sender;
        if (maxFrame <= 12 || maxFrame >= 65536) {
            throw new IllegalArgumentException("maxFrame must be > HEADER_SIZE and < 64K: " + maxFrame);
        }
        this._maxPayload = maxFrame - 12;
    }

    @Override
    public void send(ProtocolEvent event) {
        event.delegate(null, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this._sendlock;
        synchronized (object) {
            this._sender.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this._sendlock;
        synchronized (object) {
            this._sender.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Void v, ProtocolHeader header) {
        Object object = this._sendlock;
        synchronized (object) {
            this._sender.send(header.toByteBuffer());
            this._sender.flush();
        }
    }

    @Override
    public void control(Void v, Method method) {
        this.method(method, SegmentType.CONTROL);
    }

    @Override
    public void command(Void v, Method method) {
        this.method(method, SegmentType.COMMAND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void method(Method method, SegmentType type) {
        BBEncoder enc = _encoder.get();
        enc.init();
        enc.writeUint16(method.getEncodedType());
        if (type == SegmentType.COMMAND) {
            if (method.isSync()) {
                enc.writeUint16(257);
            } else {
                enc.writeUint16(256);
            }
        }
        method.write(enc);
        int methodLimit = enc.position();
        byte flags = 8;
        boolean payload = method.hasPayload();
        if (!payload) {
            flags = (byte)(flags | 4);
        }
        int headerLimit = -1;
        if (payload) {
            Header hdr = method.getHeader();
            if (hdr != null) {
                if (hdr.getDeliveryProperties() != null) {
                    enc.writeStruct32(hdr.getDeliveryProperties());
                }
                if (hdr.getMessageProperties() != null) {
                    enc.writeStruct32(hdr.getMessageProperties());
                }
                if (hdr.getNonStandardProperties() != null) {
                    for (Struct st : hdr.getNonStandardProperties()) {
                        enc.writeStruct32(st);
                    }
                }
            }
            headerLimit = enc.position();
        }
        Object object = this._sendlock;
        synchronized (object) {
            ByteBuffer buf = enc.underlyingBuffer();
            buf.flip();
            QpidByteBuffer copy = QpidByteBuffer.allocate(this._sender.isDirectBufferPreferred(), buf.remaining());
            copy.putCopyOf(QpidByteBuffer.wrap(buf));
            copy.flip();
            QpidByteBuffer methodBuf = copy.view(0, methodLimit);
            this.fragment(flags, type, method, Collections.singletonList(methodBuf));
            methodBuf.dispose();
            if (payload) {
                Collection<QpidByteBuffer> bodies = method.getBody();
                QpidByteBuffer headerBuf = copy.view(methodLimit, headerLimit);
                this.fragment(bodies == null ? (byte)4 : 0, SegmentType.HEADER, method, Collections.singletonList(headerBuf));
                headerBuf.dispose();
                if (bodies != null) {
                    ArrayList<QpidByteBuffer> dup = new ArrayList<QpidByteBuffer>(bodies.size());
                    for (QpidByteBuffer b : bodies) {
                        dup.add(b.duplicate());
                    }
                    this.fragment((byte)4, SegmentType.BODY, method, dup);
                    for (QpidByteBuffer b : dup) {
                        b.dispose();
                    }
                }
            }
            copy.dispose();
        }
    }

    private void fragment(byte flags, SegmentType type, ProtocolEvent event, Collection<QpidByteBuffer> buffers) {
        byte typeb = (byte)type.getValue();
        byte track = event.getEncodedTrack() == 3 ? (byte)1 : 0;
        int remaining = 0;
        for (QpidByteBuffer b : buffers) {
            remaining += b.remaining();
        }
        boolean first = true;
        do {
            int size = Math.min(this._maxPayload, remaining);
            remaining -= size;
            byte newflags = flags;
            if (first) {
                newflags = (byte)(newflags | 2);
                first = false;
            }
            if (remaining == 0) {
                newflags = (byte)(newflags | 1);
            }
            this.frame(newflags, typeb, track, event.getChannel(), size, buffers);
        } while (remaining != 0);
    }

    private void frame(byte flags, byte type, byte track, int channel, int size, Collection<QpidByteBuffer> buffers) {
        QpidByteBuffer data = QpidByteBuffer.allocate(this._sender.isDirectBufferPreferred(), 12);
        data.put(0, flags);
        data.put(1, type);
        data.putShort(2, (short)(size + 12));
        data.put(4, (byte)0);
        data.put(5, track);
        data.putShort(6, (short)channel);
        this._sender.send(data);
        data.dispose();
        if (size > 0) {
            int residual = size;
            for (QpidByteBuffer b : buffers) {
                int remaining = b.remaining();
                if (remaining <= 0) continue;
                if (remaining >= residual) {
                    QpidByteBuffer buffer = b.view(0, residual);
                    this._sender.send(buffer);
                    buffer.dispose();
                    b.position(b.position() + residual);
                    break;
                }
                this._sender.send(b);
                residual -= remaining;
            }
        }
    }

    @Override
    public void error(Void v, ProtocolError error) {
        throw new IllegalArgumentException(String.valueOf(error));
    }

    @Override
    public void setMaxFrameSize(int maxFrame) {
        if (maxFrame <= 12 || maxFrame >= 65536) {
            throw new IllegalArgumentException("maxFrame must be > HEADER_SIZE and < 64K: " + maxFrame);
        }
        this._maxPayload = maxFrame - 12;
    }
}

