/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.transport.Binary;
import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.ExecutionException;
import org.apache.qpid.transport.ExecutionSync;
import org.apache.qpid.transport.Future;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.MessageAcceptMode;
import org.apache.qpid.transport.MessageAcquireMode;
import org.apache.qpid.transport.MessageTransfer;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.Range;
import org.apache.qpid.transport.RangeSet;
import org.apache.qpid.transport.RangeSetFactory;
import org.apache.qpid.transport.SenderException;
import org.apache.qpid.transport.SessionClosedException;
import org.apache.qpid.transport.SessionDelegate;
import org.apache.qpid.transport.SessionDetachCode;
import org.apache.qpid.transport.SessionException;
import org.apache.qpid.transport.SessionInvoker;
import org.apache.qpid.transport.SessionListener;
import org.apache.qpid.transport.Struct;
import org.apache.qpid.transport.util.Waiter;
import org.apache.qpid.util.Serial;
import org.apache.qpid.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session
extends SessionInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(Session.class);
    public static final int UNLIMITED_CREDIT = -1;
    private Connection connection;
    private Binary name;
    private long expiry;
    private boolean closing;
    private int channel;
    private SessionDelegate delegate;
    private SessionListener listener = new DefaultSessionListener();
    private final long timeout = Long.getLong("qpid.sync_op_timeout", Long.getLong("amqj.default_syncwrite_timeout", 60000L));
    private final long blockedSendTimeout = Long.getLong("qpid.flow_control_wait_failure", 60000L);
    private long blockedSendReportingPeriod = Long.getLong("qpid.flow_control_wait_notify_period", 5000L);
    private boolean autoSync = false;
    private boolean incomingInit;
    private int commandsIn;
    private final Object processedLock = new Object();
    private RangeSet processed;
    private int maxProcessed;
    private int syncPoint;
    private int commandsOut = 0;
    private final int commandLimit = Integer.getInteger("qpid.session.command_limit", 65536);
    private Map<Integer, Method> commands = new HashMap<Integer, Method>();
    private final Object commandsLock = new Object();
    private int commandBytes = 0;
    private int byteLimit = Integer.getInteger("qpid.session.byte_limit", 0x100000);
    private int maxComplete = this.commandsOut - 1;
    private boolean needSync = false;
    private State state = State.NEW;
    private volatile boolean flowControl = false;
    private Semaphore credit = new Semaphore(0);
    private Thread resumer = null;
    private boolean transacted = false;
    private SessionDetachCode detachCode;
    private final Object stateLock = new Object();
    private final AtomicBoolean _failoverRequired = new AtomicBoolean(false);
    private boolean _isNoReplay = false;
    private Map<Integer, ResultFuture<?>> results = new HashMap();
    private ExecutionException exception = null;

    protected Session(Connection connection, Binary name, long expiry) {
        this(connection, new SessionDelegate(), name, expiry);
    }

    protected Session(Connection connection, Binary name, long expiry, boolean noReplay) {
        this(connection, new SessionDelegate(), name, expiry, noReplay);
    }

    protected Session(Connection connection, SessionDelegate delegate, Binary name, long expiry) {
        this(connection, delegate, name, expiry, false);
    }

    protected Session(Connection connection, SessionDelegate delegate, Binary name, long expiry, boolean noReplay) {
        this.connection = connection;
        this.delegate = delegate;
        this.name = name;
        this.expiry = expiry;
        this.closing = false;
        this._isNoReplay = noReplay;
        this.initReceiver();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Binary getName() {
        return this.name;
    }

    void setExpiry(long expiry) {
        this.expiry = expiry;
    }

    protected void setClose(boolean close) {
        this.closing = close;
    }

    public int getChannel() {
        return this.channel;
    }

    void setChannel(int channel) {
        this.channel = channel;
    }

    public void setSessionListener(SessionListener listener) {
        this.listener = listener == null ? new DefaultSessionListener() : listener;
    }

    public SessionListener getSessionListener() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoSync(boolean value) {
        Object object = this.commandsLock;
        synchronized (object) {
            this.autoSync = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(State state) {
        Object object = this.commandsLock;
        synchronized (object) {
            this.state = state;
            this.commandsLock.notifyAll();
        }
    }

    protected State getState() {
        return this.state;
    }

    void setFlowControl(boolean value) {
        this.flowControl = value;
    }

    void addCredit(int value) {
        this.credit.release(value);
    }

    void drainCredit() {
        this.credit.drainPermits();
    }

    void acquireCredit() {
        if (this.flowControl) {
            try {
                long wait = this.blockedSendTimeout > this.blockedSendReportingPeriod ? this.blockedSendReportingPeriod : this.blockedSendTimeout;
                long totalWait = 1L;
                while (totalWait <= this.blockedSendTimeout && !this.credit.tryAcquire(wait, TimeUnit.MILLISECONDS)) {
                    LOGGER.warn("Message send delayed by {}s due to broker enforced flow control", (Object)((totalWait += wait) / 1000L));
                }
                if (totalWait > this.blockedSendTimeout) {
                    LOGGER.error("Message send failed due to timeout waiting on broker enforced flow control");
                    throw new SessionException("timed out waiting for message credit");
                }
            }
            catch (InterruptedException e) {
                throw new SessionException("interrupted while waiting for credit", null, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initReceiver() {
        Object object = this.processedLock;
        synchronized (object) {
            this.incomingInit = false;
            this.processed = RangeSetFactory.createRangeSet();
        }
    }

    void attach() {
        this.initReceiver();
        this.sessionAttach(this.name.getBytes(), new Option[0]);
        this.sessionRequestTimeout(0L, new Option[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume() {
        this._failoverRequired.set(false);
        Object object = this.commandsLock;
        synchronized (object) {
            this.attach();
            int i = this.maxComplete + 1;
            while (Serial.lt(i, this.commandsOut)) {
                Method m = this.getCommand(i);
                if (m == null) {
                    m = new ExecutionSync(new Option[0]);
                    m.setId(i);
                } else if (m instanceof MessageTransfer) {
                    DeliveryProperties deliveryProps;
                    MessageTransfer xfr = (MessageTransfer)m;
                    Header header = xfr.getHeader();
                    if (header != null) {
                        if (header.getDeliveryProperties() != null) {
                            header.getDeliveryProperties().setRedelivered(true);
                        } else {
                            deliveryProps = new DeliveryProperties();
                            deliveryProps.setRedelivered(true);
                            xfr.setHeader(new Header(deliveryProps, header.getMessageProperties(), header.getNonStandardProperties()));
                        }
                    } else {
                        deliveryProps = new DeliveryProperties();
                        deliveryProps.setRedelivered(true);
                        xfr.setHeader(new Header(deliveryProps, null, null));
                    }
                }
                this.sessionCommandPoint(m.getId(), 0L, new Option[0]);
                this.send(m);
                ++i;
            }
            this.sessionCommandPoint(this.commandsOut, 0L, new Option[0]);
            this.sessionFlush(Option.COMPLETED);
            this.resumer = Thread.currentThread();
            this.state = State.RESUMING;
            if (this.isTransacted()) {
                this.txSelect(new Option[0]);
            }
            this.listener.resumed(this);
            this.resumer = null;
        }
    }

    private Method getCommand(int i) {
        return this.commands.get(i);
    }

    private void setCommand(int commandId, Method command) {
        this.commands.put(commandId, command);
    }

    private Method removeCommand(int id) {
        return this.commands.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void commandPoint(int id) {
        Object object = this.processedLock;
        synchronized (object) {
            this.commandsIn = id;
            if (!this.incomingInit) {
                this.incomingInit = true;
                this.syncPoint = this.maxProcessed = this.commandsIn - 1;
            }
        }
    }

    public int getCommandsOut() {
        return this.commandsOut;
    }

    public int getCommandsIn() {
        return this.commandsIn;
    }

    public int nextCommandId() {
        return this.commandsIn++;
    }

    final void identify(Method cmd) {
        if (!this.incomingInit) {
            throw new IllegalStateException();
        }
        int id = this.nextCommandId();
        cmd.setId(id);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("identify: ch={}, commandId={}", (Object)this.channel, (Object)id);
        }
        if ((id & 0xFF) == 0) {
            this.flushProcessed(Option.TIMELY_REPLY);
        }
    }

    public void processed(Method command) {
        this.processed(command.getId());
    }

    public void processed(int command) {
        this.processed(command, command);
    }

    public void processed(Range range) {
        this.processed(range.getLower(), range.getUpper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processed(int lower, int upper) {
        boolean flush;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} ch={} processed([{},{}]) {} {}", new Object[]{this, this.channel, lower, upper, this.syncPoint, this.maxProcessed});
        }
        Object object = this.processedLock;
        synchronized (object) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} processed: {}", (Object)this, (Object)this.processed);
            }
            if (Serial.ge(upper, this.commandsIn)) {
                throw new IllegalArgumentException("range exceeds max received command-id: " + Range.newInstance(lower, upper));
            }
            this.processed.add(lower, upper);
            Range first = this.processed.getFirst();
            int flower = first.getLower();
            int fupper = first.getUpper();
            int old = this.maxProcessed;
            if (Serial.le(flower, this.maxProcessed + 1)) {
                this.maxProcessed = Serial.max(this.maxProcessed, fupper);
            }
            boolean synced = Serial.ge(this.maxProcessed, this.syncPoint);
            boolean bl = flush = Serial.lt(old, this.syncPoint) && synced;
            if (synced) {
                this.syncPoint = this.maxProcessed;
            }
        }
        if (flush) {
            this.flushProcessed(new Option[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushExpected() {
        RangeSet rs = RangeSetFactory.createRangeSet();
        Object object = this.processedLock;
        synchronized (object) {
            if (this.incomingInit) {
                rs.add(this.commandsIn);
            }
        }
        this.sessionExpected(rs, null, new Option[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushProcessed(Option ... options) {
        RangeSet copy;
        Object object = this.processedLock;
        synchronized (object) {
            copy = this.processed.copy();
        }
        object = this.commandsLock;
        synchronized (object) {
            if (this.state == State.DETACHED || this.state == State.CLOSING || this.state == State.CLOSED) {
                return;
            }
            if (copy.size() > 0) {
                this.sessionCompleted(copy, options);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void knownComplete(RangeSet kc) {
        if (kc.size() > 0) {
            Object object = this.processedLock;
            synchronized (object) {
                this.processed.subtract(kc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncPoint() {
        boolean flush;
        int id = this.getCommandsIn() - 1;
        LOGGER.debug("{} synced to {}", (Object)this, (Object)id);
        Object object = this.processedLock;
        synchronized (object) {
            this.syncPoint = id;
            flush = Serial.ge(this.maxProcessed, this.syncPoint);
        }
        if (flush) {
            this.flushProcessed(new Option[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean complete(int lower, int upper) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} complete({}, {})", new Object[]{this, lower, upper});
        }
        Object object = this.commandsLock;
        synchronized (object) {
            int old = this.maxComplete;
            int id = Serial.max(this.maxComplete, lower);
            while (Serial.le(id, upper)) {
                Method m = this.removeCommand(id);
                if (m != null) {
                    this.commandBytes -= m.getBodySize();
                    m.complete();
                }
                ++id;
            }
            if (Serial.le(lower, this.maxComplete + 1)) {
                this.maxComplete = Serial.max(this.maxComplete, upper);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}   commands remaining: {}", (Object)this, (Object)(this.commandsOut - this.maxComplete));
            }
            this.commandsLock.notifyAll();
            return Serial.gt(this.maxComplete, old);
        }
    }

    void received(Method m) {
        m.delegate(this, this.delegate);
    }

    private void send(Method m) {
        m.setChannel(this.channel);
        this.connection.send(m);
        if (!m.isBatch()) {
            this.connection.flush();
        }
    }

    protected boolean isFull(int id) {
        return this.isCommandsFull(id) || this.isBytesFull();
    }

    protected boolean isBytesFull() {
        return this.commandBytes >= this.byteLimit;
    }

    protected boolean isCommandsFull(int id) {
        return id - this.maxComplete >= this.commandLimit;
    }

    @Override
    public void invoke(Method m) {
        this.invoke(m, (Runnable)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Method m, Runnable postIdSettingAction) {
        if (m.getEncodedTrack() == 3) {
            if (m.hasPayload()) {
                this.acquireCredit();
            }
            Object object = this.commandsLock;
            synchronized (object) {
                boolean replayTransfer;
                ExecutionException exc;
                Waiter w;
                Thread current;
                if (this.state == State.DETACHED && m.isUnreliable() && !(current = Thread.currentThread()).equals(this.resumer)) {
                    return;
                }
                if (this.state != State.OPEN && this.state != State.CLOSED && this.state != State.CLOSING && !(current = Thread.currentThread()).equals(this.resumer)) {
                    w = new Waiter(this.commandsLock, this.timeout);
                    while (w.hasTime() && this.state != State.OPEN && this.state != State.CLOSED) {
                        this.checkFailoverRequired("Command was interrupted because of failover, before being sent");
                        w.await();
                    }
                }
                switch (this.state) {
                    case OPEN: {
                        break;
                    }
                    case RESUMING: {
                        current = Thread.currentThread();
                        if (current.equals(this.resumer)) break;
                        throw new SessionException("timed out waiting for resume to finish");
                    }
                    case CLOSING: 
                    case CLOSED: {
                        exc = this.getException();
                        if (exc != null) {
                            throw new SessionException(exc);
                        }
                        throw new SessionClosedException();
                    }
                    default: {
                        throw new SessionException(String.format("timed out waiting for session to become open (state=%s)", new Object[]{this.state}));
                    }
                }
                int next = this.commandsOut++;
                m.setId(next);
                if (postIdSettingAction != null) {
                    postIdSettingAction.run();
                }
                if (this.isFull(next)) {
                    w = new Waiter(this.commandsLock, this.timeout);
                    while (w.hasTime() && this.isFull(next) && this.state != State.CLOSED) {
                        if (this.state == State.OPEN || this.state == State.RESUMING) {
                            try {
                                this.sessionFlush(Option.COMPLETED);
                            }
                            catch (SenderException e) {
                                if (!this.closing) {
                                    LOGGER.error("error sending flush (full replay buffer)", (Throwable)e);
                                }
                                e.rethrow();
                            }
                        }
                        this.checkFailoverRequired("Command was interrupted because of failover, before being sent");
                        w.await();
                    }
                }
                if (this.state == State.CLOSED) {
                    exc = this.getException();
                    if (exc != null) {
                        throw new SessionException(exc);
                    }
                    throw new SessionClosedException();
                }
                if (this.isFull(next)) {
                    throw new SessionException("timed out waiting for completion");
                }
                if (next == 0) {
                    this.sessionCommandPoint(0, 0L, new Option[0]);
                }
                boolean bl = replayTransfer = !this._isNoReplay && !this.closing && !this.transacted && m instanceof MessageTransfer && !m.isUnreliable();
                if (replayTransfer || m.hasCompletionListener()) {
                    this.setCommand(next, m);
                    this.commandBytes += m.getBodySize();
                }
                if (this.autoSync) {
                    m.setSync(true);
                }
                this.needSync = !m.isSync();
                try {
                    this.send(m);
                }
                catch (SenderException e) {
                    if (!this.closing) {
                        LOGGER.error("error sending command", (Throwable)e);
                    }
                    e.rethrow();
                }
                if (this.autoSync) {
                    this.sync();
                }
                if (this.shouldIssueFlush(next)) {
                    try {
                        this.sessionFlush(Option.COMPLETED);
                    }
                    catch (SenderException e) {
                        if (!this.closing) {
                            LOGGER.error("error sending flush (periodic)", (Throwable)e);
                        }
                        e.rethrow();
                    }
                }
            }
        }
        this.send(m);
    }

    private void checkFailoverRequired(String message) {
        if (this._failoverRequired.get()) {
            throw new SessionException(message);
        }
    }

    protected boolean shouldIssueFlush(int next) {
        return next % 65536 == 0;
    }

    public void sync() {
        this.sync(this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(long timeout) {
        LOGGER.debug("{} sync()", (Object)this);
        Object object = this.commandsLock;
        synchronized (object) {
            int point = this.commandsOut - 1;
            if (this.needSync && Serial.lt(this.maxComplete, point)) {
                this.executionSync(Option.SYNC);
            }
            Waiter w = new Waiter(this.commandsLock, timeout);
            while (w.hasTime() && this.state != State.CLOSED && Serial.lt(this.maxComplete, point)) {
                this.checkFailoverRequired("Session sync was interrupted by failover.");
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{}   waiting for[{}]: {}, {}", new Object[]{this, point, this.maxComplete, this.commands});
                }
                w.await();
            }
            if (Serial.lt(this.maxComplete, point)) {
                if (this.state != State.CLOSED) {
                    throw new SessionException(String.format("timed out waiting for sync: complete = %s, point = %s", this.maxComplete, point));
                }
                ExecutionException ee = this.getException();
                if (ee != null) {
                    throw new SessionException(ee);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void result(int command, Struct result) {
        ResultFuture<?> future;
        Map<Integer, ResultFuture<?>> map = this.results;
        synchronized (map) {
            future = this.results.remove(command);
        }
        if (future != null) {
            ((ResultFuture)future).set(result);
        } else {
            LOGGER.warn("Received a response to a command that's no longer valid on the client side. [ command id : {} , result : {} ]", (Object)command, (Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setException(ExecutionException exc) {
        Map<Integer, ResultFuture<?>> map = this.results;
        synchronized (map) {
            if (this.exception != null) {
                throw new IllegalStateException(String.format("too many exceptions: %s, %s", this.exception, exc));
            }
            this.exception = exc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutionException getException() {
        Map<Integer, ResultFuture<?>> map = this.results;
        synchronized (map) {
            return this.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> Future<T> invoke(Method m, Class<T> klass) {
        Object object = this.commandsLock;
        synchronized (object) {
            int command = this.commandsOut;
            ResultFuture future = new ResultFuture(klass);
            Map<Integer, ResultFuture<?>> map = this.results;
            synchronized (map) {
                this.results.put(command, future);
            }
            this.invoke(m);
            return future;
        }
    }

    public final void messageTransfer(String destination, MessageAcceptMode acceptMode, MessageAcquireMode acquireMode, Header header, byte[] body, Option ... _options) {
        this.messageTransfer(destination, acceptMode, acquireMode, header, ByteBuffer.wrap(body), _options);
    }

    public final void messageTransfer(String destination, MessageAcceptMode acceptMode, MessageAcquireMode acquireMode, Header header, String body, Option ... _options) {
        this.messageTransfer(destination, acceptMode, acquireMode, header, Strings.toUTF8(body), _options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Closing [{}] in state [{}]", (Object)this, (Object)this.state);
        }
        Object object = this.commandsLock;
        synchronized (object) {
            switch (this.state) {
                case DETACHED: {
                    this.state = State.CLOSED;
                    this.delegate.closed(this);
                    this.connection.removeSession(this);
                    this.listener.closed(this);
                    break;
                }
                case CLOSED: {
                    break;
                }
                default: {
                    this.state = State.CLOSING;
                    this.setClose(true);
                    this.sessionRequestTimeout(0L, new Option[0]);
                    this.sessionDetach(this.name.getBytes(), new Option[0]);
                    this.awaitClose();
                }
            }
        }
    }

    protected void awaitClose() {
        Waiter w = new Waiter(this.commandsLock, this.timeout);
        while (w.hasTime() && this.state != State.CLOSED) {
            this.checkFailoverRequired("close() was interrupted by failover.");
            w.await();
        }
        if (this.state != State.CLOSED) {
            throw new SessionException("close() timed out");
        }
    }

    public void exception(Throwable t) {
        LOGGER.error("caught exception", t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closed() {
        Object object = this.commandsLock;
        synchronized (object) {
            this.state = this.closing || this.getException() != null ? State.CLOSED : State.DETACHED;
            this.commandsLock.notifyAll();
            Map<Integer, ResultFuture<?>> map = this.results;
            synchronized (map) {
                Iterator<ResultFuture<?>> i$ = this.results.values().iterator();
                while (i$.hasNext()) {
                    ResultFuture<?> result;
                    ResultFuture<?> resultFuture = result = i$.next();
                    synchronized (resultFuture) {
                        result.notifyAll();
                    }
                }
            }
            if (this.state == State.CLOSED) {
                this.delegate.closed(this);
            } else {
                this.delegate.detached(this);
            }
        }
        if (this.state == State.CLOSED) {
            this.connection.removeSession(this);
            this.listener.closed(this);
        }
    }

    public boolean isClosing() {
        return this.state == State.CLOSED || this.state == State.CLOSING;
    }

    public String toString() {
        return String.format("ssn:%s", this.name);
    }

    public void setTransacted(boolean b) {
        this.transacted = b;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setDetachCode(SessionDetachCode dtc) {
        this.detachCode = dtc;
    }

    public SessionDetachCode getDetachCode() {
        return this.detachCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitOpen() {
        switch (this.state) {
            case NEW: {
                Object object = this.stateLock;
                synchronized (object) {
                    Waiter w = new Waiter(this.stateLock, this.timeout);
                    while (w.hasTime() && this.state == State.NEW) {
                        this.checkFailoverRequired("Session opening was interrupted by failover.");
                        w.await();
                    }
                }
                if (this.state == State.OPEN) break;
                throw new SessionException("Timed out waiting for Session to open");
            }
            case CLOSING: 
            case CLOSED: 
            case DETACHED: {
                throw new SessionException("Session closed");
            }
        }
    }

    public Object getStateLock() {
        return this.stateLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyFailoverRequired() {
        this._failoverRequired.set(true);
        Map<Integer, ResultFuture<?>> map = this.commandsLock;
        synchronized (map) {
            this.commandsLock.notifyAll();
        }
        map = this.results;
        synchronized (map) {
            Iterator<ResultFuture<?>> i$ = this.results.values().iterator();
            while (i$.hasNext()) {
                ResultFuture<?> result;
                ResultFuture<?> resultFuture = result = i$.next();
                synchronized (resultFuture) {
                    result.notifyAll();
                }
            }
        }
    }

    public boolean isFlowBlocked() {
        return this.flowControl && this.credit.availablePermits() == 0;
    }

    private class ResultFuture<T>
    implements Future<T> {
        private final Class<T> klass;
        private T result;

        private ResultFuture(Class<T> klass) {
            this.klass = klass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void set(Struct result) {
            ResultFuture resultFuture = this;
            synchronized (resultFuture) {
                this.result = this.klass.cast(result);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get(long timeout) {
            ResultFuture resultFuture = this;
            synchronized (resultFuture) {
                Waiter w = new Waiter(this, timeout);
                while (w.hasTime() && Session.this.state != State.CLOSED && !this.isDone()) {
                    Session.this.checkFailoverRequired("Operation was interrupted by failover.");
                    LOGGER.debug("{} waiting for result: {}", (Object)Session.this, (Object)this);
                    w.await();
                }
            }
            if (this.isDone()) {
                return this.result;
            }
            if (Session.this.state == State.CLOSED) {
                ExecutionException ex = Session.this.getException();
                if (ex == null) {
                    throw new SessionClosedException();
                }
                throw new SessionException(ex);
            }
            throw new SessionException(String.format("%s timed out waiting for result: %s", Session.this, this));
        }

        @Override
        public T get() {
            return this.get(Session.this.timeout);
        }

        @Override
        public boolean isDone() {
            return this.result != null;
        }

        public String toString() {
            return String.format("Future(%s)", this.isDone() ? this.result : this.klass);
        }
    }

    static class DefaultSessionListener
    implements SessionListener {
        DefaultSessionListener() {
        }

        @Override
        public void opened(Session ssn) {
        }

        @Override
        public void resumed(Session ssn) {
        }

        @Override
        public void message(Session ssn, MessageTransfer xfr) {
            LOGGER.info("message: {}", (Object)xfr);
        }

        @Override
        public void exception(Session ssn, SessionException exc) {
            LOGGER.error("session exception", (Throwable)exc);
        }

        @Override
        public void closed(Session ssn) {
        }
    }

    public static enum State {
        NEW,
        DETACHED,
        RESUMING,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

