/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import org.apache.qpid.QpidException;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.ClientChannelMethodProcessor;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.MethodDispatcher;

public class AccessRequestOkBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 30;
    public static final int METHOD_ID = 11;
    private final int _ticket;

    public AccessRequestOkBody(int ticket) {
        this._ticket = ticket;
    }

    @Override
    public int getClazz() {
        return 30;
    }

    @Override
    public int getMethod() {
        return 11;
    }

    public final int getTicket() {
        return this._ticket;
    }

    @Override
    protected int getBodySize() {
        int size = 2;
        return size;
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._ticket);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchAccessRequestOk(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[AccessRequestOkBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append("]");
        return buf.toString();
    }

    public static void process(QpidByteBuffer buffer, ClientChannelMethodProcessor dispatcher) {
        int ticket = buffer.getUnsignedShort();
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveAccessRequestOk(ticket);
        }
    }
}

