/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import org.apache.qpid.QpidException;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.ServerChannelMethodProcessor;

public class AccessRequestBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 30;
    public static final int METHOD_ID = 10;
    private final AMQShortString _realm;
    private final byte _bitfield0;

    public AccessRequestBody(AMQShortString realm, boolean exclusive, boolean passive, boolean active, boolean write, boolean read) {
        this._realm = realm;
        byte bitfield0 = 0;
        if (exclusive) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (passive) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        if (active) {
            bitfield0 = (byte)(bitfield0 | 4);
        }
        if (write) {
            bitfield0 = (byte)(bitfield0 | 8);
        }
        if (read) {
            bitfield0 = (byte)(bitfield0 | 0x10);
        }
        this._bitfield0 = bitfield0;
    }

    @Override
    public int getClazz() {
        return 30;
    }

    @Override
    public int getMethod() {
        return 10;
    }

    public final AMQShortString getRealm() {
        return this._realm;
    }

    public final boolean getExclusive() {
        return (this._bitfield0 & 1) != 0;
    }

    public final boolean getPassive() {
        return (this._bitfield0 & 2) != 0;
    }

    public final boolean getActive() {
        return (this._bitfield0 & 4) != 0;
    }

    public final boolean getWrite() {
        return (this._bitfield0 & 8) != 0;
    }

    public final boolean getRead() {
        return (this._bitfield0 & 0x10) != 0;
    }

    @Override
    protected int getBodySize() {
        int size = 1;
        return size += this.getSizeOf(this._realm);
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        this.writeAMQShortString(buffer, this._realm);
        this.writeBitfield(buffer, this._bitfield0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchAccessRequest(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[AccessRequestBodyImpl: ");
        buf.append("realm=");
        buf.append(this.getRealm());
        buf.append(", ");
        buf.append("exclusive=");
        buf.append(this.getExclusive());
        buf.append(", ");
        buf.append("passive=");
        buf.append(this.getPassive());
        buf.append(", ");
        buf.append("active=");
        buf.append(this.getActive());
        buf.append(", ");
        buf.append("write=");
        buf.append(this.getWrite());
        buf.append(", ");
        buf.append("read=");
        buf.append(this.getRead());
        buf.append("]");
        return buf.toString();
    }

    public static void process(QpidByteBuffer buffer, ServerChannelMethodProcessor dispatcher) {
        boolean read;
        AMQShortString realm = AMQShortString.readAMQShortString(buffer);
        byte bitfield = buffer.get();
        boolean exclusive = (bitfield & 1) == 1;
        boolean passive = (bitfield & 2) == 2;
        boolean active = (bitfield & 4) == 4;
        boolean write = (bitfield & 8) == 8;
        boolean bl = read = (bitfield & 0x10) == 16;
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveAccessRequest(realm, exclusive, passive, active, write, read);
        }
    }
}

