/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid;

import org.apache.qpid.QpidException;
import org.apache.qpid.protocol.AMQConstant;

public class AMQException
extends QpidException {
    private final AMQConstant _errorCode;
    private final boolean _isHardError;

    public AMQException(AMQConstant errorCode, String message) {
        this(errorCode, message, null);
    }

    public AMQException(AMQConstant errorCode, String msg, Throwable cause) {
        this(errorCode, true, msg, cause);
    }

    public AMQException(AMQConstant errorCode, boolean isHardError, String message, Throwable cause) {
        super(message, cause);
        this._errorCode = errorCode;
        this._isHardError = isHardError;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + this.getMessage() + (this._errorCode == null ? "" : " [error code " + this._errorCode + "]");
    }

    public AMQConstant getErrorCode() {
        return this._errorCode;
    }

    public boolean isHardError() {
        return this._isHardError;
    }

    @Override
    public AMQException cloneForCurrentThread() {
        AMQException newAMQE;
        Class<?> amqeClass = this.getClass();
        Class[] paramClasses = new Class[]{AMQConstant.class, String.class, Throwable.class};
        Object[] params = new Object[]{this._errorCode, this.getMessage(), this};
        try {
            newAMQE = (AMQException)amqeClass.getConstructor(paramClasses).newInstance(params);
        }
        catch (Exception creationException) {
            newAMQE = new AMQException(this._errorCode, this._isHardError, this.getMessage(), this);
        }
        return newAMQE;
    }
}

