/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.qpid.QpidException;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.framing.AMQBody;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicCancelOkBody;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.MessagePublishInfo;
import org.apache.qpid.protocol.AMQVersionAwareProtocolSession;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageContentSource;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.protocol.MessageConverterRegistry;
import org.apache.qpid.server.protocol.v0_8.AMQMessage;
import org.apache.qpid.server.protocol.v0_8.AMQPConnection_0_8Impl;
import org.apache.qpid.server.protocol.v0_8.ProtocolOutputConverter;
import org.apache.qpid.transport.ByteBufferSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolOutputConverterImpl
implements ProtocolOutputConverter {
    private static final int BASIC_CLASS_ID = 60;
    private final AMQPConnection_0_8Impl _connection;
    private static final AMQShortString GZIP_ENCODING = AMQShortString.valueOf((String)"gzip");
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolOutputConverterImpl.class);

    public ProtocolOutputConverterImpl(AMQPConnection_0_8Impl connection) {
        this._connection = connection;
    }

    @Override
    public long writeDeliver(ServerMessage m, InstanceProperties props, int channelId, long deliveryTag, AMQShortString consumerTag) {
        AMQMessage msg = this.convertToAMQMessage(m);
        boolean isRedelivered = Boolean.TRUE.equals(props.getProperty(InstanceProperties.Property.REDELIVERED));
        AMQBody deliverBody = this.createEncodedDeliverBody(msg, isRedelivered, deliveryTag, consumerTag);
        return this.writeMessageDelivery(msg, channelId, deliverBody);
    }

    private AMQMessage convertToAMQMessage(ServerMessage serverMessage) {
        if (serverMessage instanceof AMQMessage) {
            return (AMQMessage)serverMessage;
        }
        return (AMQMessage)this.getMessageConverter(serverMessage).convert(serverMessage, this._connection.getAddressSpace());
    }

    private <M extends ServerMessage> MessageConverter<M, AMQMessage> getMessageConverter(M message) {
        Class<?> clazz = message.getClass();
        return MessageConverterRegistry.getConverter(clazz, AMQMessage.class);
    }

    private long writeMessageDelivery(AMQMessage message, int channelId, AMQBody deliverBody) {
        return this.writeMessageDelivery((MessageContentSource)message, message.getContentHeaderBody(), channelId, deliverBody);
    }

    private long writeMessageDelivery(MessageContentSource message, ContentHeaderBody contentHeaderBody, int channelId, AMQBody deliverBody) {
        long length;
        int bodySize = (int)message.getSize();
        boolean msgCompressed = this.isCompressed(contentHeaderBody);
        DisposableMessageContentSource modifiedContent = null;
        boolean compressionSupported = this._connection.isCompressionSupported();
        if (msgCompressed && !compressionSupported && (modifiedContent = this.inflateIfPossible(message)) != null) {
            BasicContentHeaderProperties modifiedProps = new BasicContentHeaderProperties(contentHeaderBody.getProperties());
            modifiedProps.setEncoding((String)null);
            length = this.writeMessageDeliveryModified(modifiedContent, channelId, deliverBody, modifiedProps);
        } else if (!msgCompressed && compressionSupported && contentHeaderBody.getProperties().getEncoding() == null && bodySize > this._connection.getMessageCompressionThreshold() && (modifiedContent = this.deflateIfPossible(message)) != null) {
            BasicContentHeaderProperties modifiedProps = new BasicContentHeaderProperties(contentHeaderBody.getProperties());
            modifiedProps.setEncoding(GZIP_ENCODING);
            length = this.writeMessageDeliveryModified(modifiedContent, channelId, deliverBody, modifiedProps);
        } else {
            this.writeMessageDeliveryUnchanged(message, channelId, deliverBody, contentHeaderBody, bodySize);
            length = bodySize;
        }
        if (modifiedContent != null) {
            modifiedContent.dispose();
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DisposableMessageContentSource deflateIfPossible(MessageContentSource source) {
        Collection contentBuffers = source.getContent(0, (int)source.getSize());
        try {
            ModifiedContentSource modifiedContentSource = new ModifiedContentSource(QpidByteBuffer.deflate((Collection)contentBuffers));
            return modifiedContentSource;
        }
        catch (IOException e) {
            LOGGER.warn("Unable to compress message payload for consumer with gzip, message will be sent as is", (Throwable)e);
            DisposableMessageContentSource disposableMessageContentSource = null;
            return disposableMessageContentSource;
        }
        finally {
            for (QpidByteBuffer contentBuffer : contentBuffers) {
                contentBuffer.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DisposableMessageContentSource inflateIfPossible(MessageContentSource source) {
        Collection contentBuffers = source.getContent(0, (int)source.getSize());
        try {
            ModifiedContentSource modifiedContentSource = new ModifiedContentSource(QpidByteBuffer.inflate((Collection)contentBuffers));
            return modifiedContentSource;
        }
        catch (IOException e) {
            LOGGER.warn("Unable to decompress message payload for consumer with gzip, message will be sent as is", (Throwable)e);
            DisposableMessageContentSource disposableMessageContentSource = null;
            return disposableMessageContentSource;
        }
        finally {
            for (QpidByteBuffer contentBuffer : contentBuffers) {
                contentBuffer.dispose();
            }
        }
    }

    private int writeMessageDeliveryModified(MessageContentSource content, int channelId, AMQBody deliverBody, BasicContentHeaderProperties modifiedProps) {
        int bodySize = (int)content.getSize();
        ContentHeaderBody modifiedHeaderBody = new ContentHeaderBody(modifiedProps, (long)bodySize);
        this.writeMessageDeliveryUnchanged(content, channelId, deliverBody, modifiedHeaderBody, bodySize);
        return bodySize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMessageDeliveryUnchanged(MessageContentSource content, int channelId, AMQBody deliverBody, ContentHeaderBody contentHeaderBody, int bodySize) {
        if (bodySize == 0) {
            SmallCompositeAMQBodyBlock compositeBlock = new SmallCompositeAMQBodyBlock(channelId, deliverBody, (AMQBody)contentHeaderBody);
            this.writeFrame(compositeBlock);
        } else {
            int maxFrameBodySize = (int)this._connection.getMaxFrameSize() - AMQFrame.getFrameOverhead();
            Collection contentByteBuffers = content.getContent(0, bodySize);
            try {
                int contentChunkSize = bodySize > maxFrameBodySize ? maxFrameBodySize : bodySize;
                Collection<QpidByteBuffer> chunk = ProtocolOutputConverterImpl.getContent(contentByteBuffers, 0, contentChunkSize);
                try {
                    this.writeFrame(new CompositeAMQBodyBlock(channelId, deliverBody, (AMQBody)contentHeaderBody, new MessageContentSourceBody(chunk)));
                }
                finally {
                    ProtocolOutputConverterImpl.dispose(chunk);
                }
                int writtenSize = contentChunkSize;
                while (writtenSize < bodySize) {
                    contentChunkSize = bodySize - writtenSize > maxFrameBodySize ? maxFrameBodySize : bodySize - writtenSize;
                    chunk = ProtocolOutputConverterImpl.getContent(contentByteBuffers, writtenSize, contentChunkSize);
                    try {
                        this.writeFrame((AMQDataBlock)new AMQFrame(channelId, (AMQBody)new MessageContentSourceBody(chunk)));
                        writtenSize += contentChunkSize;
                    }
                    finally {
                        ProtocolOutputConverterImpl.dispose(chunk);
                    }
                }
            }
            finally {
                ProtocolOutputConverterImpl.dispose(contentByteBuffers);
            }
        }
    }

    private boolean isCompressed(ContentHeaderBody contentHeaderBody) {
        return GZIP_ENCODING.equals(contentHeaderBody.getProperties().getEncoding());
    }

    private static void dispose(Collection<QpidByteBuffer> contentByteBuffers) {
        for (QpidByteBuffer qbb : contentByteBuffers) {
            qbb.dispose();
        }
    }

    private static Collection<QpidByteBuffer> getContent(Collection<QpidByteBuffer> messageContent, int offset, int length) {
        ArrayList<QpidByteBuffer> content = new ArrayList<QpidByteBuffer>(messageContent.size());
        int pos = 0;
        for (QpidByteBuffer buf : messageContent) {
            if (length <= 0) continue;
            int bufRemaining = buf.remaining();
            if (pos + bufRemaining <= offset) {
                pos += bufRemaining;
                continue;
            }
            if (pos >= offset) {
                buf = buf.duplicate();
                if (bufRemaining <= length) {
                    length -= bufRemaining;
                } else {
                    buf.limit(length);
                    length = 0;
                }
                content.add(buf);
                pos += buf.remaining();
                continue;
            }
            int offsetInBuf = offset - pos;
            int limit = length < bufRemaining - offsetInBuf ? length : bufRemaining - offsetInBuf;
            QpidByteBuffer bufView = buf.view(offsetInBuf, limit);
            content.add(bufView);
            length -= limit;
            pos += limit + offsetInBuf;
        }
        return content;
    }

    @Override
    public long writeGetOk(ServerMessage msg, InstanceProperties props, int channelId, long deliveryTag, int queueSize) {
        AMQBody deliver = this.createEncodedGetOkBody(msg, props, deliveryTag, queueSize);
        return this.writeMessageDelivery(this.convertToAMQMessage(msg), channelId, deliver);
    }

    private AMQBody createEncodedDeliverBody(AMQMessage message, boolean isRedelivered, long deliveryTag, AMQShortString consumerTag) {
        MessagePublishInfo pb = message.getMessagePublishInfo();
        AMQShortString exchangeName = pb.getExchange();
        AMQShortString routingKey = pb.getRoutingKey();
        return new EncodedDeliveryBody(deliveryTag, routingKey, exchangeName, consumerTag, isRedelivered);
    }

    private AMQBody createEncodedGetOkBody(ServerMessage msg, InstanceProperties props, long deliveryTag, int queueSize) {
        AMQMessage message = this.convertToAMQMessage(msg);
        MessagePublishInfo pb = message.getMessagePublishInfo();
        AMQShortString exchangeName = pb.getExchange();
        AMQShortString routingKey = pb.getRoutingKey();
        boolean isRedelivered = Boolean.TRUE.equals(props.getProperty(InstanceProperties.Property.REDELIVERED));
        return this._connection.getMethodRegistry().createBasicGetOkBody(deliveryTag, isRedelivered, exchangeName, routingKey, (long)queueSize);
    }

    private AMQBody createEncodedReturnFrame(MessagePublishInfo messagePublishInfo, int replyCode, AMQShortString replyText) {
        return this._connection.getMethodRegistry().createBasicReturnBody(replyCode, replyText, messagePublishInfo.getExchange(), messagePublishInfo.getRoutingKey());
    }

    @Override
    public void writeReturn(MessagePublishInfo messagePublishInfo, ContentHeaderBody header, MessageContentSource message, int channelId, int replyCode, AMQShortString replyText) {
        AMQBody returnFrame = this.createEncodedReturnFrame(messagePublishInfo, replyCode, replyText);
        this.writeMessageDelivery(message, header, channelId, returnFrame);
    }

    @Override
    public void writeFrame(AMQDataBlock block) {
        this._connection.writeFrame(block);
    }

    @Override
    public void confirmConsumerAutoClose(int channelId, AMQShortString consumerTag) {
        BasicCancelOkBody basicCancelOkBody = this._connection.getMethodRegistry().createBasicCancelOkBody(consumerTag);
        this.writeFrame((AMQDataBlock)basicCancelOkBody.generateFrame(channelId));
    }

    private static class ModifiedContentSource
    implements DisposableMessageContentSource {
        private final Collection<QpidByteBuffer> _buffers;
        private final int _size;

        public ModifiedContentSource(Collection<QpidByteBuffer> buffers) {
            this._buffers = buffers;
            int size = 0;
            for (QpidByteBuffer buf : buffers) {
                size += buf.remaining();
            }
            this._size = size;
        }

        @Override
        public void dispose() {
            for (QpidByteBuffer buffer : this._buffers) {
                buffer.dispose();
            }
        }

        public Collection<QpidByteBuffer> getContent(int offset, int length) {
            return ProtocolOutputConverterImpl.getContent(this._buffers, offset, length);
        }

        public long getSize() {
            return this._size;
        }
    }

    public static final class SmallCompositeAMQBodyBlock
    extends AMQDataBlock {
        public static final int OVERHEAD = 2 * AMQFrame.getFrameOverhead();
        private final AMQBody _methodBody;
        private final AMQBody _headerBody;
        private final int _channel;

        public SmallCompositeAMQBodyBlock(int channel, AMQBody methodBody, AMQBody headerBody) {
            this._channel = channel;
            this._methodBody = methodBody;
            this._headerBody = headerBody;
        }

        public long getSize() {
            return OVERHEAD + this._methodBody.getSize() + this._headerBody.getSize();
        }

        public long writePayload(ByteBufferSender sender) {
            long size = new AMQFrame(this._channel, this._methodBody).writePayload(sender);
            return size += new AMQFrame(this._channel, this._headerBody).writePayload(sender);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(((Object)((Object)this)).getClass().getSimpleName()).append("methodBody=").append(this._methodBody).append(", headerBody=").append(this._headerBody).append(", channel=").append(this._channel).append("]");
            return builder.toString();
        }
    }

    public static final class CompositeAMQBodyBlock
    extends AMQDataBlock {
        public static final int OVERHEAD = 3 * AMQFrame.getFrameOverhead();
        private final AMQBody _methodBody;
        private final AMQBody _headerBody;
        private final AMQBody _contentBody;
        private final int _channel;

        public CompositeAMQBodyBlock(int channel, AMQBody methodBody, AMQBody headerBody, AMQBody contentBody) {
            this._channel = channel;
            this._methodBody = methodBody;
            this._headerBody = headerBody;
            this._contentBody = contentBody;
        }

        public long getSize() {
            return OVERHEAD + this._methodBody.getSize() + this._headerBody.getSize() + this._contentBody.getSize();
        }

        public long writePayload(ByteBufferSender sender) {
            long size = new AMQFrame(this._channel, this._methodBody).writePayload(sender);
            size += new AMQFrame(this._channel, this._headerBody).writePayload(sender);
            return size += new AMQFrame(this._channel, this._contentBody).writePayload(sender);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[").append(((Object)((Object)this)).getClass().getSimpleName()).append(" methodBody=").append(this._methodBody).append(", headerBody=").append(this._headerBody).append(", contentBody=").append(this._contentBody).append(", channel=").append(this._channel).append("]");
            return builder.toString();
        }
    }

    private class EncodedDeliveryBody
    implements AMQBody {
        private final long _deliveryTag;
        private final AMQShortString _routingKey;
        private final AMQShortString _exchangeName;
        private final AMQShortString _consumerTag;
        private final boolean _isRedelivered;
        private AMQBody _underlyingBody;

        private EncodedDeliveryBody(long deliveryTag, AMQShortString routingKey, AMQShortString exchangeName, AMQShortString consumerTag, boolean isRedelivered) {
            this._deliveryTag = deliveryTag;
            this._routingKey = routingKey;
            this._exchangeName = exchangeName;
            this._consumerTag = consumerTag;
            this._isRedelivered = isRedelivered;
        }

        public AMQBody createAMQBody() {
            return ProtocolOutputConverterImpl.this._connection.getMethodRegistry().createBasicDeliverBody(this._consumerTag, this._deliveryTag, this._isRedelivered, this._exchangeName, this._routingKey);
        }

        public byte getFrameType() {
            return 1;
        }

        public int getSize() {
            if (this._underlyingBody == null) {
                this._underlyingBody = this.createAMQBody();
            }
            return this._underlyingBody.getSize();
        }

        public long writePayload(ByteBufferSender sender) {
            if (this._underlyingBody == null) {
                this._underlyingBody = this.createAMQBody();
            }
            return this._underlyingBody.writePayload(sender);
        }

        public void handle(int channelId, AMQVersionAwareProtocolSession amqProtocolSession) throws QpidException {
            throw new QpidException("This block should never be dispatched!");
        }

        public String toString() {
            return "[" + this.getClass().getSimpleName() + " underlyingBody: " + String.valueOf(this._underlyingBody) + "]";
        }
    }

    private class MessageContentSourceBody
    implements AMQBody {
        public static final byte TYPE = 3;
        private final int _length;
        private final Collection<QpidByteBuffer> _content;

        MessageContentSourceBody(Collection<QpidByteBuffer> content) {
            this._content = content;
            int size = 0;
            for (QpidByteBuffer qbb : content) {
                size += qbb.remaining();
            }
            this._length = size;
        }

        public byte getFrameType() {
            return 3;
        }

        public int getSize() {
            return this._length;
        }

        public long writePayload(ByteBufferSender sender) {
            long size = 0L;
            for (QpidByteBuffer qbb : this._content) {
                size += (long)qbb.remaining();
                sender.send(qbb);
            }
            return size;
        }

        public void handle(int channelId, AMQVersionAwareProtocolSession amqProtocolSession) throws QpidException {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "[" + this.getClass().getSimpleName() + " length: " + this._length + "]";
        }
    }

    static interface DisposableMessageContentSource
    extends MessageContentSource {
        public void dispose();
    }
}

