/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.transport.ByteBufferSender;

class CachedFrame
extends AMQDataBlock {
    private final String _toString;
    private final QpidByteBuffer _buffer;
    private final long _size;
    private boolean _disposed;

    CachedFrame(AMQDataBlock original) {
        this._toString = original.toString();
        this._size = original.getSize();
        this._buffer = QpidByteBuffer.allocate((boolean)true, (int)((int)this._size));
        original.writePayload((ByteBufferSender)new BufferWriterSender(this._buffer));
        this._buffer.flip();
    }

    public long getSize() {
        return this._size;
    }

    public long writePayload(ByteBufferSender sender) {
        QpidByteBuffer dup = this._buffer.duplicate();
        sender.send(dup);
        dup.dispose();
        return this._size;
    }

    public String toString() {
        return this._toString;
    }

    public void dispose() {
        this._buffer.dispose();
        this._disposed = true;
    }

    private static class BufferWriterSender
    implements ByteBufferSender {
        private final QpidByteBuffer _buffer;

        BufferWriterSender(QpidByteBuffer buffer) {
            this._buffer = buffer;
        }

        public boolean isDirectBufferPreferred() {
            return true;
        }

        public void send(QpidByteBuffer msg) {
            QpidByteBuffer dup = msg.duplicate();
            this._buffer.put(dup);
            dup.dispose();
        }

        public void flush() {
        }

        public void close() {
        }
    }
}

