/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhostnode;

import java.util.Collection;
import java.util.Map;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.ManageableMessage;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.util.FixedKeyMapCreator;
import org.apache.qpid.server.virtualhostnode.RedirectingVirtualHostImpl;

final class RedirectingVirtualHostImplWithAccessChecking
extends RedirectingVirtualHostImpl {
    private static final FixedKeyMapCreator GET_CONNECTION_MAP_CREATOR = new FixedKeyMapCreator("name");
    private static final FixedKeyMapCreator PUBLISH_MESSAGE_MAP_CREATOR = new FixedKeyMapCreator("message");
    private static final FixedKeyMapCreator EXTRACT_CONFIG_MAP_CREATOR = new FixedKeyMapCreator("includeSecureAttributes");
    private static final FixedKeyMapCreator IMPORT_MESSAGE_STORE_MAP_CREATOR = new FixedKeyMapCreator("source");

    RedirectingVirtualHostImplWithAccessChecking(Map<String, Object> attributes, VirtualHostNode<?> virtualhostnode) {
        super(attributes, virtualhostnode);
    }

    @Override
    public Collection<? extends Connection<?>> getConnections() {
        this.authorise(Operation.METHOD("getConnections"));
        return super.getConnections();
    }

    @Override
    public Connection<?> getConnection(String name) {
        this.authorise(Operation.METHOD("getConnection"), GET_CONNECTION_MAP_CREATOR.createMap(name));
        return super.getConnection(name);
    }

    @Override
    public int publishMessage(ManageableMessage message) {
        this.authorise(Operation.METHOD("publishMessage"), PUBLISH_MESSAGE_MAP_CREATOR.createMap(message));
        return super.publishMessage(message);
    }

    @Override
    public Map<String, Object> extractConfig(boolean includeSecureAttributes) {
        this.authorise(Operation.METHOD("extractConfig"), EXTRACT_CONFIG_MAP_CREATOR.createMap(includeSecureAttributes));
        return super.extractConfig(includeSecureAttributes);
    }

    @Override
    public Content exportMessageStore() {
        this.authorise(Operation.METHOD("exportMessageStore"));
        return super.exportMessageStore();
    }

    @Override
    public void importMessageStore(String source) {
        this.authorise(Operation.METHOD("importMessageStore"), IMPORT_MESSAGE_STORE_MAP_CREATOR.createMap(source));
        super.importMessageStore(source);
    }
}

