/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhostnode;

import com.google.common.util.concurrent.ListenableFuture;
import java.security.AccessControlContext;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.ManageableMessage;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.model.preferences.UserPreferences;
import org.apache.qpid.server.protocol.LinkRegistry;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.txn.DtxRegistry;
import org.apache.qpid.server.virtualhost.HouseKeepingTask;
import org.apache.qpid.server.virtualhost.NodeAutoCreationPolicy;
import org.apache.qpid.server.virtualhost.VirtualHostPrincipal;
import org.apache.qpid.server.virtualhostnode.RedirectingVirtualHost;
import org.apache.qpid.server.virtualhostnode.RedirectingVirtualHostNode;

@ManagedObject(category=false, type="REDIRECTOR", register=false, description="A special virtualhost type that merely redirects all incoming connections to an alternative broker.  The mapping which governs the redirect is held by the the parent virtual host node.")
class RedirectingVirtualHostImpl
extends AbstractConfiguredObject<RedirectingVirtualHostImpl>
implements RedirectingVirtualHost<RedirectingVirtualHostImpl> {
    public static final String VIRTUAL_HOST_TYPE = "REDIRECTOR";
    private final Broker<?> _broker;
    private final VirtualHostPrincipal _principal;
    @ManagedAttributeField
    private boolean _queue_deadLetterQueueEnabled;
    @ManagedAttributeField
    private long _housekeepingCheckPeriod;
    @ManagedAttributeField
    private long _storeTransactionIdleTimeoutClose;
    @ManagedAttributeField
    private long _storeTransactionIdleTimeoutWarn;
    @ManagedAttributeField
    private long _storeTransactionOpenTimeoutClose;
    @ManagedAttributeField
    private long _storeTransactionOpenTimeoutWarn;
    @ManagedAttributeField
    private int _housekeepingThreadCount;
    @ManagedAttributeField
    private int _numberOfSelectors;
    @ManagedAttributeField
    private int _connectionThreadPoolSize;
    @ManagedAttributeField
    private List<String> _enabledConnectionValidators;
    @ManagedAttributeField
    private List<String> _disabledConnectionValidators;
    @ManagedAttributeField
    private List<String> _globalAddressDomains;
    @ManagedAttributeField
    private List<NodeAutoCreationPolicy> _nodeAutoCreationPolicies;

    @ManagedObjectFactoryConstructor
    public RedirectingVirtualHostImpl(Map<String, Object> attributes, VirtualHostNode<?> virtualHostNode) {
        super(RedirectingVirtualHostImpl.parentsMap(virtualHostNode), attributes);
        this._broker = virtualHostNode.getParent(Broker.class);
        this._principal = new VirtualHostPrincipal(this);
        this.setState(State.UNAVAILABLE);
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        if (changedAttributes.contains("desiredState") && proxyForValidation.getDesiredState() == State.DELETED) {
            throw new IllegalConfigurationException("Directly deleting a redirecting virtualhost is not supported. Delete the parent virtual host node '" + this.getParent(VirtualHostNode.class) + "' instead.");
        }
        throw new IllegalConfigurationException("A redirecting virtualhost does not support changing of its attributes");
    }

    @Override
    public String getModelVersion() {
        return "6.1";
    }

    @Override
    public void executeTask(String name, Runnable task, AccessControlContext context) {
        this.throwUnsupportedForRedirector();
    }

    @Override
    protected <C extends ConfiguredObject> ListenableFuture<C> addChildAsync(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        this.throwUnsupportedForRedirector();
        return null;
    }

    @Override
    public Broker<?> getBroker() {
        return this._broker;
    }

    @Override
    public MessageDestination getAttainedMessageDestination(String name) {
        return null;
    }

    @Override
    public long getBytesEvacuatedFromMemory() {
        return 0L;
    }

    @Override
    public <T extends ConfiguredObject<?>> T getAttainedChildFromAddress(Class<T> childClass, String address) {
        return null;
    }

    @Override
    public void executeTransaction(VirtualHost.TransactionalOperation op) {
        this.throwUnsupportedForRedirector();
    }

    @Override
    public String getRedirectHost(AmqpPort<?> port) {
        return ((RedirectingVirtualHostNode)this.getParent(VirtualHostNode.class)).getRedirects().get(port);
    }

    @Override
    public boolean isQueue_deadLetterQueueEnabled() {
        return false;
    }

    @Override
    public long getHousekeepingCheckPeriod() {
        return 0L;
    }

    @Override
    public long getStoreTransactionIdleTimeoutClose() {
        return 0L;
    }

    @Override
    public long getStoreTransactionIdleTimeoutWarn() {
        return 0L;
    }

    @Override
    public long getStoreTransactionOpenTimeoutClose() {
        return 0L;
    }

    @Override
    public long getStoreTransactionOpenTimeoutWarn() {
        return 0L;
    }

    @Override
    public int getHousekeepingThreadCount() {
        return 0;
    }

    @Override
    public List<NodeAutoCreationPolicy> getNodeAutoCreationPolicies() {
        return Collections.emptyList();
    }

    @Override
    public int getConnectionThreadPoolSize() {
        return 0;
    }

    @Override
    public int getNumberOfSelectors() {
        return 0;
    }

    @Override
    public long getQueueCount() {
        return 0L;
    }

    @Override
    public long getExchangeCount() {
        return 0L;
    }

    @Override
    public long getConnectionCount() {
        return 0L;
    }

    @Override
    public long getBytesIn() {
        return 0L;
    }

    @Override
    public long getBytesOut() {
        return 0L;
    }

    @Override
    public long getMessagesIn() {
        return 0L;
    }

    @Override
    public long getMessagesOut() {
        return 0L;
    }

    @Override
    public Collection<? extends Connection<?>> getConnections() {
        return Collections.emptyList();
    }

    @Override
    public Connection<?> getConnection(String name) {
        return null;
    }

    @Override
    public Map<String, Object> extractConfig(boolean includeSecureAttributes) {
        return Collections.emptyMap();
    }

    @Override
    public Content exportMessageStore() {
        this.throwUnsupportedForRedirector();
        return null;
    }

    @Override
    public void importMessageStore(String source) {
        this.throwUnsupportedForRedirector();
    }

    @Override
    public int publishMessage(ManageableMessage message) {
        this.throwUnsupportedForRedirector();
        return 0;
    }

    @Override
    public MessageSource getAttainedMessageSource(String name) {
        return null;
    }

    @Override
    public Queue<?> getAttainedQueue(UUID id) {
        return null;
    }

    @Override
    public DurableConfigurationStore getDurableConfigurationStore() {
        return null;
    }

    @Override
    public MessageDestination getDefaultDestination() {
        return null;
    }

    @Override
    public MessageStore getMessageStore() {
        return null;
    }

    @Override
    public <T extends MessageSource> T createMessageSource(Class<T> clazz, Map<String, Object> attributes) {
        this.throwUnsupportedForRedirector();
        return null;
    }

    @Override
    public <T extends MessageDestination> T createMessageDestination(Class<T> clazz, Map<String, Object> attributes) {
        this.throwUnsupportedForRedirector();
        return null;
    }

    @Override
    public boolean hasMessageSources() {
        return false;
    }

    @Override
    public void setTargetSize(long targetSize) {
    }

    @Override
    public long getTargetSize() {
        return 0L;
    }

    @Override
    public long getTotalQueueDepthBytes() {
        return 0L;
    }

    @Override
    public void scheduleHouseKeepingTask(long period, HouseKeepingTask task) {
    }

    @Override
    public DtxRegistry getDtxRegistry() {
        return null;
    }

    @Override
    public LinkRegistry getLinkRegistry(String remoteContainerId) {
        return null;
    }

    @Override
    public ScheduledFuture<?> scheduleTask(long delay, Runnable timeoutTask) {
        this.throwUnsupportedForRedirector();
        return null;
    }

    @Override
    public EventLogger getEventLogger() {
        return null;
    }

    @Override
    public boolean authoriseCreateConnection(AMQPConnection<?> connection) {
        return false;
    }

    @Override
    public List<String> getEnabledConnectionValidators() {
        return this._enabledConnectionValidators;
    }

    @Override
    public List<String> getDisabledConnectionValidators() {
        return this._disabledConnectionValidators;
    }

    @Override
    public List<String> getGlobalAddressDomains() {
        return this._globalAddressDomains;
    }

    @Override
    public String getLocalAddress(String routingAddress) {
        String localAddress = routingAddress;
        if (this.getGlobalAddressDomains() != null) {
            for (String domain : this.getGlobalAddressDomains()) {
                if (localAddress.length() <= routingAddress.length() - domain.length() || !routingAddress.startsWith(domain + "/")) continue;
                localAddress = routingAddress.substring(domain.length());
            }
        }
        return localAddress;
    }

    @Override
    public Principal getPrincipal() {
        return this._principal;
    }

    @Override
    public void registerConnection(AMQPConnection<?> connection) {
        this.throwUnsupportedForRedirector();
    }

    @Override
    public void deregisterConnection(AMQPConnection<?> connection) {
        this.throwUnsupportedForRedirector();
    }

    private void throwUnsupportedForRedirector() {
        throw new IllegalStateException("The virtual host state of " + (Object)((Object)this.getState()) + " does not permit this operation.");
    }

    @Override
    public void setFirstOpening(boolean firstOpening) {
    }

    @Override
    public UserPreferences createUserPreferences(ConfiguredObject<?> object) {
        this.throwUnsupportedForRedirector();
        return null;
    }
}

