/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhostalias;

import java.util.Map;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostNameAlias;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.virtualhostalias.AbstractVirtualHostAlias;

public class VirtualHostNameAliasImpl
extends AbstractVirtualHostAlias<VirtualHostNameAliasImpl>
implements VirtualHostNameAlias<VirtualHostNameAliasImpl> {
    @ManagedObjectFactoryConstructor
    protected VirtualHostNameAliasImpl(Map<String, Object> attributes, Port port) {
        super(attributes, port);
    }

    @Override
    public NamedAddressSpace getAddressSpace(String name) {
        Broker broker = this.getPort().getParent(Broker.class);
        VirtualHost<?> addressSpace = broker.getSystemAddressSpace(name);
        if (addressSpace == null) {
            for (VirtualHostNode<?> vhn : broker.getVirtualHostNodes()) {
                VirtualHost<?> vh = vhn.getVirtualHost();
                if (vh == null || !vh.getName().equals(name)) continue;
                addressSpace = vh;
                break;
            }
        }
        return addressSpace;
    }
}

