/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhostalias;

import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.PatternMatchingAlias;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.SystemAddressSpaceAlias;
import org.apache.qpid.server.virtualhostalias.AbstractVirtualHostAlias;

public class SystemAddressSpaceAliasImpl
extends AbstractVirtualHostAlias<SystemAddressSpaceAliasImpl>
implements SystemAddressSpaceAlias<SystemAddressSpaceAliasImpl> {
    @ManagedAttributeField
    private String _pattern;
    @ManagedAttributeField
    private String _systemAddressSpace;

    @ManagedObjectFactoryConstructor
    protected SystemAddressSpaceAliasImpl(Map<String, Object> attributes, Port port) {
        super(attributes, port);
    }

    protected boolean matches(String name) {
        return name == null ? "".matches(this._pattern) : name.matches(this._pattern);
    }

    @Override
    public void onValidate() {
        super.onValidate();
        this.validatePattern(this.getPattern());
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        this.validatePattern(((PatternMatchingAlias)proxyForValidation).getPattern());
    }

    private void validatePattern(String pattern) {
        try {
            Pattern pattern2 = Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalConfigurationException("'" + pattern + "' is not a valid Java regex pattern", e);
        }
    }

    @Override
    public String getPattern() {
        return this._pattern;
    }

    @Override
    public String getSystemAddressSpace() {
        return this._systemAddressSpace;
    }

    @Override
    public NamedAddressSpace getAddressSpace(String name) {
        return this.matches(name) ? this.getParent(Broker.class).getSystemAddressSpace(this.getSystemAddressSpace()) : null;
    }
}

