/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.qpid.server.consumer.ConsumerImpl;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.message.internal.InternalMessageHeader;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.virtualhost.AbstractSystemMessageSource;

public class VirtualHostPropertiesNode
extends AbstractSystemMessageSource {
    public VirtualHostPropertiesNode(NamedAddressSpace virtualHost) {
        this(virtualHost, "$virtualhostProperties");
    }

    public VirtualHostPropertiesNode(NamedAddressSpace virtualHost, String name) {
        super(name, virtualHost);
    }

    @Override
    public AbstractSystemMessageSource.Consumer addConsumer(ConsumerTarget target, FilterManager filters, Class<? extends ServerMessage> messageClass, String consumerName, EnumSet<ConsumerImpl.Option> options, Integer priority) throws MessageSource.ExistingExclusiveConsumer, MessageSource.ExistingConsumerPreventsExclusive, MessageSource.ConsumerAccessRefused {
        ConsumerImpl consumer = super.addConsumer(target, filters, (Class)messageClass, consumerName, (EnumSet)options, priority);
        ((AbstractSystemMessageSource.Consumer)consumer).send(this.createMessage());
        target.queueEmpty();
        return consumer;
    }

    protected InternalMessage createMessage() {
        String primaryDomain;
        HashMap<String, Object> headers = new HashMap<String, Object>();
        List<String> globalAddresseDomains = this._addressSpace.getGlobalAddressDomains();
        if (globalAddresseDomains != null && !globalAddresseDomains.isEmpty() && (primaryDomain = globalAddresseDomains.get(0)) != null) {
            if (!(primaryDomain = primaryDomain.trim()).endsWith("/")) {
                primaryDomain = primaryDomain + "/";
            }
            headers.put("virtualHost.temporaryQueuePrefix", primaryDomain);
        }
        InternalMessageHeader header = new InternalMessageHeader(headers, null, 0L, null, null, UUID.randomUUID().toString(), null, null, 4, System.currentTimeMillis(), 0L, null, null);
        InternalMessage message = InternalMessage.createBytesMessage(this._addressSpace.getMessageStore(), header, new byte[0]);
        message.setInitialRoutingAddress(this.getName());
        return message;
    }
}

