/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import java.util.Map;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.MessageStoreProvider;
import org.apache.qpid.server.virtualhost.AbstractVirtualHost;
import org.apache.qpid.server.virtualhost.ProvidedStoreVirtualHost;

@ManagedObject(category=false, type="ProvidedStore")
public class ProvidedStoreVirtualHostImpl
extends AbstractVirtualHost<ProvidedStoreVirtualHostImpl>
implements ProvidedStoreVirtualHost<ProvidedStoreVirtualHostImpl> {
    public static final String VIRTUAL_HOST_TYPE = "ProvidedStore";
    public static final String STORE_PATH = "storePath";
    @ManagedAttributeField
    private Long _storeUnderfullSize;
    @ManagedAttributeField
    private Long _storeOverfullSize;

    @ManagedObjectFactoryConstructor
    public ProvidedStoreVirtualHostImpl(Map<String, Object> attributes, VirtualHostNode<?> virtualHostNode) {
        super(attributes, virtualHostNode);
    }

    @Override
    public void onValidate() {
        super.onValidate();
        VirtualHostNode virtualHostNode = this.getParent(VirtualHostNode.class);
        DurableConfigurationStore configurationStore = virtualHostNode.getConfigurationStore();
        if (!(configurationStore instanceof MessageStoreProvider)) {
            throw new IllegalConfigurationException("ProvidedStore virtual host can only be used where the node's store (" + configurationStore.getClass().getName() + ") is a message store provider. ");
        }
    }

    @Override
    protected MessageStore createMessageStore() {
        VirtualHostNode virtualHostNode = this.getParent(VirtualHostNode.class);
        MessageStoreProvider messageStoreProvider = (MessageStoreProvider)((Object)virtualHostNode.getConfigurationStore());
        return messageStoreProvider.getMessageStore();
    }

    @Override
    public Long getStoreUnderfullSize() {
        return this._storeUnderfullSize;
    }

    @Override
    public Long getStoreOverfullSize() {
        return this._storeOverfullSize;
    }
}

