/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.qpid.server.model.VirtualHost;

public abstract class HouseKeepingTask
implements Runnable {
    private final String _name;
    private final AccessControlContext _accessControlContext;

    public HouseKeepingTask(String name, VirtualHost vhost, AccessControlContext context) {
        this._name = name == null ? vhost.getName() + ":" + this.getClass().getSimpleName() : name;
        this._accessControlContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        String originalThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this._name);
        try {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    HouseKeepingTask.this.execute();
                    return null;
                }
            }, this._accessControlContext);
        }
        finally {
            Thread.currentThread().setName(originalThreadName);
        }
    }

    public abstract void execute();
}

