/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import com.google.common.base.Function;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlContext;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.security.auth.Subject;
import org.apache.qpid.pool.SuppressingInheritedAccessControlContextThreadFactory;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.configuration.updater.TaskExecutorImpl;
import org.apache.qpid.server.exchange.DefaultDestination;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.MessageStoreMessages;
import org.apache.qpid.server.logging.messages.VirtualHostMessages;
import org.apache.qpid.server.logging.subjects.MessageStoreLogSubject;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.EnqueueableMessage;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageNode;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfigurationExtractor;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.CustomRestHeaders;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.ManageableMessage;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.NoFactoryForTypeException;
import org.apache.qpid.server.model.Param;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.RestContentHeader;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.model.UnknownConfiguredObjectException;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostAccessControlProvider;
import org.apache.qpid.server.model.VirtualHostAlias;
import org.apache.qpid.server.model.VirtualHostLogger;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.model.preferences.UserPreferences;
import org.apache.qpid.server.model.preferences.UserPreferencesImpl;
import org.apache.qpid.server.plugin.ConnectionValidator;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.plugin.SystemNodeCreator;
import org.apache.qpid.server.protocol.LinkRegistry;
import org.apache.qpid.server.protocol.LinkRegistryImpl;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.security.AccessControl;
import org.apache.qpid.server.security.CompoundAccessControl;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.SubjectFixedResultAccessControl;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.stats.StatisticsCounter;
import org.apache.qpid.server.stats.StatisticsGatherer;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.Event;
import org.apache.qpid.server.store.EventListener;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.MessageStoreProvider;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.store.Transaction;
import org.apache.qpid.server.store.VirtualHostStoreUpgraderAndRecoverer;
import org.apache.qpid.server.store.handler.ConfiguredObjectRecordHandler;
import org.apache.qpid.server.store.handler.DistributedTransactionHandler;
import org.apache.qpid.server.store.handler.MessageHandler;
import org.apache.qpid.server.store.handler.MessageInstanceHandler;
import org.apache.qpid.server.store.preferences.PreferenceRecord;
import org.apache.qpid.server.store.preferences.PreferenceStore;
import org.apache.qpid.server.store.preferences.PreferenceStoreUpdaterImpl;
import org.apache.qpid.server.store.preferences.PreferencesRecoverer;
import org.apache.qpid.server.store.preferences.PreferencesRoot;
import org.apache.qpid.server.store.serializer.MessageStoreSerializer;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.transport.NetworkConnectionScheduler;
import org.apache.qpid.server.txn.AutoCommitTransaction;
import org.apache.qpid.server.txn.DtxRegistry;
import org.apache.qpid.server.txn.LocalTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.util.HousekeepingExecutor;
import org.apache.qpid.server.util.MapValueConverter;
import org.apache.qpid.server.virtualhost.AsynchronousMessageStoreRecoverer;
import org.apache.qpid.server.virtualhost.ExchangeExistsException;
import org.apache.qpid.server.virtualhost.HouseKeepingTask;
import org.apache.qpid.server.virtualhost.MessageStoreRecoverer;
import org.apache.qpid.server.virtualhost.NodeAutoCreationPolicy;
import org.apache.qpid.server.virtualhost.QueueExistsException;
import org.apache.qpid.server.virtualhost.ReservedExchangeNameException;
import org.apache.qpid.server.virtualhost.SynchronousMessageStoreRecoverer;
import org.apache.qpid.server.virtualhost.VirtualHostPrincipal;
import org.apache.qpid.server.virtualhost.VirtualHostUnavailableException;
import org.apache.qpid.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVirtualHost<X extends AbstractVirtualHost<X>>
extends AbstractConfiguredObject<X>
implements VirtualHost<X>,
EventListener,
StatisticsGatherer {
    private final Collection<ConnectionValidator> _connectionValidators = new ArrayList<ConnectionValidator>();
    private final Set<AMQPConnection<?>> _connections = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AccessControlContext _housekeepingJobContext;
    private final AccessControlContext _fileSystemSpaceCheckerJobContext;
    private final AtomicBoolean _acceptsConnections = new AtomicBoolean(false);
    private TaskExecutor _preferenceTaskExecutor;
    private static final String USE_ASYNC_RECOVERY = "use_async_message_store_recovery";
    public static final String DEFAULT_DLQ_NAME_SUFFIX = "_DLQ";
    public static final String DLQ_ROUTING_KEY = "dlq";
    public static final String CREATE_DLQ_ON_CREATION = "x-qpid-dlq-enabled";
    private static final int MAX_LENGTH = 255;
    private static final Logger _logger = LoggerFactory.getLogger(AbstractVirtualHost.class);
    private static final int HOUSEKEEPING_SHUTDOWN_TIMEOUT = 5;
    private ScheduledThreadPoolExecutor _houseKeepingTaskExecutor;
    private final Broker<?> _broker;
    private final DtxRegistry _dtxRegistry;
    private final SystemNodeRegistry _systemNodeRegistry = new SystemNodeRegistry();
    private final StatisticsCounter _messagesDelivered;
    private final StatisticsCounter _dataDelivered;
    private final StatisticsCounter _messagesReceived;
    private final StatisticsCounter _dataReceived;
    private final Map<String, LinkRegistry> _linkRegistry = new HashMap<String, LinkRegistry>();
    private AtomicBoolean _blocked = new AtomicBoolean();
    private final Map<String, MessageDestination> _systemNodeDestinations = Collections.synchronizedMap(new HashMap());
    private final Map<String, MessageSource> _systemNodeSources = Collections.synchronizedMap(new HashMap());
    private final EventLogger _eventLogger;
    private final VirtualHostNode<?> _virtualHostNode;
    private final AtomicLong _targetSize = new AtomicLong(0x6400000L);
    private MessageStoreLogSubject _messageStoreLogSubject;
    private final Set<BlockingType> _blockingReasons = Collections.synchronizedSet(EnumSet.noneOf(BlockingType.class));
    private NetworkConnectionScheduler _networkConnectionScheduler;
    private final VirtualHostPrincipal _principal;
    private ConfigurationChangeListener _accessControlProviderListener = new AccessControlProviderListener();
    private final AccessControl _accessControl;
    private volatile boolean _createDefaultExchanges;
    private final AccessControl _systemUserAllowed = new SubjectFixedResultAccessControl(new SubjectFixedResultAccessControl.ResultCalculator(){

        @Override
        public Result getResult(Subject subject) {
            return AbstractVirtualHost.this.isSystemSubject(subject) ? Result.ALLOWED : Result.DEFER;
        }
    }, Result.DEFER);
    @ManagedAttributeField
    private boolean _queue_deadLetterQueueEnabled;
    @ManagedAttributeField
    private long _housekeepingCheckPeriod;
    @ManagedAttributeField
    private long _storeTransactionIdleTimeoutClose;
    @ManagedAttributeField
    private long _storeTransactionIdleTimeoutWarn;
    @ManagedAttributeField
    private long _storeTransactionOpenTimeoutClose;
    @ManagedAttributeField
    private long _storeTransactionOpenTimeoutWarn;
    @ManagedAttributeField
    private int _housekeepingThreadCount;
    @ManagedAttributeField
    private int _connectionThreadPoolSize;
    @ManagedAttributeField
    private int _numberOfSelectors;
    @ManagedAttributeField
    private List<String> _enabledConnectionValidators;
    @ManagedAttributeField
    private List<String> _disabledConnectionValidators;
    @ManagedAttributeField
    private List<String> _globalAddressDomains;
    @ManagedAttributeField
    private List<NodeAutoCreationPolicy> _nodeAutoCreationPolicies;
    private boolean _useAsyncRecoverer;
    private MessageDestination _defaultDestination;
    private MessageStore _messageStore;
    private MessageStoreRecoverer _messageStoreRecoverer;
    private final FileSystemSpaceChecker _fileSystemSpaceChecker;
    private int _fileSystemMaxUsagePercent;
    private Collection<VirtualHostLogger> _virtualHostLoggersToClose;
    private PreferenceStore _preferenceStore;

    public AbstractVirtualHost(Map<String, Object> attributes, VirtualHostNode<?> virtualHostNode) {
        super(AbstractVirtualHost.parentsMap(virtualHostNode), attributes);
        this._broker = virtualHostNode.getParent(Broker.class);
        this._virtualHostNode = virtualHostNode;
        this._dtxRegistry = new DtxRegistry(this);
        this._eventLogger = this._broker.getParent(SystemConfig.class).getEventLogger();
        this._eventLogger.message(VirtualHostMessages.CREATED(this.getName()));
        this._messagesDelivered = new StatisticsCounter("messages-delivered-" + this.getName());
        this._dataDelivered = new StatisticsCounter("bytes-delivered-" + this.getName());
        this._messagesReceived = new StatisticsCounter("messages-received-" + this.getName());
        this._dataReceived = new StatisticsCounter("bytes-received-" + this.getName());
        this._principal = new VirtualHostPrincipal(this);
        this._accessControl = this._broker.getParent(SystemConfig.class).isManagementMode() ? AccessControl.ALWAYS_ALLOWED : new CompoundAccessControl(Collections.emptyList(), Result.DEFER);
        this._defaultDestination = new DefaultDestination(this, this._accessControl);
        this._housekeepingJobContext = this.getSystemTaskControllerContext("Housekeeping[" + this.getName() + "]", this._principal);
        this._fileSystemSpaceCheckerJobContext = this.getSystemTaskControllerContext("FileSystemSpaceChecker[" + this.getName() + "]", this._principal);
        this._fileSystemSpaceChecker = new FileSystemSpaceChecker();
        this.addChangeListener(new TargetSizeAssigningListener());
    }

    private void updateAccessControl() {
        if (!this._broker.getParent(SystemConfig.class).isManagementMode()) {
            ArrayList<VirtualHostAccessControlProvider> children = new ArrayList<VirtualHostAccessControlProvider>(this.getChildren(VirtualHostAccessControlProvider.class));
            _logger.debug("Updating access control list with {} provider children", (Object)children.size());
            Collections.sort(children, VirtualHostAccessControlProvider.ACCESS_CONTROL_PROVIDER_COMPARATOR);
            ArrayList accessControls = new ArrayList(children.size() + 2);
            accessControls.add(this._systemUserAllowed);
            for (VirtualHostAccessControlProvider prov : children) {
                if (prov.getState() == State.ERRORED) {
                    accessControls.clear();
                    accessControls.add(AccessControl.ALWAYS_DENIED);
                    break;
                }
                if (prov.getState() != State.ACTIVE) continue;
                accessControls.add(prov.getAccessControl());
            }
            accessControls.add(this.getParentAccessControl());
            ((CompoundAccessControl)this._accessControl).setAccessControls(accessControls);
        }
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        this._createDefaultExchanges = true;
    }

    @Override
    public void setFirstOpening(boolean firstOpening) {
        this._createDefaultExchanges = firstOpening;
    }

    @Override
    public void onValidate() {
        super.onValidate();
        String name = this.getName();
        if (name == null || "".equals(name.trim())) {
            throw new IllegalConfigurationException("Virtual host name must be specified");
        }
        String type = this.getType();
        if (type == null || "".equals(type.trim())) {
            throw new IllegalConfigurationException("Virtual host type must be specified");
        }
        if (!this.isDurable()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " must be durable");
        }
        if (this.getGlobalAddressDomains() != null) {
            for (String domain : this.getGlobalAddressDomains()) {
                this.validateGlobalAddressDomain(domain);
            }
        }
        if (this.getNodeAutoCreationPolicies() != null) {
            for (NodeAutoCreationPolicy policy : this.getNodeAutoCreationPolicies()) {
                this.validateNodeAutoCreationPolicy(policy);
            }
        }
        this.validateConnectionThreadPoolSettings(this);
        this.validateMessageStoreCreation();
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        VirtualHost virtualHost = (VirtualHost)proxyForValidation;
        if (changedAttributes.contains("globalAddressDomains") && virtualHost.getGlobalAddressDomains() != null) {
            for (String name : virtualHost.getGlobalAddressDomains()) {
                this.validateGlobalAddressDomain(name);
            }
        }
        if (changedAttributes.contains("nodeAutoCreationPolicies") && this.getNodeAutoCreationPolicies() != null) {
            for (NodeAutoCreationPolicy policy : virtualHost.getNodeAutoCreationPolicies()) {
                this.validateNodeAutoCreationPolicy(policy);
            }
        }
        if (changedAttributes.contains("connectionThreadPoolSize") || changedAttributes.contains("numberOfSelectors")) {
            this.validateConnectionThreadPoolSettings(virtualHost);
        }
    }

    @Override
    protected AccessControl getAccessControl() {
        return this._accessControl;
    }

    private AccessControl getParentAccessControl() {
        return super.getAccessControl();
    }

    @Override
    protected void postResolveChildren() {
        super.postResolveChildren();
        this.addChangeListener(this._accessControlProviderListener);
    }

    private void validateNodeAutoCreationPolicy(NodeAutoCreationPolicy policy) {
        String pattern = policy.getPattern();
        if (pattern == null) {
            throw new IllegalArgumentException("The 'pattern' attribute of a NodeAutoCreationPattern MUST be supplied: " + policy);
        }
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("The 'pattern' attribute of a NodeAutoCreationPattern MUST be a valid Java Regular Expression Pattern, the value '" + pattern + "' is not: " + policy);
        }
        String nodeType = policy.getNodeType();
        Class<? extends ConfiguredObject> sourceClass = null;
        for (Class<? extends ConfiguredObject> childClass : this.getModel().getChildTypes(this.getCategoryClass())) {
            if (!childClass.getSimpleName().equalsIgnoreCase(nodeType.trim())) continue;
            sourceClass = childClass;
            break;
        }
        if (sourceClass == null) {
            throw new IllegalArgumentException("The node type of a NodeAutoCreationPattern must be a valid child type of a VirtualHost, '" + nodeType + "' is not.");
        }
        if (policy.isCreatedOnConsume() && !MessageSource.class.isAssignableFrom(sourceClass)) {
            throw new IllegalArgumentException("A NodeAutoCreationPattern which creates nodes on consume must have a nodeType which implements MessageSource, '" + nodeType + "' does not.");
        }
        if (policy.isCreatedOnPublish() && !MessageDestination.class.isAssignableFrom(sourceClass)) {
            throw new IllegalArgumentException("A NodeAutoCreationPattern which creates nodes on publish must have a nodeType which implements MessageDestination, '" + nodeType + "' does not.");
        }
        if (!policy.isCreatedOnConsume() && !policy.isCreatedOnPublish()) {
            throw new IllegalArgumentException("A NodeAutoCreationPattern must create on consume, create on publish or both.");
        }
    }

    private void validateGlobalAddressDomain(String name) {
        String regex = "/(/?)([\\w_\\-:.\\$]+/)*[\\w_\\-:.\\$]+";
        if (!name.matches(regex)) {
            throw new IllegalArgumentException("'" + name + "' is not a valid global address domain");
        }
    }

    @Override
    public MessageStore getMessageStore() {
        return this._messageStore;
    }

    private void validateConnectionThreadPoolSettings(VirtualHost<?> virtualHost) {
        if (virtualHost.getConnectionThreadPoolSize() < 1) {
            throw new IllegalConfigurationException(String.format("Thread pool size %d on VirtualHost %s must be greater than zero.", virtualHost.getConnectionThreadPoolSize(), this.getName()));
        }
        if (virtualHost.getNumberOfSelectors() < 1) {
            throw new IllegalConfigurationException(String.format("Number of Selectors %d on VirtualHost %s must be greater than zero.", virtualHost.getNumberOfSelectors(), this.getName()));
        }
        if (virtualHost.getConnectionThreadPoolSize() <= virtualHost.getNumberOfSelectors()) {
            throw new IllegalConfigurationException(String.format("Number of Selectors %d on VirtualHost %s must be less than the connection pool size %d.", virtualHost.getNumberOfSelectors(), this.getName(), virtualHost.getConnectionThreadPoolSize()));
        }
    }

    protected void validateMessageStoreCreation() {
        MessageStore store = this.createMessageStore();
        if (store != null) {
            try {
                store.openMessageStore(this);
            }
            catch (Exception e) {
                throw new IllegalConfigurationException("Cannot open virtual host message store:" + e.getMessage(), e);
            }
            finally {
                try {
                    store.closeMessageStore();
                }
                catch (Exception e) {
                    _logger.warn("Failed to close database", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void onExceptionInOpen(RuntimeException e) {
        super.onExceptionInOpen(e);
        this.shutdownHouseKeeping();
        this.closeNetworkConnectionScheduler();
        this.closeMessageStore();
        this.stopPreferenceTaskExecutor();
        this.closePreferenceStore();
        this.stopLogging(new ArrayList<VirtualHostLogger>(this.getChildren(VirtualHostLogger.class)));
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this.registerSystemNodes();
        this._messageStore = this.createMessageStore();
        this._messageStoreLogSubject = new MessageStoreLogSubject(this.getName(), this._messageStore.getClass().getSimpleName());
        this._messageStore.addEventListener(this, Event.PERSISTENT_MESSAGE_SIZE_OVERFULL);
        this._messageStore.addEventListener(this, Event.PERSISTENT_MESSAGE_SIZE_UNDERFULL);
        this._fileSystemMaxUsagePercent = this.getContextValue(Integer.class, "store.filesystem.maxUsagePercent");
        QpidServiceLoader serviceLoader = new QpidServiceLoader();
        for (ConnectionValidator validator : serviceLoader.instancesOf(ConnectionValidator.class)) {
            if ((!this._enabledConnectionValidators.isEmpty() || !this._disabledConnectionValidators.isEmpty()) && this._disabledConnectionValidators.contains(validator.getType()) && !this._enabledConnectionValidators.contains(validator.getType())) continue;
            this._connectionValidators.add(validator);
        }
        PreferencesRoot preferencesRoot = this.getParent(VirtualHostNode.class);
        this._preferenceStore = preferencesRoot.createPreferenceStore();
    }

    private void checkVHostStateIsActive() {
        if (this.getState() != State.ACTIVE) {
            throw new IllegalStateException("The virtual host state of " + (Object)((Object)this.getState()) + " does not permit this operation.");
        }
    }

    @Override
    public boolean isActive() {
        return this.getState() == State.ACTIVE;
    }

    private void registerSystemNodes() {
        QpidServiceLoader qpidServiceLoader = new QpidServiceLoader();
        Iterable<SystemNodeCreator> factories = qpidServiceLoader.instancesOf(SystemNodeCreator.class);
        for (SystemNodeCreator creator : factories) {
            creator.register(this._systemNodeRegistry);
        }
    }

    protected abstract MessageStore createMessageStore();

    private ListenableFuture<List<Void>> createDefaultExchanges() {
        return Subject.doAs(this.getSubjectWithAddedSystemRights(), new PrivilegedAction<ListenableFuture<List<Void>>>(){

            @Override
            public ListenableFuture<List<Void>> run() {
                ArrayList<ListenableFuture<Void>> standardExchangeFutures = new ArrayList<ListenableFuture<Void>>();
                standardExchangeFutures.add(this.addStandardExchange("amq.direct", "direct"));
                standardExchangeFutures.add(this.addStandardExchange("amq.topic", "topic"));
                standardExchangeFutures.add(this.addStandardExchange("amq.match", "headers"));
                standardExchangeFutures.add(this.addStandardExchange("amq.fanout", "fanout"));
                return Futures.allAsList(standardExchangeFutures);
            }

            ListenableFuture<Void> addStandardExchange(String name, String type) {
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("name", name);
                attributes.put("type", type);
                attributes.put("id", UUIDGenerator.generateExchangeUUID(name, AbstractVirtualHost.this.getName()));
                ListenableFuture future = AbstractVirtualHost.this.addExchangeAsync(attributes);
                final SettableFuture returnVal = SettableFuture.create();
                AbstractVirtualHost.addFutureCallback(future, new FutureCallback<Exchange<?>>(){

                    public void onSuccess(Exchange<?> result) {
                        try {
                            AbstractVirtualHost.this.childAdded(result);
                            returnVal.set(null);
                        }
                        catch (Throwable t) {
                            returnVal.setException(t);
                        }
                    }

                    public void onFailure(Throwable t) {
                        returnVal.setException(t);
                    }
                }, AbstractVirtualHost.this.getTaskExecutor());
                return returnVal;
            }
        });
    }

    protected MessageStoreLogSubject getMessageStoreLogSubject() {
        return this._messageStoreLogSubject;
    }

    @Override
    public Collection<? extends Connection<?>> getConnections() {
        return this._connections;
    }

    @Override
    public Connection<?> getConnection(String name) {
        for (Connection connection : this._connections) {
            if (!connection.getName().equals(name)) continue;
            return connection;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int publishMessage(final @Param(name="message") ManageableMessage message) {
        MessageDestination destination;
        if (message == null) {
            throw new IllegalArgumentException("Message is not provided");
        }
        String address = message.getAddress();
        MessageDestination messageDestination = destination = address == null ? this.getDefaultDestination() : this.getAttainedMessageDestination(address);
        if (destination == null) {
            destination = this.getDefaultDestination();
        }
        MessageHeaderImpl header = new MessageHeaderImpl(message);
        Object body = null;
        Object messageContent = message.getContent();
        if (messageContent != null) {
            if (messageContent instanceof Map || messageContent instanceof List) {
                if (message.getMimeType() != null || message.getEncoding() != null) {
                    throw new IllegalArgumentException("If the message content is provided as map or list, the mime type and encoding must be left unset");
                }
                body = (Serializable)messageContent;
            } else {
                if (!(messageContent instanceof String)) throw new IllegalArgumentException("The message content (if present) can only be a string, map or list");
                String contentTransferEncoding = message.getContentTransferEncoding();
                if ("base64".equalsIgnoreCase(contentTransferEncoding)) {
                    body = Strings.decodeBase64((String)((String)messageContent));
                } else {
                    if (contentTransferEncoding != null && !contentTransferEncoding.trim().equals("") && !contentTransferEncoding.trim().equalsIgnoreCase("identity")) throw new IllegalArgumentException("contentTransferEncoding value '" + contentTransferEncoding + "' is invalid.  The only valid values are base64 and identity");
                    String mimeType = message.getMimeType();
                    if (mimeType != null && !(mimeType = mimeType.trim().toLowerCase()).equals("")) {
                        if (!mimeType.startsWith("text/") && !Arrays.asList("application/json", "application/xml").contains(mimeType)) {
                            throw new IllegalArgumentException(message.getMimeType() + " is invalid as a MIME type for this message. " + "Only MIME types of the text type can be used if a string is supplied as the content");
                        }
                        if (mimeType.matches(".*;\\s*charset\\s*=.*")) {
                            throw new IllegalArgumentException(message.getMimeType() + " is invalid as a MIME type for this message. " + "If a string is supplied as the content, the MIME type must not include a charset parameter");
                        }
                    }
                    body = (String)messageContent;
                }
            }
        }
        InternalMessage internalMessage = InternalMessage.createMessage(this.getMessageStore(), header, body, message.isPersistent());
        AutoCommitTransaction txn = new AutoCommitTransaction(this.getMessageStore());
        InstanceProperties instanceProperties = new InstanceProperties(){

            @Override
            public Object getProperty(InstanceProperties.Property prop) {
                switch (prop) {
                    case EXPIRATION: {
                        Date expiration = message.getExpiration();
                        return expiration == null ? 0L : expiration.getTime();
                    }
                    case IMMEDIATE: {
                        return false;
                    }
                    case PERSISTENT: {
                        return message.isPersistent();
                    }
                    case MANDATORY: {
                        return false;
                    }
                    case REDELIVERED: {
                        return false;
                    }
                }
                return null;
            }
        };
        return destination.send(internalMessage, address, instanceProperties, txn, null);
    }

    @Override
    protected <C extends ConfiguredObject> ListenableFuture<C> addChildAsync(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        this.checkVHostStateIsActive();
        if (childClass == Exchange.class) {
            return this.addExchangeAsync(attributes);
        }
        if (childClass == Queue.class) {
            return this.addQueueAsync(attributes);
        }
        if (childClass == VirtualHostAlias.class) {
            throw new UnsupportedOperationException();
        }
        if (childClass == VirtualHostLogger.class || childClass == VirtualHostAccessControlProvider.class) {
            return this.getObjectFactory().createAsync(childClass, attributes, this);
        }
        throw new IllegalArgumentException("Cannot create a child of class " + childClass.getSimpleName());
    }

    @Override
    public EventLogger getEventLogger() {
        return this._eventLogger;
    }

    @Override
    public Map<String, Object> extractConfig(final boolean includeSecureAttributes) {
        return this.doSync(this.doOnConfigThread(new Task<ListenableFuture<Map<String, Object>>, RuntimeException>(){

            @Override
            public ListenableFuture<Map<String, Object>> execute() throws RuntimeException {
                ConfigurationExtractor configExtractor = new ConfigurationExtractor();
                Map<String, Object> config = configExtractor.extractConfig(AbstractVirtualHost.this, includeSecureAttributes);
                return Futures.immediateFuture(config);
            }

            @Override
            public String getObject() {
                return AbstractVirtualHost.this.toString();
            }

            @Override
            public String getAction() {
                return "extractConfig";
            }

            @Override
            public String getArguments() {
                return "includeSecureAttributes=" + String.valueOf(includeSecureAttributes);
            }
        }));
    }

    @Override
    public Content exportMessageStore() {
        return new MessageStoreContent();
    }

    @Override
    public void importMessageStore(final String source) {
        try {
            final URL url = AbstractVirtualHost.convertStringToURL(source);
            try (InputStream input = url.openStream();
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(input);
                 final DataInputStream data = new DataInputStream(bufferedInputStream);){
                final MessageStoreSerializer serializer = MessageStoreSerializer.FACTORY.newInstance(data);
                this.doSync(this.doOnConfigThread(new Task<ListenableFuture<Void>, IOException>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public ListenableFuture<Void> execute() throws IOException {
                        if (AbstractVirtualHost.this.getState() != State.STOPPED) {
                            throw new IllegalArgumentException("The importMessageStore operation can only be called when the virtual host is stopped");
                        }
                        try {
                            AbstractVirtualHost.this._messageStore.openMessageStore(AbstractVirtualHost.this);
                            AbstractVirtualHost.this.checkMessageStoreEmpty();
                            final HashMap<String, UUID> queueMap = new HashMap<String, UUID>();
                            AbstractVirtualHost.this.getDurableConfigurationStore().reload(new ConfiguredObjectRecordHandler(){

                                @Override
                                public void handle(ConfiguredObjectRecord record) {
                                    if (record.getType().equals(Queue.class.getSimpleName())) {
                                        queueMap.put((String)record.getAttributes().get("name"), record.getId());
                                    }
                                }
                            });
                            serializer.deserialize(queueMap, AbstractVirtualHost.this._messageStore, data);
                        }
                        finally {
                            AbstractVirtualHost.this._messageStore.closeMessageStore();
                        }
                        return Futures.immediateFuture(null);
                    }

                    @Override
                    public String getObject() {
                        return AbstractVirtualHost.this.toString();
                    }

                    @Override
                    public String getAction() {
                        return "importMessageStore";
                    }

                    @Override
                    public String getArguments() {
                        if (url.getProtocol().equalsIgnoreCase("http") || url.getProtocol().equalsIgnoreCase("https") || url.getProtocol().equalsIgnoreCase("file")) {
                            return "source=" + source;
                        }
                        if (url.getProtocol().equalsIgnoreCase("data")) {
                            return "source=<data stream>";
                        }
                        return "source=<unknown source type>";
                    }
                }));
            }
        }
        catch (IOException e) {
            throw new IllegalConfigurationException("Cannot convert '" + source + "' to a readable resource", e);
        }
    }

    private void checkMessageStoreEmpty() {
        MessageStore.MessageStoreReader reader = this._messageStore.newMessageStoreReader();
        StoreEmptyCheckingHandler handler = new StoreEmptyCheckingHandler();
        reader.visitMessages(handler);
        if (handler.isEmpty()) {
            reader.visitMessageInstances(handler);
            if (handler.isEmpty()) {
                reader.visitDistributedTransactions(handler);
            }
        }
        if (!handler.isEmpty()) {
            throw new IllegalArgumentException("The message store is not empty");
        }
    }

    private static URL convertStringToURL(String source) {
        URL url;
        try {
            url = new URL(source);
        }
        catch (MalformedURLException e) {
            File file = new File(source);
            try {
                url = file.toURI().toURL();
            }
            catch (MalformedURLException notAFile) {
                throw new IllegalConfigurationException("Cannot convert " + source + " to a readable resource", notAFile);
            }
        }
        return url;
    }

    @Override
    public boolean authoriseCreateConnection(AMQPConnection<?> connection) {
        this.authorise(Operation.ACTION("connect"));
        for (ConnectionValidator validator : this._connectionValidators) {
            if (validator.validateConnectionCreation(connection, this)) continue;
            return false;
        }
        return true;
    }

    private void initialiseHouseKeeping(long period) {
        if (period > 0L) {
            this.scheduleHouseKeepingTask(period, new VirtualHostHouseKeepingTask());
        }
    }

    protected void shutdownHouseKeeping() {
        if (this._houseKeepingTaskExecutor != null) {
            this._houseKeepingTaskExecutor.shutdown();
            try {
                if (!this._houseKeepingTaskExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this._houseKeepingTaskExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                _logger.warn("Interrupted during Housekeeping shutdown:", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    protected void removeHouseKeepingTasks() {
        BlockingQueue<Runnable> taskQueue = this._houseKeepingTaskExecutor.getQueue();
        for (Runnable runnable : taskQueue) {
            this._houseKeepingTaskExecutor.remove(runnable);
        }
    }

    private void closeNetworkConnectionScheduler() {
        if (this._networkConnectionScheduler != null) {
            this._networkConnectionScheduler.close();
            this._networkConnectionScheduler = null;
        }
    }

    @Override
    public void scheduleHouseKeepingTask(long period, HouseKeepingTask task) {
        this._houseKeepingTaskExecutor.scheduleAtFixedRate(task, period / 2L, period, TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledFuture<?> scheduleTask(long delay, Runnable task) {
        return this._houseKeepingTaskExecutor.schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public void executeTask(String name, final Runnable task, AccessControlContext context) {
        this._houseKeepingTaskExecutor.execute(new HouseKeepingTask(name, this, context){

            @Override
            public void execute() {
                task.run();
            }
        });
    }

    @Override
    public List<String> getEnabledConnectionValidators() {
        return this._enabledConnectionValidators;
    }

    @Override
    public List<String> getDisabledConnectionValidators() {
        return this._disabledConnectionValidators;
    }

    @Override
    public List<String> getGlobalAddressDomains() {
        return this._globalAddressDomains;
    }

    @Override
    public List<NodeAutoCreationPolicy> getNodeAutoCreationPolicies() {
        return this._nodeAutoCreationPolicies;
    }

    @Override
    public MessageSource getAttainedMessageSource(String name) {
        MessageSource messageSource = this._systemNodeSources.get(name);
        if (messageSource == null) {
            messageSource = this.getAttainedChildFromAddress(Queue.class, name);
        }
        if (messageSource == null) {
            messageSource = this.autoCreateNode(name, MessageSource.class, false);
        }
        return messageSource;
    }

    private <T> T autoCreateNode(String name, Class<T> clazz, boolean publish) {
        for (NodeAutoCreationPolicy policy : this.getNodeAutoCreationPolicies()) {
            Class<? extends ConfiguredObject> childClass2;
            String pattern = policy.getPattern();
            if (!name.matches(pattern) || (!publish || !policy.isCreatedOnPublish()) && (publish || !policy.isCreatedOnConsume())) continue;
            String nodeType = policy.getNodeType();
            Class<? extends ConfiguredObject> sourceClass = null;
            for (final Class<? extends ConfiguredObject> childClass2 : this.getModel().getChildTypes(this.getCategoryClass())) {
                if (!childClass2.getSimpleName().equalsIgnoreCase(nodeType.trim()) || !clazz.isAssignableFrom(childClass2)) continue;
                sourceClass = childClass2;
            }
            if (sourceClass == null) continue;
            final HashMap<String, Object> attributes = new HashMap<String, Object>(policy.getAttributes());
            attributes.remove("id");
            attributes.put("name", name);
            childClass2 = sourceClass;
            try {
                Object node = Subject.doAs(this.getSubjectWithAddedSystemRights(), new PrivilegedAction<T>(){

                    @Override
                    public T run() {
                        return AbstractVirtualHost.this.doSync(AbstractVirtualHost.this.createChildAsync(childClass2, attributes, new ConfiguredObject[0]));
                    }
                });
                if (node == null) continue;
                return node;
            }
            catch (RuntimeException e) {
                _logger.info("Unable to auto create a node named {} due to exception", (Object)name, (Object)e);
            }
        }
        return null;
    }

    @Override
    public Queue<?> getAttainedQueue(UUID id) {
        return this.awaitChildClassToAttainState(Queue.class, id);
    }

    @Override
    public Broker<?> getBroker() {
        return this._broker;
    }

    private ListenableFuture<? extends Queue<?>> addQueueAsync(Map<String, Object> attributes) throws QueueExistsException {
        if (this.shouldCreateDLQ(attributes)) {
            String queueName = String.valueOf(attributes.get("name"));
            AbstractVirtualHost.validateDLNames(queueName);
            String altExchangeName = this.createDLQ(queueName);
            attributes = new LinkedHashMap<String, Object>(attributes);
            attributes.put("alternateExchange", altExchangeName);
        }
        return Futures.immediateFuture(this.addQueueWithoutDLQ(attributes));
    }

    private Queue<?> addQueueWithoutDLQ(Map<String, Object> attributes) throws QueueExistsException {
        try {
            return this.getObjectFactory().create(Queue.class, attributes, this);
        }
        catch (AbstractConfiguredObject.DuplicateNameException e) {
            throw new QueueExistsException(String.format("Queue with name '%s' already exists", e.getName()), (Queue)e.getExisting());
        }
    }

    @Override
    public MessageDestination getAttainedMessageDestination(String name) {
        MessageDestination destination = this._systemNodeDestinations.get(name);
        if (destination == null) {
            destination = this.getAttainedChildFromAddress(Exchange.class, name);
        }
        if (destination == null) {
            destination = this.getAttainedChildFromAddress(Queue.class, name);
        }
        if (destination == null) {
            destination = this.autoCreateNode(name, MessageDestination.class, true);
        }
        return destination;
    }

    @Override
    public long getBytesEvacuatedFromMemory() {
        return this._messageStore == null ? -1L : this._messageStore.getBytesEvacuatedFromMemory();
    }

    @Override
    public <T extends ConfiguredObject<?>> T getAttainedChildFromAddress(Class<T> childClass, String address) {
        T child;
        block1: {
            child = this.awaitChildClassToAttainState(childClass, address);
            if (child != null || this.getGlobalAddressDomains() == null) break block1;
            for (String domain : this.getGlobalAddressDomains()) {
                if (address.startsWith(domain + "/") && (child = this.awaitChildClassToAttainState(childClass, address.substring(domain.length() + 1))) != null) break;
            }
        }
        return child;
    }

    @Override
    public MessageDestination getDefaultDestination() {
        return this._defaultDestination;
    }

    private ListenableFuture<Exchange<?>> addExchangeAsync(Map<String, Object> attributes) throws ExchangeExistsException, ReservedExchangeNameException, NoFactoryForTypeException {
        final SettableFuture returnVal = SettableFuture.create();
        AbstractVirtualHost.addFutureCallback(this.getObjectFactory().createAsync(Exchange.class, attributes, this), new FutureCallback<Exchange>(){

            public void onSuccess(Exchange result) {
                returnVal.set((Object)result);
            }

            public void onFailure(Throwable t) {
                if (t instanceof AbstractConfiguredObject.DuplicateNameException) {
                    AbstractConfiguredObject.DuplicateNameException dne = (AbstractConfiguredObject.DuplicateNameException)t;
                    returnVal.setException((Throwable)new ExchangeExistsException((Exchange)dne.getExisting()));
                } else {
                    returnVal.setException(t);
                }
            }
        }, this.getTaskExecutor());
        return returnVal;
    }

    @Override
    public String getLocalAddress(String routingAddress) {
        String localAddress = routingAddress;
        if (this.getGlobalAddressDomains() != null) {
            for (String domain : this.getGlobalAddressDomains()) {
                if (localAddress.length() <= routingAddress.length() - domain.length() || !routingAddress.startsWith(domain + "/")) continue;
                localAddress = routingAddress.substring(domain.length());
            }
        }
        return localAddress;
    }

    @Override
    protected ListenableFuture<Void> beforeClose() {
        this.setState(State.UNAVAILABLE);
        this._virtualHostLoggersToClose = new ArrayList<VirtualHostLogger>(this.getChildren(VirtualHostLogger.class));
        return this.closeConnections();
    }

    @Override
    protected void onClose() {
        this._dtxRegistry.close();
        this.shutdownHouseKeeping();
        this.closeMessageStore();
        this.stopPreferenceTaskExecutor();
        this.closePreferenceStore();
        this.closeNetworkConnectionScheduler();
        this._eventLogger.message(VirtualHostMessages.CLOSED(this.getName()));
        this.stopLogging(this._virtualHostLoggersToClose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> closeConnections() {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Closing connection registry :" + this._connections.size() + " connections.");
        }
        this._acceptsConnections.set(false);
        for (AMQPConnection<?> conn : this._connections) {
            conn.stopConnection();
        }
        ArrayList<ListenableFuture<Void>> connectionCloseFutures = new ArrayList<ListenableFuture<Void>>();
        while (!this._connections.isEmpty()) {
            Iterator<AMQPConnection<?>> itr = this._connections.iterator();
            while (itr.hasNext()) {
                Connection connection = itr.next();
                try {
                    connectionCloseFutures.add(connection.closeAsync());
                }
                catch (Exception e) {
                    _logger.warn("Exception closing connection " + connection.getName() + " from " + connection.getRemoteAddress(), (Throwable)e);
                }
                finally {
                    itr.remove();
                }
            }
        }
        ListenableFuture combinedFuture = Futures.allAsList(connectionCloseFutures);
        return Futures.transform((ListenableFuture)combinedFuture, (Function)new Function<List<Void>, Void>(){

            public Void apply(List<Void> voids) {
                return null;
            }
        });
    }

    private void closeMessageStore() {
        if (this.getMessageStore() != null) {
            try {
                if (this._messageStoreRecoverer != null) {
                    this._messageStoreRecoverer.cancel();
                }
                this.getMessageStore().closeMessageStore();
            }
            catch (StoreException e) {
                _logger.error("Failed to close message store", (Throwable)e);
            }
            if (!(this._virtualHostNode.getConfigurationStore() instanceof MessageStoreProvider)) {
                this.getEventLogger().message(this.getMessageStoreLogSubject(), MessageStoreMessages.CLOSED());
            }
        }
    }

    @Override
    public void registerMessageDelivered(long messageSize) {
        this._messagesDelivered.registerEvent(1L);
        this._dataDelivered.registerEvent(messageSize);
        this._broker.registerMessageDelivered(messageSize);
    }

    @Override
    public void registerMessageReceived(long messageSize, long timestamp) {
        this._messagesReceived.registerEvent(1L, timestamp);
        this._dataReceived.registerEvent(messageSize, timestamp);
        this._broker.registerMessageReceived(messageSize, timestamp);
    }

    @Override
    public StatisticsCounter getMessageReceiptStatistics() {
        return this._messagesReceived;
    }

    @Override
    public StatisticsCounter getDataReceiptStatistics() {
        return this._dataReceived;
    }

    @Override
    public StatisticsCounter getMessageDeliveryStatistics() {
        return this._messagesDelivered;
    }

    @Override
    public StatisticsCounter getDataDeliveryStatistics() {
        return this._dataDelivered;
    }

    @Override
    public void resetStatistics() {
        this._messagesDelivered.reset();
        this._dataDelivered.reset();
        this._messagesReceived.reset();
        this._dataReceived.reset();
        for (AMQPConnection<?> connection : this._connections) {
            connection.resetStatistics();
        }
    }

    @Override
    public synchronized LinkRegistry getLinkRegistry(String remoteContainerId) {
        LinkRegistry linkRegistry = this._linkRegistry.get(remoteContainerId);
        if (linkRegistry == null) {
            linkRegistry = new LinkRegistryImpl();
            this._linkRegistry.put(remoteContainerId, linkRegistry);
        }
        return linkRegistry;
    }

    @Override
    public DtxRegistry getDtxRegistry() {
        return this._dtxRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void block(BlockingType blockingType) {
        Set<AMQPConnection<?>> set = this._connections;
        synchronized (set) {
            this._blockingReasons.add(blockingType);
            if (this._blocked.compareAndSet(false, true)) {
                for (AMQPConnection<?> conn : this._connections) {
                    conn.block();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unblock(BlockingType blockingType) {
        Set<AMQPConnection<?>> set = this._connections;
        synchronized (set) {
            this._blockingReasons.remove((Object)blockingType);
            if (this._blockingReasons.isEmpty() && this._blocked.compareAndSet(true, false)) {
                for (AMQPConnection<?> conn : this._connections) {
                    conn.unblock();
                }
            }
        }
    }

    @Override
    public void event(Event event) {
        switch (event) {
            case PERSISTENT_MESSAGE_SIZE_OVERFULL: {
                this.block(BlockingType.STORE);
                this._eventLogger.message(this.getMessageStoreLogSubject(), MessageStoreMessages.OVERFULL());
                break;
            }
            case PERSISTENT_MESSAGE_SIZE_UNDERFULL: {
                this.unblock(BlockingType.STORE);
                this._eventLogger.message(this.getMessageStoreLogSubject(), MessageStoreMessages.UNDERFULL());
            }
        }
    }

    protected void reportIfError(State state) {
        if (state == State.ERRORED) {
            this._eventLogger.message(VirtualHostMessages.ERRORED(this.getName()));
        }
    }

    @Override
    public String getRedirectHost(AmqpPort<?> port) {
        return null;
    }

    @Override
    public void executeTransaction(VirtualHost.TransactionalOperation op) {
        final MessageStore store = this.getMessageStore();
        final LocalTransaction txn = new LocalTransaction(store);
        op.withinTransaction(new VirtualHost.Transaction(){

            @Override
            public void dequeue(final QueueEntry messageInstance) {
                final ServerTransaction.Action deleteAction = new ServerTransaction.Action(){

                    @Override
                    public void postCommit() {
                        messageInstance.delete();
                    }

                    @Override
                    public void onRollback() {
                    }
                };
                boolean acquired = messageInstance.acquireOrSteal(new Runnable(){

                    @Override
                    public void run() {
                        AutoCommitTransaction txn = new AutoCommitTransaction(store);
                        txn.dequeue(messageInstance.getEnqueueRecord(), deleteAction);
                    }
                });
                if (acquired) {
                    txn.dequeue(messageInstance.getEnqueueRecord(), deleteAction);
                }
            }

            @Override
            public void copy(QueueEntry entry, final Queue<?> queue) {
                final ServerMessage message = entry.getMessage();
                txn.enqueue(queue, (EnqueueableMessage)message, new ServerTransaction.EnqueueAction(){

                    @Override
                    public void postCommit(MessageEnqueueRecord ... records) {
                        queue.enqueue(message, null, records[0]);
                    }

                    @Override
                    public void onRollback() {
                    }
                });
            }

            @Override
            public void move(final QueueEntry entry, final Queue<?> queue) {
                final ServerMessage message = entry.getMessage();
                if (entry.acquire()) {
                    txn.enqueue(queue, (EnqueueableMessage)message, new ServerTransaction.EnqueueAction(){

                        @Override
                        public void postCommit(MessageEnqueueRecord ... records) {
                            queue.enqueue(message, null, records[0]);
                        }

                        @Override
                        public void onRollback() {
                            entry.release();
                        }
                    });
                    txn.dequeue(entry.getEnqueueRecord(), new ServerTransaction.Action(){

                        @Override
                        public void postCommit() {
                            entry.delete();
                        }

                        @Override
                        public void onRollback() {
                        }
                    });
                }
            }
        });
        txn.commit();
    }

    @Override
    public boolean isQueue_deadLetterQueueEnabled() {
        return this._queue_deadLetterQueueEnabled;
    }

    @Override
    public long getHousekeepingCheckPeriod() {
        return this._housekeepingCheckPeriod;
    }

    @Override
    public long getStoreTransactionIdleTimeoutClose() {
        return this._storeTransactionIdleTimeoutClose;
    }

    @Override
    public long getStoreTransactionIdleTimeoutWarn() {
        return this._storeTransactionIdleTimeoutWarn;
    }

    @Override
    public long getStoreTransactionOpenTimeoutClose() {
        return this._storeTransactionOpenTimeoutClose;
    }

    @Override
    public long getStoreTransactionOpenTimeoutWarn() {
        return this._storeTransactionOpenTimeoutWarn;
    }

    @Override
    public long getQueueCount() {
        return this.getChildren(Queue.class).size();
    }

    @Override
    public long getExchangeCount() {
        return this.getChildren(Exchange.class).size();
    }

    @Override
    public long getConnectionCount() {
        return this._connections.size();
    }

    @Override
    public long getBytesIn() {
        return this.getDataReceiptStatistics().getTotal();
    }

    @Override
    public long getBytesOut() {
        return this.getDataDeliveryStatistics().getTotal();
    }

    @Override
    public long getMessagesIn() {
        return this.getMessageReceiptStatistics().getTotal();
    }

    @Override
    public long getMessagesOut() {
        return this.getMessageDeliveryStatistics().getTotal();
    }

    @Override
    public int getHousekeepingThreadCount() {
        return this._housekeepingThreadCount;
    }

    @Override
    public int getConnectionThreadPoolSize() {
        return this._connectionThreadPoolSize;
    }

    @Override
    public int getNumberOfSelectors() {
        return this._numberOfSelectors;
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ACTIVE, State.ERRORED}, desiredState=State.STOPPED)
    protected ListenableFuture<Void> doStop() {
        final ArrayList<VirtualHostLogger> loggers = new ArrayList<VirtualHostLogger>(this.getChildren(VirtualHostLogger.class));
        return this.doAfter(this.closeConnections(), new Callable<ListenableFuture<Void>>(){

            @Override
            public ListenableFuture<Void> call() throws Exception {
                return AbstractVirtualHost.this.closeChildren();
            }
        }).then(new Runnable(){

            @Override
            public void run() {
                AbstractVirtualHost.this.shutdownHouseKeeping();
                AbstractVirtualHost.this.closeNetworkConnectionScheduler();
                AbstractVirtualHost.this.closeMessageStore();
                AbstractVirtualHost.this.stopPreferenceTaskExecutor();
                AbstractVirtualHost.this.closePreferenceStore();
                AbstractVirtualHost.this.setState(State.STOPPED);
                AbstractVirtualHost.this.stopLogging(loggers);
            }
        });
    }

    @Override
    public UserPreferences createUserPreferences(ConfiguredObject<?> object) {
        if (this._preferenceTaskExecutor == null || !this._preferenceTaskExecutor.isRunning()) {
            throw new IllegalStateException("Cannot create user preferences in not fully initialized virtual host");
        }
        return new UserPreferencesImpl(this._preferenceTaskExecutor, object, this._preferenceStore, Collections.emptySet());
    }

    private void stopPreferenceTaskExecutor() {
        if (this._preferenceTaskExecutor != null) {
            this._preferenceTaskExecutor.stop();
        }
    }

    private void closePreferenceStore() {
        if (this._preferenceStore != null) {
            this._preferenceStore.close();
        }
    }

    private void stopLogging(Collection<VirtualHostLogger> loggers) {
        for (VirtualHostLogger logger : loggers) {
            logger.stopLogging();
        }
    }

    @StateTransition(currentState={State.ACTIVE, State.ERRORED}, desiredState=State.DELETED)
    private ListenableFuture<Void> doDelete() {
        return this.doAfterAlways(this.closeAsync(), new Runnable(){

            @Override
            public void run() {
                PreferenceStore ps;
                MessageStore ms = AbstractVirtualHost.this.getMessageStore();
                if (ms != null) {
                    try {
                        ms.onDelete(AbstractVirtualHost.this);
                    }
                    catch (Exception e) {
                        _logger.warn("Exception occurred on message store deletion", (Throwable)e);
                    }
                }
                if ((ps = AbstractVirtualHost.this._preferenceStore) != null) {
                    try {
                        ps.onDelete();
                    }
                    catch (Exception e) {
                        _logger.warn("Exception occurred on preference store deletion", (Throwable)e);
                    }
                }
                AbstractVirtualHost.this.deleted();
                AbstractVirtualHost.this.setState(State.DELETED);
            }
        });
    }

    private String createDLQ(String queueName) {
        String dlExchangeName = AbstractVirtualHost.getDeadLetterExchangeName(queueName);
        String dlQueueName = AbstractVirtualHost.getDeadLetterQueueName(queueName);
        Exchange dlExchange = null;
        UUID dlExchangeId = UUID.randomUUID();
        try {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("id", dlExchangeId);
            attributes.put("name", dlExchangeName);
            attributes.put("type", "fanout");
            attributes.put("durable", true);
            attributes.put("lifetimePolicy", (Object)LifetimePolicy.PERMANENT);
            attributes.put("alternateExchange", null);
            dlExchange = this.createChild(Exchange.class, attributes, new ConfiguredObject[0]);
        }
        catch (ExchangeExistsException e) {
            dlExchange = e.getExistingExchange();
        }
        catch (NoFactoryForTypeException | UnknownConfiguredObjectException | ReservedExchangeNameException e) {
            throw new ConnectionScopedRuntimeException("Attempt to create an alternate exchange for a queue failed", e);
        }
        Queue<?> dlQueue = null;
        dlQueue = this.getChildByName(Queue.class, dlQueueName);
        if (dlQueue == null) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put(CREATE_DLQ_ON_CREATION, false);
            args.put("maximumDeliveryAttempts", 0);
            try {
                args.put("id", UUID.randomUUID());
                args.put("name", dlQueueName);
                args.put("durable", true);
                dlQueue = this.addQueueWithoutDLQ(args);
                this.childAdded(dlQueue);
            }
            catch (QueueExistsException queueExistsException) {
                // empty catch block
            }
        }
        if (!dlExchange.isBound(DLQ_ROUTING_KEY, dlQueue)) {
            dlExchange.addBinding(DLQ_ROUTING_KEY, dlQueue, null);
        }
        return dlExchangeName;
    }

    private static void validateDLNames(String name) {
        String exchangeName = AbstractVirtualHost.getDeadLetterExchangeName(name);
        if (exchangeName.length() > 255) {
            throw new IllegalArgumentException("DL exchange name '" + exchangeName + "' length exceeds limit of " + 255 + " characters for queue " + name);
        }
        String queueName = AbstractVirtualHost.getDeadLetterQueueName(name);
        if (queueName.length() > 255) {
            throw new IllegalArgumentException("DLQ queue name '" + queueName + "' length exceeds limit of " + 255 + " characters for queue " + name);
        }
    }

    private boolean shouldCreateDLQ(Map<String, Object> arguments) {
        boolean autoDelete;
        boolean bl = autoDelete = MapValueConverter.getEnumAttribute(LifetimePolicy.class, "lifetimePolicy", arguments, LifetimePolicy.PERMANENT) != LifetimePolicy.PERMANENT;
        if (!(autoDelete || arguments != null && arguments.containsKey("alternateExchange"))) {
            boolean dlqArgumentPresent;
            boolean bl2 = dlqArgumentPresent = arguments != null && arguments.containsKey(CREATE_DLQ_ON_CREATION);
            if (dlqArgumentPresent) {
                boolean dlqEnabled = true;
                if (dlqArgumentPresent) {
                    Object argument = arguments.get(CREATE_DLQ_ON_CREATION);
                    dlqEnabled = argument instanceof Boolean && (Boolean)argument != false || argument instanceof String && Boolean.parseBoolean(argument.toString());
                }
                return dlqEnabled;
            }
            return this.isQueue_deadLetterQueueEnabled();
        }
        return false;
    }

    private static String getDeadLetterQueueName(String name) {
        return name + System.getProperty("qpid.broker_dead_letter_queue_suffix", DEFAULT_DLQ_NAME_SUFFIX);
    }

    private static String getDeadLetterExchangeName(String name) {
        return name + System.getProperty("qpid.broker_dead_letter_exchange_suffix", "_DLE");
    }

    @Override
    public String getModelVersion() {
        return "6.1";
    }

    @Override
    public DurableConfigurationStore getDurableConfigurationStore() {
        return this._virtualHostNode.getConfigurationStore();
    }

    @Override
    public void setTargetSize(long targetSize) {
        this._targetSize.set(targetSize);
        this.allocateTargetSizeToQueues();
    }

    @Override
    public long getTargetSize() {
        return this._targetSize.get();
    }

    private void allocateTargetSizeToQueues() {
        long targetSize = this._targetSize.get();
        Collection<Queue> queues = this.getChildren(Queue.class);
        long totalSize = this.calculateTotalEnqueuedSize(queues);
        _logger.debug("Allocating target size to queues, total target: {} ; total enqueued size {}", (Object)targetSize, (Object)totalSize);
        if (targetSize > 0L) {
            for (Queue q : queues) {
                long size = (long)((double)q.getPotentialMemoryFootprint() / (double)totalSize * (double)targetSize);
                q.setTargetSize(size);
            }
        }
    }

    @Override
    public long getTotalQueueDepthBytes() {
        return this.calculateTotalEnqueuedSize(this.getChildren(Queue.class));
    }

    @Override
    public Principal getPrincipal() {
        return this._principal;
    }

    @Override
    public void registerConnection(AMQPConnection<?> connection) {
        this.doSync(this.registerConnectionAsync(connection));
    }

    public ListenableFuture<Void> registerConnectionAsync(final AMQPConnection<?> connection) {
        return this.doOnConfigThread(new Task<ListenableFuture<Void>, RuntimeException>(){

            @Override
            public ListenableFuture<Void> execute() {
                if (AbstractVirtualHost.this._acceptsConnections.get()) {
                    AbstractVirtualHost.this._connections.add(connection);
                    if (AbstractVirtualHost.this._blocked.get()) {
                        connection.block();
                    }
                    connection.pushScheduler(AbstractVirtualHost.this._networkConnectionScheduler);
                    return Futures.immediateFuture(null);
                }
                VirtualHostUnavailableException exception = new VirtualHostUnavailableException(String.format("VirtualHost '%s' not accepting connections", AbstractVirtualHost.this.getName()));
                return Futures.immediateFailedFuture((Throwable)exception);
            }

            @Override
            public String getObject() {
                return AbstractVirtualHost.this.toString();
            }

            @Override
            public String getAction() {
                return "register connection";
            }

            @Override
            public String getArguments() {
                return String.valueOf(connection);
            }
        });
    }

    @Override
    public void deregisterConnection(AMQPConnection<?> connection) {
        this.doSync(this.deregisterConnectionAsync(connection));
    }

    public ListenableFuture<Void> deregisterConnectionAsync(final AMQPConnection<?> connection) {
        return this.doOnConfigThread(new Task<ListenableFuture<Void>, RuntimeException>(){

            @Override
            public ListenableFuture<Void> execute() {
                connection.popScheduler();
                AbstractVirtualHost.this._connections.remove(connection);
                return Futures.immediateFuture(null);
            }

            @Override
            public String getObject() {
                return AbstractVirtualHost.this.toString();
            }

            @Override
            public String getAction() {
                return "deregister connection";
            }

            @Override
            public String getArguments() {
                return String.valueOf(connection);
            }
        });
    }

    private long calculateTotalEnqueuedSize(Collection<Queue> queues) {
        long total = 0L;
        for (Queue queue : queues) {
            total += queue.getPotentialMemoryFootprint();
        }
        return total;
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
    private ListenableFuture<Void> onActivate() {
        this._houseKeepingTaskExecutor = new HousekeepingExecutor("virtualhost-" + this.getName() + "-pool", this.getHousekeepingThreadCount(), this.getSystemTaskSubject("Housekeeping", this.getPrincipal()));
        long threadPoolKeepAliveTimeout = this.getContextValue(Long.class, "connectionThreadPoolKeepAliveTimeout");
        SuppressingInheritedAccessControlContextThreadFactory connectionThreadFactory = new SuppressingInheritedAccessControlContextThreadFactory("virtualhost-" + this.getName() + "-iopool", this.getSystemTaskSubject("IO Pool", this.getPrincipal()));
        this._networkConnectionScheduler = new NetworkConnectionScheduler("virtualhost-" + this.getName() + "-iopool", this.getNumberOfSelectors(), this.getConnectionThreadPoolSize(), threadPoolKeepAliveTimeout, (ThreadFactory)connectionThreadFactory);
        this._networkConnectionScheduler.start();
        this.updateAccessControl();
        MessageStore messageStore = this.getMessageStore();
        messageStore.openMessageStore(this);
        this.startFileSystemSpaceChecking();
        if (!(this._virtualHostNode.getConfigurationStore() instanceof MessageStoreProvider)) {
            this.getEventLogger().message(this.getMessageStoreLogSubject(), MessageStoreMessages.CREATED());
            this.getEventLogger().message(this.getMessageStoreLogSubject(), MessageStoreMessages.STORE_LOCATION(messageStore.getStoreLocation()));
        }
        messageStore.upgradeStoreStructure();
        this.getBroker().assignTargetSizes();
        PreferenceStoreUpdaterImpl updater = new PreferenceStoreUpdaterImpl();
        Collection<PreferenceRecord> records = this._preferenceStore.openAndLoad(updater);
        this._preferenceTaskExecutor = new TaskExecutorImpl("virtualhost-" + this.getName() + "-preferences", null);
        this._preferenceTaskExecutor.start();
        PreferencesRecoverer preferencesRecoverer = new PreferencesRecoverer(this._preferenceTaskExecutor);
        preferencesRecoverer.recoverPreferences(this, records, this._preferenceStore);
        if (this._createDefaultExchanges) {
            return this.doAfter(this.createDefaultExchanges(), new Runnable(){

                @Override
                public void run() {
                    AbstractVirtualHost.this._createDefaultExchanges = false;
                    AbstractVirtualHost.this.postCreateDefaultExchangeTasks();
                }
            });
        }
        this.postCreateDefaultExchangeTasks();
        return Futures.immediateFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postCreateDefaultExchangeTasks() {
        this._messageStoreRecoverer = this.getContextValue(Boolean.class, USE_ASYNC_RECOVERY) != false ? new AsynchronousMessageStoreRecoverer() : new SynchronousMessageStoreRecoverer();
        final ListenableFuture<Void> recoveryResult = this._messageStoreRecoverer.recover(this);
        recoveryResult.addListener(new Runnable(){

            @Override
            public void run() {
                Futures.getUnchecked((Future)recoveryResult);
            }
        }, (Executor)this._houseKeepingTaskExecutor);
        State finalState = State.ERRORED;
        try {
            this.initialiseHouseKeeping(this.getHousekeepingCheckPeriod());
            finalState = State.ACTIVE;
            this._acceptsConnections.set(true);
        }
        finally {
            this.setState(finalState);
            this.reportIfError(this.getState());
        }
    }

    protected void startFileSystemSpaceChecking() {
        long housekeepingCheckPeriod = this.getHousekeepingCheckPeriod();
        File storeLocationAsFile = this._messageStore.getStoreLocationAsFile();
        if (storeLocationAsFile != null && this._fileSystemMaxUsagePercent > 0 && housekeepingCheckPeriod > 0L) {
            this._fileSystemSpaceChecker.setFileSystem(storeLocationAsFile);
            this.scheduleHouseKeepingTask(housekeepingCheckPeriod, this._fileSystemSpaceChecker);
        }
    }

    @StateTransition(currentState={State.STOPPED}, desiredState=State.ACTIVE)
    private ListenableFuture<Void> onRestart() {
        this.resetStatistics();
        VirtualHostStoreUpgraderAndRecoverer virtualHostStoreUpgraderAndRecoverer = new VirtualHostStoreUpgraderAndRecoverer(this._virtualHostNode);
        virtualHostStoreUpgraderAndRecoverer.reloadAndRecoverVirtualHost(this.getDurableConfigurationStore());
        final ArrayList childOpenFutures = new ArrayList();
        Subject.doAs(this.getSubjectWithAddedSystemRights(), new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                AbstractVirtualHost.this.applyToChildren(new Action<ConfiguredObject<?>>(){

                    @Override
                    public void performAction(final ConfiguredObject<?> child) {
                        ListenableFuture<Void> childOpenFuture = child.openAsync();
                        childOpenFutures.add(childOpenFuture);
                        AbstractVirtualHost.addFutureCallback(childOpenFuture, (FutureCallback)new FutureCallback<Void>(){

                            public void onSuccess(Void result) {
                            }

                            public void onFailure(Throwable t) {
                                _logger.error("Exception occurred while opening {} : {}", new Object[]{child.getClass().getSimpleName(), child.getName(), t});
                            }
                        }, AbstractVirtualHost.this.getTaskExecutor());
                    }
                });
                return null;
            }
        });
        ListenableFuture combinedFuture = Futures.allAsList(childOpenFutures);
        return Futures.transform((ListenableFuture)combinedFuture, (AsyncFunction)new AsyncFunction<List<Void>, Void>(){

            public ListenableFuture<Void> apply(List<Void> input) throws Exception {
                return AbstractVirtualHost.this.onActivate();
            }
        });
    }

    @Override
    public <T extends MessageSource> T createMessageSource(Class<T> clazz, Map<String, Object> attributes) {
        if (Queue.class.isAssignableFrom(clazz)) {
            return (T)((MessageSource)this.createChild(clazz, attributes, new ConfiguredObject[0]));
        }
        throw new IllegalArgumentException("Cannot create message source children of class " + clazz.getSimpleName());
    }

    @Override
    public <T extends MessageDestination> T createMessageDestination(Class<T> clazz, Map<String, Object> attributes) {
        if (Exchange.class.isAssignableFrom(clazz)) {
            return (T)((MessageDestination)this.createChild(clazz, attributes, new ConfiguredObject[0]));
        }
        if (Queue.class.isAssignableFrom(clazz)) {
            return (T)((MessageDestination)this.createChild(clazz, attributes, new ConfiguredObject[0]));
        }
        throw new IllegalArgumentException("Cannot create message destination children of class " + clazz.getSimpleName());
    }

    @Override
    public boolean hasMessageSources() {
        return !this._systemNodeSources.isEmpty() || !this.getChildren(Queue.class).isEmpty();
    }

    private class StoreEmptyCheckingHandler
    implements MessageHandler,
    MessageInstanceHandler,
    DistributedTransactionHandler {
        private boolean _empty = true;

        private StoreEmptyCheckingHandler() {
        }

        @Override
        public boolean handle(StoredMessage<?> storedMessage) {
            this._empty = false;
            return false;
        }

        @Override
        public boolean handle(MessageEnqueueRecord record) {
            this._empty = false;
            return false;
        }

        @Override
        public boolean handle(Transaction.StoredXidRecord storedXid, Transaction.EnqueueRecord[] enqueues, Transaction.DequeueRecord[] dequeues) {
            this._empty = false;
            return false;
        }

        public boolean isEmpty() {
            return this._empty;
        }
    }

    private final class AccessControlProviderListener
    implements ConfigurationChangeListener {
        private final Set<ConfiguredObject<?>> _bulkChanges = new HashSet();

        private AccessControlProviderListener() {
        }

        @Override
        public void stateChanged(ConfiguredObject<?> object, State oldState, State newState) {
        }

        @Override
        public void childAdded(ConfiguredObject<?> object, ConfiguredObject<?> child) {
            if (object.getCategoryClass() == VirtualHost.class && child.getCategoryClass() == VirtualHostAccessControlProvider.class) {
                child.addChangeListener(this);
                AbstractVirtualHost.this.updateAccessControl();
            }
        }

        @Override
        public void childRemoved(ConfiguredObject<?> object, ConfiguredObject<?> child) {
            if (object.getCategoryClass() == VirtualHost.class && child.getCategoryClass() == VirtualHostAccessControlProvider.class) {
                AbstractVirtualHost.this.updateAccessControl();
            }
        }

        @Override
        public void attributeSet(ConfiguredObject<?> object, String attributeName, Object oldAttributeValue, Object newAttributeValue) {
            if (object.getCategoryClass() == VirtualHostAccessControlProvider.class && !this._bulkChanges.contains(object)) {
                AbstractVirtualHost.this.updateAccessControl();
            }
        }

        @Override
        public void bulkChangeStart(ConfiguredObject<?> object) {
            if (object.getCategoryClass() == VirtualHostAccessControlProvider.class) {
                this._bulkChanges.add(object);
            }
        }

        @Override
        public void bulkChangeEnd(ConfiguredObject<?> object) {
            if (object.getCategoryClass() == VirtualHostAccessControlProvider.class) {
                this._bulkChanges.remove(object);
                AbstractVirtualHost.this.updateAccessControl();
            }
        }
    }

    private class FileSystemSpaceChecker
    extends HouseKeepingTask {
        private boolean _fileSystemFull;
        private File _fileSystem;

        public FileSystemSpaceChecker() {
            super("FileSystemSpaceChecker[" + AbstractVirtualHost.this.getName() + "]", AbstractVirtualHost.this, AbstractVirtualHost.this._fileSystemSpaceCheckerJobContext);
        }

        @Override
        public void execute() {
            long totalSpace = this._fileSystem.getTotalSpace();
            long freeSpace = this._fileSystem.getFreeSpace();
            if (totalSpace == 0L) {
                _logger.warn("Cannot check file system for disk space because store path '{}' is not valid", (Object)this._fileSystem.getPath());
                return;
            }
            long usagePercent = 100L * (totalSpace - freeSpace) / totalSpace;
            if (this._fileSystemFull && usagePercent < (long)AbstractVirtualHost.this._fileSystemMaxUsagePercent) {
                this._fileSystemFull = false;
                AbstractVirtualHost.this.getEventLogger().message(AbstractVirtualHost.this.getMessageStoreLogSubject(), VirtualHostMessages.FILESYSTEM_NOTFULL(AbstractVirtualHost.this._fileSystemMaxUsagePercent));
                AbstractVirtualHost.this.unblock(BlockingType.FILESYSTEM);
            } else if (!this._fileSystemFull && usagePercent > (long)AbstractVirtualHost.this._fileSystemMaxUsagePercent) {
                this._fileSystemFull = true;
                AbstractVirtualHost.this.getEventLogger().message(AbstractVirtualHost.this.getMessageStoreLogSubject(), VirtualHostMessages.FILESYSTEM_FULL(AbstractVirtualHost.this._fileSystemMaxUsagePercent));
                AbstractVirtualHost.this.block(BlockingType.FILESYSTEM);
            }
        }

        public void setFileSystem(File fileSystem) {
            this._fileSystem = fileSystem;
        }
    }

    private class SystemNodeRegistry
    implements SystemNodeCreator.SystemNodeRegistry {
        private SystemNodeRegistry() {
        }

        @Override
        public void registerSystemNode(MessageNode node) {
            if (node instanceof MessageDestination) {
                AbstractVirtualHost.this._systemNodeDestinations.put(node.getName(), (MessageDestination)node);
            }
            if (node instanceof MessageSource) {
                AbstractVirtualHost.this._systemNodeSources.put(node.getName(), (MessageSource)node);
            }
        }

        @Override
        public void removeSystemNode(MessageNode node) {
            if (node instanceof MessageDestination) {
                AbstractVirtualHost.this._systemNodeDestinations.remove(node.getName());
            }
            if (node instanceof MessageSource) {
                AbstractVirtualHost.this._systemNodeSources.remove(node.getName());
            }
        }

        @Override
        public void removeSystemNode(String name) {
            AbstractVirtualHost.this._systemNodeDestinations.remove(name);
            AbstractVirtualHost.this._systemNodeSources.remove(name);
        }

        @Override
        public VirtualHostNode<?> getVirtualHostNode() {
            return AbstractVirtualHost.this.getParent(VirtualHostNode.class);
        }

        @Override
        public VirtualHost<?> getVirtualHost() {
            return AbstractVirtualHost.this;
        }

        @Override
        public boolean hasSystemNode(String name) {
            return AbstractVirtualHost.this._systemNodeSources.containsKey(name) || AbstractVirtualHost.this._systemNodeDestinations.containsKey(name);
        }
    }

    private class VirtualHostHouseKeepingTask
    extends HouseKeepingTask {
        private long _lastReportedBytesEvacuatedFromMemory;

        public VirtualHostHouseKeepingTask() {
            super("Housekeeping[" + AbstractVirtualHost.this.getName() + "]", AbstractVirtualHost.this, AbstractVirtualHost.this._housekeepingJobContext);
            this._lastReportedBytesEvacuatedFromMemory = 0L;
        }

        @Override
        public void execute() {
            VirtualHostNode virtualHostNode = AbstractVirtualHost.this.getParent(VirtualHostNode.class);
            Broker broker = virtualHostNode.getParent(Broker.class);
            broker.assignTargetSizes();
            for (Queue q : AbstractVirtualHost.this.getChildren(Queue.class)) {
                if (q.getState() != State.ACTIVE) continue;
                _logger.debug("Checking message status for queue: {}", (Object)q.getName());
                q.checkMessageStatus();
            }
            long currentBytesEvacuatedFromMemory = AbstractVirtualHost.this.getBytesEvacuatedFromMemory();
            if (currentBytesEvacuatedFromMemory != this._lastReportedBytesEvacuatedFromMemory) {
                AbstractVirtualHost.this.getEventLogger().message(VirtualHostMessages.FLOW_TO_DISK(currentBytesEvacuatedFromMemory));
                this._lastReportedBytesEvacuatedFromMemory = currentBytesEvacuatedFromMemory;
            }
        }
    }

    private class TargetSizeAssigningListener
    implements ConfigurationChangeListener {
        private TargetSizeAssigningListener() {
        }

        @Override
        public void childAdded(ConfiguredObject<?> object, ConfiguredObject<?> child) {
            if (child instanceof Queue) {
                AbstractVirtualHost.this.allocateTargetSizeToQueues();
            }
        }

        @Override
        public void childRemoved(ConfiguredObject<?> object, ConfiguredObject<?> child) {
            if (child instanceof Queue) {
                AbstractVirtualHost.this.allocateTargetSizeToQueues();
            }
        }

        @Override
        public void stateChanged(ConfiguredObject<?> object, State oldState, State newState) {
        }

        @Override
        public void attributeSet(ConfiguredObject<?> object, String attributeName, Object oldAttributeValue, Object newAttributeValue) {
        }

        @Override
        public void bulkChangeStart(ConfiguredObject<?> object) {
        }

        @Override
        public void bulkChangeEnd(ConfiguredObject<?> object) {
        }
    }

    private static class MessageHeaderImpl
    implements AMQMessageHeader {
        private final String _userName;
        private final long _timestamp;
        private final ManageableMessage _message;

        public MessageHeaderImpl(ManageableMessage message) {
            this._message = message;
            this._userName = AuthenticatedPrincipal.getCurrentUser().getName();
            this._timestamp = System.currentTimeMillis();
        }

        @Override
        public String getCorrelationId() {
            return this._message.getCorrelationId();
        }

        @Override
        public long getExpiration() {
            Date expiration = this._message.getExpiration();
            return expiration == null ? 0L : expiration.getTime();
        }

        @Override
        public String getUserId() {
            return this._userName;
        }

        @Override
        public String getAppId() {
            return null;
        }

        @Override
        public String getMessageId() {
            return this._message.getMessageId();
        }

        @Override
        public String getMimeType() {
            return this._message.getMimeType();
        }

        @Override
        public String getEncoding() {
            return this._message.getEncoding();
        }

        @Override
        public byte getPriority() {
            return (byte)this._message.getPriority();
        }

        @Override
        public long getTimestamp() {
            return this._timestamp;
        }

        @Override
        public long getNotValidBefore() {
            Date notValidBefore = this._message.getNotValidBefore();
            return notValidBefore == null ? 0L : notValidBefore.getTime();
        }

        @Override
        public String getType() {
            return null;
        }

        @Override
        public String getReplyTo() {
            return this._message.getReplyTo();
        }

        @Override
        public Object getHeader(String name) {
            return this.getHeaders().get(name);
        }

        @Override
        public boolean containsHeaders(Set<String> names) {
            return this.getHeaders().keySet().containsAll(names);
        }

        @Override
        public boolean containsHeader(String name) {
            return this.getHeaders().keySet().contains(name);
        }

        @Override
        public Collection<String> getHeaderNames() {
            return Collections.unmodifiableCollection(this.getHeaders().keySet());
        }

        private Map<String, Object> getHeaders() {
            return this._message.getHeaders() == null ? Collections.emptyMap() : this._message.getHeaders();
        }
    }

    private class MessageStoreContent
    implements Content,
    CustomRestHeaders {
        private MessageStoreContent() {
        }

        @Override
        public void write(final OutputStream outputStream) throws IOException {
            AbstractVirtualHost.this.doSync(AbstractVirtualHost.this.doOnConfigThread(new Task<ListenableFuture<Void>, IOException>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ListenableFuture<Void> execute() throws IOException {
                    if (AbstractVirtualHost.this.getState() != State.STOPPED) {
                        throw new IllegalArgumentException("The exportMessageStore operation can only be called when the virtual host is stopped");
                    }
                    AbstractVirtualHost.this._messageStore.openMessageStore(AbstractVirtualHost.this);
                    try {
                        final HashMap<UUID, String> queueMap = new HashMap<UUID, String>();
                        AbstractVirtualHost.this.getDurableConfigurationStore().reload(new ConfiguredObjectRecordHandler(){

                            @Override
                            public void handle(ConfiguredObjectRecord record) {
                                if (record.getType().equals(Queue.class.getSimpleName())) {
                                    queueMap.put(record.getId(), (String)record.getAttributes().get("name"));
                                }
                            }
                        });
                        MessageStoreSerializer serializer = new QpidServiceLoader().getInstancesByType(MessageStoreSerializer.class).get("v1.0");
                        MessageStore.MessageStoreReader reader = AbstractVirtualHost.this._messageStore.newMessageStoreReader();
                        serializer.serialize(queueMap, reader, outputStream);
                    }
                    finally {
                        AbstractVirtualHost.this._messageStore.closeMessageStore();
                    }
                    return Futures.immediateFuture(null);
                }

                @Override
                public String getObject() {
                    return AbstractVirtualHost.this.toString();
                }

                @Override
                public String getAction() {
                    return "exportMessageStore";
                }

                @Override
                public String getArguments() {
                    return null;
                }
            }));
        }

        @Override
        public void release() {
        }

        @RestContentHeader(value="Content-Type")
        public String getContentType() {
            return "application/octet-stream";
        }

        @RestContentHeader(value="Content-Disposition")
        public String getContentDisposition() {
            try {
                String vhostName = AbstractVirtualHost.this.getName();
                String asciiName = vhostName.replaceAll("[^\\x20-\\x7E]", "?").replace('\\', '?').replaceAll("%[0-9a-fA-F]{2}", "?");
                String disposition = String.format("attachment; filename=\"%s_messages.bin\"; filename*=\"UTF-8''%s_messages.bin\"", asciiName, URLEncoder.encode(vhostName, StandardCharsets.UTF_8.name()));
                return disposition;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("JVM does not support UTF8", e);
            }
        }
    }

    private static enum BlockingType {
        STORE,
        FILESYSTEM;

    }
}

