/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.qpid.server.consumer.ConsumerImpl;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.store.MessageDurability;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.StateChangeListener;

public abstract class AbstractSystemMessageSource
implements MessageSource {
    protected final UUID _id;
    protected final String _name;
    protected final NamedAddressSpace _addressSpace;
    private List<Consumer> _consumers = new CopyOnWriteArrayList<Consumer>();

    public AbstractSystemMessageSource(String name, NamedAddressSpace addressSpace) {
        this._name = name;
        this._id = UUID.nameUUIDFromBytes((this.getClass().getSimpleName() + "/" + addressSpace.getName() + "/" + name).getBytes(StandardCharsets.UTF_8));
        this._addressSpace = addressSpace;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public UUID getId() {
        return this._id;
    }

    @Override
    public MessageDurability getMessageDurability() {
        return MessageDurability.NEVER;
    }

    @Override
    public Consumer addConsumer(ConsumerTarget target, FilterManager filters, Class<? extends ServerMessage> messageClass, String consumerName, EnumSet<ConsumerImpl.Option> options, Integer priority) throws MessageSource.ExistingExclusiveConsumer, MessageSource.ExistingConsumerPreventsExclusive, MessageSource.ConsumerAccessRefused {
        Consumer consumer = new Consumer(consumerName, target);
        target.consumerAdded(consumer);
        this._consumers.add(consumer);
        return consumer;
    }

    public Collection<Consumer> getConsumers() {
        return new ArrayList<Consumer>(this._consumers);
    }

    @Override
    public boolean verifySessionAccess(AMQSessionModel<?> session) {
        return true;
    }

    class PropertiesMessageInstance
    implements MessageInstance {
        private final Consumer _consumer;
        private int _deliveryCount;
        private boolean _isRedelivered;
        private boolean _isDelivered;
        private boolean _isDeleted;
        private InternalMessage _message;

        PropertiesMessageInstance(Consumer consumer, InternalMessage message) {
            this._consumer = consumer;
            this._message = message;
        }

        @Override
        public int getDeliveryCount() {
            return 0;
        }

        @Override
        public void incrementDeliveryCount() {
            ++this._deliveryCount;
        }

        @Override
        public void decrementDeliveryCount() {
            --this._deliveryCount;
        }

        @Override
        public void addStateChangeListener(StateChangeListener<? super MessageInstance, MessageInstance.EntryState> listener) {
        }

        @Override
        public boolean removeStateChangeListener(StateChangeListener<? super MessageInstance, MessageInstance.EntryState> listener) {
            return false;
        }

        @Override
        public boolean acquiredByConsumer() {
            return !this.isDeleted();
        }

        @Override
        public ConsumerImpl getAcquiringConsumer() {
            return this._consumer;
        }

        @Override
        public MessageEnqueueRecord getEnqueueRecord() {
            return null;
        }

        @Override
        public boolean isAcquiredBy(ConsumerImpl consumer) {
            return consumer == this._consumer && !this.isDeleted();
        }

        @Override
        public boolean removeAcquisitionFromConsumer(ConsumerImpl consumer) {
            return consumer == this._consumer;
        }

        @Override
        public void setRedelivered() {
            this._isRedelivered = true;
        }

        @Override
        public boolean isRedelivered() {
            return this._isRedelivered;
        }

        @Override
        public Consumer getDeliveredConsumer() {
            return this.isDeleted() ? null : this._consumer;
        }

        @Override
        public void reject() {
            this.delete();
        }

        @Override
        public boolean isRejectedBy(ConsumerImpl consumer) {
            return false;
        }

        @Override
        public boolean getDeliveredToConsumer() {
            return this._isDelivered;
        }

        @Override
        public boolean expired() {
            return false;
        }

        @Override
        public boolean acquire(ConsumerImpl sub) {
            return false;
        }

        @Override
        public boolean makeAcquisitionUnstealable(ConsumerImpl consumer) {
            return false;
        }

        @Override
        public boolean makeAcquisitionStealable() {
            return false;
        }

        @Override
        public int getMaximumDeliveryCount() {
            return 0;
        }

        @Override
        public int routeToAlternate(Action<? super MessageInstance> action, ServerTransaction txn) {
            return 0;
        }

        @Override
        public Filterable asFilterable() {
            return null;
        }

        @Override
        public boolean isAvailable() {
            return false;
        }

        @Override
        public boolean acquire() {
            return false;
        }

        @Override
        public boolean isAcquired() {
            return !this.isDeleted();
        }

        @Override
        public void release() {
            this.delete();
        }

        @Override
        public void release(ConsumerImpl consumer) {
            this.release();
        }

        @Override
        public boolean resend() {
            return false;
        }

        @Override
        public void delete() {
            this._isDeleted = true;
        }

        @Override
        public boolean isDeleted() {
            return this._isDeleted;
        }

        @Override
        public boolean isHeld() {
            return false;
        }

        @Override
        public ServerMessage getMessage() {
            return this._message;
        }

        @Override
        public InstanceProperties getInstanceProperties() {
            return InstanceProperties.EMPTY;
        }

        @Override
        public TransactionLogResource getOwningResource() {
            return AbstractSystemMessageSource.this;
        }
    }

    protected class Consumer
    implements ConsumerImpl {
        private final long _id = ConsumerImpl.CONSUMER_NUMBER_GENERATOR.getAndIncrement();
        private final List<PropertiesMessageInstance> _queue = Collections.synchronizedList(new ArrayList());
        private final ConsumerTarget _target;
        private final String _name;
        private final StateChangeListener<ConsumerTarget, ConsumerTarget.State> _targetChangeListener = new TargetChangeListener();

        public Consumer(String consumerName, ConsumerTarget target) {
            this._name = consumerName;
            this._target = target;
            target.addStateListener(this._targetChangeListener);
        }

        @Override
        public void externalStateChange() {
        }

        @Override
        public ConsumerTarget getTarget() {
            return this._target;
        }

        @Override
        public boolean hasAvailableMessages() {
            return !this._queue.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pullMessage() {
            AMQPConnection<?> connection = this._target.getSessionModel().getAMQPConnection();
            this._target.getSendLock();
            try {
                connection.alwaysAllowMessageAssignmentInThisThreadIfItIsIOThread(true);
                try {
                    if (!this._queue.isEmpty()) {
                        PropertiesMessageInstance propertiesMessageInstance = this._queue.get(0);
                        if (!this._target.isSuspended() && this._target.allocateCredit(propertiesMessageInstance.getMessage())) {
                            this._queue.remove(0);
                            this._target.send(this, propertiesMessageInstance, false);
                        }
                    }
                }
                finally {
                    connection.alwaysAllowMessageAssignmentInThisThreadIfItIsIOThread(false);
                }
            }
            finally {
                this._target.releaseSendLock();
            }
        }

        @Override
        public long getBytesOut() {
            return 0L;
        }

        @Override
        public long getMessagesOut() {
            return 0L;
        }

        @Override
        public long getUnacknowledgedBytes() {
            return 0L;
        }

        @Override
        public long getUnacknowledgedMessages() {
            return 0L;
        }

        @Override
        public AMQSessionModel getSessionModel() {
            return this._target.getSessionModel();
        }

        @Override
        public MessageSource getMessageSource() {
            return AbstractSystemMessageSource.this;
        }

        @Override
        public long getConsumerNumber() {
            return this._id;
        }

        @Override
        public boolean isSuspended() {
            return false;
        }

        @Override
        public boolean isClosed() {
            return false;
        }

        @Override
        public boolean acquires() {
            return true;
        }

        @Override
        public boolean seesRequeues() {
            return false;
        }

        @Override
        public void close() {
            AbstractSystemMessageSource.this._consumers.remove(this);
        }

        @Override
        public boolean trySendLock() {
            return this._target.trySendLock();
        }

        @Override
        public void getSendLock() {
            this._target.getSendLock();
        }

        @Override
        public void releaseSendLock() {
            this._target.releaseSendLock();
        }

        @Override
        public boolean isActive() {
            return false;
        }

        @Override
        public String getName() {
            return this._name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            AMQPConnection<?> connection = this.getSessionModel().getAMQPConnection();
            try {
                connection.alwaysAllowMessageAssignmentInThisThreadIfItIsIOThread(true);
                this.deliverMessages();
                this._target.processPending();
            }
            finally {
                connection.alwaysAllowMessageAssignmentInThisThreadIfItIsIOThread(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(InternalMessage response) {
            this._target.getSendLock();
            try {
                PropertiesMessageInstance responseEntry = new PropertiesMessageInstance(this, response);
                if (this._queue.isEmpty() && this._target.allocateCredit(response)) {
                    this._target.send(this, responseEntry, false);
                } else {
                    this._queue.add(responseEntry);
                }
            }
            finally {
                this._target.releaseSendLock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deliverMessages() {
            this._target.getSendLock();
            try {
                while (!this._queue.isEmpty()) {
                    PropertiesMessageInstance propertiesMessageInstance = this._queue.get(0);
                    if (!this._target.isSuspended() && this._target.allocateCredit(propertiesMessageInstance.getMessage())) {
                        this._queue.remove(0);
                        this._target.send(this, propertiesMessageInstance, false);
                        continue;
                    }
                    break;
                }
            }
            finally {
                this._target.releaseSendLock();
            }
        }

        private class TargetChangeListener
        implements StateChangeListener<ConsumerTarget, ConsumerTarget.State> {
            private TargetChangeListener() {
            }

            @Override
            public void stateChanged(ConsumerTarget object, ConsumerTarget.State oldState, ConsumerTarget.State newState) {
                if (newState == ConsumerTarget.State.ACTIVE) {
                    Consumer.this.deliverMessages();
                }
            }
        }
    }
}

