/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.qpid.server.util.CipherSuiteAndProtocolRestrictingSSLSocketFactory;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.transport.TransportException;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionBuilder.class);
    private final URL _url;
    private int _connectTimeout;
    private int _readTimeout;
    private TrustManager[] _trustMangers;
    private List<String> _tlsProtocolWhiteList;
    private List<String> _tlsProtocolBlackList;
    private List<String> _tlsCipherSuiteWhiteList;
    private List<String> _tlsCipherSuiteBlackList;

    public ConnectionBuilder(URL url) {
        this._url = url;
    }

    public ConnectionBuilder setConnectTimeout(int timeout) {
        this._connectTimeout = timeout;
        return this;
    }

    public ConnectionBuilder setReadTimeout(int readTimeout) {
        this._readTimeout = readTimeout;
        return this;
    }

    public ConnectionBuilder setTrustMangers(TrustManager[] trustMangers) {
        this._trustMangers = trustMangers;
        return this;
    }

    public ConnectionBuilder setTlsProtocolWhiteList(List<String> tlsProtocolWhiteList) {
        this._tlsProtocolWhiteList = tlsProtocolWhiteList;
        return this;
    }

    public ConnectionBuilder setTlsProtocolBlackList(List<String> tlsProtocolBlackList) {
        this._tlsProtocolBlackList = tlsProtocolBlackList;
        return this;
    }

    public ConnectionBuilder setTlsCipherSuiteWhiteList(List<String> tlsCipherSuiteWhiteList) {
        this._tlsCipherSuiteWhiteList = tlsCipherSuiteWhiteList;
        return this;
    }

    public ConnectionBuilder setTlsCipherSuiteBlackList(List<String> tlsCipherSuiteBlackList) {
        this._tlsCipherSuiteBlackList = tlsCipherSuiteBlackList;
        return this;
    }

    public HttpURLConnection build() throws IOException {
        HttpsURLConnection httpsConnection;
        HttpURLConnection connection = (HttpURLConnection)this._url.openConnection();
        connection.setConnectTimeout(this._connectTimeout);
        connection.setReadTimeout(this._readTimeout);
        if (this._trustMangers != null && this._trustMangers.length > 0) {
            SSLContext sslContext;
            httpsConnection = (HttpsURLConnection)connection;
            try {
                sslContext = SSLUtil.tryGetSSLContext();
                sslContext.init(null, this._trustMangers, null);
            }
            catch (GeneralSecurityException e) {
                throw new ServerScopedRuntimeException("Cannot initialise TLS", e);
            }
            SSLSocketFactory socketFactory = sslContext.getSocketFactory();
            httpsConnection.setSSLSocketFactory(socketFactory);
            httpsConnection.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession sslSession) {
                    try {
                        Certificate cert = sslSession.getPeerCertificates()[0];
                        if (cert instanceof X509Certificate) {
                            X509Certificate x509Certificate = (X509Certificate)cert;
                            SSLUtil.verifyHostname((String)hostname, (X509Certificate)x509Certificate);
                            return true;
                        }
                        LOGGER.warn("Cannot verify peer's hostname as peer does not present a X509Certificate. Presented certificate : {}", (Object)cert);
                    }
                    catch (SSLPeerUnverifiedException | TransportException e) {
                        LOGGER.warn("Failed to verify peer's hostname (connecting to host {})", (Object)hostname, (Object)e);
                    }
                    return false;
                }
            });
        }
        if (this._tlsProtocolWhiteList != null && !this._tlsProtocolWhiteList.isEmpty() || this._tlsProtocolBlackList != null && !this._tlsProtocolBlackList.isEmpty() || this._tlsCipherSuiteWhiteList != null && !this._tlsCipherSuiteWhiteList.isEmpty() || this._tlsCipherSuiteBlackList != null && !this._tlsCipherSuiteBlackList.isEmpty()) {
            httpsConnection = (HttpsURLConnection)connection;
            SSLSocketFactory originalSocketFactory = httpsConnection.getSSLSocketFactory();
            httpsConnection.setSSLSocketFactory(new CipherSuiteAndProtocolRestrictingSSLSocketFactory(originalSocketFactory, this._tlsCipherSuiteWhiteList, this._tlsCipherSuiteBlackList, this._tlsProtocolWhiteList, this._tlsProtocolBlackList));
        }
        return connection;
    }
}

