/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;

public class CipherSuiteAndProtocolRestrictingSSLSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory _wrappedSocketFactory;
    private final List<String> _tlsCipherSuiteWhiteList;
    private final List<String> _tlsCipherSuiteBlackList;
    private final List<String> _tlsProtocolWhiteList;
    private final List<String> _tlsProtocolBlackList;

    public CipherSuiteAndProtocolRestrictingSSLSocketFactory(SSLSocketFactory wrappedSocketFactory, List<String> tlsCipherSuiteWhiteList, List<String> tlsCipherSuiteBlackList, List<String> tlsProtocolWhiteList, List<String> tlsProtocolBlackList) {
        this._wrappedSocketFactory = wrappedSocketFactory;
        this._tlsCipherSuiteWhiteList = tlsCipherSuiteWhiteList == null ? null : new ArrayList<String>(tlsCipherSuiteWhiteList);
        this._tlsCipherSuiteBlackList = tlsCipherSuiteBlackList == null ? null : new ArrayList<String>(tlsCipherSuiteBlackList);
        this._tlsProtocolWhiteList = tlsProtocolWhiteList == null ? null : new ArrayList<String>(tlsProtocolWhiteList);
        this._tlsProtocolBlackList = tlsProtocolBlackList == null ? null : new ArrayList<String>(tlsProtocolBlackList);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return SSLUtil.filterEnabledCipherSuites((String[])this._wrappedSocketFactory.getDefaultCipherSuites(), (String[])this._wrappedSocketFactory.getSupportedCipherSuites(), this._tlsCipherSuiteWhiteList, this._tlsCipherSuiteBlackList);
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this._wrappedSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        SSLSocket newSocket = (SSLSocket)this._wrappedSocketFactory.createSocket(socket, host, port, autoClose);
        SSLUtil.updateEnabledCipherSuites((SSLSocket)newSocket, this._tlsCipherSuiteWhiteList, this._tlsCipherSuiteBlackList);
        SSLUtil.updateEnabledTlsProtocols((SSLSocket)newSocket, this._tlsProtocolWhiteList, this._tlsProtocolBlackList);
        return newSocket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this._wrappedSocketFactory.createSocket(host, port);
        SSLUtil.updateEnabledCipherSuites((SSLSocket)socket, this._tlsCipherSuiteWhiteList, this._tlsCipherSuiteBlackList);
        SSLUtil.updateEnabledTlsProtocols((SSLSocket)socket, this._tlsProtocolWhiteList, this._tlsProtocolBlackList);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localhost, int localPort) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this._wrappedSocketFactory.createSocket(host, port, localhost, localPort);
        SSLUtil.updateEnabledCipherSuites((SSLSocket)socket, this._tlsCipherSuiteWhiteList, this._tlsCipherSuiteBlackList);
        SSLUtil.updateEnabledTlsProtocols((SSLSocket)socket, this._tlsProtocolWhiteList, this._tlsProtocolBlackList);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocket socket = (SSLSocket)this._wrappedSocketFactory.createSocket(host, port);
        SSLUtil.updateEnabledCipherSuites((SSLSocket)socket, this._tlsCipherSuiteWhiteList, this._tlsCipherSuiteBlackList);
        SSLUtil.updateEnabledTlsProtocols((SSLSocket)socket, this._tlsProtocolWhiteList, this._tlsProtocolBlackList);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocket socket = (SSLSocket)this._wrappedSocketFactory.createSocket(address, port, localAddress, localPort);
        SSLUtil.updateEnabledCipherSuites((SSLSocket)socket, this._tlsCipherSuiteWhiteList, this._tlsCipherSuiteBlackList);
        SSLUtil.updateEnabledTlsProtocols((SSLSocket)socket, this._tlsProtocolWhiteList, this._tlsProtocolBlackList);
        return socket;
    }
}

