/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class CachingUUIDFactory {
    private final Map<UUID, UUID> _uuids = new HashMap<UUID, UUID>();

    public UUID createUuidFromString(String name) {
        UUID candidate = UUID.fromString(name);
        return this.cacheIfNecessary(candidate);
    }

    public UUID createUuidFromBits(long mostSigBits, long leastSigBits) {
        UUID candidate = new UUID(mostSigBits, leastSigBits);
        return this.cacheIfNecessary(candidate);
    }

    private UUID cacheIfNecessary(UUID candidate) {
        UUID existing = this._uuids.get(candidate);
        if (existing != null) {
            return existing;
        }
        this._uuids.put(candidate, candidate);
        return candidate;
    }
}

