/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.txn;

import java.util.Collection;
import java.util.List;
import org.apache.qpid.server.message.EnqueueableMessage;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.txn.AlreadyKnownDtxException;
import org.apache.qpid.server.txn.AutoCommitTransaction;
import org.apache.qpid.server.txn.DtxBranch;
import org.apache.qpid.server.txn.DtxRegistry;
import org.apache.qpid.server.txn.JoinAndResumeDtxException;
import org.apache.qpid.server.txn.NotAssociatedDtxException;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.txn.SuspendAndFailDtxException;
import org.apache.qpid.server.txn.TimeoutDtxException;
import org.apache.qpid.server.txn.UnknownDtxBranchException;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.transport.Xid;

public class DistributedTransaction
implements ServerTransaction {
    private final AutoCommitTransaction _autoCommitTransaction;
    private DtxBranch _branch;
    private AMQSessionModel _session;
    private DtxRegistry _dtxRegistry;

    public DistributedTransaction(AMQSessionModel session, DtxRegistry dtxRegistry) {
        this._session = session;
        this._dtxRegistry = dtxRegistry;
        this._autoCommitTransaction = new AutoCommitTransaction(dtxRegistry.getMessageStore());
    }

    @Override
    public long getTransactionStartTime() {
        return 0L;
    }

    @Override
    public long getTransactionUpdateTime() {
        return 0L;
    }

    @Override
    public void addPostTransactionAction(ServerTransaction.Action postTransactionAction) {
        if (this._branch != null) {
            this._branch.addPostTransactionAction(postTransactionAction);
        } else {
            this._autoCommitTransaction.addPostTransactionAction(postTransactionAction);
        }
    }

    @Override
    public void dequeue(MessageEnqueueRecord record, ServerTransaction.Action postTransactionAction) {
        if (this._branch != null) {
            this._branch.dequeue(record);
            this._branch.addPostTransactionAction(postTransactionAction);
        } else {
            this._autoCommitTransaction.dequeue(record, postTransactionAction);
        }
    }

    @Override
    public void dequeue(Collection<MessageInstance> messages, ServerTransaction.Action postTransactionAction) {
        if (this._branch != null) {
            for (MessageInstance entry : messages) {
                this._branch.dequeue(entry.getEnqueueRecord());
            }
            this._branch.addPostTransactionAction(postTransactionAction);
        } else {
            this._autoCommitTransaction.dequeue(messages, postTransactionAction);
        }
    }

    @Override
    public void enqueue(TransactionLogResource queue, EnqueueableMessage message, final ServerTransaction.EnqueueAction postTransactionAction) {
        if (this._branch != null) {
            final MessageEnqueueRecord[] enqueueRecords = new MessageEnqueueRecord[1];
            this._branch.enqueue(queue, message, new Action<MessageEnqueueRecord>(){

                @Override
                public void performAction(MessageEnqueueRecord record) {
                    enqueueRecords[0] = record;
                }
            });
            this.addPostTransactionAction(new ServerTransaction.Action(){

                @Override
                public void postCommit() {
                    postTransactionAction.postCommit(enqueueRecords);
                }

                @Override
                public void onRollback() {
                    postTransactionAction.onRollback();
                }
            });
        } else {
            this._autoCommitTransaction.enqueue(queue, message, postTransactionAction);
        }
    }

    @Override
    public void enqueue(List<? extends BaseQueue> queues, EnqueueableMessage message, final ServerTransaction.EnqueueAction postTransactionAction) {
        if (this._branch != null) {
            final MessageEnqueueRecord[] enqueueRecords = new MessageEnqueueRecord[queues.size()];
            int i = 0;
            for (BaseQueue baseQueue : queues) {
                final int pos = i++;
                this._branch.enqueue(baseQueue, message, new Action<MessageEnqueueRecord>(){

                    @Override
                    public void performAction(MessageEnqueueRecord record) {
                        enqueueRecords[pos] = record;
                    }
                });
            }
            this.addPostTransactionAction(new ServerTransaction.Action(){

                @Override
                public void postCommit() {
                    postTransactionAction.postCommit(enqueueRecords);
                }

                @Override
                public void onRollback() {
                    postTransactionAction.onRollback();
                }
            });
        } else {
            this._autoCommitTransaction.enqueue(queues, message, postTransactionAction);
        }
    }

    @Override
    public void commit() {
        throw new IllegalStateException("Cannot call tx.commit() on a distributed transaction");
    }

    @Override
    public void commit(Runnable immediatePostTransactionAction) {
        throw new IllegalStateException("Cannot call tx.commit() on a distributed transaction");
    }

    @Override
    public void rollback() {
        throw new IllegalStateException("Cannot call tx.rollback() on a distributed transaction");
    }

    @Override
    public boolean isTransactional() {
        return this._branch != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start(Xid id, boolean join, boolean resume) throws UnknownDtxBranchException, AlreadyKnownDtxException, JoinAndResumeDtxException {
        if (join && resume) {
            throw new JoinAndResumeDtxException(id);
        }
        DtxBranch branch = this._dtxRegistry.getBranch(id);
        if (branch == null) {
            if (join || resume) {
                throw new UnknownDtxBranchException(id);
            }
            branch = new DtxBranch(id, this._dtxRegistry);
            if (!this._dtxRegistry.registerBranch(branch)) throw new AlreadyKnownDtxException(id);
            this._branch = branch;
            branch.associateSession(this._session);
            return;
        } else {
            if (join) {
                branch.associateSession(this._session);
            } else {
                if (!resume) throw new AlreadyKnownDtxException(id);
                branch.resumeSession(this._session);
            }
            this._branch = branch;
        }
    }

    public void end(Xid id, boolean fail, boolean suspend) throws UnknownDtxBranchException, NotAssociatedDtxException, SuspendAndFailDtxException, TimeoutDtxException {
        DtxBranch branch = this._dtxRegistry.getBranch(id);
        if (suspend && fail) {
            branch.disassociateSession(this._session);
            this._branch = null;
            throw new SuspendAndFailDtxException(id);
        }
        if (branch == null) {
            throw new UnknownDtxBranchException(id);
        }
        if (!branch.isAssociated(this._session)) {
            throw new NotAssociatedDtxException(id);
        }
        if (branch.expired() || branch.getState() == DtxBranch.State.TIMEDOUT) {
            branch.disassociateSession(this._session);
            throw new TimeoutDtxException(id);
        }
        if (suspend) {
            branch.suspendSession(this._session);
        } else {
            if (fail) {
                branch.setState(DtxBranch.State.ROLLBACK_ONLY);
            }
            branch.disassociateSession(this._session);
        }
        this._branch = null;
    }
}

