/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.txn;

import java.util.Collection;
import java.util.List;
import org.apache.qpid.server.message.EnqueueableMessage;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.Transaction;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.txn.ServerTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCommitTransaction
implements ServerTransaction {
    protected static final Logger _logger = LoggerFactory.getLogger(AutoCommitTransaction.class);
    private final MessageStore _messageStore;

    public AutoCommitTransaction(MessageStore transactionLog) {
        this._messageStore = transactionLog;
    }

    @Override
    public long getTransactionStartTime() {
        return 0L;
    }

    @Override
    public long getTransactionUpdateTime() {
        return 0L;
    }

    @Override
    public void addPostTransactionAction(ServerTransaction.Action immediateAction) {
        immediateAction.postCommit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dequeue(MessageEnqueueRecord record, ServerTransaction.Action postTransactionAction) {
        Transaction txn = null;
        try {
            if (record != null) {
                _logger.debug("Dequeue of message number {} from transaction log. Queue : {}", (Object)record.getMessageNumber(), (Object)record.getQueueId());
                txn = this._messageStore.newTransaction();
                txn.dequeueMessage(record);
                txn.commitTran();
                txn = null;
            }
            postTransactionAction.postCommit();
            postTransactionAction = null;
        }
        finally {
            this.rollbackIfNecessary(postTransactionAction, txn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dequeue(Collection<MessageInstance> queueEntries, ServerTransaction.Action postTransactionAction) {
        Transaction txn = null;
        try {
            for (MessageInstance entry : queueEntries) {
                MessageEnqueueRecord enqueueRecord = entry.getEnqueueRecord();
                if (enqueueRecord == null) continue;
                _logger.debug("Dequeue of message number {} from transaction log. Queue : {}", (Object)enqueueRecord.getMessageNumber(), (Object)enqueueRecord.getQueueId());
                if (txn == null) {
                    txn = this._messageStore.newTransaction();
                }
                txn.dequeueMessage(enqueueRecord);
            }
            if (txn != null) {
                txn.commitTran();
                txn = null;
            }
            postTransactionAction.postCommit();
            postTransactionAction = null;
            this.rollbackIfNecessary(postTransactionAction, txn);
        }
        catch (Throwable throwable) {
            this.rollbackIfNecessary(postTransactionAction, txn);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(TransactionLogResource queue, EnqueueableMessage message, ServerTransaction.EnqueueAction postTransactionAction) {
        Transaction txn = null;
        try {
            MessageEnqueueRecord record;
            if (queue.getMessageDurability().persist(message.isPersistent())) {
                _logger.debug("Enqueue of message number {} to transaction log. Queue : {}", (Object)message.getMessageNumber(), (Object)queue.getName());
                txn = this._messageStore.newTransaction();
                record = txn.enqueueMessage(queue, message);
                txn.commitTran();
                txn = null;
            } else {
                record = null;
            }
            if (postTransactionAction != null) {
                postTransactionAction.postCommit(record);
            }
            ServerTransaction.EnqueueAction underlying = postTransactionAction = null;
            this.rollbackIfNecessary(new ServerTransaction.Action(underlying){
                final /* synthetic */ ServerTransaction.EnqueueAction val$underlying;
                {
                    this.val$underlying = enqueueAction;
                }

                @Override
                public void postCommit() {
                }

                @Override
                public void onRollback() {
                    if (this.val$underlying != null) {
                        this.val$underlying.onRollback();
                    }
                }
            }, txn);
        }
        catch (Throwable throwable) {
            ServerTransaction.EnqueueAction underlying = postTransactionAction;
            this.rollbackIfNecessary(new /* invalid duplicate definition of identical inner class */, txn);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(List<? extends BaseQueue> queues, EnqueueableMessage message, ServerTransaction.EnqueueAction postTransactionAction) {
        Transaction txn = null;
        try {
            MessageEnqueueRecord[] enqueueRecords = new MessageEnqueueRecord[queues.size()];
            int i = 0;
            for (BaseQueue baseQueue : queues) {
                if (baseQueue.getMessageDurability().persist(message.isPersistent())) {
                    _logger.debug("Enqueue of message number {} to transaction log. Queue : {}", (Object)message.getMessageNumber(), (Object)baseQueue.getName());
                    if (txn == null) {
                        txn = this._messageStore.newTransaction();
                    }
                    enqueueRecords[i] = txn.enqueueMessage(baseQueue, message);
                }
                ++i;
            }
            if (txn != null) {
                txn.commitTran();
                txn = null;
            }
            if (postTransactionAction != null) {
                postTransactionAction.postCommit(enqueueRecords);
            }
            ServerTransaction.EnqueueAction underlying = postTransactionAction = null;
            this.rollbackIfNecessary(new ServerTransaction.Action(underlying){
                final /* synthetic */ ServerTransaction.EnqueueAction val$underlying;
                {
                    this.val$underlying = enqueueAction;
                }

                @Override
                public void postCommit() {
                }

                @Override
                public void onRollback() {
                    if (this.val$underlying != null) {
                        this.val$underlying.onRollback();
                    }
                }
            }, txn);
        }
        catch (Throwable throwable) {
            ServerTransaction.EnqueueAction underlying = postTransactionAction;
            this.rollbackIfNecessary(new /* invalid duplicate definition of identical inner class */, txn);
            throw throwable;
        }
    }

    @Override
    public void commit(Runnable immediatePostTransactionAction) {
        immediatePostTransactionAction.run();
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() {
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    private void rollbackIfNecessary(ServerTransaction.Action postTransactionAction, Transaction txn) {
        if (txn != null) {
            txn.abortTran();
        }
        if (postTransactionAction != null) {
            postTransactionAction.onRollback();
        }
    }
}

