/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.txn;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import org.apache.qpid.server.message.EnqueueableMessage;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.Transaction;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.txn.ServerTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncAutoCommitTransaction
implements ServerTransaction {
    static final String QPID_STRICT_ORDER_WITH_MIXED_DELIVERY_MODE = "qpid.strict_order_with_mixed_delivery_mode";
    protected static final Logger _logger = LoggerFactory.getLogger(AsyncAutoCommitTransaction.class);
    private final MessageStore _messageStore;
    private final FutureRecorder _futureRecorder;
    private boolean _strictOrderWithMixedDeliveryMode = Boolean.getBoolean("qpid.strict_order_with_mixed_delivery_mode");

    public AsyncAutoCommitTransaction(MessageStore transactionLog, FutureRecorder recorder) {
        this._messageStore = transactionLog;
        this._futureRecorder = recorder;
    }

    @Override
    public long getTransactionStartTime() {
        return 0L;
    }

    @Override
    public long getTransactionUpdateTime() {
        return 0L;
    }

    @Override
    public void addPostTransactionAction(ServerTransaction.Action immediateAction) {
        this.addFuture((ListenableFuture<Void>)Futures.immediateFuture(null), immediateAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dequeue(MessageEnqueueRecord record, ServerTransaction.Action postTransactionAction) {
        Transaction txn = null;
        try {
            ListenableFuture<Void> future;
            if (record != null) {
                _logger.debug("Dequeue of message number {} from transaction log. Queue : {}", (Object)record.getMessageNumber(), (Object)record.getQueueId());
                txn = this._messageStore.newTransaction();
                txn.dequeueMessage(record);
                future = txn.commitTranAsync(null);
                txn = null;
            } else {
                future = Futures.immediateFuture(null);
            }
            this.addFuture(future, postTransactionAction);
            postTransactionAction = null;
            this.rollbackIfNecessary(postTransactionAction, txn);
        }
        catch (Throwable throwable) {
            this.rollbackIfNecessary(postTransactionAction, txn);
            throw throwable;
        }
    }

    private void addFuture(ListenableFuture<Void> future, ServerTransaction.Action action) {
        if (action != null) {
            if (future.isDone()) {
                action.postCommit();
            } else {
                this._futureRecorder.recordFuture(future, action);
            }
        }
    }

    private void addEnqueueFuture(ListenableFuture<Void> future, ServerTransaction.Action action, boolean persistent) {
        if (action != null) {
            if (future.isDone() && !persistent && !this._strictOrderWithMixedDeliveryMode) {
                action.postCommit();
            } else {
                this._futureRecorder.recordFuture(future, action);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dequeue(Collection<MessageInstance> queueEntries, ServerTransaction.Action postTransactionAction) {
        Transaction txn = null;
        try {
            ListenableFuture<Void> future;
            for (MessageInstance entry : queueEntries) {
                MessageEnqueueRecord record = entry.getEnqueueRecord();
                if (record == null) continue;
                _logger.debug("Dequeue of message number {} from transaction log. Queue : {}", (Object)record.getMessageNumber(), (Object)record.getQueueId());
                if (txn == null) {
                    txn = this._messageStore.newTransaction();
                }
                txn.dequeueMessage(record);
            }
            if (txn != null) {
                future = txn.commitTranAsync(null);
                txn = null;
            } else {
                future = Futures.immediateFuture(null);
            }
            this.addFuture(future, postTransactionAction);
            postTransactionAction = null;
            this.rollbackIfNecessary(postTransactionAction, txn);
        }
        catch (Throwable throwable) {
            this.rollbackIfNecessary(postTransactionAction, txn);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(TransactionLogResource queue, EnqueueableMessage message, ServerTransaction.EnqueueAction postTransactionAction) {
        Transaction txn = null;
        try {
            ListenableFuture<Void> future;
            MessageEnqueueRecord enqueueRecord;
            if (queue.getMessageDurability().persist(message.isPersistent())) {
                _logger.debug("Enqueue of message number {} to transaction log. Queue : {}", (Object)message.getMessageNumber(), (Object)queue.getName());
                txn = this._messageStore.newTransaction();
                enqueueRecord = txn.enqueueMessage(queue, message);
                future = txn.commitTranAsync(null);
                txn = null;
            } else {
                future = Futures.immediateFuture(null);
                enqueueRecord = null;
            }
            final ServerTransaction.EnqueueAction underlying = postTransactionAction;
            this.addEnqueueFuture(future, new ServerTransaction.Action(){

                @Override
                public void postCommit() {
                    underlying.postCommit(enqueueRecord);
                }

                @Override
                public void onRollback() {
                    underlying.postCommit(enqueueRecord);
                }
            }, message.isPersistent());
            ServerTransaction.EnqueueAction underlying2 = postTransactionAction = null;
            this.rollbackIfNecessary(new ServerTransaction.Action(underlying2){
                final /* synthetic */ ServerTransaction.EnqueueAction val$underlying;
                {
                    this.val$underlying = enqueueAction;
                }

                @Override
                public void postCommit() {
                }

                @Override
                public void onRollback() {
                    if (this.val$underlying != null) {
                        this.val$underlying.onRollback();
                    }
                }
            }, txn);
        }
        catch (Throwable throwable) {
            ServerTransaction.EnqueueAction underlying = postTransactionAction;
            this.rollbackIfNecessary(new /* invalid duplicate definition of identical inner class */, txn);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(List<? extends BaseQueue> queues, EnqueueableMessage message, ServerTransaction.EnqueueAction postTransactionAction) {
        Transaction txn = null;
        try {
            ListenableFuture<Void> future;
            final MessageEnqueueRecord[] records = new MessageEnqueueRecord[queues.size()];
            int i = 0;
            for (BaseQueue baseQueue : queues) {
                if (baseQueue.getMessageDurability().persist(message.isPersistent())) {
                    _logger.debug("Enqueue of message number {} to transaction log. Queue : {}", (Object)message.getMessageNumber(), (Object)baseQueue.getName());
                    if (txn == null) {
                        txn = this._messageStore.newTransaction();
                    }
                    records[i] = txn.enqueueMessage(baseQueue, message);
                }
                ++i;
            }
            if (txn != null) {
                future = txn.commitTranAsync(null);
                txn = null;
            } else {
                future = Futures.immediateFuture(null);
            }
            final ServerTransaction.EnqueueAction enqueueAction = postTransactionAction;
            this.addEnqueueFuture(future, new ServerTransaction.Action(){

                @Override
                public void postCommit() {
                    if (enqueueAction != null) {
                        enqueueAction.postCommit(records);
                    }
                }

                @Override
                public void onRollback() {
                    enqueueAction.onRollback();
                }
            }, message.isPersistent());
            ServerTransaction.EnqueueAction underlying2 = postTransactionAction = null;
            this.rollbackIfNecessary(new ServerTransaction.Action(underlying2){
                final /* synthetic */ ServerTransaction.EnqueueAction val$underlying;
                {
                    this.val$underlying = enqueueAction;
                }

                @Override
                public void postCommit() {
                }

                @Override
                public void onRollback() {
                    if (this.val$underlying != null) {
                        this.val$underlying.onRollback();
                    }
                }
            }, txn);
        }
        catch (Throwable throwable) {
            ServerTransaction.EnqueueAction underlying = postTransactionAction;
            this.rollbackIfNecessary(new /* invalid duplicate definition of identical inner class */, txn);
            throw throwable;
        }
    }

    @Override
    public void commit(final Runnable immediatePostTransactionAction) {
        if (immediatePostTransactionAction != null) {
            this.addFuture((ListenableFuture<Void>)Futures.immediateFuture(null), new ServerTransaction.Action(){

                @Override
                public void postCommit() {
                    immediatePostTransactionAction.run();
                }

                @Override
                public void onRollback() {
                }
            });
        }
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() {
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    private void rollbackIfNecessary(ServerTransaction.Action postTransactionAction, Transaction txn) {
        if (txn != null) {
            txn.abortTran();
        }
        if (postTransactionAction != null) {
            postTransactionAction.onRollback();
        }
    }

    public static interface FutureRecorder {
        public void recordFuture(ListenableFuture<Void> var1, ServerTransaction.Action var2);
    }
}

