/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport;

import org.apache.qpid.transport.network.Ticker;
import org.apache.qpid.transport.network.TransportActivity;

public class ServerIdleWriteTimeoutTicker
implements Ticker {
    private final TransportActivity _transport;
    private final int _writeDelay;

    public ServerIdleWriteTimeoutTicker(TransportActivity transport, int writeDelay) {
        if (writeDelay <= 0) {
            throw new IllegalArgumentException("Write delay should be positive");
        }
        this._transport = transport;
        this._writeDelay = writeDelay;
    }

    public int getTimeToNextTick(long currentTime) {
        long writeTime = this._transport.getLastWriteTime() + (long)this._writeDelay;
        return (int)(writeTime - currentTime);
    }

    public int tick(long currentTime) {
        int timeToNextTick = this.getTimeToNextTick(currentTime);
        if (timeToNextTick <= 0) {
            this._transport.writerIdle();
        }
        return timeToNextTick;
    }
}

