/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.EnumSet;
import java.util.Set;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.transport.MultiVersionProtocolEngine;
import org.apache.qpid.server.transport.MultiVersionProtocolEngineFactory;
import org.apache.qpid.server.transport.NetworkConnectionScheduler;
import org.apache.qpid.server.transport.NonBlockingConnection;
import org.apache.qpid.server.transport.PortBindFailureException;
import org.apache.qpid.transport.TransportException;
import org.apache.qpid.transport.network.TransportEncryption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonBlockingNetworkTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonBlockingNetworkTransport.class);
    private final Set<TransportEncryption> _encryptionSet;
    private final MultiVersionProtocolEngineFactory _factory;
    private final ServerSocketChannel _serverSocket;
    private final NetworkConnectionScheduler _scheduler;
    private final AmqpPort<?> _port;
    private final InetSocketAddress _address;

    public NonBlockingNetworkTransport(MultiVersionProtocolEngineFactory factory, EnumSet<TransportEncryption> encryptionSet, NetworkConnectionScheduler scheduler, AmqpPort<?> port) {
        try {
            this._factory = factory;
            String bindingAddress = port.getBindingAddress();
            if ("*".equals(bindingAddress)) {
                bindingAddress = null;
            }
            int portNumber = port.getPort();
            this._address = bindingAddress == null ? new InetSocketAddress(portNumber) : new InetSocketAddress(bindingAddress, portNumber);
            int acceptBacklog = port.getContextValue(Integer.class, "qpid.port.amqp.acceptBacklog");
            this._serverSocket = ServerSocketChannel.open();
            this._serverSocket.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            try {
                this._serverSocket.bind(this._address, acceptBacklog);
            }
            catch (BindException e) {
                throw new PortBindFailureException(this._address);
            }
            this._serverSocket.configureBlocking(false);
            this._encryptionSet = encryptionSet;
            this._scheduler = scheduler;
            this._port = port;
        }
        catch (IOException e) {
            throw new TransportException("Failed to start AMQP on port : " + port, (Throwable)e);
        }
    }

    public void start() {
        this._scheduler.addAcceptingSocket(this._serverSocket, this);
    }

    public void close() {
        this._scheduler.cancelAcceptingSocket(this._serverSocket);
        try {
            this._serverSocket.close();
        }
        catch (IOException e) {
            LOGGER.warn("Error closing the server socket for : " + this._address.toString(), (Throwable)e);
        }
    }

    public int getAcceptingPort() {
        return this._serverSocket.socket().getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acceptSocketChannel(ServerSocketChannel serverSocketChannel) {
        block17: {
            SocketChannel socketChannel = null;
            boolean success = false;
            block13: while (true) {
                try {
                    while ((socketChannel = serverSocketChannel.accept()) != null) {
                        SocketAddress remoteSocketAddress = socketChannel.socket().getRemoteSocketAddress();
                        final MultiVersionProtocolEngine engine = this._factory.newProtocolEngine(remoteSocketAddress);
                        if (engine != null) {
                            socketChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)this._port.isTcpNoDelay());
                            int bufferSize = this._port.getNetworkBufferSize();
                            socketChannel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)bufferSize);
                            socketChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)bufferSize);
                            socketChannel.configureBlocking(false);
                            NonBlockingConnection connection = new NonBlockingConnection(socketChannel, engine, this._encryptionSet, new Runnable(){

                                @Override
                                public void run() {
                                    engine.encryptedTransport();
                                }
                            }, this._scheduler, this._port);
                            engine.setNetworkConnection(connection);
                            connection.start();
                            this._scheduler.addConnection(connection);
                            success = true;
                            continue;
                        }
                        LOGGER.error("No Engine available.");
                        try {
                            socketChannel.close();
                            continue block13;
                        }
                        catch (IOException e) {
                            LOGGER.debug("Failed to close socket " + socketChannel, (Throwable)e);
                        }
                    }
                    break block17;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to process incoming socket", (Throwable)e);
                    break block17;
                }
            }
            finally {
                if (!success && socketChannel != null) {
                    try {
                        socketChannel.close();
                    }
                    catch (IOException e) {
                        LOGGER.debug("Failed to close socket " + socketChannel, (Throwable)e);
                    }
                }
            }
        }
    }
}

