/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.transport.AggregateTicker;
import org.apache.qpid.server.transport.NetworkConnectionScheduler;
import org.apache.qpid.server.transport.NonBlockingConnectionDelegate;
import org.apache.qpid.server.transport.NonBlockingConnectionPlainDelegate;
import org.apache.qpid.server.transport.NonBlockingConnectionTLSDelegate;
import org.apache.qpid.server.transport.NonBlockingConnectionUndecidedDelegate;
import org.apache.qpid.server.transport.ProtocolEngine;
import org.apache.qpid.server.transport.SchedulingDelayNotificationListener;
import org.apache.qpid.server.transport.SelectorThread;
import org.apache.qpid.server.transport.ServerNetworkConnection;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.transport.ByteBufferSender;
import org.apache.qpid.transport.network.TransportEncryption;
import org.apache.qpid.util.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonBlockingConnection
implements ServerNetworkConnection,
ByteBufferSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonBlockingConnection.class);
    private final SocketChannel _socketChannel;
    private NonBlockingConnectionDelegate _delegate;
    private final Deque<NetworkConnectionScheduler> _schedulerDeque = new ConcurrentLinkedDeque<NetworkConnectionScheduler>();
    private final ConcurrentLinkedQueue<QpidByteBuffer> _buffers = new ConcurrentLinkedQueue();
    private final String _remoteSocketAddress;
    private final AtomicBoolean _closed = new AtomicBoolean(false);
    private final ProtocolEngine _protocolEngine;
    private final Runnable _onTransportEncryptionAction;
    private final AtomicLong _usedOutboundMessageSpace = new AtomicLong();
    private final long _outboundMessageBufferLimit;
    private volatile boolean _fullyWritten = true;
    private boolean _partialRead = false;
    private final AmqpPort _port;
    private final AtomicBoolean _scheduled = new AtomicBoolean();
    private volatile long _scheduledTime;
    private volatile boolean _unexpectedByteBufferSizeReported;
    private final String _threadName;
    private volatile SelectorThread.SelectionTask _selectionTask;
    private Iterator<Runnable> _pendingIterator;
    private final AtomicLong _maxWriteIdleMillis = new AtomicLong();
    private final AtomicLong _maxReadIdleMillis = new AtomicLong();
    private final List<SchedulingDelayNotificationListener> _schedulingDelayNotificationListeners = new CopyOnWriteArrayList<SchedulingDelayNotificationListener>();
    private final AtomicBoolean _hasShutdown = new AtomicBoolean();

    public NonBlockingConnection(SocketChannel socketChannel, ProtocolEngine protocolEngine, Set<TransportEncryption> encryptionSet, Runnable onTransportEncryptionAction, NetworkConnectionScheduler scheduler, AmqpPort port) {
        this._socketChannel = socketChannel;
        this.pushScheduler(scheduler);
        this._protocolEngine = protocolEngine;
        this._onTransportEncryptionAction = onTransportEncryptionAction;
        this._remoteSocketAddress = this._socketChannel.socket().getRemoteSocketAddress().toString();
        this._port = port;
        this._threadName = "IO-" + this._remoteSocketAddress.toString();
        this._outboundMessageBufferLimit = this._port.getContextValue(Long.class, "qpid.port.amqp.outboundMessageBufferSize");
        protocolEngine.setWorkListener(new Action<ProtocolEngine>(){

            @Override
            public void performAction(ProtocolEngine object) {
                if (!NonBlockingConnection.this._scheduled.get()) {
                    NonBlockingConnection.this.getScheduler().schedule(NonBlockingConnection.this);
                }
            }
        });
        if (encryptionSet.size() == 1) {
            this.setTransportEncryption(encryptionSet.iterator().next());
        } else {
            this._delegate = new NonBlockingConnectionUndecidedDelegate(this);
        }
    }

    String getThreadName() {
        return this._threadName;
    }

    public boolean isPartialRead() {
        return this._partialRead;
    }

    AggregateTicker getTicker() {
        return this._protocolEngine.getAggregateTicker();
    }

    SocketChannel getSocketChannel() {
        return this._socketChannel;
    }

    public void start() {
    }

    public ByteBufferSender getSender() {
        return this;
    }

    public void close() {
        LOGGER.debug("Closing " + this._remoteSocketAddress);
        if (this._closed.compareAndSet(false, true)) {
            this._protocolEngine.notifyWork();
            this._selectionTask.wakeup();
        }
    }

    public SocketAddress getRemoteAddress() {
        return this._socketChannel.socket().getRemoteSocketAddress();
    }

    public SocketAddress getLocalAddress() {
        return this._socketChannel.socket().getLocalSocketAddress();
    }

    public void setMaxWriteIdleMillis(long millis) {
        this._maxWriteIdleMillis.set(millis);
    }

    public void setMaxReadIdleMillis(long millis) {
        this._maxReadIdleMillis.set(millis);
    }

    public Principal getPeerPrincipal() {
        return this._delegate.getPeerPrincipal();
    }

    public Certificate getPeerCertificate() {
        return this._delegate.getPeerCertificate();
    }

    public long getMaxReadIdleMillis() {
        return this._maxReadIdleMillis.get();
    }

    public long getMaxWriteIdleMillis() {
        return this._maxWriteIdleMillis.get();
    }

    @Override
    public void reserveOutboundMessageSpace(long size) {
        if (this._usedOutboundMessageSpace.addAndGet(size) > this._outboundMessageBufferLimit) {
            this._protocolEngine.setMessageAssignmentSuspended(true, false);
        }
    }

    @Override
    public String getTransportInfo() {
        return this._delegate.getTransportInfo();
    }

    boolean wantsRead() {
        return this._fullyWritten;
    }

    boolean wantsWrite() {
        return !this._fullyWritten;
    }

    public boolean isStateChanged() {
        return this._protocolEngine.hasWork();
    }

    public void doPreWork() {
        if (!this._closed.get()) {
            long currentTime = System.currentTimeMillis();
            long schedulingDelay = currentTime - this.getScheduledTime();
            if (!this._schedulingDelayNotificationListeners.isEmpty()) {
                for (SchedulingDelayNotificationListener listener : this._schedulingDelayNotificationListeners) {
                    listener.notifySchedulingDelay(schedulingDelay);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doWork() {
        boolean closed;
        this._protocolEngine.clearWork();
        if (!this._closed.get()) {
            try {
                long currentTime = System.currentTimeMillis();
                int tick = this.getTicker().getTimeToNextTick(currentTime);
                if (tick <= 0) {
                    this.getTicker().tick(currentTime);
                }
                this._protocolEngine.setIOThread(Thread.currentThread());
                this._protocolEngine.setMessageAssignmentSuspended(true, true);
                boolean processPendingComplete = this.processPending();
                if (processPendingComplete) {
                    this._pendingIterator = null;
                    this._protocolEngine.setTransportBlockedForWriting(false);
                    boolean dataRead = this.doRead();
                    this._protocolEngine.setTransportBlockedForWriting(!this.doWrite());
                    if (!this._fullyWritten || dataRead || this._delegate.needsWork() && this._delegate.getNetInputBuffer().position() != 0) {
                        this._protocolEngine.notifyWork();
                    }
                    if (this._fullyWritten) {
                        this._protocolEngine.setMessageAssignmentSuspended(false, true);
                    }
                } else {
                    this._protocolEngine.notifyWork();
                }
            }
            catch (IOException | ConnectionScopedRuntimeException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Exception performing I/O for connection '{}'", (Object)this._remoteSocketAddress, (Object)e);
                } else {
                    LOGGER.info("Exception performing I/O for connection '{}' : {}", (Object)this._remoteSocketAddress, (Object)e.getMessage());
                }
                if (this._closed.compareAndSet(false, true)) {
                    this._protocolEngine.notifyWork();
                }
            }
            finally {
                this._protocolEngine.setIOThread(null);
            }
        }
        if (closed = this._closed.get()) {
            this.shutdown();
        }
        return closed;
    }

    @Override
    public void addSchedulingDelayNotificationListeners(SchedulingDelayNotificationListener listener) {
        this._schedulingDelayNotificationListeners.add(listener);
    }

    @Override
    public void removeSchedulingDelayNotificationListeners(SchedulingDelayNotificationListener listener) {
        this._schedulingDelayNotificationListeners.remove(listener);
    }

    private boolean processPending() throws IOException {
        boolean complete;
        if (this._pendingIterator == null) {
            this._pendingIterator = this._protocolEngine.processPendingIterator();
        }
        int networkBufferSize = this._port.getNetworkBufferSize();
        while (this._pendingIterator.hasNext()) {
            long size = this.getBufferedSize();
            if (size >= (long)networkBufferSize) {
                this.doWrite();
                long bytesWritten = size - this.getBufferedSize();
                if (bytesWritten >= (long)(networkBufferSize / 2)) continue;
                break;
            }
            Runnable task = this._pendingIterator.next();
            task.run();
        }
        boolean bl = complete = !this._pendingIterator.hasNext();
        if (this.getBufferedSize() >= (long)networkBufferSize) {
            this.doWrite();
            complete &= this.getBufferedSize() < (long)(networkBufferSize / 2);
        }
        return complete;
    }

    private long getBufferedSize() {
        if (this._buffers.isEmpty()) {
            return 0L;
        }
        long totalSize = 0L;
        for (QpidByteBuffer buf : this._buffers) {
            totalSize += (long)buf.remaining();
        }
        return totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        if (this._hasShutdown.getAndSet(true)) {
            return;
        }
        try {
            this.shutdownInput();
            this.shutdownFinalWrite();
            this._protocolEngine.closed();
            this.shutdownOutput();
        }
        finally {
            try {
                try {
                    NetworkConnectionScheduler scheduler = this.getScheduler();
                    if (scheduler != null) {
                        scheduler.removeConnection(this);
                    }
                }
                finally {
                    this._socketChannel.close();
                }
            }
            catch (IOException e) {
                LOGGER.info("Exception closing socket '{}': {}", (Object)this._remoteSocketAddress, (Object)e.getMessage());
            }
            if (SystemUtils.isWindows()) {
                this._delegate.shutdownInput();
                this._delegate.shutdownOutput();
            }
        }
    }

    private void shutdownFinalWrite() {
        try {
            while (!this.doWrite()) {
            }
        }
        catch (IOException e) {
            LOGGER.info("Exception performing final write/close for '{}': {}", (Object)this._remoteSocketAddress, (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownOutput() {
        if (!SystemUtils.isWindows()) {
            try {
                this._socketChannel.shutdownOutput();
            }
            catch (IOException e) {
                LOGGER.info("Exception closing socket '{}': {}", (Object)this._remoteSocketAddress, (Object)e.getMessage());
            }
            finally {
                this._delegate.shutdownOutput();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownInput() {
        if (!SystemUtils.isWindows()) {
            try {
                this._socketChannel.shutdownInput();
            }
            catch (IOException e) {
                LOGGER.info("Exception shutting down input for '{}': {}", (Object)this._remoteSocketAddress, (Object)e.getMessage());
            }
            finally {
                this._delegate.shutdownInput();
            }
        }
    }

    boolean doRead() throws IOException {
        this._partialRead = false;
        if (!this._closed.get() && this._delegate.readyForRead()) {
            int readData = this.readFromNetwork();
            if (readData > 0) {
                return this._delegate.processData();
            }
            return false;
        }
        return false;
    }

    long writeToTransport(Collection<QpidByteBuffer> buffers) throws IOException {
        long written = QpidByteBuffer.write((GatheringByteChannel)this._socketChannel, buffers);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Written " + written + " bytes");
        }
        return written;
    }

    private boolean doWrite() throws IOException {
        QpidByteBuffer buf;
        this._fullyWritten = this._delegate.doWrite(this._buffers);
        while (!this._buffers.isEmpty() && !(buf = this._buffers.peek()).hasRemaining()) {
            this._buffers.poll();
            buf.dispose();
        }
        if (this._fullyWritten) {
            this._usedOutboundMessageSpace.set(0L);
        }
        return this._fullyWritten;
    }

    protected int readFromNetwork() throws IOException {
        QpidByteBuffer buffer = this._delegate.getNetInputBuffer();
        int read = buffer.read((ReadableByteChannel)this._socketChannel);
        if (read == -1) {
            this._closed.set(true);
        }
        boolean bl = this._partialRead = read != 0;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Read " + read + " byte(s)");
        }
        return read;
    }

    public boolean isDirectBufferPreferred() {
        return true;
    }

    public void send(QpidByteBuffer msg) {
        if (this._closed.get()) {
            LOGGER.warn("Send ignored as the connection is already closed");
        } else if (msg.remaining() > 0) {
            this._buffers.add(msg.duplicate());
        }
        msg.position(msg.limit());
    }

    public void flush() {
    }

    public final void pushScheduler(NetworkConnectionScheduler scheduler) {
        this._schedulerDeque.addFirst(scheduler);
    }

    public final NetworkConnectionScheduler popScheduler() {
        return this._schedulerDeque.removeFirst();
    }

    public final NetworkConnectionScheduler getScheduler() {
        return this._schedulerDeque.peekFirst();
    }

    public String toString() {
        return "[NonBlockingConnection " + this._remoteSocketAddress + "]";
    }

    public void processAmqpData(QpidByteBuffer applicationData) {
        this._protocolEngine.received(applicationData);
    }

    public void setTransportEncryption(TransportEncryption transportEncryption) {
        NonBlockingConnectionDelegate oldDelegate = this._delegate;
        switch (transportEncryption) {
            case TLS: {
                this._onTransportEncryptionAction.run();
                this._delegate = new NonBlockingConnectionTLSDelegate(this, this._port);
                break;
            }
            case NONE: {
                this._delegate = new NonBlockingConnectionPlainDelegate(this, this._port);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown TransportEncryption " + transportEncryption);
            }
        }
        if (oldDelegate != null) {
            QpidByteBuffer src = oldDelegate.getNetInputBuffer().duplicate();
            src.flip();
            this._delegate.getNetInputBuffer().put(src);
            src.dispose();
        }
        LOGGER.debug("Identified transport encryption as " + transportEncryption);
    }

    public boolean setScheduled() {
        boolean scheduled = this._scheduled.compareAndSet(false, true);
        if (scheduled) {
            this._scheduledTime = System.currentTimeMillis();
        }
        return scheduled;
    }

    public void clearScheduled() {
        this._scheduled.set(false);
        this._scheduledTime = 0L;
    }

    @Override
    public long getScheduledTime() {
        return this._scheduledTime;
    }

    void reportUnexpectedByteBufferSizeUsage() {
        if (!this._unexpectedByteBufferSizeReported) {
            LOGGER.info("At least one frame unexpectedly does not fit into default byte buffer size ({}B) on a connection {}.", (Object)this._port.getNetworkBufferSize(), (Object)this.toString());
            this._unexpectedByteBufferSizeReported = true;
        }
    }

    public SelectorThread.SelectionTask getSelectionTask() {
        return this._selectionTask;
    }

    public void setSelectionTask(SelectorThread.SelectionTask selectionTask) {
        this._selectionTask = selectionTask;
    }
}

