/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.plugin.ProtocolEngineCreator;
import org.apache.qpid.server.plugin.ProtocolEngineCreatorComparator;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.transport.MultiVersionProtocolEngine;
import org.apache.qpid.server.transport.ProtocolEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiVersionProtocolEngineFactory
implements ProtocolEngineFactory {
    private static final AtomicLong ID_GENERATOR = new AtomicLong(0L);
    private static final Logger _logger = LoggerFactory.getLogger(MultiVersionProtocolEngineFactory.class);
    private final Broker<?> _broker;
    private final Set<Protocol> _supported;
    private final Protocol _defaultSupportedReply;
    private final AmqpPort<?> _port;
    private final Transport _transport;
    private final ProtocolEngineCreator[] _creators;
    private final ConnectionCountDecrementingTask _connectionCountDecrementingTask = new ConnectionCountDecrementingTask();

    public MultiVersionProtocolEngineFactory(Broker<?> broker, Set<Protocol> supportedVersions, Protocol defaultSupportedReply, AmqpPort<?> port, Transport transport) {
        if (defaultSupportedReply != null && !supportedVersions.contains((Object)defaultSupportedReply)) {
            _logger.warn("The configured default reply ({}) to an unsupported protocol version initiation is not supported on this port.  Only the following versions are supported: {}", (Object)defaultSupportedReply, supportedVersions);
            defaultSupportedReply = null;
        }
        this._broker = broker;
        this._supported = supportedVersions;
        this._defaultSupportedReply = defaultSupportedReply;
        ArrayList<ProtocolEngineCreator> creators = new ArrayList<ProtocolEngineCreator>();
        for (ProtocolEngineCreator c : new QpidServiceLoader().instancesOf(ProtocolEngineCreator.class)) {
            creators.add(c);
        }
        Collections.sort(creators, new ProtocolEngineCreatorComparator());
        this._creators = creators.toArray(new ProtocolEngineCreator[creators.size()]);
        this._port = port;
        this._transport = transport;
    }

    @Override
    public MultiVersionProtocolEngine newProtocolEngine(SocketAddress remoteSocketAddress) {
        if (this._port.canAcceptNewConnection(remoteSocketAddress)) {
            this._port.incrementConnectionCount();
            return new MultiVersionProtocolEngine(this._broker, this._supported, this._defaultSupportedReply, this._port, this._transport, ID_GENERATOR.getAndIncrement(), this._creators, this._connectionCountDecrementingTask);
        }
        return null;
    }

    private class ConnectionCountDecrementingTask
    implements Runnable {
        private ConnectionCountDecrementingTask() {
        }

        @Override
        public void run() {
            MultiVersionProtocolEngineFactory.this._port.decrementConnectionCount();
        }
    }
}

