/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.logging.messages.ConnectionMessages;
import org.apache.qpid.server.logging.messages.PortMessages;
import org.apache.qpid.server.logging.subjects.PortLogSubject;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.plugin.ProtocolEngineCreator;
import org.apache.qpid.server.security.ManagedPeerCertificateTrustStore;
import org.apache.qpid.server.transport.AbstractAMQPConnection;
import org.apache.qpid.server.transport.AggregateTicker;
import org.apache.qpid.server.transport.ProtocolEngine;
import org.apache.qpid.server.transport.SchedulingDelayNotificationListener;
import org.apache.qpid.server.transport.ServerNetworkConnection;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.transport.ByteBufferSender;
import org.apache.qpid.transport.network.Ticker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiVersionProtocolEngine
implements ProtocolEngine {
    private static final Logger _logger = LoggerFactory.getLogger(MultiVersionProtocolEngine.class);
    private static final int MINIMUM_REQUIRED_HEADER_BYTES = 8;
    private final long _id;
    private final AmqpPort<?> _port;
    private Transport _transport;
    private final ProtocolEngineCreator[] _creators;
    private final Runnable _onCloseTask;
    private Set<Protocol> _supported;
    private String _fqdn;
    private final Broker<?> _broker;
    private ServerNetworkConnection _network;
    private ByteBufferSender _sender;
    private final Protocol _defaultSupportedReply;
    private volatile ProtocolEngine _delegate = new SelfDelegateProtocolEngine();
    private volatile Thread _ioThread;
    private final AtomicReference<Action<ProtocolEngine>> _workListener = new AtomicReference();
    private final AggregateTicker _aggregateTicker = new AggregateTicker();

    public MultiVersionProtocolEngine(Broker<?> broker, Set<Protocol> supported, Protocol defaultSupportedReply, AmqpPort<?> port, Transport transport, long id, ProtocolEngineCreator[] creators, Runnable onCloseTask) {
        this._id = id;
        this._broker = broker;
        this._supported = supported;
        this._defaultSupportedReply = defaultSupportedReply;
        this._port = port;
        this._transport = transport;
        this._creators = creators;
        this._onCloseTask = onCloseTask;
    }

    @Override
    public void setMessageAssignmentSuspended(boolean value, boolean notifyConsumers) {
        this._delegate.setMessageAssignmentSuspended(value, notifyConsumers);
    }

    @Override
    public boolean isMessageAssignmentSuspended() {
        return this._delegate.isMessageAssignmentSuspended();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closed() {
        _logger.debug("Closed");
        try {
            this._delegate.closed();
        }
        finally {
            if (this._onCloseTask != null) {
                this._onCloseTask.run();
            }
        }
    }

    @Override
    public void writerIdle() {
        this._delegate.writerIdle();
    }

    @Override
    public void readerIdle() {
        this._delegate.readerIdle();
    }

    @Override
    public void encryptedTransport() {
        this._delegate.encryptedTransport();
    }

    @Override
    public void received(QpidByteBuffer msg) {
        this._delegate.received(msg);
    }

    @Override
    public void setIOThread(Thread ioThread) {
        this._ioThread = ioThread;
        this._delegate.setIOThread(ioThread);
    }

    public long getConnectionId() {
        return this._id;
    }

    @Override
    public Subject getSubject() {
        return this._delegate.getSubject();
    }

    @Override
    public boolean isTransportBlockedForWriting() {
        return this._delegate.isTransportBlockedForWriting();
    }

    @Override
    public void setTransportBlockedForWriting(boolean blocked) {
        this._delegate.setTransportBlockedForWriting(blocked);
    }

    public void setNetworkConnection(ServerNetworkConnection network) {
        this._network = network;
        SocketAddress address = this._network.getLocalAddress();
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported socket address class: " + address);
        }
        this._fqdn = ((InetSocketAddress)address).getHostName();
        this._sender = network.getSender();
        SlowProtocolHeaderTicker ticker = new SlowProtocolHeaderTicker(this._port.getProtocolHandshakeTimeout(), System.currentTimeMillis());
        this._aggregateTicker.addTicker(ticker);
        this._network.addSchedulingDelayNotificationListeners(this._aggregateTicker);
    }

    public long getLastReadTime() {
        return this._delegate.getLastReadTime();
    }

    public long getLastWriteTime() {
        return this._delegate.getLastWriteTime();
    }

    @Override
    public Iterator<Runnable> processPendingIterator() {
        return this._delegate.processPendingIterator();
    }

    @Override
    public boolean hasWork() {
        return this._delegate.hasWork();
    }

    @Override
    public void notifyWork() {
        this._delegate.notifyWork();
    }

    @Override
    public void setWorkListener(Action<ProtocolEngine> listener) {
        this._workListener.set(listener);
        this._delegate.setWorkListener(listener);
    }

    @Override
    public void clearWork() {
        this._delegate.clearWork();
    }

    @Override
    public AggregateTicker getAggregateTicker() {
        return this._aggregateTicker;
    }

    public boolean isProtocolEstablished() {
        return this._delegate instanceof AbstractAMQPConnection;
    }

    class SlowProtocolHeaderTicker
    implements Ticker,
    SchedulingDelayNotificationListener {
        private final long _allowedTime;
        private final long _createdTime;
        private volatile long _accumulatedSchedulingDelay;

        public SlowProtocolHeaderTicker(long allowedTime, long createdTime) {
            this._allowedTime = allowedTime;
            this._createdTime = createdTime;
        }

        public int getTimeToNextTick(long currentTime) {
            return (int)(this._createdTime + this._allowedTime + this._accumulatedSchedulingDelay - currentTime);
        }

        public int tick(long currentTime) {
            int nextTick = this.getTimeToNextTick(currentTime);
            if (nextTick <= 0) {
                if (MultiVersionProtocolEngine.this.isProtocolEstablished()) {
                    MultiVersionProtocolEngine.this._aggregateTicker.removeTicker(this);
                    MultiVersionProtocolEngine.this._network.removeSchedulingDelayNotificationListeners(this);
                } else {
                    _logger.warn("Connection has taken more than {} ms to send complete protocol header.  Closing as possible DoS.", (Object)this._allowedTime);
                    MultiVersionProtocolEngine.this._broker.getEventLogger().message(ConnectionMessages.IDLE_CLOSE("Protocol header not received within timeout period", true));
                    MultiVersionProtocolEngine.this._network.close();
                }
            }
            return nextTick;
        }

        @Override
        public void notifySchedulingDelay(long schedulingDelay) {
            if (schedulingDelay > 0L) {
                this._accumulatedSchedulingDelay += schedulingDelay;
            }
        }
    }

    private class SelfDelegateProtocolEngine
    implements ProtocolEngine {
        private final QpidByteBuffer _header = QpidByteBuffer.allocate((int)8);
        private long _lastReadTime = System.currentTimeMillis();
        private final AtomicBoolean _hasWork = new AtomicBoolean();

        private SelfDelegateProtocolEngine() {
        }

        @Override
        public void setMessageAssignmentSuspended(boolean value, boolean notifyConsumers) {
        }

        @Override
        public boolean isMessageAssignmentSuspended() {
            return false;
        }

        @Override
        public Iterator<Runnable> processPendingIterator() {
            return Collections.emptyIterator();
        }

        @Override
        public boolean hasWork() {
            return this._hasWork.get();
        }

        @Override
        public void notifyWork() {
            this._hasWork.set(true);
        }

        @Override
        public void setWorkListener(Action<ProtocolEngine> listener) {
        }

        @Override
        public AggregateTicker getAggregateTicker() {
            return MultiVersionProtocolEngine.this._aggregateTicker;
        }

        @Override
        public void clearWork() {
            this._hasWork.set(false);
        }

        @Override
        public void received(QpidByteBuffer msg) {
            this._lastReadTime = System.currentTimeMillis();
            QpidByteBuffer msgheader = msg.slice();
            if (this._header.remaining() > msgheader.limit()) {
                msgheader.dispose();
                return;
            }
            msgheader.limit(this._header.remaining());
            msg.position(msg.position() + this._header.remaining());
            this._header.put(msgheader);
            msgheader.dispose();
            if (!this._header.hasRemaining()) {
                this._header.flip();
                byte[] headerBytes = new byte[8];
                this._header.get(headerBytes);
                ProtocolEngine newDelegate = null;
                byte[] supportedReplyBytes = null;
                byte[] defaultSupportedReplyBytes = null;
                Enum supportedReplyVersion = null;
                for (int i = 0; newDelegate == null && i < MultiVersionProtocolEngine.this._creators.length; ++i) {
                    ProtocolEngineCreator creator = MultiVersionProtocolEngine.this._creators[i];
                    if (MultiVersionProtocolEngine.this._supported.contains((Object)creator.getVersion())) {
                        supportedReplyBytes = creator.getHeaderIdentifier();
                        supportedReplyVersion = creator.getVersion();
                        byte[] compareBytes = creator.getHeaderIdentifier();
                        boolean equal = true;
                        for (int j = 0; equal && j < compareBytes.length; ++j) {
                            equal = headerBytes[j] == compareBytes[j];
                        }
                        if (equal && (newDelegate = creator.newProtocolEngine(MultiVersionProtocolEngine.this._broker, MultiVersionProtocolEngine.this._network, MultiVersionProtocolEngine.this._port, MultiVersionProtocolEngine.this._transport, MultiVersionProtocolEngine.this._id, MultiVersionProtocolEngine.this._aggregateTicker)) == null && creator.getSuggestedAlternativeHeader() != null) {
                            defaultSupportedReplyBytes = creator.getSuggestedAlternativeHeader();
                        }
                    }
                    if (defaultSupportedReplyBytes != null || MultiVersionProtocolEngine.this._defaultSupportedReply == null || creator.getVersion() != MultiVersionProtocolEngine.this._defaultSupportedReply) continue;
                    defaultSupportedReplyBytes = creator.getHeaderIdentifier();
                }
                if (newDelegate == null) {
                    if (MultiVersionProtocolEngine.this._defaultSupportedReply != null && MultiVersionProtocolEngine.this._defaultSupportedReply != supportedReplyVersion) {
                        _logger.debug("Default reply to unsupported protocol version was configured, changing reply from {} to {}", supportedReplyVersion, (Object)MultiVersionProtocolEngine.this._defaultSupportedReply);
                        supportedReplyBytes = defaultSupportedReplyBytes;
                        supportedReplyVersion = MultiVersionProtocolEngine.this._defaultSupportedReply;
                    }
                    MultiVersionProtocolEngine.this._broker.getEventLogger().message(new PortLogSubject(MultiVersionProtocolEngine.this._port), PortMessages.UNSUPPORTED_PROTOCOL_HEADER(supportedReplyVersion.toString()));
                    QpidByteBuffer supportedReplyBuf = QpidByteBuffer.allocateDirect((int)supportedReplyBytes.length);
                    supportedReplyBuf.put(supportedReplyBytes);
                    supportedReplyBuf.flip();
                    MultiVersionProtocolEngine.this._sender.send(supportedReplyBuf);
                    MultiVersionProtocolEngine.this._sender.flush();
                    MultiVersionProtocolEngine.this._delegate = new ClosedDelegateProtocolEngine();
                    MultiVersionProtocolEngine.this._network.close();
                } else {
                    boolean hasWork = MultiVersionProtocolEngine.this._delegate.hasWork();
                    if (hasWork) {
                        newDelegate.notifyWork();
                    }
                    MultiVersionProtocolEngine.this._delegate = newDelegate;
                    MultiVersionProtocolEngine.this._delegate.setIOThread(MultiVersionProtocolEngine.this._ioThread);
                    MultiVersionProtocolEngine.this._delegate.setWorkListener((Action)MultiVersionProtocolEngine.this._workListener.get());
                    this._header.flip();
                    MultiVersionProtocolEngine.this._delegate.received(this._header);
                    Certificate peerCertificate = MultiVersionProtocolEngine.this._network.getPeerCertificate();
                    if (peerCertificate != null && MultiVersionProtocolEngine.this._port.getClientCertRecorder() != null) {
                        ((ManagedPeerCertificateTrustStore)MultiVersionProtocolEngine.this._port.getClientCertRecorder()).addCertificate(peerCertificate);
                    }
                    if (msg.hasRemaining()) {
                        MultiVersionProtocolEngine.this._delegate.received(msg);
                    }
                }
            }
        }

        @Override
        public void setIOThread(Thread ioThread) {
        }

        @Override
        public Subject getSubject() {
            return MultiVersionProtocolEngine.this._delegate.getSubject();
        }

        @Override
        public boolean isTransportBlockedForWriting() {
            return false;
        }

        @Override
        public void setTransportBlockedForWriting(boolean blocked) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void closed() {
            try {
                MultiVersionProtocolEngine.this._delegate = new ClosedDelegateProtocolEngine();
                _logger.debug("Connection from {} was closed before any protocol version was established.", (Object)MultiVersionProtocolEngine.this._network.getRemoteAddress());
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    MultiVersionProtocolEngine.this._network.close();
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public void writerIdle() {
        }

        @Override
        public void readerIdle() {
        }

        @Override
        public void encryptedTransport() {
            if (MultiVersionProtocolEngine.this._transport == Transport.TCP) {
                MultiVersionProtocolEngine.this._transport = Transport.SSL;
            }
        }

        public long getLastReadTime() {
            return this._lastReadTime;
        }

        public long getLastWriteTime() {
            return 0L;
        }
    }

    private class ClosedDelegateProtocolEngine
    implements ProtocolEngine {
        private ClosedDelegateProtocolEngine() {
        }

        @Override
        public void setMessageAssignmentSuspended(boolean value, boolean notifyConsumers) {
        }

        @Override
        public boolean isMessageAssignmentSuspended() {
            return false;
        }

        @Override
        public Iterator<Runnable> processPendingIterator() {
            return Collections.emptyIterator();
        }

        @Override
        public boolean hasWork() {
            return false;
        }

        @Override
        public void notifyWork() {
        }

        @Override
        public void setWorkListener(Action<ProtocolEngine> listener) {
        }

        @Override
        public void clearWork() {
        }

        @Override
        public void received(QpidByteBuffer msg) {
            _logger.debug("Error processing incoming data, could not negotiate a common protocol");
            msg.position(msg.limit());
        }

        @Override
        public void setIOThread(Thread ioThread) {
        }

        @Override
        public void closed() {
        }

        @Override
        public void writerIdle() {
        }

        @Override
        public void readerIdle() {
        }

        @Override
        public void encryptedTransport() {
        }

        public long getLastReadTime() {
            return 0L;
        }

        public long getLastWriteTime() {
            return 0L;
        }

        @Override
        public Subject getSubject() {
            return new Subject();
        }

        @Override
        public boolean isTransportBlockedForWriting() {
            return false;
        }

        @Override
        public void setTransportBlockedForWriting(boolean blocked) {
        }

        @Override
        public AggregateTicker getAggregateTicker() {
            return MultiVersionProtocolEngine.this._aggregateTicker;
        }
    }
}

