/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import javax.security.auth.SubjectDomainCombiner;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.connection.ConnectionPrincipal;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.messages.ConnectionMessages;
import org.apache.qpid.server.logging.subjects.ConnectionLogSubject;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ContextProvider;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Session;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.TaskExecutorProvider;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.adapter.SessionAdapter;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.stats.StatisticsCounter;
import org.apache.qpid.server.stats.StatisticsGatherer;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.transport.AggregateTicker;
import org.apache.qpid.server.transport.NetworkConnectionScheduler;
import org.apache.qpid.server.transport.NonBlockingConnection;
import org.apache.qpid.server.transport.ProtocolEngine;
import org.apache.qpid.server.transport.SchedulingDelayNotificationListener;
import org.apache.qpid.server.transport.ServerIdleReadTimeoutTicker;
import org.apache.qpid.server.transport.ServerIdleWriteTimeoutTicker;
import org.apache.qpid.server.transport.ServerNetworkConnection;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.FixedKeyMapCreator;
import org.apache.qpid.transport.network.NetworkConnection;
import org.apache.qpid.transport.network.Ticker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAMQPConnection<C extends AbstractAMQPConnection<C>>
extends AbstractConfiguredObject<C>
implements ProtocolEngine,
AMQPConnection<C>,
EventLoggerProvider {
    public static final FixedKeyMapCreator PUBLISH_ACTION_MAP_CREATOR = new FixedKeyMapCreator("routingKey", "immediate");
    private static final Logger _logger = LoggerFactory.getLogger(AbstractAMQPConnection.class);
    private final Broker<?> _broker;
    private final ServerNetworkConnection _network;
    private final AmqpPort<?> _port;
    private final Transport _transport;
    private final Protocol _protocol;
    private final long _connectionId;
    private final AggregateTicker _aggregateTicker;
    private final Subject _subject = new Subject();
    private final List<Action<? super C>> _connectionCloseTaskList = new CopyOnWriteArrayList<Action<? super C>>();
    private final LogSubject _logSubject;
    private final AtomicReference<Thread> _messageAssignmentAllowedThread = new AtomicReference();
    private final AtomicBoolean _messageAssignmentSuspended = new AtomicBoolean();
    private volatile ContextProvider _contextProvider;
    private volatile EventLoggerProvider _eventLoggerProvider;
    private String _clientProduct;
    private String _clientVersion;
    private String _remoteProcessPid;
    private String _clientId;
    private volatile boolean _stopped;
    private final StatisticsCounter _messagesDelivered;
    private final StatisticsCounter _dataDelivered;
    private final StatisticsCounter _messagesReceived;
    private final StatisticsCounter _dataReceived;
    private final SettableFuture<Void> _transportClosedFuture = SettableFuture.create();
    private final SettableFuture<Void> _modelClosedFuture = SettableFuture.create();
    private final AtomicBoolean _modelClosing = new AtomicBoolean();
    private volatile NamedAddressSpace _addressSpace;
    private volatile long _lastReadTime;
    private volatile long _lastWriteTime;
    private volatile AccessControlContext _accessControllerContext;
    private volatile Thread _ioThread;
    private volatile StatisticsGatherer _statisticsGatherer;
    private volatile boolean _messageAuthorizationRequired;
    private final AtomicLong _maxMessageSize = new AtomicLong(Long.MAX_VALUE);
    private volatile int _messageCompressionThreshold;

    public AbstractAMQPConnection(Broker<?> broker, ServerNetworkConnection network, AmqpPort<?> port, Transport transport, Protocol protocol, long connectionId, AggregateTicker aggregateTicker) {
        super(AbstractAMQPConnection.parentsMap(port), AbstractAMQPConnection.createAttributes(connectionId, network));
        this._broker = broker;
        this._eventLoggerProvider = broker;
        this._contextProvider = broker;
        this._statisticsGatherer = broker;
        this._network = network;
        this._port = port;
        this._transport = transport;
        this._protocol = protocol;
        this._connectionId = connectionId;
        this._aggregateTicker = aggregateTicker;
        this._subject.getPrincipals().add(new ConnectionPrincipal(this));
        this.updateAccessControllerContext();
        this._messagesDelivered = new StatisticsCounter("messages-delivered-" + this.getConnectionId());
        this._dataDelivered = new StatisticsCounter("data-delivered-" + this.getConnectionId());
        this._messagesReceived = new StatisticsCounter("messages-received-" + this.getConnectionId());
        this._dataReceived = new StatisticsCounter("data-received-" + this.getConnectionId());
        this._transportClosedFuture.addListener(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AbstractAMQPConnection.this.deleted();
                    AbstractAMQPConnection.this.setState(State.DELETED);
                    AbstractAMQPConnection.this.logConnectionClose();
                }
                finally {
                    AbstractAMQPConnection.this._modelClosedFuture.set(null);
                }
            }
        }, (Executor)this.getTaskExecutor());
        this.setState(State.ACTIVE);
        this._logSubject = new ConnectionLogSubject(this);
    }

    private static Map<String, Object> createAttributes(long connectionId, NetworkConnection network) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", "[" + connectionId + "] " + String.valueOf(network.getRemoteAddress()).replaceAll("/", ""));
        attributes.put("durable", false);
        return attributes;
    }

    @Override
    public final AccessControlContext getAccessControlContextFromSubject(final Subject subject) {
        final AccessControlContext acc = AccessController.getContext();
        return AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

            @Override
            public AccessControlContext run() {
                if (subject == null) {
                    return new AccessControlContext(acc, null);
                }
                return new AccessControlContext(acc, new SubjectDomainCombiner(subject));
            }
        });
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        long maxAuthDelay = this._port.getContextValue(Long.class, "connection.maximumAuthenticationDelay");
        SlowConnectionOpenTicker slowConnectionOpenTicker = new SlowConnectionOpenTicker(maxAuthDelay);
        this._aggregateTicker.addTicker(slowConnectionOpenTicker);
        this._lastReadTime = this._lastWriteTime = this.getCreatedTime().getTime();
        this.logConnectionOpen();
    }

    public Broker<?> getBroker() {
        return this._broker;
    }

    public final ServerNetworkConnection getNetwork() {
        return this._network;
    }

    @Override
    public final AmqpPort<?> getPort() {
        return this._port;
    }

    @Override
    public final Transport getTransport() {
        return this._transport;
    }

    @Override
    public String getTransportInfo() {
        return this._network.getTransportInfo();
    }

    @Override
    public Protocol getProtocol() {
        return this._protocol;
    }

    @Override
    public final AggregateTicker getAggregateTicker() {
        return this._aggregateTicker;
    }

    @Override
    public final Date getLastIoTime() {
        return new Date(Math.max(this.getLastReadTime(), this.getLastWriteTime()));
    }

    public final long getLastReadTime() {
        return this._lastReadTime;
    }

    public final void updateLastReadTime() {
        this._lastReadTime = System.currentTimeMillis();
    }

    public final long getLastWriteTime() {
        return this._lastWriteTime;
    }

    public final void updateLastWriteTime() {
        this._lastWriteTime = System.currentTimeMillis();
    }

    @Override
    public final long getConnectionId() {
        return this._connectionId;
    }

    private StatisticsCounter getMessageDeliveryStatistics() {
        return this._messagesDelivered;
    }

    @Override
    public String getRemoteAddressString() {
        return String.valueOf(this._network.getRemoteAddress());
    }

    @Override
    public final void stopConnection() {
        this._stopped = true;
    }

    @Override
    public boolean isConnectionStopped() {
        return this._stopped;
    }

    @Override
    public final String getAddressSpaceName() {
        return this.getAddressSpace() == null ? null : this.getAddressSpace().getName();
    }

    @Override
    public String getClientVersion() {
        return this._clientVersion;
    }

    @Override
    public String getRemoteProcessPid() {
        return this._remoteProcessPid;
    }

    @Override
    public void pushScheduler(NetworkConnectionScheduler networkConnectionScheduler) {
        if (this._network instanceof NonBlockingConnection) {
            ((NonBlockingConnection)this._network).pushScheduler(networkConnectionScheduler);
        }
    }

    @Override
    public NetworkConnectionScheduler popScheduler() {
        if (this._network instanceof NonBlockingConnection) {
            return ((NonBlockingConnection)this._network).popScheduler();
        }
        return null;
    }

    @Override
    public String getClientProduct() {
        return this._clientProduct;
    }

    protected void updateMaxMessageSize() {
        this._maxMessageSize.set(Math.min(this.getMaxMessageSize(this.getPort()), this.getMaxMessageSize(this._contextProvider)));
    }

    private long getMaxMessageSize(ContextProvider object) {
        long maxMessageSize;
        try {
            maxMessageSize = object.getContextValue(Integer.class, "qpid.max_message_size").intValue();
        }
        catch (IllegalArgumentException | NullPointerException e) {
            _logger.warn("Context variable {} has invalid value and cannot be used to restrict maximum message size", (Object)"qpid.max_message_size", (Object)e);
            maxMessageSize = Long.MAX_VALUE;
        }
        return maxMessageSize > 0L ? maxMessageSize : Long.MAX_VALUE;
    }

    public long getMaxMessageSize() {
        return this._maxMessageSize.get();
    }

    @Override
    public void addDeleteTask(Action<? super C> task) {
        this._connectionCloseTaskList.add(task);
    }

    @Override
    public void removeDeleteTask(Action<? super C> task) {
        this._connectionCloseTaskList.remove(task);
    }

    public void performDeleteTasks() {
        if (this.runningAsSubject()) {
            for (Action<C> task : this._connectionCloseTaskList) {
                task.performAction(this);
            }
        } else {
            this.runAsSubject(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    AbstractAMQPConnection.this.performDeleteTasks();
                    return null;
                }
            });
        }
    }

    @Override
    public String getClientId() {
        return this._clientId;
    }

    private StatisticsCounter getDataReceiptStatistics() {
        return this._dataReceived;
    }

    private StatisticsCounter getDataDeliveryStatistics() {
        return this._dataDelivered;
    }

    @Override
    public final SocketAddress getRemoteSocketAddress() {
        return this._network.getRemoteAddress();
    }

    @Override
    public void registerMessageDelivered(long messageSize) {
        this._messagesDelivered.registerEvent(1L);
        this._dataDelivered.registerEvent(messageSize);
        this._statisticsGatherer.registerMessageDelivered(messageSize);
    }

    @Override
    public void registerMessageReceived(long messageSize, long timestamp) {
        this._messagesReceived.registerEvent(1L, timestamp);
        this._dataReceived.registerEvent(messageSize, timestamp);
        this._statisticsGatherer.registerMessageReceived(messageSize, timestamp);
    }

    @Override
    public final void resetStatistics() {
        this._messagesDelivered.reset();
        this._dataDelivered.reset();
        this._messagesReceived.reset();
        this._dataReceived.reset();
    }

    private StatisticsCounter getMessageReceiptStatistics() {
        return this._messagesReceived;
    }

    public void setClientProduct(String clientProduct) {
        this._clientProduct = clientProduct;
    }

    public void setClientVersion(String clientVersion) {
        this._clientVersion = clientVersion;
    }

    public void setRemoteProcessPid(String remoteProcessPid) {
        this._remoteProcessPid = remoteProcessPid;
    }

    public void setClientId(String clientId) {
        this._clientId = clientId;
    }

    @Override
    public boolean isMessageAssignmentSuspended() {
        Thread currentThread = Thread.currentThread();
        if (this._messageAssignmentAllowedThread.get() == currentThread && currentThread == this._ioThread) {
            return false;
        }
        return this._messageAssignmentSuspended.get();
    }

    @Override
    public void setMessageAssignmentSuspended(boolean messageAssignmentSuspended, boolean notifyConsumers) {
        this._messageAssignmentSuspended.set(messageAssignmentSuspended);
        if (notifyConsumers) {
            for (AMQSessionModel session : this.getSessionModels()) {
                if (messageAssignmentSuspended) {
                    session.ensureConsumersNoticedStateChange();
                    continue;
                }
                session.notifyConsumerTargetCurrentStates();
            }
        }
    }

    @Override
    public void alwaysAllowMessageAssignmentInThisThreadIfItIsIOThread(boolean allowed) {
        if (allowed) {
            this._messageAssignmentAllowedThread.set(Thread.currentThread());
        } else {
            this._messageAssignmentAllowedThread.set(null);
        }
    }

    @Override
    public void setIOThread(Thread ioThread) {
        this._ioThread = ioThread;
    }

    @Override
    public boolean isIOThread() {
        return Thread.currentThread() == this._ioThread;
    }

    protected <T> T runAsSubject(PrivilegedAction<T> action) {
        return Subject.doAs(this._subject, action);
    }

    private boolean runningAsSubject() {
        return this._subject.equals(Subject.getSubject(AccessController.getContext()));
    }

    @Override
    public Subject getSubject() {
        return this._subject;
    }

    public void sessionAdded(AMQSessionModel<?> session) {
        SessionAdapter adapter = new SessionAdapter(this, session);
        adapter.create();
        this.childAdded(adapter);
    }

    public void sessionRemoved(AMQSessionModel<?> session) {
    }

    @Override
    public TaskExecutor getChildExecutor() {
        NamedAddressSpace addressSpace = this.getAddressSpace();
        if (addressSpace instanceof TaskExecutorProvider) {
            return ((TaskExecutorProvider)((Object)addressSpace)).getTaskExecutor();
        }
        return super.getChildExecutor();
    }

    @Override
    public boolean isIncoming() {
        return true;
    }

    @Override
    public String getLocalAddress() {
        return null;
    }

    @Override
    public String getPrincipal() {
        Principal authorizedPrincipal = this.getAuthorizedPrincipal();
        return authorizedPrincipal == null ? null : authorizedPrincipal.getName();
    }

    @Override
    public String getRemoteAddress() {
        return this.getRemoteAddressString();
    }

    @Override
    public String getRemoteProcessName() {
        return null;
    }

    @Override
    public Collection<Session> getSessions() {
        return this.getChildren(Session.class);
    }

    @StateTransition(currentState={State.ACTIVE}, desiredState=State.DELETED)
    private ListenableFuture<Void> doDelete() {
        this.getEventLogger().message(this._logSubject, ConnectionMessages.MODEL_DELETE());
        return this.closeAsyncIfNotAlreadyClosing();
    }

    @Override
    protected ListenableFuture<Void> beforeClose() {
        return this.closeAsyncIfNotAlreadyClosing();
    }

    private ListenableFuture<Void> closeAsyncIfNotAlreadyClosing() {
        if (this._modelClosing.compareAndSet(false, true)) {
            this.sendConnectionCloseAsync(AMQConstant.CONNECTION_FORCED, "Connection closed by external action");
        }
        return this._modelClosedFuture;
    }

    @Override
    public <C extends ConfiguredObject> ListenableFuture<C> addChildAsync(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        if (childClass == Session.class) {
            throw new IllegalStateException();
        }
        throw new IllegalArgumentException("Cannot create a child of class " + childClass.getSimpleName());
    }

    @Override
    public long getBytesIn() {
        return this.getDataReceiptStatistics().getTotal();
    }

    @Override
    public long getBytesOut() {
        return this.getDataDeliveryStatistics().getTotal();
    }

    @Override
    public long getMessagesIn() {
        return this.getMessageReceiptStatistics().getTotal();
    }

    @Override
    public long getMessagesOut() {
        return this.getMessageDeliveryStatistics().getTotal();
    }

    public AccessControlContext getAccessControllerContext() {
        return this._accessControllerContext;
    }

    public final void updateAccessControllerContext() {
        this._accessControllerContext = this.getAccessControlContextFromSubject(this.getSubject());
    }

    private void logConnectionOpen() {
        this.runAsSubject(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                String localAddressStr;
                SocketAddress localAddress = AbstractAMQPConnection.this._network.getLocalAddress();
                if (localAddress instanceof InetSocketAddress) {
                    InetSocketAddress inetAddress = (InetSocketAddress)localAddress;
                    localAddressStr = inetAddress.getAddress().getHostAddress() + ":" + inetAddress.getPort();
                } else {
                    localAddressStr = localAddress.toString();
                }
                AbstractAMQPConnection.this.getEventLogger().message(ConnectionMessages.OPEN(AbstractAMQPConnection.this.getPort().getName(), localAddressStr, AbstractAMQPConnection.this.getProtocol().getProtocolVersion(), AbstractAMQPConnection.this.getClientId(), AbstractAMQPConnection.this.getClientVersion(), AbstractAMQPConnection.this.getClientProduct(), AbstractAMQPConnection.this.getTransport().isSecure(), AbstractAMQPConnection.this.getClientId() != null, AbstractAMQPConnection.this.getClientVersion() != null, AbstractAMQPConnection.this.getClientProduct() != null));
                return null;
            }
        });
    }

    private void logConnectionClose() {
        this.runAsSubject(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                AbstractAMQPConnection.this.getEventLogger().message(AbstractAMQPConnection.this.isOrderlyClose() ? ConnectionMessages.CLOSE() : ConnectionMessages.DROPPED_CONNECTION());
                return null;
            }
        });
    }

    protected void initialiseHeartbeating(long writerDelay, long readerDelay) {
        if (writerDelay > 0L) {
            this._aggregateTicker.addTicker(new ServerIdleWriteTimeoutTicker(this, (int)writerDelay));
            this._network.setMaxWriteIdleMillis(writerDelay);
        }
        if (readerDelay > 0L) {
            this._aggregateTicker.addTicker(new ServerIdleReadTimeoutTicker(this._network, this, (int)readerDelay));
            this._network.setMaxReadIdleMillis(readerDelay);
        }
    }

    protected abstract boolean isOrderlyClose();

    @Override
    public int getSessionCount() {
        return this.getSessionModels().size();
    }

    @Override
    public void reserveOutboundMessageSpace(long size) {
        this._network.reserveOutboundMessageSpace(size);
    }

    protected void markTransportClosed() {
        this._transportClosedFuture.set(null);
    }

    public LogSubject getLogSubject() {
        return this._logSubject;
    }

    @Override
    public EventLogger getEventLogger() {
        return this._eventLoggerProvider.getEventLogger();
    }

    @Override
    public final void checkAuthorizedMessagePrincipal(String userId) {
        if (userId != null && !"".equals(userId.trim()) && this._messageAuthorizationRequired && !this.getAuthorizedPrincipal().getName().equals(userId)) {
            throw new AccessControlException("The user id of the message '" + userId + "' is not valid on a connection authenticated as  " + this.getAuthorizedPrincipal().getName());
        }
    }

    @Override
    public NamedAddressSpace getAddressSpace() {
        return this._addressSpace;
    }

    public ContextProvider getContextProvider() {
        return this._contextProvider;
    }

    public void setAddressSpace(NamedAddressSpace addressSpace) {
        addressSpace.registerConnection(this);
        this._addressSpace = addressSpace;
        if (addressSpace instanceof EventLoggerProvider) {
            this._eventLoggerProvider = (EventLoggerProvider)((Object)addressSpace);
        }
        if (addressSpace instanceof ContextProvider) {
            this._contextProvider = (ContextProvider)((Object)addressSpace);
        }
        if (addressSpace instanceof StatisticsGatherer) {
            this._statisticsGatherer = (StatisticsGatherer)((Object)addressSpace);
        }
        this.updateMaxMessageSize();
        this._messageAuthorizationRequired = this._contextProvider.getContextValue(Boolean.class, "qpid.broker_msg_auth");
        this._messageCompressionThreshold = this._contextProvider.getContextValue(Integer.class, "connection.messageCompressionThresholdSize");
        if (this._messageCompressionThreshold <= 0) {
            this._messageCompressionThreshold = Integer.MAX_VALUE;
        }
        this.getSubject().getPrincipals().add(addressSpace.getPrincipal());
        this.updateAccessControllerContext();
        this.logConnectionOpen();
    }

    public int getMessageCompressionThreshold() {
        return this._messageCompressionThreshold;
    }

    @Override
    public String toString() {
        return this.getNetwork().getRemoteAddress() + "(" + (this.getAuthorizedPrincipal() == null ? "?" : this.getAuthorizedPrincipal().getName()) + ")";
    }

    @Override
    public Principal getAuthorizedPrincipal() {
        return AuthenticatedPrincipal.getOptionalAuthenticatedPrincipalFromSubject(this.getSubject());
    }

    public void setSubject(Subject subject) {
        if (subject == null) {
            throw new IllegalArgumentException("subject cannot be null");
        }
        this.getSubject().getPrincipals().addAll(subject.getPrincipals());
        this.getSubject().getPrivateCredentials().addAll(subject.getPrivateCredentials());
        this.getSubject().getPublicCredentials().addAll(subject.getPublicCredentials());
        this.updateAccessControllerContext();
    }

    private class SlowConnectionOpenTicker
    implements Ticker,
    SchedulingDelayNotificationListener {
        private final long _allowedTime;
        private volatile long _accumulatedSchedulingDelay;

        SlowConnectionOpenTicker(long timeoutTime) {
            this._allowedTime = timeoutTime;
        }

        public int getTimeToNextTick(long currentTime) {
            return (int)(AbstractAMQPConnection.this.getCreatedTime().getTime() + this._allowedTime + this._accumulatedSchedulingDelay - currentTime);
        }

        public int tick(long currentTime) {
            int nextTick = this.getTimeToNextTick(currentTime);
            if (nextTick <= 0) {
                if (AbstractAMQPConnection.this.getAuthorizedPrincipal() == null) {
                    _logger.warn("Connection has taken more than {} ms to establish identity.  Closing as possible DoS.", (Object)this._allowedTime);
                    AbstractAMQPConnection.this.getEventLogger().message(ConnectionMessages.IDLE_CLOSE("Protocol authentication not established within timeout period", true));
                    AbstractAMQPConnection.this._network.close();
                } else {
                    AbstractAMQPConnection.this._aggregateTicker.removeTicker(this);
                    AbstractAMQPConnection.this._network.removeSchedulingDelayNotificationListeners(this);
                }
            }
            return nextTick;
        }

        @Override
        public void notifySchedulingDelay(long schedulingDelay) {
            if (schedulingDelay > 0L) {
                this._accumulatedSchedulingDelay += schedulingDelay;
            }
        }
    }
}

