/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport;

import java.net.SocketAddress;
import java.security.AccessControlContext;
import java.security.Principal;
import java.util.Collection;
import javax.security.auth.Subject;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.transport.NetworkConnectionScheduler;
import org.apache.qpid.server.util.Deletable;

public interface AMQPConnection<C extends AMQPConnection<C>>
extends Connection<C>,
Deletable<C>,
EventLoggerProvider {
    public boolean isMessageAssignmentSuspended();

    public void alwaysAllowMessageAssignmentInThisThreadIfItIsIOThread(boolean var1);

    public AccessControlContext getAccessControlContextFromSubject(Subject var1);

    public long getConnectionId();

    public Principal getAuthorizedPrincipal();

    public String getRemoteAddressString();

    public String getAddressSpaceName();

    public void notifyWork();

    public String getRemoteContainerName();

    public boolean isConnectionStopped();

    public void registerMessageReceived(long var1, long var3);

    public void registerMessageDelivered(long var1);

    public void closeSessionAsync(AMQSessionModel<?> var1, AMQConstant var2, String var3);

    public SocketAddress getRemoteSocketAddress();

    public void block();

    public void unblock();

    public void pushScheduler(NetworkConnectionScheduler var1);

    public NetworkConnectionScheduler popScheduler();

    public boolean hasSessionWithName(byte[] var1);

    public void sendConnectionCloseAsync(AMQConstant var1, String var2);

    public void reserveOutboundMessageSpace(long var1);

    public boolean isIOThread();

    public void checkAuthorizedMessagePrincipal(String var1);

    public void stopConnection();

    public Collection<? extends AMQSessionModel<?>> getSessionModels();

    public void resetStatistics();
}

