/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.serializer.v1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.EnqueueableMessage;
import org.apache.qpid.server.plugin.MessageMetaDataType;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.store.MessageDurability;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.MessageHandle;
import org.apache.qpid.server.store.MessageMetaDataTypeRegistry;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.store.Transaction;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.store.handler.DistributedTransactionHandler;
import org.apache.qpid.server.store.handler.MessageHandler;
import org.apache.qpid.server.store.handler.MessageInstanceHandler;
import org.apache.qpid.server.store.serializer.MessageStoreSerializer;
import org.apache.qpid.server.store.serializer.v1.DTXRecord;
import org.apache.qpid.server.store.serializer.v1.Deserializer;
import org.apache.qpid.server.store.serializer.v1.MessageInstanceRecord;
import org.apache.qpid.server.store.serializer.v1.MessageRecord;
import org.apache.qpid.server.store.serializer.v1.QueueMappingRecord;
import org.apache.qpid.server.store.serializer.v1.Record;
import org.apache.qpid.server.store.serializer.v1.RecordType;
import org.apache.qpid.server.store.serializer.v1.Serializer;

@PluggableService
public class MessageStoreSerializer_v1
implements MessageStoreSerializer {
    public static final String VERSION = "v1.0";

    @Override
    public String getType() {
        return VERSION;
    }

    @Override
    public void serialize(Map<UUID, String> queueMap, MessageStore.MessageStoreReader storeReader, OutputStream outputStream) throws IOException {
        Serializer serializer = new Serializer(outputStream);
        this.serializeQueueMappings(queueMap, serializer);
        this.serializeMessages(storeReader, serializer);
        this.serializeMessageInstances(storeReader, serializer);
        this.serializeDistributedTransactions(storeReader, serializer);
        serializer.complete();
    }

    private void serializeQueueMappings(Map<UUID, String> queueMap, Serializer serializer) throws IOException {
        for (Map.Entry<UUID, String> entry : queueMap.entrySet()) {
            serializer.add(new QueueMappingRecord(entry.getKey(), entry.getValue()));
        }
    }

    private void serializeMessages(MessageStore.MessageStoreReader storeReader, Serializer serializer) throws IOException {
        SerializerMessageHandler messageHandler = new SerializerMessageHandler(serializer);
        storeReader.visitMessages(messageHandler);
        if (messageHandler.getException() != null) {
            throw messageHandler.getException();
        }
    }

    private void serializeMessageInstances(MessageStore.MessageStoreReader storeReader, Serializer serializer) throws IOException {
        SerializerMessageInstanceHandler messageInstanceHandler = new SerializerMessageInstanceHandler(serializer);
        storeReader.visitMessageInstances(messageInstanceHandler);
        if (messageInstanceHandler.getException() != null) {
            throw messageInstanceHandler.getException();
        }
    }

    private void serializeDistributedTransactions(MessageStore.MessageStoreReader storeReader, Serializer serializer) throws IOException {
        SerializerDistributedTransactionHandler distributedTransactionHandler = new SerializerDistributedTransactionHandler(serializer);
        storeReader.visitDistributedTransactions(distributedTransactionHandler);
        if (distributedTransactionHandler.getException() != null) {
            throw distributedTransactionHandler.getException();
        }
    }

    @Override
    public void deserialize(Map<String, UUID> queueMap, MessageStore store, InputStream inputStream) throws IOException {
        Deserializer deserializer = new Deserializer(inputStream);
        HashMap messageMap = new HashMap();
        HashMap<UUID, UUID> queueIdMap = new HashMap<UUID, UUID>();
        Record nextRecord = deserializer.readRecord();
        switch (nextRecord.getType()) {
            case VERSION: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected record type: " + (Object)((Object)nextRecord.getType()) + " expecting VERSION");
            }
        }
        nextRecord = deserializer.readRecord();
        nextRecord = this.deserializeQueueMappings(queueMap, queueIdMap, deserializer, nextRecord);
        nextRecord = this.deserializeMessages(messageMap, store, deserializer, nextRecord);
        nextRecord = this.deserializeMessageInstances(store, queueIdMap, messageMap, deserializer, nextRecord);
        nextRecord = this.deserializeDistributedTransactions(store, queueIdMap, messageMap, deserializer, nextRecord);
        if (nextRecord.getType() != RecordType.DIGEST) {
            throw new IllegalArgumentException("Unexpected record type '" + (Object)((Object)nextRecord.getType()) + "' expecting DIGEST");
        }
    }

    private Record deserializeDistributedTransactions(MessageStore store, Map<UUID, UUID> queueIdMap, Map<Long, StoredMessage<?>> messageMap, Deserializer deserializer, Record nextRecord) throws IOException {
        while (nextRecord.getType() == RecordType.DTX) {
            DTXRecord dtxRecord = (DTXRecord)nextRecord;
            Transaction txn = store.newTransaction();
            Transaction.StoredXidRecord xid = dtxRecord.getXid();
            Transaction.EnqueueRecord[] translatedEnqueues = this.translateEnqueueRecords(dtxRecord.getEnqueues(), queueIdMap, messageMap);
            Transaction.DequeueRecord[] translatedDequeues = this.translateDequeueRecords(dtxRecord.getDequeues(), queueIdMap, messageMap);
            txn.recordXid(xid.getFormat(), xid.getGlobalId(), xid.getBranchId(), translatedEnqueues, translatedDequeues);
            txn.commitTranAsync(null);
            nextRecord = deserializer.readRecord();
        }
        return nextRecord;
    }

    private Transaction.DequeueRecord[] translateDequeueRecords(Transaction.DequeueRecord[] dequeues, Map<UUID, UUID> queueIdMap, Map<Long, StoredMessage<?>> messageMap) {
        Transaction.DequeueRecord[] translatedRecords = new Transaction.DequeueRecord[dequeues.length];
        for (int i = 0; i < dequeues.length; ++i) {
            translatedRecords[i] = new DTXRecord.DequeueRecordImpl(messageMap.get(dequeues[i].getEnqueueRecord().getMessageNumber()).getMessageNumber(), queueIdMap.get(dequeues[i].getEnqueueRecord().getQueueId()));
        }
        return translatedRecords;
    }

    private Transaction.EnqueueRecord[] translateEnqueueRecords(Transaction.EnqueueRecord[] enqueues, Map<UUID, UUID> queueIdMap, Map<Long, StoredMessage<?>> messageMap) {
        Transaction.EnqueueRecord[] translatedRecords = new Transaction.EnqueueRecord[enqueues.length];
        for (int i = 0; i < enqueues.length; ++i) {
            translatedRecords[i] = new DTXRecord.EnqueueRecordImpl(messageMap.get(enqueues[i].getMessage().getMessageNumber()).getMessageNumber(), queueIdMap.get(enqueues[i].getResource().getId()));
        }
        return translatedRecords;
    }

    private Record deserializeMessageInstances(MessageStore store, Map<UUID, UUID> queueIdMap, Map<Long, StoredMessage<?>> messageMap, Deserializer deserializer, Record nextRecord) throws IOException {
        while (nextRecord.getType() == RecordType.MESSAGE_INSTANCE) {
            MessageInstanceRecord messageInstanceRecord = (MessageInstanceRecord)nextRecord;
            final StoredMessage<?> storedMessage = messageMap.get(messageInstanceRecord.getMessageNumber());
            final UUID queueId = queueIdMap.get(messageInstanceRecord.getQueueId());
            if (storedMessage != null && queueId != null) {
                Transaction txn = store.newTransaction();
                EnqueueableMessage msg = new EnqueueableMessage(){

                    @Override
                    public long getMessageNumber() {
                        return storedMessage.getMessageNumber();
                    }

                    @Override
                    public boolean isPersistent() {
                        return true;
                    }

                    public StoredMessage getStoredMessage() {
                        return storedMessage;
                    }
                };
                txn.enqueueMessage(new TransactionLogResource(){

                    @Override
                    public String getName() {
                        return queueId.toString();
                    }

                    @Override
                    public UUID getId() {
                        return queueId;
                    }

                    @Override
                    public MessageDurability getMessageDurability() {
                        return MessageDurability.DEFAULT;
                    }
                }, msg);
                txn.commitTranAsync(null);
            }
            nextRecord = deserializer.readRecord();
        }
        return nextRecord;
    }

    private Record deserializeQueueMappings(Map<String, UUID> queueMap, Map<UUID, UUID> queueIdMap, Deserializer deserializer, Record record) throws IOException {
        while (record.getType() == RecordType.QUEUE_MAPPING) {
            QueueMappingRecord queueMappingRecord = (QueueMappingRecord)record;
            if (!queueMap.containsKey(queueMappingRecord.getName())) {
                throw new IllegalArgumentException("The message store expects the existence of a queue named '" + queueMappingRecord.getName() + "'");
            }
            queueIdMap.put(queueMappingRecord.getId(), queueMap.get(queueMappingRecord.getName()));
            record = deserializer.readRecord();
        }
        return record;
    }

    private Record deserializeMessages(Map<Long, StoredMessage<?>> messageNumberMap, MessageStore store, Deserializer deserializer, Record record) throws IOException {
        while (record.getType() == RecordType.MESSAGE) {
            MessageRecord messageRecord = (MessageRecord)record;
            long originalMessageNumber = messageRecord.getMessageNumber();
            byte[] metaData = messageRecord.getMetaData();
            MessageMetaDataType metaDataType = MessageMetaDataTypeRegistry.fromOrdinal(metaData[0] & 0xFF);
            QpidByteBuffer buf = QpidByteBuffer.wrap((byte[])metaData, (int)1, (int)(metaData.length - 1));
            Object storableMessageMetaData = metaDataType.createMetaData(buf);
            buf.dispose();
            MessageHandle handle = store.addMessage(storableMessageMetaData);
            buf = QpidByteBuffer.wrap((byte[])messageRecord.getContent());
            handle.addContent(buf);
            StoredMessage storedMessage = handle.allContentAdded();
            messageNumberMap.put(originalMessageNumber, storedMessage);
            storedMessage.flowToDisk();
            buf.dispose();
            record = deserializer.readRecord();
        }
        return record;
    }

    private static class SerializerDistributedTransactionHandler
    implements DistributedTransactionHandler {
        private final Serializer _serializer;
        private IOException _exception;

        public SerializerDistributedTransactionHandler(Serializer serializer) {
            this._serializer = serializer;
        }

        @Override
        public boolean handle(Transaction.StoredXidRecord storedXid, Transaction.EnqueueRecord[] enqueues, Transaction.DequeueRecord[] dequeues) {
            try {
                this._serializer.add(new DTXRecord(storedXid, enqueues, dequeues));
            }
            catch (IOException e) {
                this._exception = e;
                return false;
            }
            return true;
        }

        public IOException getException() {
            return this._exception;
        }
    }

    private static class SerializerMessageInstanceHandler
    implements MessageInstanceHandler {
        private final Serializer _serializer;
        private IOException _exception;

        private SerializerMessageInstanceHandler(Serializer serializer) {
            this._serializer = serializer;
        }

        @Override
        public boolean handle(MessageEnqueueRecord record) {
            try {
                this._serializer.add(new MessageInstanceRecord(record));
            }
            catch (IOException e) {
                this._exception = e;
                return false;
            }
            return true;
        }

        public IOException getException() {
            return this._exception;
        }
    }

    private static class SerializerMessageHandler
    implements MessageHandler {
        private final Serializer _serializer;
        private IOException _exception;

        public SerializerMessageHandler(Serializer serializer) {
            this._serializer = serializer;
        }

        @Override
        public boolean handle(StoredMessage<?> storedMessage) {
            try {
                this._serializer.add(new MessageRecord(storedMessage));
            }
            catch (IOException e) {
                this._exception = e;
                return false;
            }
            return true;
        }

        public IOException getException() {
            return this._exception;
        }
    }
}

