/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.serializer.v1;

import java.io.IOException;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.store.serializer.v1.Deserializer;
import org.apache.qpid.server.store.serializer.v1.Record;
import org.apache.qpid.server.store.serializer.v1.RecordType;
import org.apache.qpid.server.store.serializer.v1.Serializer;

class MessageRecord
implements Record {
    private final long _messageNumber;
    private final byte[] _metaData;
    private final byte[] _content;

    public MessageRecord(StoredMessage<?> storedMessage) {
        this._messageNumber = storedMessage.getMessageNumber();
        this._metaData = new byte[1 + storedMessage.getMetaData().getStorableSize()];
        QpidByteBuffer buf = QpidByteBuffer.wrap((byte[])this._metaData);
        buf.put((byte)storedMessage.getMetaData().getType().ordinal());
        storedMessage.getMetaData().writeToBuffer(buf);
        buf.dispose();
        this._content = new byte[storedMessage.getMetaData().getContentSize()];
        buf = QpidByteBuffer.wrap((byte[])this._content);
        for (QpidByteBuffer content : storedMessage.getContent(0, storedMessage.getMetaData().getContentSize())) {
            buf.put(content);
            content.dispose();
        }
        buf.dispose();
    }

    MessageRecord(long messageNumber, byte[] metaData, byte[] content) {
        this._messageNumber = messageNumber;
        this._metaData = metaData;
        this._content = content;
    }

    @Override
    public RecordType getType() {
        return RecordType.MESSAGE;
    }

    public int getLength() {
        return this._metaData.length + this._content.length + 16;
    }

    @Override
    public void writeData(Serializer output) throws IOException {
        output.writeLong(this._messageNumber);
        output.writeInt(this._metaData.length);
        output.write(this._metaData);
        output.writeInt(this._content.length);
        output.write(this._content);
    }

    public long getMessageNumber() {
        return this._messageNumber;
    }

    public byte[] getMetaData() {
        return this._metaData;
    }

    public byte[] getContent() {
        return this._content;
    }

    public static MessageRecord read(Deserializer deserializer) throws IOException {
        long messageNumber = deserializer.readLong();
        int storableSize = deserializer.readInt();
        byte[] metaDataContent = deserializer.readBytes(storableSize);
        int messageSize = deserializer.readInt();
        byte[] content = deserializer.readBytes(messageSize);
        return new MessageRecord(messageNumber, metaDataContent, content);
    }
}

