/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.preferences;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.qpid.server.model.ConfiguredObjectJacksonModule;
import org.apache.qpid.server.model.ModelVersion;
import org.apache.qpid.server.store.JdbcUtils;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.preferences.PreferenceRecord;
import org.apache.qpid.server.store.preferences.PreferenceRecordImpl;
import org.apache.qpid.server.store.preferences.PreferenceStore;
import org.apache.qpid.server.store.preferences.PreferenceStoreUpdater;
import org.apache.qpid.server.util.BaseAction;
import org.slf4j.Logger;

public abstract class AbstractJDBCPreferenceStore
implements PreferenceStore {
    private static final String PREFERENCES_VERSION_TABLE_NAME = "PREFERENCES_VERSION";
    private static final String PREFERENCES_TABLE_NAME = "PREFERENCES";
    private static final String CREATE_PREFERENCES_VERSION_TABLE = "CREATE TABLE PREFERENCES_VERSION ( version VARCHAR(20) NOT NULL )";
    private static final String INSERT_INTO_PREFERENCES_VERSION = "INSERT INTO PREFERENCES_VERSION ( version ) VALUES ( ? )";
    private static final String SELECT_FROM_PREFERENCES_VERSION = "SELECT version FROM PREFERENCES_VERSION";
    private static final String INSERT_INTO_PREFERENCES = "INSERT INTO PREFERENCES ( id, attributes ) VALUES ( ?, ? )";
    private static final String DELETE_FROM_PREFERENCES = "DELETE FROM PREFERENCES where id = ?";
    private static final String SELECT_FROM_PREFERENCES = "SELECT id, attributes FROM PREFERENCES";
    private static final String FIND_PREFERENCE = "SELECT attributes FROM PREFERENCES WHERE id = ?";
    private static final String UPDATE_PREFERENCES = "UPDATE PREFERENCES SET attributes = ? WHERE id = ?";
    private final AtomicReference<StoreState> _storeState = new AtomicReference<StoreState>(StoreState.CLOSED);
    private final ReentrantReadWriteLock _useOrCloseRWLock = new ReentrantReadWriteLock(true);

    @Override
    public Collection<PreferenceRecord> openAndLoad(PreferenceStoreUpdater updater) throws StoreException {
        if (!this._storeState.compareAndSet(StoreState.CLOSED, StoreState.OPENING)) {
            throw new IllegalStateException(String.format("PreferenceStore cannot be opened when in state '%s'", new Object[]{this._storeState.get()}));
        }
        try {
            Collection<PreferenceRecord> records;
            try (Connection connection = this.getConnection();){
                this.createVersionTable(connection);
                this.createPreferencesTable(connection);
                ModelVersion preferencesVersion = this.getPreferencesVersion(connection);
                ModelVersion brokerModelVersion = ModelVersion.fromString("6.1");
                if (brokerModelVersion.lessThan(preferencesVersion)) {
                    throw new StoreException(String.format("Cannot downgrade preference store from '%s' to '%s'", preferencesVersion, brokerModelVersion));
                }
                records = this.getPreferenceRecords(connection);
                if (preferencesVersion.lessThan(brokerModelVersion)) {
                    HashSet<UUID> ids = new HashSet<UUID>();
                    for (PreferenceRecord record : records) {
                        ids.add(record.getId());
                    }
                    records = updater.updatePreferences(preferencesVersion.toString(), records);
                    this.replace(ids, records);
                }
            }
            this._storeState.set(StoreState.OPENED);
            return records;
        }
        catch (SQLException e) {
            this._storeState.set(StoreState.ERRORED);
            this.close();
            throw new StoreException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateOrCreate(final Collection<PreferenceRecord> preferenceRecords) {
        this._useOrCloseRWLock.readLock().lock();
        try {
            if (!this.getStoreState().equals((Object)StoreState.OPENED)) {
                throw new IllegalStateException("PreferenceStore is not opened");
            }
            this.performSafeTransaction(new BaseAction<Connection, Exception>(){

                @Override
                public void performAction(Connection connection) throws Exception {
                    AbstractJDBCPreferenceStore.this.updateOrCreateInternal(connection, preferenceRecords);
                }
            });
        }
        finally {
            this._useOrCloseRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replace(final Collection<UUID> preferenceRecordsToRemove, final Collection<PreferenceRecord> preferenceRecordsToAdd) {
        this._useOrCloseRWLock.readLock().lock();
        try {
            if (!this.getStoreState().equals((Object)StoreState.OPENED)) {
                throw new IllegalStateException("PreferenceStore is not opened");
            }
            this.performSafeTransaction(new BaseAction<Connection, Exception>(){

                @Override
                public void performAction(Connection connection) throws Exception {
                    for (UUID id : preferenceRecordsToRemove) {
                        PreparedStatement deleteStatement = connection.prepareStatement(AbstractJDBCPreferenceStore.DELETE_FROM_PREFERENCES);
                        Throwable throwable = null;
                        try {
                            deleteStatement.setString(1, id.toString());
                            int deletedCount = deleteStatement.executeUpdate();
                            if (deletedCount != 1) continue;
                            AbstractJDBCPreferenceStore.this.getLogger().debug(String.format("Failed to delete preference with id %s : no such record", id));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (deleteStatement == null) continue;
                            if (throwable != null) {
                                try {
                                    deleteStatement.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            deleteStatement.close();
                        }
                    }
                    AbstractJDBCPreferenceStore.this.updateOrCreateInternal(connection, preferenceRecordsToAdd);
                }
            });
        }
        finally {
            this._useOrCloseRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDelete() {
        this._useOrCloseRWLock.writeLock().lock();
        try {
            this.close();
            this.doDelete();
        }
        finally {
            this._useOrCloseRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this._useOrCloseRWLock.writeLock().lock();
        try {
            while (true) {
                StoreState storeState;
                if ((storeState = this.getStoreState()).equals((Object)StoreState.OPENED) || storeState.equals((Object)StoreState.ERRORED)) {
                    if (!this._storeState.compareAndSet(storeState, StoreState.CLOSING)) continue;
                    break;
                }
                if (!storeState.equals((Object)StoreState.CLOSED) && !storeState.equals((Object)StoreState.CLOSING)) continue;
                return;
            }
            this.doClose();
            this._storeState.set(StoreState.CLOSED);
        }
        finally {
            this._useOrCloseRWLock.writeLock().unlock();
        }
    }

    protected void dropTables(Connection connection) throws SQLException {
        try (Statement dropTableStatement = connection.createStatement();){
            dropTableStatement.execute("DROP TABLE PREFERENCES");
            dropTableStatement.execute("DROP TABLE PREFERENCES_VERSION");
        }
        catch (SQLException e) {
            this.getLogger().warn("Failed to drop preferences table", (Throwable)e);
        }
    }

    protected abstract void doDelete();

    protected abstract void doClose();

    protected abstract Logger getLogger();

    protected abstract Connection getConnection() throws SQLException;

    protected abstract String getSqlBlobType();

    protected abstract String getBlobAsString(ResultSet var1, int var2) throws SQLException;

    StoreState getStoreState() {
        return this._storeState.get();
    }

    private void updateOrCreateInternal(Connection conn, Collection<PreferenceRecord> preferenceRecords) throws SQLException, JsonProcessingException {
        for (PreferenceRecord record : preferenceRecords) {
            PreparedStatement stmt = conn.prepareStatement(FIND_PREFERENCE);
            Throwable throwable = null;
            try {
                stmt.setString(1, record.getId().toString());
                ResultSet rs = stmt.executeQuery();
                Throwable throwable2 = null;
                try {
                    Throwable throwable3;
                    if (rs.next()) {
                        PreparedStatement updateStatement = conn.prepareStatement(UPDATE_PREFERENCES);
                        throwable3 = null;
                        try {
                            this.setAttributesAsBlob(updateStatement, 1, record.getAttributes());
                            updateStatement.setString(2, record.getId().toString());
                            updateStatement.execute();
                            continue;
                        }
                        catch (Throwable x2) {
                            throwable3 = x2;
                            throw x2;
                        }
                        finally {
                            if (updateStatement == null) continue;
                            if (throwable3 != null) {
                                try {
                                    updateStatement.close();
                                }
                                catch (Throwable x2) {
                                    throwable3.addSuppressed(x2);
                                }
                                continue;
                            }
                            updateStatement.close();
                            continue;
                        }
                    }
                    PreparedStatement insertStatement = conn.prepareStatement(INSERT_INTO_PREFERENCES);
                    throwable3 = null;
                    try {
                        insertStatement.setString(1, record.getId().toString());
                        this.setAttributesAsBlob(insertStatement, 2, record.getAttributes());
                        insertStatement.execute();
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (insertStatement == null) continue;
                        if (throwable3 != null) {
                            try {
                                insertStatement.close();
                            }
                            catch (Throwable x2) {
                                throwable3.addSuppressed(x2);
                            }
                            continue;
                        }
                        insertStatement.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    if (rs == null) continue;
                    if (throwable2 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable x2) {
                            throwable2.addSuppressed(x2);
                        }
                        continue;
                    }
                    rs.close();
                }
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (stmt == null) continue;
                if (throwable != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                stmt.close();
            }
        }
    }

    private void performSafeTransaction(BaseAction<Connection, Exception> transactedAction) {
        Connection connection = null;
        try {
            connection = this.getTransactedConnection();
            transactedAction.performAction(connection);
            connection.commit();
        }
        catch (Exception e) {
            try {
                if (connection != null) {
                    connection.rollback();
                }
            }
            catch (SQLException e1) {
                this.getLogger().error("Failed to rollback transaction", (Throwable)e1);
            }
            throw new StoreException(e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                this.getLogger().warn("Failed to close JDBC connection", (Throwable)e);
            }
        }
    }

    private Connection getTransactedConnection() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        connection.setTransactionIsolation(2);
        return connection;
    }

    private void setAttributesAsBlob(PreparedStatement preparedSqlStatement, int parameterIndex, Map<String, Object> attributes) throws JsonProcessingException, SQLException {
        ObjectMapper objectMapper = ConfiguredObjectJacksonModule.newObjectMapper();
        if (attributes != null) {
            byte[] attributesAsBytes = objectMapper.writeValueAsBytes(attributes);
            ByteArrayInputStream bis = new ByteArrayInputStream(attributesAsBytes);
            preparedSqlStatement.setBinaryStream(parameterIndex, (InputStream)bis, attributesAsBytes.length);
        } else {
            preparedSqlStatement.setNull(parameterIndex, 2004);
        }
    }

    private void createVersionTable(Connection conn) throws SQLException {
        if (!JdbcUtils.tableExists(PREFERENCES_VERSION_TABLE_NAME, conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute(CREATE_PREFERENCES_VERSION_TABLE);
            }
            var3_3 = null;
            try (PreparedStatement pstmt = conn.prepareStatement(INSERT_INTO_PREFERENCES_VERSION);){
                pstmt.setString(1, "6.1");
                pstmt.execute();
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
        }
    }

    private void createPreferencesTable(Connection conn) throws SQLException {
        if (!JdbcUtils.tableExists(PREFERENCES_TABLE_NAME, conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE PREFERENCES ( id VARCHAR(36) not null, attributes " + this.getSqlBlobType() + ",  PRIMARY KEY (id))");
            }
        }
    }

    /*
     * Exception decompiling
     */
    private ModelVersion getPreferencesVersion(Connection conn) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Collection<PreferenceRecord> getPreferenceRecords(Connection connection) throws SQLException {
        LinkedHashSet<PreferenceRecord> records = new LinkedHashSet<PreferenceRecord>();
        ObjectMapper objectMapper = new ObjectMapper();
        try (PreparedStatement stmt = connection.prepareStatement(SELECT_FROM_PREFERENCES);){
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String id = rs.getString(1);
                    String attributes = this.getBlobAsString(rs, 2);
                    PreferenceRecordImpl preferenceRecord = new PreferenceRecordImpl(UUID.fromString(id), (Map)objectMapper.readValue(attributes, Map.class));
                    records.add(preferenceRecord);
                }
            }
            catch (IOException e) {
                throw new StoreException("Error recovering persistent state: " + e.getMessage(), e);
            }
        }
        return records;
    }

    static enum StoreState {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING,
        ERRORED;

    }
}

