/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.store.StoreConfigurationChangeListener;
import org.apache.qpid.server.filter.FilterSupport;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.queue.QueueArgumentsConverter;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.ConfiguredObjectRecordImpl;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.GenericRecoverer;
import org.apache.qpid.server.store.GenericStoreUpgrader;
import org.apache.qpid.server.store.StoreUpgraderPhase;
import org.apache.qpid.server.store.handler.ConfiguredObjectRecordHandler;
import org.apache.qpid.server.util.Action;

public class VirtualHostStoreUpgraderAndRecoverer {
    private final VirtualHostNode<?> _virtualHostNode;
    private Map<String, StoreUpgraderPhase> _upgraders = new HashMap<String, StoreUpgraderPhase>();
    private static final Map<String, String> DEFAULT_EXCHANGES = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("amq.direct", "direct");
            this.put("amq.topic", "topic");
            this.put("amq.fanout", "fanout");
            this.put("amq.match", "headers");
        }
    });
    private final Map<String, UUID> _defaultExchangeIds;

    public VirtualHostStoreUpgraderAndRecoverer(VirtualHostNode<?> virtualHostNode) {
        this._virtualHostNode = virtualHostNode;
        this.register(new Upgrader_0_0_to_0_1());
        this.register(new Upgrader_0_1_to_0_2());
        this.register(new Upgrader_0_2_to_0_3());
        this.register(new Upgrader_0_3_to_0_4());
        this.register(new Upgrader_0_4_to_2_0());
        this.register(new Upgrader_2_0_to_3_0());
        this.register(new Upgrader_3_0_to_6_0());
        this.register(new Upgrader_6_0_to_6_1());
        HashMap<String, UUID> defaultExchangeIds = new HashMap<String, UUID>();
        for (String exchangeName : DEFAULT_EXCHANGES.keySet()) {
            UUID id = UUIDGenerator.generateExchangeUUID(exchangeName, virtualHostNode.getName());
            defaultExchangeIds.put(exchangeName, id);
        }
        this._defaultExchangeIds = Collections.unmodifiableMap(defaultExchangeIds);
    }

    private void register(StoreUpgraderPhase upgrader) {
        this._upgraders.put(upgrader.getFromVersion(), upgrader);
    }

    public boolean upgradeAndRecover(DurableConfigurationStore durableConfigurationStore, ConfiguredObjectRecord ... initialRecords) {
        String virtualHostCategory = VirtualHost.class.getSimpleName();
        final ArrayList<ConfiguredObjectRecord> records = new ArrayList<ConfiguredObjectRecord>();
        boolean isNew = durableConfigurationStore.openConfigurationStore(new ConfiguredObjectRecordHandler(){

            @Override
            public void handle(ConfiguredObjectRecord record) {
                records.add(record);
            }
        }, initialRecords);
        GenericStoreUpgrader upgraderHandler = new GenericStoreUpgrader(virtualHostCategory, "modelVersion", durableConfigurationStore, this._upgraders);
        upgraderHandler.upgrade(records);
        List<ConfiguredObjectRecord> upgradedRecords = upgraderHandler.getRecords();
        this.recover(this._virtualHostNode, durableConfigurationStore, upgradedRecords, isNew);
        return isNew;
    }

    public void reloadAndRecover(DurableConfigurationStore durableConfigurationStore) {
        this.reloadAndRecoverInternal(this._virtualHostNode, durableConfigurationStore);
    }

    public void reloadAndRecoverVirtualHost(DurableConfigurationStore durableConfigurationStore) {
        this.reloadAndRecoverInternal(this._virtualHostNode.getVirtualHost(), durableConfigurationStore);
    }

    private void reloadAndRecoverInternal(ConfiguredObject<?> recoveryRoot, DurableConfigurationStore durableConfigurationStore) {
        final ArrayList<ConfiguredObjectRecord> records = new ArrayList<ConfiguredObjectRecord>();
        durableConfigurationStore.reload(new ConfiguredObjectRecordHandler(){

            @Override
            public void handle(ConfiguredObjectRecord record) {
                records.add(record);
            }
        });
        this.recover(recoveryRoot, durableConfigurationStore, records, false);
    }

    private void recover(ConfiguredObject<?> recoveryRoot, final DurableConfigurationStore durableConfigurationStore, List<ConfiguredObjectRecord> records, boolean isNew) {
        new GenericRecoverer(recoveryRoot).recover(records, isNew);
        final StoreConfigurationChangeListener configChangeListener = new StoreConfigurationChangeListener(durableConfigurationStore);
        if (this._virtualHostNode.getVirtualHost() != null) {
            this.applyRecursively(this._virtualHostNode.getVirtualHost(), new Action<ConfiguredObject<?>>(){

                @Override
                public void performAction(ConfiguredObject<?> object) {
                    object.addChangeListener(configChangeListener);
                }
            });
        }
        if (recoveryRoot instanceof VirtualHostNode) {
            this._virtualHostNode.addChangeListener(new ConfigurationChangeListener(){

                @Override
                public void stateChanged(ConfiguredObject<?> object, State oldState, State newState) {
                }

                @Override
                public void childAdded(ConfiguredObject<?> object, ConfiguredObject<?> child) {
                    if (child instanceof VirtualHost) {
                        VirtualHostStoreUpgraderAndRecoverer.this.applyRecursively(child, new Action<ConfiguredObject<?>>(){

                            @Override
                            public void performAction(ConfiguredObject<?> object) {
                                if (object.isDurable()) {
                                    durableConfigurationStore.update(true, object.asObjectRecord());
                                    object.addChangeListener(configChangeListener);
                                }
                            }
                        });
                    }
                }

                @Override
                public void childRemoved(ConfiguredObject<?> object, ConfiguredObject<?> child) {
                    if (child instanceof VirtualHost) {
                        child.removeChangeListener(configChangeListener);
                    }
                }

                @Override
                public void attributeSet(ConfiguredObject<?> object, String attributeName, Object oldAttributeValue, Object newAttributeValue) {
                }

                @Override
                public void bulkChangeStart(ConfiguredObject<?> object) {
                }

                @Override
                public void bulkChangeEnd(ConfiguredObject<?> object) {
                }
            });
            if (isNew && this._virtualHostNode instanceof AbstractConfiguredObject) {
                ((AbstractConfiguredObject)((Object)this._virtualHostNode)).forceUpdateAllSecureAttributes();
            }
        }
    }

    private void applyRecursively(ConfiguredObject<?> object, Action<ConfiguredObject<?>> action) {
        this.applyRecursively(object, action, new HashSet());
    }

    private void applyRecursively(ConfiguredObject<?> object, Action<ConfiguredObject<?>> action, HashSet<ConfiguredObject<?>> visited) {
        if (!visited.contains(object)) {
            visited.add(object);
            action.performAction(object);
            for (Class<? extends ConfiguredObject> childClass : object.getModel().getChildTypes(object.getCategoryClass())) {
                Collection<? extends ConfiguredObject> children = object.getChildren(childClass);
                if (children == null) continue;
                for (ConfiguredObject configuredObject : children) {
                    this.applyRecursively(configuredObject, action, visited);
                }
            }
        }
    }

    private class Upgrader_6_0_to_6_1
    extends StoreUpgraderPhase {
        public Upgrader_6_0_to_6_1() {
            super("modelVersion", "6.0", "6.1");
        }

        @Override
        public void configuredObject(ConfiguredObjectRecord record) {
            if ("VirtualHost".equals(record.getType())) {
                record = this.upgradeRootRecord(record);
            }
            this.getNextUpgrader().configuredObject(record);
        }

        @Override
        public void complete() {
            this.getNextUpgrader().complete();
        }
    }

    private class Upgrader_3_0_to_6_0
    extends StoreUpgraderPhase {
        public Upgrader_3_0_to_6_0() {
            super("modelVersion", "3.0", "6.0");
        }

        @Override
        public void configuredObject(ConfiguredObjectRecord record) {
            if ("VirtualHost".equals(record.getType())) {
                record = this.upgradeRootRecord(record);
            }
            this.getNextUpgrader().configuredObject(record);
        }

        @Override
        public void complete() {
            this.getNextUpgrader().complete();
        }
    }

    private class Upgrader_2_0_to_3_0
    extends StoreUpgraderPhase {
        public Upgrader_2_0_to_3_0() {
            super("modelVersion", "2.0", "3.0");
        }

        @Override
        public void configuredObject(ConfiguredObjectRecord record) {
            if ("VirtualHost".equals(record.getType())) {
                record = this.upgradeRootRecord(record);
            }
            this.getNextUpgrader().configuredObject(record);
        }

        @Override
        public void complete() {
            this.getNextUpgrader().complete();
        }
    }

    private class Upgrader_0_4_to_2_0
    extends StoreUpgraderPhase {
        private static final String ALTERNATE_EXCHANGE = "alternateExchange";
        private static final String DLQ_ENABLED_ARGUMENT = "x-qpid-dlq-enabled";
        private static final String DEFAULT_DLE_NAME_SUFFIX = "_DLE";
        private Map<String, String> _missingAmqpExchanges;
        private ConfiguredObjectRecord _virtualHostRecord;
        private Map<UUID, String> _queuesMissingAlternateExchange;
        private Map<String, ConfiguredObjectRecord> _exchanges;

        public Upgrader_0_4_to_2_0() {
            super("modelVersion", "0.4", "2.0");
            this._missingAmqpExchanges = new HashMap<String, String>(DEFAULT_EXCHANGES);
            this._queuesMissingAlternateExchange = new HashMap<UUID, String>();
            this._exchanges = new HashMap<String, ConfiguredObjectRecord>();
        }

        @Override
        public void configuredObject(ConfiguredObjectRecord record) {
            if ("VirtualHost".equals(record.getType())) {
                record = this.upgradeRootRecord(record);
                HashMap<String, Object> virtualHostAttributes = new HashMap<String, Object>(record.getAttributes());
                virtualHostAttributes.put("name", VirtualHostStoreUpgraderAndRecoverer.this._virtualHostNode.getName());
                virtualHostAttributes.put("modelVersion", this.getToVersion());
                this._virtualHostRecord = record = new ConfiguredObjectRecordImpl(record.getId(), "VirtualHost", virtualHostAttributes, Collections.emptyMap());
            } else if ("Exchange".equals(record.getType())) {
                Map<String, Object> attributes = record.getAttributes();
                String name = (String)attributes.get("name");
                this._missingAmqpExchanges.remove(name);
                this._exchanges.put(name, record);
            } else if ("Queue".equals(record.getType())) {
                record = this.updateQueueRecordIfNecessary(record);
            }
            this.getNextUpgrader().configuredObject(record);
        }

        @Override
        public void complete() {
            for (UUID uUID : this._queuesMissingAlternateExchange.keySet()) {
                String dleExchangeName;
                ConfiguredObjectRecord alternateExchange;
                ConfiguredObjectRecord record = this.getUpdateMap().get(uUID);
                if (record == null || (alternateExchange = this._exchanges.get(dleExchangeName = this._queuesMissingAlternateExchange.get(uUID))) == null) continue;
                this.setAlternateExchangeAttribute(record, alternateExchange);
            }
            for (Map.Entry entry : this._missingAmqpExchanges.entrySet()) {
                String name = (String)entry.getKey();
                String type = (String)entry.getValue();
                UUID id = (UUID)VirtualHostStoreUpgraderAndRecoverer.this._defaultExchangeIds.get(name);
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("name", name);
                attributes.put("type", type);
                attributes.put("lifetimePolicy", "PERMANENT");
                ConfiguredObjectRecordImpl record = new ConfiguredObjectRecordImpl(id, Exchange.class.getSimpleName(), attributes, Collections.singletonMap(this._virtualHostRecord.getType(), this._virtualHostRecord.getId()));
                this.getUpdateMap().put(id, record);
                this.getNextUpgrader().configuredObject(record);
            }
            this.getNextUpgrader().complete();
        }

        private ConfiguredObjectRecord updateQueueRecordIfNecessary(ConfiguredObjectRecord record) {
            Map<String, Object> attributes = record.getAttributes();
            boolean queueDLQEnabled = Boolean.parseBoolean(String.valueOf(attributes.get(DLQ_ENABLED_ARGUMENT)));
            if (queueDLQEnabled && attributes.get(ALTERNATE_EXCHANGE) == null) {
                Object queueName = attributes.get("name");
                if (queueName == null || "".equals(queueName)) {
                    throw new IllegalConfigurationException("Queue name is not found in queue configuration entry attributes: " + attributes);
                }
                String dleSuffix = System.getProperty("qpid.broker_dead_letter_exchange_suffix", DEFAULT_DLE_NAME_SUFFIX);
                String dleExchangeName = queueName + dleSuffix;
                ConfiguredObjectRecord exchangeRecord = this.findConfiguredObjectRecordInUpdateMap("Exchange", dleExchangeName);
                if (exchangeRecord == null) {
                    if (!this.getUpdateMap().containsKey(record.getId())) {
                        this.getUpdateMap().put(record.getId(), record);
                    }
                    this._queuesMissingAlternateExchange.put(record.getId(), dleExchangeName);
                } else {
                    record = this.setAlternateExchangeAttribute(record, exchangeRecord);
                }
            }
            return record;
        }

        private ConfiguredObjectRecord setAlternateExchangeAttribute(ConfiguredObjectRecord record, ConfiguredObjectRecord alternateExchange) {
            LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>(record.getAttributes());
            attributes.put(ALTERNATE_EXCHANGE, alternateExchange.getId());
            record = new ConfiguredObjectRecordImpl(record.getId(), record.getType(), attributes, record.getParents());
            this.getUpdateMap().put(record.getId(), record);
            return record;
        }

        private ConfiguredObjectRecord findConfiguredObjectRecordInUpdateMap(String type, String name) {
            for (ConfiguredObjectRecord record : this.getUpdateMap().values()) {
                if (!type.equals(record.getType()) || !name.equals(record.getAttributes().get("name"))) continue;
                return record;
            }
            return null;
        }
    }

    private class Upgrader_0_3_to_0_4
    extends StoreUpgraderPhase {
        private static final String EXCLUSIVE = "exclusive";

        public Upgrader_0_3_to_0_4() {
            super("modelVersion", "0.3", "0.4");
        }

        @Override
        public void configuredObject(ConfiguredObjectRecord record) {
            if ("VirtualHost".equals(record.getType())) {
                record = this.upgradeRootRecord(record);
            } else if (Queue.class.getSimpleName().equals(record.getType())) {
                LinkedHashMap<String, Object> newAttributes = new LinkedHashMap<String, Object>(record.getAttributes());
                if (record.getAttributes().get(EXCLUSIVE) instanceof Boolean) {
                    boolean isExclusive = (Boolean)record.getAttributes().get(EXCLUSIVE);
                    newAttributes.put(EXCLUSIVE, isExclusive ? "CONTAINER" : "NONE");
                    if (!isExclusive && record.getAttributes().containsKey("owner")) {
                        newAttributes.remove("owner");
                    }
                } else {
                    newAttributes.remove("owner");
                }
                if (!record.getAttributes().containsKey("durable")) {
                    newAttributes.put("durable", "true");
                }
                record = new ConfiguredObjectRecordImpl(record.getId(), record.getType(), newAttributes, record.getParents());
                this.getUpdateMap().put(record.getId(), record);
            }
            this.getNextUpgrader().configuredObject(record);
        }

        @Override
        public void complete() {
            this.getNextUpgrader().complete();
        }
    }

    private class Upgrader_0_2_to_0_3
    extends StoreUpgraderPhase {
        private static final String ARGUMENTS = "arguments";

        public Upgrader_0_2_to_0_3() {
            super("modelVersion", "0.2", "0.3");
        }

        @Override
        public void configuredObject(ConfiguredObjectRecord record) {
            if ("VirtualHost".equals(record.getType())) {
                record = this.upgradeRootRecord(record);
            } else if ("Queue".equals(record.getType())) {
                LinkedHashMap<String, Object> newAttributes = new LinkedHashMap<String, Object>();
                if (record.getAttributes().get(ARGUMENTS) instanceof Map) {
                    newAttributes.putAll(QueueArgumentsConverter.convertWireArgsToModel((Map)record.getAttributes().get(ARGUMENTS)));
                }
                newAttributes.putAll(record.getAttributes());
                record = new ConfiguredObjectRecordImpl(record.getId(), record.getType(), newAttributes, record.getParents());
                this.getUpdateMap().put(record.getId(), record);
            }
            this.getNextUpgrader().configuredObject(record);
        }

        @Override
        public void complete() {
            this.getNextUpgrader().complete();
        }
    }

    private class Upgrader_0_1_to_0_2
    extends StoreUpgraderPhase {
        public Upgrader_0_1_to_0_2() {
            super("modelVersion", "0.1", "0.2");
        }

        @Override
        public void configuredObject(ConfiguredObjectRecord record) {
            String type = record.getType().substring(1 + record.getType().lastIndexOf(46));
            ConfiguredObjectRecord newRecord = new ConfiguredObjectRecordImpl(record.getId(), type, record.getAttributes(), record.getParents());
            this.getUpdateMap().put(record.getId(), newRecord);
            if ("VirtualHost".equals(type)) {
                newRecord = this.upgradeRootRecord(newRecord);
            }
        }

        @Override
        public void complete() {
            Iterator<Map.Entry<UUID, ConfiguredObjectRecord>> iterator = this.getUpdateMap().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UUID, ConfiguredObjectRecord> entry = iterator.next();
                ConfiguredObjectRecord record = entry.getValue();
                UUID exchangeParent = record.getParents().get(Exchange.class.getSimpleName());
                UUID queueParent = record.getParents().get(Queue.class.getSimpleName());
                if (this.isBinding(record.getType()) && (exchangeParent == null || this.unknownExchange(exchangeParent) || queueParent == null || this.unknownQueue(queueParent))) {
                    this.getDeleteMap().put(entry.getKey(), entry.getValue());
                    iterator.remove();
                    continue;
                }
                this.getNextUpgrader().configuredObject(record);
            }
            this.getNextUpgrader().complete();
        }

        private boolean unknownExchange(UUID exchangeId) {
            if (VirtualHostStoreUpgraderAndRecoverer.this._defaultExchangeIds.containsValue(exchangeId)) {
                return false;
            }
            ConfiguredObjectRecord localRecord = this.getUpdateMap().get(exchangeId);
            return localRecord == null || !localRecord.getType().equals(Exchange.class.getSimpleName());
        }

        private boolean unknownQueue(UUID queueId) {
            ConfiguredObjectRecord localRecord = this.getUpdateMap().get(queueId);
            return localRecord == null || !localRecord.getType().equals(Queue.class.getSimpleName());
        }

        private boolean isBinding(String type) {
            return Binding.class.getSimpleName().equals(type);
        }
    }

    private class Upgrader_0_0_to_0_1
    extends StoreUpgraderPhase {
        private final Map<UUID, ConfiguredObjectRecord> _records;

        public Upgrader_0_0_to_0_1() {
            super("modelVersion", "0.0", "0.1");
            this._records = new HashMap<UUID, ConfiguredObjectRecord>();
        }

        @Override
        public void configuredObject(ConfiguredObjectRecord record) {
            this._records.put(record.getId(), record);
        }

        private void removeSelectorArguments(Map<String, Object> binding) {
            LinkedHashMap<String, Object> arguments = new LinkedHashMap<String, Object>((Map)binding.get("arguments"));
            FilterSupport.removeFilters(arguments);
            binding.put("arguments", arguments);
        }

        private boolean isTopicExchange(ConfiguredObjectRecord entry) {
            UUID exchangeId = entry.getParents().get("Exchange");
            if (exchangeId == null) {
                return false;
            }
            if (this._records.containsKey(exchangeId)) {
                return "topic".equals(this._records.get(exchangeId).getAttributes().get("type"));
            }
            return ((UUID)VirtualHostStoreUpgraderAndRecoverer.this._defaultExchangeIds.get("amq.topic")).equals(exchangeId);
        }

        private boolean hasSelectorArguments(Map<String, Object> binding) {
            Map arguments = (Map)binding.get("arguments");
            return arguments != null && FilterSupport.argumentsContainFilter(arguments);
        }

        @Override
        public void complete() {
            for (Map.Entry<UUID, ConfiguredObjectRecord> entry : this._records.entrySet()) {
                ConfiguredObjectRecord record = entry.getValue();
                String type = record.getType();
                Map<String, Object> attributes = record.getAttributes();
                UUID id = record.getId();
                if ("org.apache.qpid.server.model.VirtualHost".equals(type)) {
                    record = this.upgradeRootRecord(record);
                } else if (type.equals(Binding.class.getName()) && this.hasSelectorArguments(attributes) && !this.isTopicExchange(record)) {
                    attributes = new LinkedHashMap<String, Object>(attributes);
                    this.removeSelectorArguments(attributes);
                    record = new ConfiguredObjectRecordImpl(id, type, attributes, record.getParents());
                    this.getUpdateMap().put(id, record);
                    entry.setValue(record);
                }
                this.getNextUpgrader().configuredObject(record);
            }
            this.getNextUpgrader().complete();
        }
    }
}

