/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.store.MessageHandle;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoredMessage;

public class StoredMemoryMessage<T extends StorableMessageMetaData>
implements StoredMessage<T>,
MessageHandle<T> {
    private final long _messageNumber;
    private final int _contentSize;
    private final Queue<QpidByteBuffer> _content = new LinkedList<QpidByteBuffer>();
    private volatile T _metaData;

    public StoredMemoryMessage(long messageNumber, T metaData) {
        this._messageNumber = messageNumber;
        this._metaData = metaData;
        this._contentSize = this._metaData.getContentSize();
    }

    @Override
    public long getMessageNumber() {
        return this._messageNumber;
    }

    @Override
    public synchronized void addContent(QpidByteBuffer src) {
        this._content.add(src.slice());
    }

    @Override
    public synchronized StoredMessage<T> allContentAdded() {
        return this;
    }

    @Override
    public synchronized Collection<QpidByteBuffer> getContent(int offset, int length) {
        ArrayList<QpidByteBuffer> content = new ArrayList<QpidByteBuffer>(this._content.size());
        int pos = 0;
        for (QpidByteBuffer buf : this._content) {
            if (length <= 0) continue;
            int bufRemaining = buf.remaining();
            if (pos + bufRemaining <= offset) {
                pos += bufRemaining;
                continue;
            }
            if (pos >= offset) {
                buf = buf.duplicate();
                if (bufRemaining <= length) {
                    length -= bufRemaining;
                } else {
                    buf.limit(length);
                    length = 0;
                }
                content.add(buf);
                pos += buf.remaining();
                continue;
            }
            int offsetInBuf = offset - pos;
            int limit = length < bufRemaining - offsetInBuf ? length : bufRemaining - offsetInBuf;
            QpidByteBuffer bufView = buf.view(offsetInBuf, limit);
            content.add(bufView);
            length -= limit;
            pos += limit + offsetInBuf;
        }
        return content;
    }

    public int getContentSize() {
        return this._contentSize;
    }

    @Override
    public T getMetaData() {
        return this._metaData;
    }

    @Override
    public synchronized void remove() {
        this._metaData.dispose();
        this._metaData = null;
        if (this._content != null) {
            for (QpidByteBuffer content : this._content) {
                content.dispose();
            }
            this._content.clear();
        }
    }

    @Override
    public boolean isInMemory() {
        return true;
    }

    @Override
    public boolean flowToDisk() {
        return false;
    }

    public void clear() {
        this.remove();
    }
}

