/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import java.io.File;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.Event;
import org.apache.qpid.server.store.EventListener;
import org.apache.qpid.server.store.MessageHandle;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.store.Transaction;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.store.handler.DistributedTransactionHandler;
import org.apache.qpid.server.store.handler.MessageHandler;
import org.apache.qpid.server.store.handler.MessageInstanceHandler;

public interface MessageStore {
    public long getNextMessageId();

    public String getStoreLocation();

    public File getStoreLocationAsFile();

    public void addEventListener(EventListener var1, Event ... var2);

    public void openMessageStore(ConfiguredObject<?> var1);

    public void upgradeStoreStructure() throws StoreException;

    public <T extends StorableMessageMetaData> MessageHandle<T> addMessage(T var1);

    public long getBytesEvacuatedFromMemory();

    public boolean isPersistent();

    public Transaction newTransaction();

    public void closeMessageStore();

    public void onDelete(ConfiguredObject<?> var1);

    public MessageStoreReader newMessageStoreReader();

    public static interface MessageStoreReader {
        public void visitMessages(MessageHandler var1) throws StoreException;

        public void visitMessageInstances(MessageInstanceHandler var1) throws StoreException;

        public void visitMessageInstances(TransactionLogResource var1, MessageInstanceHandler var2) throws StoreException;

        public void visitDistributedTransactions(DistributedTransactionHandler var1) throws StoreException;

        public StoredMessage<?> getMessage(long var1);

        public void close();
    }
}

