/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.server.message.EnqueueableMessage;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.Event;
import org.apache.qpid.server.store.EventListener;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.MessageHandle;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.StoredMemoryMessage;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.store.Transaction;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.store.Xid;
import org.apache.qpid.server.store.handler.DistributedTransactionHandler;
import org.apache.qpid.server.store.handler.MessageHandler;
import org.apache.qpid.server.store.handler.MessageInstanceHandler;

public class MemoryMessageStore
implements MessageStore {
    public static final String TYPE = "Memory";
    private final AtomicLong _messageId = new AtomicLong(1L);
    private final ConcurrentMap<Long, StoredMemoryMessage> _messages = new ConcurrentHashMap<Long, StoredMemoryMessage>();
    private final Object _transactionLock = new Object();
    private final Map<UUID, Set<Long>> _messageInstances = new HashMap<UUID, Set<Long>>();
    private final Map<Xid, DistributedTransactionRecords> _distributedTransactions = new HashMap<Xid, DistributedTransactionRecords>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitTransactionInternal(MemoryMessageStoreTransaction transaction) {
        Object object = this._transactionLock;
        synchronized (object) {
            Set<Long> messageIds;
            for (Map.Entry localEnqueuedEntry : transaction._localEnqueueMap.entrySet()) {
                messageIds = this._messageInstances.get(localEnqueuedEntry.getKey());
                if (messageIds == null) {
                    messageIds = new HashSet<Long>();
                    this._messageInstances.put((UUID)localEnqueuedEntry.getKey(), messageIds);
                }
                messageIds.addAll((Collection)localEnqueuedEntry.getValue());
            }
            for (Map.Entry loacalDequeueEntry : transaction._localDequeueMap.entrySet()) {
                messageIds = this._messageInstances.get(loacalDequeueEntry.getKey());
                if (messageIds == null) continue;
                messageIds.removeAll((Collection)loacalDequeueEntry.getValue());
                if (!messageIds.isEmpty()) continue;
                this._messageInstances.remove(loacalDequeueEntry.getKey());
            }
            for (Map.Entry entry : transaction._localDistributedTransactionsRecords.entrySet()) {
                this._distributedTransactions.put((Xid)entry.getKey(), (DistributedTransactionRecords)entry.getValue());
            }
            for (Xid removed : transaction._localDistributedTransactionsRemoves) {
                this._distributedTransactions.remove(removed);
            }
        }
    }

    @Override
    public void openMessageStore(ConfiguredObject<?> parent) {
    }

    @Override
    public void upgradeStoreStructure() throws StoreException {
    }

    @Override
    public <T extends StorableMessageMetaData> MessageHandle<T> addMessage(T metaData) {
        long id = this.getNextMessageId();
        StoredMemoryMessage storedMemoryMessage = new StoredMemoryMessage<T>(id, metaData){

            @Override
            public void remove() {
                MemoryMessageStore.this._messages.remove(this.getMessageNumber());
                super.remove();
            }
        };
        return storedMemoryMessage;
    }

    @Override
    public long getNextMessageId() {
        return this._messageId.getAndIncrement();
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public long getBytesEvacuatedFromMemory() {
        return 0L;
    }

    @Override
    public Transaction newTransaction() {
        return new MemoryMessageStoreTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeMessageStore() {
        for (StoredMemoryMessage storedMemoryMessage : this._messages.values()) {
            storedMemoryMessage.clear();
        }
        this._messages.clear();
        Object object = this._transactionLock;
        synchronized (object) {
            this._messageInstances.clear();
            this._distributedTransactions.clear();
        }
    }

    @Override
    public void addEventListener(EventListener eventListener, Event ... events) {
    }

    @Override
    public String getStoreLocation() {
        return null;
    }

    @Override
    public File getStoreLocationAsFile() {
        return null;
    }

    @Override
    public void onDelete(ConfiguredObject<?> parent) {
    }

    @Override
    public MessageStore.MessageStoreReader newMessageStoreReader() {
        return new MemoryMessageStoreReader();
    }

    private class MemoryMessageStoreReader
    implements MessageStore.MessageStoreReader {
        private MemoryMessageStoreReader() {
        }

        @Override
        public StoredMessage<?> getMessage(long messageId) {
            return (StoredMessage)MemoryMessageStore.this._messages.get(messageId);
        }

        @Override
        public void close() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitMessageInstances(MessageInstanceHandler handler) throws StoreException {
            Object object = MemoryMessageStore.this._transactionLock;
            synchronized (object) {
                for (Map.Entry enqueuedEntry : MemoryMessageStore.this._messageInstances.entrySet()) {
                    UUID resourceId = (UUID)enqueuedEntry.getKey();
                    for (Long messageId : (Set)enqueuedEntry.getValue()) {
                        if (handler.handle(new MemoryEnqueueRecord(resourceId, messageId))) continue;
                        return;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitMessageInstances(TransactionLogResource queue, MessageInstanceHandler handler) throws StoreException {
            Object object = MemoryMessageStore.this._transactionLock;
            synchronized (object) {
                Set ids = (Set)MemoryMessageStore.this._messageInstances.get(queue.getId());
                if (ids != null) {
                    Iterator i$ = ids.iterator();
                    while (i$.hasNext()) {
                        long id = (Long)i$.next();
                        if (handler.handle(new MemoryEnqueueRecord(queue.getId(), id))) continue;
                        return;
                    }
                }
            }
        }

        @Override
        public void visitMessages(MessageHandler handler) throws StoreException {
            StoredMemoryMessage message;
            Iterator i$ = MemoryMessageStore.this._messages.values().iterator();
            while (i$.hasNext() && handler.handle(message = (StoredMemoryMessage)i$.next())) {
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitDistributedTransactions(DistributedTransactionHandler handler) throws StoreException {
            Object object = MemoryMessageStore.this._transactionLock;
            synchronized (object) {
                for (Map.Entry entry : MemoryMessageStore.this._distributedTransactions.entrySet()) {
                    Xid xid = (Xid)entry.getKey();
                    DistributedTransactionRecords records = (DistributedTransactionRecords)entry.getValue();
                    if (handler.handle(new MemoryStoredXidRecord(xid.getFormat(), xid.getGlobalId(), xid.getBranchId()), records.getEnqueues(), records.getDequeues())) continue;
                    break;
                }
            }
        }
    }

    private static class MemoryEnqueueRecord
    implements MessageEnqueueRecord {
        private final UUID _queueId;
        private final long _messageNumber;

        public MemoryEnqueueRecord(UUID queueId, long messageNumber) {
            this._queueId = queueId;
            this._messageNumber = messageNumber;
        }

        @Override
        public UUID getQueueId() {
            return this._queueId;
        }

        @Override
        public long getMessageNumber() {
            return this._messageNumber;
        }
    }

    private static final class DistributedTransactionRecords {
        private Transaction.EnqueueRecord[] _enqueues;
        private Transaction.DequeueRecord[] _dequeues;

        public DistributedTransactionRecords(Transaction.EnqueueRecord[] enqueues, Transaction.DequeueRecord[] dequeues) {
            this._enqueues = enqueues;
            this._dequeues = dequeues;
        }

        public Transaction.EnqueueRecord[] getEnqueues() {
            return this._enqueues;
        }

        public Transaction.DequeueRecord[] getDequeues() {
            return this._dequeues;
        }
    }

    private static class MemoryStoredXidRecord
    implements Transaction.StoredXidRecord {
        private final long _format;
        private final byte[] _globalId;
        private final byte[] _branchId;

        public MemoryStoredXidRecord(long format, byte[] globalId, byte[] branchId) {
            this._format = format;
            this._globalId = globalId;
            this._branchId = branchId;
        }

        @Override
        public long getFormat() {
            return this._format;
        }

        @Override
        public byte[] getGlobalId() {
            return this._globalId;
        }

        @Override
        public byte[] getBranchId() {
            return this._branchId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemoryStoredXidRecord that = (MemoryStoredXidRecord)o;
            return this._format == that._format && Arrays.equals(this._globalId, that._globalId) && Arrays.equals(this._branchId, that._branchId);
        }

        public int hashCode() {
            int result = (int)(this._format ^ this._format >>> 32);
            result = 31 * result + Arrays.hashCode(this._globalId);
            result = 31 * result + Arrays.hashCode(this._branchId);
            return result;
        }
    }

    private final class MemoryMessageStoreTransaction
    implements Transaction {
        private Map<UUID, Set<Long>> _localEnqueueMap = new HashMap<UUID, Set<Long>>();
        private Map<UUID, Set<Long>> _localDequeueMap = new HashMap<UUID, Set<Long>>();
        private Map<Xid, DistributedTransactionRecords> _localDistributedTransactionsRecords = new HashMap<Xid, DistributedTransactionRecords>();
        private Set<Xid> _localDistributedTransactionsRemoves = new HashSet<Xid>();

        private MemoryMessageStoreTransaction() {
        }

        @Override
        public <X> ListenableFuture<X> commitTranAsync(X val) {
            return Futures.immediateFuture(val);
        }

        @Override
        public MessageEnqueueRecord enqueueMessage(TransactionLogResource queue, EnqueueableMessage message) {
            Set<Long> messageIds;
            if (message.getStoredMessage() instanceof StoredMemoryMessage) {
                MemoryMessageStore.this._messages.putIfAbsent(message.getMessageNumber(), (StoredMemoryMessage)message.getStoredMessage());
            }
            if ((messageIds = this._localEnqueueMap.get(queue.getId())) == null) {
                messageIds = new HashSet<Long>();
                this._localEnqueueMap.put(queue.getId(), messageIds);
            }
            messageIds.add(message.getMessageNumber());
            return new MemoryEnqueueRecord(queue.getId(), message.getMessageNumber());
        }

        @Override
        public void dequeueMessage(MessageEnqueueRecord enqueueRecord) {
            this.dequeueMessage(enqueueRecord.getQueueId(), enqueueRecord.getMessageNumber());
        }

        private void dequeueMessage(UUID queueId, long messageNumber) {
            Set<Long> messageIds = this._localDequeueMap.get(queueId);
            if (messageIds == null) {
                messageIds = new HashSet<Long>();
                this._localDequeueMap.put(queueId, messageIds);
            }
            messageIds.add(messageNumber);
        }

        @Override
        public void commitTran() {
            MemoryMessageStore.this.commitTransactionInternal(this);
            this._localEnqueueMap.clear();
            this._localDequeueMap.clear();
        }

        @Override
        public void abortTran() {
            this._localEnqueueMap.clear();
            this._localDequeueMap.clear();
        }

        @Override
        public void removeXid(Transaction.StoredXidRecord record) {
            this._localDistributedTransactionsRemoves.add(new Xid(record.getFormat(), record.getGlobalId(), record.getBranchId()));
        }

        @Override
        public Transaction.StoredXidRecord recordXid(long format, byte[] globalId, byte[] branchId, Transaction.EnqueueRecord[] enqueues, Transaction.DequeueRecord[] dequeues) {
            this._localDistributedTransactionsRecords.put(new Xid(format, globalId, branchId), new DistributedTransactionRecords(enqueues, dequeues));
            return new MemoryStoredXidRecord(format, globalId, branchId);
        }
    }
}

