/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;

public class JdbcUtils {
    public static void closeConnection(Connection conn, Logger logger) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                logger.error("Problem closing connection", (Throwable)e);
            }
        }
    }

    public static void closePreparedStatement(PreparedStatement stmt, Logger logger) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                logger.error("Problem closing prepared statement", (Throwable)e);
            }
        }
    }

    public static boolean tableExists(String tableName, Connection conn) throws SQLException {
        DatabaseMetaData metaData = conn.getMetaData();
        return JdbcUtils.tableExistsCase(tableName.toUpperCase(), metaData) || JdbcUtils.tableExistsCase(tableName.toLowerCase(), metaData) || !tableName.equals(tableName.toUpperCase()) && !tableName.equals(tableName.toLowerCase()) && JdbcUtils.tableExistsCase(tableName, metaData);
    }

    private static boolean tableExistsCase(String tableName, DatabaseMetaData metaData) throws SQLException {
        try (ResultSet rs = metaData.getTables(null, null, tableName, null);){
            boolean bl = rs.next();
            return bl;
        }
    }
}

