/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.DurableConfigurationStoreUpgrader;
import org.apache.qpid.server.store.NullUpgrader;
import org.apache.qpid.server.store.StoreUpgraderPhase;
import org.apache.qpid.server.store.handler.ConfiguredObjectRecordHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericStoreUpgrader {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericStoreUpgrader.class);
    private final Map<UUID, ConfiguredObjectRecord> _records = new HashMap<UUID, ConfiguredObjectRecord>();
    private final Map<String, StoreUpgraderPhase> _upgraders;
    private final DurableConfigurationStore _store;
    private final String _rootCategory;
    private final String _modelVersionAttributeName;

    public GenericStoreUpgrader(String rootCategory, String rootModelVersionAttributeName, DurableConfigurationStore configurationStore, Map<String, StoreUpgraderPhase> upgraders) {
        this._upgraders = upgraders;
        this._store = configurationStore;
        this._rootCategory = rootCategory;
        this._modelVersionAttributeName = rootModelVersionAttributeName;
    }

    public List<ConfiguredObjectRecord> getRecords() {
        return new ArrayList<ConfiguredObjectRecord>(this._records.values());
    }

    public void upgrade(List<ConfiguredObjectRecord> records) {
        this._records.clear();
        for (ConfiguredObjectRecord record : records) {
            this._records.put(record.getId(), record);
        }
        this.performUpgrade();
    }

    private void performUpgrade() {
        String version = this.getCurrentVersion();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(this._rootCategory + " store has model version " + version + ". Number of record(s) " + this._records.size());
        }
        DurableConfigurationStoreUpgrader upgrader = this.buildUpgraderChain(version);
        for (ConfiguredObjectRecord record : this._records.values()) {
            upgrader.configuredObject(record);
        }
        upgrader.complete();
        Map<UUID, ConfiguredObjectRecord> deletedRecords = upgrader.getDeletedRecords();
        Map<UUID, ConfiguredObjectRecord> updatedRecords = upgrader.getUpdatedRecords();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this._rootCategory + " store upgrade is about to complete. " + this._records.size() + " total record(s)." + " Records to update " + updatedRecords.size() + " Records to delete " + deletedRecords.size());
        }
        this._store.update(true, updatedRecords.values().toArray(new ConfiguredObjectRecord[updatedRecords.size()]));
        this._store.remove(deletedRecords.values().toArray(new ConfiguredObjectRecord[deletedRecords.size()]));
        this._records.keySet().removeAll(deletedRecords.keySet());
        this._records.putAll(updatedRecords);
    }

    private DurableConfigurationStoreUpgrader buildUpgraderChain(String version) {
        DurableConfigurationStoreUpgrader head = null;
        while (!"6.1".equals(version)) {
            StoreUpgraderPhase upgrader;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Adding " + this._rootCategory + " store upgrader from model version: " + version);
            }
            if ((upgrader = this._upgraders.get(version)) == null) {
                throw new IllegalConfigurationException("No phase upgrader for version " + version);
            }
            if (head == null) {
                head = upgrader;
            } else {
                head.setNextUpgrader(upgrader);
            }
            version = upgrader.getToVersion();
        }
        if (head == null) {
            head = new NullUpgrader();
        } else {
            head.setNextUpgrader(new NullUpgrader());
        }
        return head;
    }

    private String getCurrentVersion() {
        for (ConfiguredObjectRecord record : this._records.values()) {
            if (!this._rootCategory.equals(record.getType())) continue;
            return (String)record.getAttributes().get(this._modelVersionAttributeName);
        }
        return "6.1";
    }

    private class RecordCollectionHandler
    implements ConfiguredObjectRecordHandler {
        private RecordCollectionHandler() {
        }

        @Override
        public void handle(ConfiguredObjectRecord record) {
            GenericStoreUpgrader.this._records.put(record.getId(), record);
        }
    }
}

