/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.store.Event;
import org.apache.qpid.server.store.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManager {
    private Map<Event, List<EventListener>> _listeners = new EnumMap<Event, List<EventListener>>(Event.class);
    private static final Logger _LOGGER = LoggerFactory.getLogger(EventManager.class);

    public synchronized void addEventListener(EventListener listener, Event ... events) {
        for (Event event : events) {
            List<EventListener> list = this._listeners.get((Object)event);
            if (list == null) {
                list = new ArrayList<EventListener>();
                this._listeners.put(event, list);
            }
            list.add(listener);
        }
    }

    public synchronized void notifyEvent(Event event) {
        if (this._listeners.containsKey((Object)event)) {
            if (_LOGGER.isDebugEnabled()) {
                _LOGGER.debug("Received event " + (Object)((Object)event));
            }
            for (EventListener listener : this._listeners.get((Object)event)) {
                listener.event(event);
            }
        }
    }

    public synchronized boolean hasListeners(Event event) {
        return this._listeners.containsKey((Object)event);
    }
}

