/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.store.StoreConfigurationChangeListener;
import org.apache.qpid.server.logging.LogLevel;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ContainerStoreUpgraderAndRecoverer;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.ConfiguredObjectRecordImpl;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.GenericRecoverer;
import org.apache.qpid.server.store.GenericStoreUpgrader;
import org.apache.qpid.server.store.StoreUpgraderPhase;
import org.apache.qpid.server.util.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerStoreUpgraderAndRecoverer
implements ContainerStoreUpgraderAndRecoverer<Broker> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrokerStoreUpgraderAndRecoverer.class);
    public static final String VIRTUALHOSTS = "virtualhosts";
    private final SystemConfig<?> _systemConfig;
    private final Map<String, StoreUpgraderPhase> _upgraders = new HashMap<String, StoreUpgraderPhase>();

    public BrokerStoreUpgraderAndRecoverer(SystemConfig<?> systemConfig) {
        this._systemConfig = systemConfig;
        this.register(new Upgrader_1_0_to_1_1());
        this.register(new Upgrader_1_1_to_1_2());
        this.register(new Upgrader_1_2_to_1_3());
        this.register(new Upgrader_1_3_to_2_0());
        this.register(new Upgrader_2_0_to_3_0());
        this.register(new Upgrader_3_0_to_6_0());
        this.register(new Upgrader_6_0_to_6_1());
    }

    private void register(StoreUpgraderPhase upgrader) {
        this._upgraders.put(upgrader.getFromVersion(), upgrader);
    }

    private static AttributeTransformer copyAttribute() {
        return CopyAttribute.INSTANCE;
    }

    private static AttributeTransformer mutateAttributeName(String newName) {
        return new MutateAttributeName(newName);
    }

    private static AttributeTransformer addContextVar(String newName) {
        return new AddContextVar(newName);
    }

    private static ConfiguredObjectRecord createVirtualHostsRecordsFromBrokerRecordForModel_1_x(ConfiguredObjectRecord brokerRecord, StoreUpgraderPhase upgrader) {
        Map<String, Object> attributes = brokerRecord.getAttributes();
        if (attributes.containsKey(VIRTUALHOSTS) && attributes.get(VIRTUALHOSTS) instanceof Collection) {
            Collection virtualHosts = (Collection)attributes.get(VIRTUALHOSTS);
            for (Object virtualHost : virtualHosts) {
                UUID id;
                if (!(virtualHost instanceof Map)) continue;
                HashMap<String, Object> virtualHostAttributes = (HashMap<String, Object>)virtualHost;
                if (virtualHostAttributes.containsKey("configPath")) {
                    throw new IllegalConfigurationException("Auto-upgrade of virtual host " + attributes.get("name") + " having XML configuration is not supported. Virtual host configuration file is " + attributes.get("configPath"));
                }
                virtualHostAttributes = new HashMap<String, Object>(virtualHostAttributes);
                Object nameAttribute = virtualHostAttributes.get("name");
                Object idAttribute = virtualHostAttributes.remove("id");
                if (idAttribute == null) {
                    id = UUID.randomUUID();
                } else if (idAttribute instanceof String) {
                    id = UUID.fromString((String)idAttribute);
                } else if (idAttribute instanceof UUID) {
                    id = (UUID)idAttribute;
                } else {
                    throw new IllegalConfigurationException("Illegal ID value '" + idAttribute + "' for virtual host " + nameAttribute);
                }
                ConfiguredObjectRecordImpl nodeRecord = new ConfiguredObjectRecordImpl(id, "VirtualHost", virtualHostAttributes, Collections.singletonMap("Broker", brokerRecord.getId()));
                upgrader.getUpdateMap().put(nodeRecord.getId(), nodeRecord);
                upgrader.configuredObject(nodeRecord);
            }
            attributes = new HashMap<String, Object>(attributes);
            attributes.remove(VIRTUALHOSTS);
            brokerRecord = new ConfiguredObjectRecordImpl(brokerRecord.getId(), brokerRecord.getType(), attributes, brokerRecord.getParents());
            upgrader.getUpdateMap().put(brokerRecord.getId(), brokerRecord);
        }
        return brokerRecord;
    }

    @Override
    public Broker<?> upgradeAndRecover(List<ConfiguredObjectRecord> records) {
        DurableConfigurationStore store = this._systemConfig.getConfigurationStore();
        List<ConfiguredObjectRecord> upgradedRecords = this.upgrade(store, records);
        new GenericRecoverer(this._systemConfig).recover(upgradedRecords, false);
        final StoreConfigurationChangeListener configChangeListener = new StoreConfigurationChangeListener(store);
        this.applyRecursively(this._systemConfig.getChild(Broker.class), new RecursiveAction<ConfiguredObject<?>>(){

            @Override
            public void performAction(ConfiguredObject<?> object) {
                object.addChangeListener(configChangeListener);
            }

            @Override
            public boolean applyToChildren(ConfiguredObject<?> object) {
                return !object.managesChildStorage();
            }
        });
        return this._systemConfig.getChild(Broker.class);
    }

    List<ConfiguredObjectRecord> upgrade(DurableConfigurationStore store, List<ConfiguredObjectRecord> records) {
        GenericStoreUpgrader upgrader = new GenericStoreUpgrader(Broker.class.getSimpleName(), "modelVersion", store, this._upgraders);
        upgrader.upgrade(records);
        return upgrader.getRecords();
    }

    private void applyRecursively(ConfiguredObject<?> object, RecursiveAction<ConfiguredObject<?>> action) {
        this.applyRecursively(object, action, new HashSet());
    }

    private void applyRecursively(ConfiguredObject<?> object, RecursiveAction<ConfiguredObject<?>> action, HashSet<ConfiguredObject<?>> visited) {
        if (!visited.contains(object)) {
            visited.add(object);
            action.performAction(object);
            if (action.applyToChildren(object)) {
                for (Class<? extends ConfiguredObject> childClass : object.getModel().getChildTypes(object.getCategoryClass())) {
                    Collection<? extends ConfiguredObject> children = object.getChildren(childClass);
                    if (children == null) continue;
                    for (ConfiguredObject configuredObject : children) {
                        this.applyRecursively(configuredObject, action, visited);
                    }
                }
            }
        }
    }

    private static interface RecursiveAction<C>
    extends Action<C> {
        public boolean applyToChildren(C var1);
    }

    private static class MutableEntry {
        private String _key;
        private Object _value;

        public MutableEntry(String key, Object value) {
            this._key = key;
            this._value = value;
        }

        public String getKey() {
            return this._key;
        }

        public void setKey(String key) {
            this._key = key;
        }

        public Object getValue() {
            return this._value;
        }
    }

    private static class MutateAttributeName
    implements AttributeTransformer {
        private final String _newName;

        public MutateAttributeName(String newName) {
            this._newName = newName;
        }

        @Override
        public MutableEntry transform(MutableEntry entry) {
            entry.setKey(this._newName);
            return entry;
        }
    }

    private static class AddContextVar
    implements AttributeTransformer {
        private final String _newName;

        public AddContextVar(String newName) {
            this._newName = newName;
        }

        @Override
        public MutableEntry transform(MutableEntry entry) {
            return new MutableEntry("context", Collections.singletonMap(this._newName, entry.getValue()));
        }
    }

    private static class CopyAttribute
    implements AttributeTransformer {
        private static final CopyAttribute INSTANCE = new CopyAttribute();

        private CopyAttribute() {
        }

        @Override
        public MutableEntry transform(MutableEntry entry) {
            return entry;
        }
    }

    private static interface AttributeTransformer {
        public MutableEntry transform(MutableEntry var1);
    }

    private static class AttributesTransformer {
        private final Map<String, List<AttributeTransformer>> _transformers = new HashMap<String, List<AttributeTransformer>>();

        private AttributesTransformer() {
        }

        public AttributesTransformer addAttributeTransformer(String string, AttributeTransformer ... attributeTransformers) {
            this._transformers.put(string, Arrays.asList(attributeTransformers));
            return this;
        }

        public Map<String, Object> upgrade(Map<String, Object> attributes) {
            HashMap<String, Object> settings = new HashMap<String, Object>();
            for (Map.Entry<String, List<AttributeTransformer>> entry : this._transformers.entrySet()) {
                AttributeTransformer attributeTransformer;
                String attributeName = entry.getKey();
                if (!attributes.containsKey(attributeName)) continue;
                Object attributeValue = attributes.get(attributeName);
                MutableEntry newEntry = new MutableEntry(attributeName, attributeValue);
                List<AttributeTransformer> transformers = entry.getValue();
                Iterator<AttributeTransformer> i$ = transformers.iterator();
                while (i$.hasNext() && (newEntry = (attributeTransformer = i$.next()).transform(newEntry)) != null) {
                }
                if (newEntry == null) continue;
                if (settings.get(newEntry.getKey()) instanceof Map && newEntry.getValue() instanceof Map) {
                    Map newMap = (Map)newEntry.getValue();
                    HashMap mergedMap = new HashMap((Map)settings.get(newEntry.getKey()));
                    mergedMap.putAll(newMap);
                    settings.put(newEntry.getKey(), mergedMap);
                    continue;
                }
                settings.put(newEntry.getKey(), newEntry.getValue());
            }
            return settings;
        }
    }

    private static class VirtualHostEntryUpgrader {
        Map<String, AttributesTransformer> _messageStoreToNodeTransformers = new HashMap<String, AttributesTransformer>(){
            {
                this.put("DERBY", new AttributesTransformer().addAttributeTransformer("id", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("name", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("createdTime", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("createdBy", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("storePath", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("storeUnderfullSize", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("storeOverfullSize", BrokerStoreUpgraderAndRecoverer.copyAttribute()));
                this.put("Memory", new AttributesTransformer().addAttributeTransformer("id", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("name", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("createdTime", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("createdBy", BrokerStoreUpgraderAndRecoverer.copyAttribute()));
                this.put("BDB", new AttributesTransformer().addAttributeTransformer("id", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("name", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("createdTime", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("createdBy", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("storePath", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("storeUnderfullSize", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("storeOverfullSize", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("bdbEnvironmentConfig", BrokerStoreUpgraderAndRecoverer.mutateAttributeName("context")));
                this.put("JDBC", new AttributesTransformer().addAttributeTransformer("id", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("name", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("createdTime", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("createdBy", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("storePath", BrokerStoreUpgraderAndRecoverer.mutateAttributeName("connectionURL")).addAttributeTransformer("connectionURL", BrokerStoreUpgraderAndRecoverer.mutateAttributeName("connectionUrl")).addAttributeTransformer("connectionPool", new AttributeTransformer(){

                    @Override
                    public MutableEntry transform(MutableEntry entry) {
                        Object value = entry.getValue();
                        if ("DEFAULT".equals(value)) {
                            value = "NONE";
                        }
                        return new MutableEntry("connectionPoolType", value);
                    }
                }).addAttributeTransformer("jdbcBigIntType", BrokerStoreUpgraderAndRecoverer.addContextVar("qpid.jdbcstore.bigIntType")).addAttributeTransformer("jdbcBytesForBlob", BrokerStoreUpgraderAndRecoverer.addContextVar("qpid.jdbcstore.useBytesForBlob")).addAttributeTransformer("jdbcBlobType", BrokerStoreUpgraderAndRecoverer.addContextVar("qpid.jdbcstore.blobType")).addAttributeTransformer("jdbcVarbinaryType", BrokerStoreUpgraderAndRecoverer.addContextVar("qpid.jdbcstore.varBinaryType")).addAttributeTransformer("partitionCount", BrokerStoreUpgraderAndRecoverer.addContextVar("qpid.jdbcstore.bonecp.partitionCount")).addAttributeTransformer("maxConnectionsPerPartition", BrokerStoreUpgraderAndRecoverer.addContextVar("qpid.jdbcstore.bonecp.maxConnectionsPerPartition")).addAttributeTransformer("minConnectionsPerPartition", BrokerStoreUpgraderAndRecoverer.addContextVar("qpid.jdbcstore.bonecp.minConnectionsPerPartition")));
                this.put("BDB_HA", new AttributesTransformer().addAttributeTransformer("id", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("createdTime", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("createdBy", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("storePath", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("storeUnderfullSize", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("storeOverfullSize", BrokerStoreUpgraderAndRecoverer.copyAttribute()).addAttributeTransformer("haNodeName", BrokerStoreUpgraderAndRecoverer.mutateAttributeName("name")).addAttributeTransformer("haGroupName", BrokerStoreUpgraderAndRecoverer.mutateAttributeName("groupName")).addAttributeTransformer("haHelperAddress", BrokerStoreUpgraderAndRecoverer.mutateAttributeName("helperAddress")).addAttributeTransformer("haNodeAddress", BrokerStoreUpgraderAndRecoverer.mutateAttributeName("address")).addAttributeTransformer("haDesignatedPrimary", BrokerStoreUpgraderAndRecoverer.mutateAttributeName("designatedPrimary")).addAttributeTransformer("haReplicationConfig", BrokerStoreUpgraderAndRecoverer.mutateAttributeName("context")).addAttributeTransformer("bdbEnvironmentConfig", BrokerStoreUpgraderAndRecoverer.mutateAttributeName("context")));
            }
        };

        private VirtualHostEntryUpgrader() {
        }

        public ConfiguredObjectRecord upgrade(ConfiguredObjectRecord vhost) {
            Map<String, Object> attributes = vhost.getAttributes();
            String type = (String)attributes.get("type");
            AttributesTransformer nodeAttributeTransformer = null;
            if ("STANDARD".equalsIgnoreCase(type)) {
                if (attributes.containsKey("configStoreType")) {
                    throw new IllegalConfigurationException("Auto-upgrade of virtual host " + attributes.get("name") + " with split configuration and message store is not supported." + " Configuration store type is " + attributes.get("configStoreType") + " and message store type is " + attributes.get("storeType"));
                }
                type = (String)attributes.get("storeType");
            }
            if (type == null) {
                throw new IllegalConfigurationException("Cannot auto-upgrade virtual host with attributes: " + attributes);
            }
            nodeAttributeTransformer = this._messageStoreToNodeTransformers.get(type = this.getVirtualHostNodeType(type));
            if (nodeAttributeTransformer == null) {
                throw new IllegalConfigurationException("Don't know how to perform an upgrade from version for virtualhost type " + type);
            }
            Map<String, Object> nodeAttributes = nodeAttributeTransformer.upgrade(attributes);
            nodeAttributes.put("type", type);
            return new ConfiguredObjectRecordImpl(vhost.getId(), "VirtualHostNode", nodeAttributes, vhost.getParents());
        }

        private String getVirtualHostNodeType(String type) {
            for (String t : this._messageStoreToNodeTransformers.keySet()) {
                if (!type.equalsIgnoreCase(t)) continue;
                return t;
            }
            return null;
        }
    }

    private class Upgrader_6_0_to_6_1
    extends StoreUpgraderPhase {
        private boolean _hasAcl;
        private UUID _rootRecordId;

        public Upgrader_6_0_to_6_1() {
            super("modelVersion", "6.0", "6.1");
            this._hasAcl = false;
        }

        @Override
        public void configuredObject(ConfiguredObjectRecord record) {
            if (record.getType().equals("Broker")) {
                record = this.upgradeRootRecord(record);
                this._rootRecordId = record.getId();
                this.getNextUpgrader().configuredObject(record);
            } else if (record.getType().equals("TrustStore")) {
                this.upgradeTrustStore(record);
            } else {
                Map<String, Object> attributes = record.getAttributes();
                String type = (String)attributes.get("type");
                if (record.getType().equals("Plugin") && "MANAGEMENT-JMX".equals(type)) {
                    this.getDeleteMap().put(record.getId(), record);
                } else if (record.getType().equals("Port")) {
                    Object protocols = attributes.get("protocols");
                    if (protocols instanceof Collection && (((Collection)protocols).contains("RMI") || ((Collection)protocols).contains("JMX_RMI")) || "JMX".equals(type) || "RMI".equals(type)) {
                        this.getDeleteMap().put(record.getId(), record);
                    } else {
                        this.getNextUpgrader().configuredObject(record);
                    }
                } else if (record.getType().equals("AuthenticationProvider") && attributes.containsKey("preferencesproviders")) {
                    LinkedHashMap<String, Object> updatedAttributes = new LinkedHashMap<String, Object>(attributes);
                    updatedAttributes.remove("preferencesproviders");
                    record = new ConfiguredObjectRecordImpl(record.getId(), record.getType(), updatedAttributes, record.getParents());
                    this.getUpdateMap().put(record.getId(), record);
                    this.getNextUpgrader().configuredObject(record);
                } else if (record.getType().equals("PreferencesProvider")) {
                    this.getDeleteMap().put(record.getId(), record);
                } else {
                    this.getNextUpgrader().configuredObject(record);
                }
            }
        }

        private void upgradeTrustStore(ConfiguredObjectRecord record) {
            LinkedHashMap<String, Object> updatedAttributes = new LinkedHashMap<String, Object>(record.getAttributes());
            if (updatedAttributes.containsKey("includedVirtualHostMessageSources") || updatedAttributes.containsKey("excludedVirtualHostMessageSources")) {
                if (updatedAttributes.containsKey("includedVirtualHostMessageSources")) {
                    LOGGER.warn("Detected 'includedVirtualHostMessageSources' attribute during upgrade. Starting with version 6.1 this attribute has been replaced with 'includedVirtualHostNodeMessageSources'. The upgrade is automatic but assumes that the VirtualHostNode has the same name as the VirtualHost. Assumed name: '{}'", updatedAttributes.get("includedVirtualHostMessageSources"));
                    updatedAttributes.put("includedVirtualHostNodeMessageSources", updatedAttributes.get("includedVirtualHostMessageSources"));
                    updatedAttributes.remove("includedVirtualHostMessageSources");
                }
                if (updatedAttributes.containsKey("excludedVirtualHostMessageSources")) {
                    LOGGER.warn("Detected 'excludedVirtualHostMessageSources' attribute during upgrade. Starting with version 6.1 this attribute has been replaced with 'excludedVirtualHostNodeMessageSources'. The upgrade is automatic but assumes that the VirtualHostNode has the same name as the VirtualHost. Assumed name: '{}'", updatedAttributes.get("excludedVirtualHostMessageSources"));
                    updatedAttributes.put("excludedVirtualHostNodeMessageSources", updatedAttributes.get("excludedVirtualHostMessageSources"));
                    updatedAttributes.remove("excludedVirtualHostMessageSources");
                }
                record = new ConfiguredObjectRecordImpl(record.getId(), record.getType(), updatedAttributes, record.getParents());
                this.getUpdateMap().put(record.getId(), record);
            }
            this.getNextUpgrader().configuredObject(record);
        }

        @Override
        public void complete() {
            if (!this._hasAcl) {
                UUID allowAllACLId = UUID.randomUUID();
                HashMap<String, Object> attrs = new HashMap<String, Object>();
                attrs.put("name", "AllowAll");
                attrs.put("type", "AllowAll");
                attrs.put("priority", 9999);
                ConfiguredObjectRecordImpl allowAllAclRecord = new ConfiguredObjectRecordImpl(allowAllACLId, "AccessControlProvider", attrs, Collections.singletonMap("Broker", this._rootRecordId));
                this.getUpdateMap().put(allowAllAclRecord.getId(), allowAllAclRecord);
                this.getNextUpgrader().configuredObject(allowAllAclRecord);
            }
            this.getNextUpgrader().complete();
        }
    }

    private class Upgrader_3_0_to_6_0
    extends StoreUpgraderPhase {
        private String _defaultVirtualHost;
        private final Set<ConfiguredObjectRecord> _knownBdbHaVirtualHostNode;
        private final Map<String, ConfiguredObjectRecord> _knownNonBdbHaVirtualHostNode;

        public Upgrader_3_0_to_6_0() {
            super("modelVersion", "3.0", "6.0");
            this._knownBdbHaVirtualHostNode = new HashSet<ConfiguredObjectRecord>();
            this._knownNonBdbHaVirtualHostNode = new HashMap<String, ConfiguredObjectRecord>();
        }

        @Override
        public void configuredObject(ConfiguredObjectRecord record) {
            HashMap<String, Object> updatedAttributes;
            if (record.getType().equals("Broker")) {
                boolean typeDetected;
                record = this.upgradeRootRecord(record);
                HashMap<String, Object> brokerAttributes = new HashMap<String, Object>(record.getAttributes());
                this._defaultVirtualHost = (String)brokerAttributes.remove("defaultVirtualHost");
                boolean bl = typeDetected = brokerAttributes.remove("type") != null;
                if (this._defaultVirtualHost != null || typeDetected) {
                    record = new ConfiguredObjectRecordImpl(record.getId(), record.getType(), brokerAttributes, record.getParents());
                    this.getUpdateMap().put(record.getId(), record);
                }
                this.addLogger(record, "memory", "Memory");
                this.addLogger(record, "logfile", "File");
            } else if (record.getType().equals("VirtualHostNode")) {
                if ("BDB_HA".equals(record.getAttributes().get("type"))) {
                    this._knownBdbHaVirtualHostNode.add(record);
                } else {
                    String nodeName = (String)record.getAttributes().get("name");
                    this._knownNonBdbHaVirtualHostNode.put(nodeName, record);
                }
            } else if (record.getType().equals("Port") && "AMQP".equals(record.getAttributes().get("type")) && ((updatedAttributes = new HashMap<String, Object>(record.getAttributes())).containsKey("receiveBufferSize") || updatedAttributes.containsKey("sendBufferSize"))) {
                updatedAttributes.remove("receiveBufferSize");
                updatedAttributes.remove("sendBufferSize");
                record = new ConfiguredObjectRecordImpl(record.getId(), record.getType(), updatedAttributes, record.getParents());
                this.getUpdateMap().put(record.getId(), record);
            }
            this.getNextUpgrader().configuredObject(record);
        }

        private void addLogger(ConfiguredObjectRecord record, String name, String type) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("name", name);
            attributes.put("type", type);
            ConfiguredObjectRecordImpl logger = new ConfiguredObjectRecordImpl(UUID.randomUUID(), "BrokerLogger", attributes, Collections.singletonMap("Broker", record.getId()));
            this.addNameValueFilter("Root", logger, LogLevel.WARN, "ROOT");
            this.addNameValueFilter("Qpid", logger, LogLevel.INFO, "org.apache.qpid.*");
            this.addNameValueFilter("Operational", logger, LogLevel.INFO, "qpid.message.*");
            this.getUpdateMap().put(logger.getId(), logger);
            this.getNextUpgrader().configuredObject(logger);
        }

        private void addNameValueFilter(String inclusionRuleName, ConfiguredObjectRecord loggerRecord, LogLevel level, String loggerName) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("name", inclusionRuleName);
            attributes.put("level", level.name());
            attributes.put("loggerName", loggerName);
            attributes.put("type", "NameAndLevel");
            ConfiguredObjectRecordImpl filterRecord = new ConfiguredObjectRecordImpl(UUID.randomUUID(), "BrokerLogInclusionRule", attributes, Collections.singletonMap("BrokerLogger", loggerRecord.getId()));
            this.getUpdateMap().put(filterRecord.getId(), filterRecord);
            this.getNextUpgrader().configuredObject(filterRecord);
        }

        @Override
        public void complete() {
            if (this._defaultVirtualHost != null) {
                ConfiguredObjectRecord defaultVirtualHostNode;
                if (this._knownNonBdbHaVirtualHostNode.containsKey(this._defaultVirtualHost)) {
                    defaultVirtualHostNode = this._knownNonBdbHaVirtualHostNode.get(this._defaultVirtualHost);
                } else if (this._knownBdbHaVirtualHostNode.size() == 1) {
                    defaultVirtualHostNode = this._knownBdbHaVirtualHostNode.iterator().next();
                } else {
                    LOGGER.warn("Unable to identify the target virtual host node for old default virtualhost name : '{}'", (Object)this._defaultVirtualHost);
                    defaultVirtualHostNode = null;
                }
                if (defaultVirtualHostNode != null) {
                    HashMap<String, Object> updatedAttributes = new HashMap<String, Object>(defaultVirtualHostNode.getAttributes());
                    updatedAttributes.put("defaultVirtualHostNode", "true");
                    ConfiguredObjectRecordImpl updateRecord = new ConfiguredObjectRecordImpl(defaultVirtualHostNode.getId(), defaultVirtualHostNode.getType(), updatedAttributes, defaultVirtualHostNode.getParents());
                    this.getUpdateMap().put(updateRecord.getId(), updateRecord);
                }
            }
            this.getNextUpgrader().complete();
        }
    }

    private class Upgrader_2_0_to_3_0
    extends StoreUpgraderPhase {
        public Upgrader_2_0_to_3_0() {
            super("modelVersion", "2.0", "3.0");
        }

        @Override
        public void configuredObject(ConfiguredObjectRecord record) {
            if (record.getType().equals("Port") && this.isAmqpPort(record.getAttributes())) {
                this.createAliasRecord(record, "nameAlias", "nameAlias");
                this.createAliasRecord(record, "defaultAlias", "defaultAlias");
                this.createAliasRecord(record, "hostnameAlias", "hostnameAlias");
            } else if (record.getType().equals("User") && "scram".equals(record.getAttributes().get("type"))) {
                HashMap<String, Object> updatedAttributes = new HashMap<String, Object>(record.getAttributes());
                updatedAttributes.put("type", "managed");
                record = new ConfiguredObjectRecordImpl(record.getId(), record.getType(), updatedAttributes, record.getParents());
                this.getUpdateMap().put(record.getId(), record);
            } else if (record.getType().equals("Broker")) {
                record = this.upgradeRootRecord(record);
            } else if ("KeyStore".equals(record.getType())) {
                record = this.upgradeKeyStoreRecordIfTypeTheSame(record, "FileKeyStore");
            } else if ("TrustStore".equals(record.getType())) {
                record = this.upgradeKeyStoreRecordIfTypeTheSame(record, "FileTrustStore");
            }
            this.getNextUpgrader().configuredObject(record);
        }

        private ConfiguredObjectRecord upgradeKeyStoreRecordIfTypeTheSame(ConfiguredObjectRecord record, String expectedType) {
            HashMap<String, Object> attributes = new HashMap<String, Object>(record.getAttributes());
            if (!attributes.containsKey("type")) {
                attributes.put("type", expectedType);
            }
            if (expectedType.equals(attributes.get("type"))) {
                Object path = attributes.remove("path");
                attributes.put("storeUrl", path);
                record = new ConfiguredObjectRecordImpl(record.getId(), record.getType(), attributes, record.getParents());
                this.getUpdateMap().put(record.getId(), record);
            }
            return record;
        }

        private boolean isAmqpPort(Map<String, Object> attributes) {
            Object type = attributes.get("type");
            Object protocols = attributes.get("protocols");
            String protocolString = protocols == null ? null : protocols.toString();
            return "AMQP".equals(type) || (type == null || "".equals(type.toString().trim())) && (protocolString == null || !protocolString.matches(".*\\w.*") || protocolString.contains("AMQP"));
        }

        private void createAliasRecord(ConfiguredObjectRecord parent, String name, String type) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("name", name);
            attributes.put("type", type);
            ConfiguredObjectRecordImpl record = new ConfiguredObjectRecordImpl(UUID.randomUUID(), "VirtualHostAlias", attributes, Collections.singletonMap("Port", parent.getId()));
            this.getUpdateMap().put(record.getId(), record);
            this.getNextUpgrader().configuredObject(record);
        }

        @Override
        public void complete() {
            this.getNextUpgrader().complete();
        }
    }

    private static final class Upgrader_1_3_to_2_0
    extends StoreUpgraderPhase {
        private final VirtualHostEntryUpgrader _virtualHostUpgrader = new VirtualHostEntryUpgrader();

        private Upgrader_1_3_to_2_0() {
            super("modelVersion", "1.3", "2.0");
        }

        @Override
        public void configuredObject(ConfiguredObjectRecord record) {
            if (record.getType().equals("VirtualHost")) {
                Map<String, Object> attributes = record.getAttributes();
                if (attributes.containsKey("configPath")) {
                    throw new IllegalConfigurationException("Auto-upgrade of virtual host " + attributes.get("name") + " having XML configuration is not supported. Virtual host configuration file is " + attributes.get("configPath"));
                }
                record = this._virtualHostUpgrader.upgrade(record);
                this.getUpdateMap().put(record.getId(), record);
            } else if (record.getType().equals("Plugin") && record.getAttributes().containsKey("pluginType")) {
                HashMap<String, Object> updatedAttributes = new HashMap<String, Object>(record.getAttributes());
                updatedAttributes.put("type", updatedAttributes.remove("pluginType"));
                record = new ConfiguredObjectRecordImpl(record.getId(), record.getType(), updatedAttributes, record.getParents());
                this.getUpdateMap().put(record.getId(), record);
            } else if (record.getType().equals("Broker")) {
                record = this.upgradeRootRecord(record);
                record = BrokerStoreUpgraderAndRecoverer.createVirtualHostsRecordsFromBrokerRecordForModel_1_x(record, this);
            }
            this.getNextUpgrader().configuredObject(record);
        }

        @Override
        public void complete() {
            this.getNextUpgrader().complete();
        }
    }

    private static final class Upgrader_1_2_to_1_3
    extends StoreUpgraderPhase {
        private Upgrader_1_2_to_1_3() {
            super("modelVersion", "1.2", "1.3");
        }

        @Override
        public void configuredObject(ConfiguredObjectRecord record) {
            if (record.getType().equals("TrustStore") && record.getAttributes().containsKey("type")) {
                HashMap<String, Object> updatedAttributes = new HashMap<String, Object>(record.getAttributes());
                updatedAttributes.put("trustStoreType", updatedAttributes.remove("type"));
                record = new ConfiguredObjectRecordImpl(record.getId(), record.getType(), updatedAttributes, record.getParents());
                this.getUpdateMap().put(record.getId(), record);
            } else if (record.getType().equals("KeyStore") && record.getAttributes().containsKey("type")) {
                HashMap<String, Object> updatedAttributes = new HashMap<String, Object>(record.getAttributes());
                updatedAttributes.put("keyStoreType", updatedAttributes.remove("type"));
                record = new ConfiguredObjectRecordImpl(record.getId(), record.getType(), updatedAttributes, record.getParents());
                this.getUpdateMap().put(record.getId(), record);
            } else if (record.getType().equals("Broker")) {
                record = this.upgradeRootRecord(record);
                record = BrokerStoreUpgraderAndRecoverer.createVirtualHostsRecordsFromBrokerRecordForModel_1_x(record, this);
            }
            this.getNextUpgrader().configuredObject(record);
        }

        @Override
        public void complete() {
            this.getNextUpgrader().complete();
        }
    }

    private static final class Upgrader_1_1_to_1_2
    extends StoreUpgraderPhase {
        private Upgrader_1_1_to_1_2() {
            super("modelVersion", "1.1", "1.2");
        }

        @Override
        public void configuredObject(ConfiguredObjectRecord record) {
            if (record.getType().equals("Broker")) {
                record = this.upgradeRootRecord(record);
                record = BrokerStoreUpgraderAndRecoverer.createVirtualHostsRecordsFromBrokerRecordForModel_1_x(record, this);
            }
            this.getNextUpgrader().configuredObject(record);
        }

        @Override
        public void complete() {
            this.getNextUpgrader().complete();
        }
    }

    private static final class Upgrader_1_0_to_1_1
    extends StoreUpgraderPhase {
        private Upgrader_1_0_to_1_1() {
            super("modelVersion", "1.0", "1.1");
        }

        @Override
        public void configuredObject(ConfiguredObjectRecord record) {
            if (record.getType().equals("Broker")) {
                record = this.upgradeRootRecord(record);
                record = BrokerStoreUpgraderAndRecoverer.createVirtualHostsRecordsFromBrokerRecordForModel_1_x(record, this);
            } else if (record.getType().equals("VirtualHost") && record.getAttributes().containsKey("storeType")) {
                HashMap<String, Object> updatedAttributes = new HashMap<String, Object>(record.getAttributes());
                updatedAttributes.put("type", "STANDARD");
                record = new ConfiguredObjectRecordImpl(record.getId(), record.getType(), updatedAttributes, record.getParents());
                this.getUpdateMap().put(record.getId(), record);
            }
            this.getNextUpgrader().configuredObject(record);
        }

        @Override
        public void complete() {
            this.getNextUpgrader().complete();
        }
    }
}

