/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.EnqueueableMessage;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.plugin.MessageMetaDataType;
import org.apache.qpid.server.store.Event;
import org.apache.qpid.server.store.EventListener;
import org.apache.qpid.server.store.EventManager;
import org.apache.qpid.server.store.JdbcUtils;
import org.apache.qpid.server.store.MessageDurability;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.MessageHandle;
import org.apache.qpid.server.store.MessageMetaDataTypeRegistry;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.store.Transaction;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.store.Xid;
import org.apache.qpid.server.store.handler.DistributedTransactionHandler;
import org.apache.qpid.server.store.handler.MessageHandler;
import org.apache.qpid.server.store.handler.MessageInstanceHandler;
import org.apache.qpid.server.util.CachingUUIDFactory;
import org.slf4j.Logger;

public abstract class AbstractJDBCMessageStore
implements MessageStore {
    private static final String DB_VERSION_TABLE_NAME_SUFFIX = "QPID_DB_VERSION";
    private static final String QUEUE_ENTRY_TABLE_NAME_SUFFIX = "QPID_QUEUE_ENTRIES";
    private static final String META_DATA_TABLE_NAME_SUFFIX = "QPID_MESSAGE_METADATA";
    private static final String MESSAGE_CONTENT_TABLE_NAME_SUFFIX = "QPID_MESSAGE_CONTENT";
    private static final String XID_TABLE_NAME_SUFFIX = "QPID_XIDS";
    private static final String XID_ACTIONS_TABLE_NAME_SUFFIX = "QPID_XID_ACTIONS";
    private static final int DB_VERSION = 8;
    private final AtomicLong _messageId = new AtomicLong(0L);
    protected final EventManager _eventManager = new EventManager();
    private ConfiguredObject<?> _parent;
    private String _tablePrefix = "";
    private final AtomicLong _bytesEvacuatedFromMemory = new AtomicLong();
    private final Set<StoredJDBCMessage<?>> _messages = Collections.newSetFromMap(new ConcurrentHashMap());
    private ScheduledThreadPoolExecutor _executor;

    protected abstract boolean isMessageStoreOpen();

    protected abstract void checkMessageStoreOpen();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMaximumMessageId() {
        try (Connection conn = this.newAutoCommitConnection();){
            this.setMaxMessageId(conn, "SELECT max(message_id) FROM " + this.getMessageContentTableName(), 1);
            this.setMaxMessageId(conn, "SELECT max(message_id) FROM " + this.getMetaDataTableName(), 1);
            this.setMaxMessageId(conn, "SELECT queue_id, max(message_id) FROM " + this.getQueueEntryTableName() + " GROUP BY queue_id ", 2);
        }
        catch (SQLException e) {
            throw new StoreException("Failed to determine maximum ids", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMaxMessageId(Connection conn, String query, int col) throws SQLException {
        try (PreparedStatement statement = conn.prepareStatement(query);
             ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                long maxMessageId = rs.getLong(col);
                if (this._messageId.get() >= maxMessageId) continue;
                this._messageId.set(maxMessageId);
            }
        }
    }

    protected void upgrade(ConfiguredObject<?> parent) throws StoreException {
        Connection conn = null;
        try {
            conn = this.newAutoCommitConnection();
            if (this.tableExists(this.getDbVersionTableName(), conn)) {
                this.upgradeIfNecessary(parent);
            }
        }
        catch (SQLException e) {
            throw new StoreException("Failed to upgrade database", e);
        }
        finally {
            JdbcUtils.closeConnection(conn, this.getLogger());
        }
    }

    /*
     * Exception decompiling
     */
    private void upgradeIfNecessary(ConfiguredObject<?> parent) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 18[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void upgradeFromV7() throws SQLException {
        this.updateDbVersion(8);
    }

    private void upgradeFromV6() throws SQLException {
        this.updateDbVersion(7);
    }

    private void updateDbVersion(int newVersion) throws SQLException {
        try (Connection conn = this.newAutoCommitConnection();
             PreparedStatement statement = conn.prepareStatement("UPDATE " + this.getDbVersionTableName() + " SET version = ?");){
            statement.setInt(1, newVersion);
            statement.execute();
        }
    }

    protected void initMessageStore(final ConfiguredObject<?> parent) {
        this._parent = parent;
        this._executor = new ScheduledThreadPoolExecutor(4, new ThreadFactory(){
            private final AtomicInteger _count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = Executors.defaultThreadFactory().newThread(r);
                thread.setName(parent.getName() + "-store-" + this._count.incrementAndGet());
                return thread;
            }
        });
        this._executor.prestartAllCoreThreads();
    }

    @Override
    public void closeMessageStore() {
        for (StoredJDBCMessage<?> message : this._messages) {
            message.clear();
        }
        this._messages.clear();
        this._bytesEvacuatedFromMemory.set(0L);
        if (this._executor != null) {
            this._executor.shutdown();
        }
    }

    protected abstract Logger getLogger();

    protected abstract String getSqlBlobType();

    protected abstract String getSqlVarBinaryType(int var1);

    protected abstract String getSqlBigIntType();

    protected void createOrOpenMessageStoreDatabase() throws StoreException {
        Connection conn = null;
        try {
            conn = this.newAutoCommitConnection();
            this.createVersionTable(conn);
            this.createQueueEntryTable(conn);
            this.createMetaDataTable(conn);
            this.createMessageContentTable(conn);
            this.createXidTable(conn);
            this.createXidActionTable(conn);
        }
        catch (SQLException e) {
            throw new StoreException("Failed to create message store tables", e);
        }
        finally {
            JdbcUtils.closeConnection(conn, this.getLogger());
        }
    }

    private void createVersionTable(Connection conn) throws SQLException {
        if (!this.tableExists(this.getDbVersionTableName(), conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE " + this.getDbVersionTableName() + " ( version int not null )");
            }
            var3_3 = null;
            try (PreparedStatement pstmt = conn.prepareStatement("INSERT INTO " + this.getDbVersionTableName() + " ( version ) VALUES ( ? )");){
                pstmt.setInt(1, 8);
                pstmt.execute();
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
        }
    }

    private void createQueueEntryTable(Connection conn) throws SQLException {
        if (!this.tableExists(this.getQueueEntryTableName(), conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE " + this.getQueueEntryTableName() + " ( queue_id varchar(36) not null, message_id " + this.getSqlBigIntType() + " not null, PRIMARY KEY (queue_id, message_id) )");
            }
        }
    }

    private void createMetaDataTable(Connection conn) throws SQLException {
        if (!this.tableExists(this.getMetaDataTableName(), conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE " + this.getMetaDataTableName() + " ( message_id " + this.getSqlBigIntType() + " not null, meta_data " + this.getSqlBlobType() + ", PRIMARY KEY ( message_id ) )");
            }
        }
    }

    private void createMessageContentTable(Connection conn) throws SQLException {
        if (!this.tableExists(this.getMessageContentTableName(), conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE " + this.getMessageContentTableName() + " ( message_id " + this.getSqlBigIntType() + " not null, content " + this.getSqlBlobType() + ", PRIMARY KEY (message_id) )");
            }
        }
    }

    private void createXidTable(Connection conn) throws SQLException {
        if (!this.tableExists(this.getXidTableName(), conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE " + this.getXidTableName() + " ( format " + this.getSqlBigIntType() + " not null," + " global_id " + this.getSqlVarBinaryType(64) + ", branch_id " + this.getSqlVarBinaryType(64) + " ,  PRIMARY KEY ( format, " + "global_id, branch_id ))");
            }
        }
    }

    private void createXidActionTable(Connection conn) throws SQLException {
        if (!this.tableExists(this.getXidActionsTableName(), conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE " + this.getXidActionsTableName() + " ( format " + this.getSqlBigIntType() + " not null," + " global_id " + this.getSqlVarBinaryType(64) + " not null, branch_id " + this.getSqlVarBinaryType(64) + " not null, " + "action_type char not null, queue_id varchar(36) not null, message_id " + this.getSqlBigIntType() + " not null" + ",  PRIMARY KEY ( " + "format, global_id, branch_id, action_type, queue_id, message_id))");
            }
        }
    }

    protected boolean tableExists(String tableName, Connection conn) throws SQLException {
        return JdbcUtils.tableExists(tableName, conn);
    }

    @Override
    public <T extends StorableMessageMetaData> MessageHandle<T> addMessage(T metaData) {
        this.checkMessageStoreOpen();
        return this.createStoredJDBCMessage(this.getNextMessageId(), metaData, false);
    }

    public <T extends StorableMessageMetaData> StoredJDBCMessage<T> createStoredJDBCMessage(long newMessageId, T metaData, boolean recovered) {
        StoredJDBCMessage message = new StoredJDBCMessage(this, newMessageId, metaData, recovered);
        this._messages.add(message);
        return message;
    }

    @Override
    public long getNextMessageId() {
        return this._messageId.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMessage(long messageId) {
        try (Connection conn = this.newConnection();){
            try (PreparedStatement stmt = conn.prepareStatement("DELETE FROM " + this.getMetaDataTableName() + " WHERE message_id = ?");){
                stmt.setLong(1, messageId);
                int results = stmt.executeUpdate();
                stmt.close();
                if (results == 0) {
                    this.getLogger().debug("Message id {} not found (attempt to remove failed - probably application initiated rollback)", (Object)messageId);
                }
                this.getLogger().debug("Deleted metadata for message {}", (Object)messageId);
                stmt = conn.prepareStatement("DELETE FROM " + this.getMessageContentTableName() + " WHERE message_id = ?");
                stmt.setLong(1, messageId);
                results = stmt.executeUpdate();
            }
            conn.commit();
        }
        catch (SQLException e) {
            throw new StoreException("Error removing message with id " + messageId + " from database: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection newAutoCommitConnection() throws SQLException {
        Connection connection = this.newConnection();
        try {
            connection.setAutoCommit(true);
        }
        catch (SQLException sqlEx) {
            try {
                connection.close();
            }
            finally {
                throw sqlEx;
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection newConnection() throws SQLException {
        Connection connection = this.getConnection();
        try {
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(2);
        }
        catch (SQLException sqlEx) {
            try {
                connection.close();
            }
            finally {
                throw sqlEx;
            }
        }
        return connection;
    }

    protected abstract Connection getConnection() throws SQLException;

    @Override
    public Transaction newTransaction() {
        this.checkMessageStoreOpen();
        return new JDBCTransaction();
    }

    private void enqueueMessage(ConnectionWrapper connWrapper, TransactionLogResource queue, Long messageId) throws StoreException {
        Connection conn = connWrapper.getConnection();
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Enqueuing message {} on queue {} with id {} [Connection {}]", new Object[]{messageId, queue.getName(), queue.getId(), conn});
            }
            try (PreparedStatement stmt = conn.prepareStatement("INSERT INTO " + this.getQueueEntryTableName() + " (queue_id, message_id) values (?,?)");){
                stmt.setString(1, queue.getId().toString());
                stmt.setLong(2, messageId);
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            this.getLogger().error("Failed to enqueue message {}", (Object)messageId, (Object)e);
            throw new StoreException("Error writing enqueued message with id " + messageId + " for queue " + queue.getName() + " with id " + queue.getId() + " to database", e);
        }
    }

    private void dequeueMessage(ConnectionWrapper connWrapper, UUID queueId, Long messageId) throws StoreException {
        Connection conn = connWrapper.getConnection();
        try (PreparedStatement stmt = conn.prepareStatement("DELETE FROM " + this.getQueueEntryTableName() + " WHERE queue_id = ? AND message_id =?");){
            stmt.setString(1, queueId.toString());
            stmt.setLong(2, messageId);
            int results = stmt.executeUpdate();
            if (results != 1) {
                throw new StoreException("Unable to find message with id " + messageId + " on queue with id " + queueId);
            }
            this.getLogger().debug("Dequeuing message {} on queue with id {}", (Object)messageId, (Object)queueId);
        }
        catch (SQLException e) {
            this.getLogger().error("Failed to dequeue message {}", (Object)messageId, (Object)e);
            throw new StoreException("Error deleting enqueued message with id " + messageId + " for queue with id " + queueId + " from database", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeXid(ConnectionWrapper connWrapper, long format, byte[] globalId, byte[] branchId) throws StoreException {
        Connection conn = connWrapper.getConnection();
        try {
            try (PreparedStatement stmt = conn.prepareStatement("DELETE FROM " + this.getXidTableName() + " WHERE format = ? and global_id = ? and branch_id = ?");){
                stmt.setLong(1, format);
                stmt.setBytes(2, globalId);
                stmt.setBytes(3, branchId);
                int results = stmt.executeUpdate();
                if (results != 1) {
                    throw new StoreException("Unable to find message with xid");
                }
            }
            stmt = conn.prepareStatement("DELETE FROM " + this.getXidActionsTableName() + " WHERE format = ? and global_id = ? and branch_id = ?");
            try {
                stmt.setLong(1, format);
                stmt.setBytes(2, globalId);
                stmt.setBytes(3, branchId);
                int n = stmt.executeUpdate();
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException e) {
            this.getLogger().error("Failed to remove xid", (Throwable)e);
            throw new StoreException("Error deleting enqueued message with xid", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Runnable> recordXid(ConnectionWrapper connWrapper, long format, byte[] globalId, byte[] branchId, Transaction.EnqueueRecord[] enqueues, Transaction.DequeueRecord[] dequeues) throws StoreException {
        Connection conn = connWrapper.getConnection();
        try {
            try (PreparedStatement stmt = conn.prepareStatement("INSERT INTO " + this.getXidTableName() + " ( format, global_id, branch_id ) values (?, ?, ?)");){
                stmt.setLong(1, format);
                stmt.setBytes(2, globalId);
                stmt.setBytes(3, branchId);
                stmt.executeUpdate();
            }
            for (Transaction.EnqueueRecord enqueueRecord : enqueues) {
                StoredMessage storedMessage = enqueueRecord.getMessage().getStoredMessage();
                if (!(storedMessage instanceof StoredJDBCMessage)) continue;
                ((StoredJDBCMessage)storedMessage).store(conn);
            }
            stmt = conn.prepareStatement("INSERT INTO " + this.getXidActionsTableName() + " ( format, global_id, branch_id, action_type, " + "queue_id, message_id ) values (?,?,?,?,?,?) ");
            try {
                stmt.setLong(1, format);
                stmt.setBytes(2, globalId);
                stmt.setBytes(3, branchId);
                if (enqueues != null) {
                    stmt.setString(4, "E");
                    for (Transaction.EnqueueRecord enqueueRecord : enqueues) {
                        stmt.setString(5, enqueueRecord.getResource().getId().toString());
                        stmt.setLong(6, enqueueRecord.getMessage().getMessageNumber());
                        stmt.executeUpdate();
                    }
                }
                if (dequeues != null) {
                    stmt.setString(4, "D");
                    for (Transaction.DequeueRecord dequeueRecord : dequeues) {
                        stmt.setString(5, dequeueRecord.getEnqueueRecord().getQueueId().toString());
                        stmt.setLong(6, dequeueRecord.getEnqueueRecord().getMessageNumber());
                        stmt.executeUpdate();
                    }
                }
            }
            finally {
                stmt.close();
            }
            return Collections.emptyList();
        }
        catch (SQLException e) {
            this.getLogger().error("Failed to record xid", (Throwable)e);
            throw new StoreException("Error writing xid ", e);
        }
    }

    public void onOpen(ConfiguredObject<?> parent) {
    }

    protected void setTablePrefix(String tablePrefix) {
        this._tablePrefix = tablePrefix == null ? "" : tablePrefix;
    }

    private String getDbVersionTableName() {
        return this._tablePrefix + DB_VERSION_TABLE_NAME_SUFFIX;
    }

    private String getQueueEntryTableName() {
        return this._tablePrefix + QUEUE_ENTRY_TABLE_NAME_SUFFIX;
    }

    private String getMetaDataTableName() {
        return this._tablePrefix + META_DATA_TABLE_NAME_SUFFIX;
    }

    private String getMessageContentTableName() {
        return this._tablePrefix + MESSAGE_CONTENT_TABLE_NAME_SUFFIX;
    }

    private String getXidTableName() {
        return this._tablePrefix + XID_TABLE_NAME_SUFFIX;
    }

    private String getXidActionsTableName() {
        return this._tablePrefix + XID_ACTIONS_TABLE_NAME_SUFFIX;
    }

    private void commitTran(ConnectionWrapper connWrapper) throws StoreException {
        try {
            Connection conn = connWrapper.getConnection();
            conn.commit();
            this.getLogger().debug("commit tran completed");
            conn.close();
        }
        catch (SQLException e) {
            throw new StoreException("Error commit tx", e);
        }
    }

    private <X> ListenableFuture<X> commitTranAsync(final ConnectionWrapper connWrapper, final X val) throws StoreException {
        final SettableFuture future = SettableFuture.create();
        this._executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractJDBCMessageStore.this.commitTran(connWrapper);
                    future.set(val);
                }
                catch (RuntimeException e) {
                    future.setException((Throwable)e);
                }
            }
        });
        return future;
    }

    private void abortTran(ConnectionWrapper connWrapper) throws StoreException {
        if (connWrapper == null) {
            throw new StoreException("Fatal internal error: transactional context is empty at abortTran");
        }
        this.getLogger().debug("abort tran called: {}", (Object)connWrapper.getConnection());
        try {
            Connection conn = connWrapper.getConnection();
            conn.rollback();
            conn.close();
        }
        catch (SQLException e) {
            throw new StoreException("Error aborting transaction: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeMetaData(Connection conn, long messageId, StorableMessageMetaData metaData) throws SQLException {
        this.getLogger().debug("Adding metadata for message {}", (Object)messageId);
        try (PreparedStatement stmt = conn.prepareStatement("INSERT INTO " + this.getMetaDataTableName() + "( message_id , meta_data ) values (?, ?)");){
            stmt.setLong(1, messageId);
            int bodySize = 1 + metaData.getStorableSize();
            byte[] underlying = new byte[bodySize];
            underlying[0] = (byte)metaData.getType().ordinal();
            QpidByteBuffer buf = QpidByteBuffer.wrap((byte[])underlying);
            buf.position(1);
            buf = buf.slice();
            metaData.writeToBuffer(buf);
            ByteArrayInputStream bis = new ByteArrayInputStream(underlying);
            try {
                stmt.setBinaryStream(2, (InputStream)bis, underlying.length);
                int result = stmt.executeUpdate();
                if (result == 0) {
                    throw new StoreException("Unable to add meta data for message " + messageId);
                }
            }
            finally {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
            }
        }
    }

    private StorableMessageMetaData getMetaData(long messageId) throws SQLException {
        try (Connection conn = this.newAutoCommitConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT meta_data FROM " + this.getMetaDataTableName() + " WHERE message_id = ?");){
            stmt.setLong(1, messageId);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    byte[] dataAsBytes = this.getBlobAsBytes(rs, 1);
                    StorableMessageMetaData storableMessageMetaData = this.getStorableMessageMetaData(dataAsBytes);
                    return storableMessageMetaData;
                }
                throw new StoreException("Meta data not found for message with id " + messageId);
            }
        }
    }

    protected abstract byte[] getBlobAsBytes(ResultSet var1, int var2) throws SQLException;

    private void addContent(Connection conn, long messageId, Collection<QpidByteBuffer> contentBody) {
        this.getLogger().debug("Adding content for message {}", (Object)messageId);
        PreparedStatement stmt = null;
        int size = 0;
        for (QpidByteBuffer buf : contentBody) {
            size += buf.remaining();
        }
        byte[] data = new byte[size];
        ByteBuffer dst = ByteBuffer.wrap(data);
        for (QpidByteBuffer buf : contentBody) {
            buf.copyTo(dst);
        }
        try {
            stmt = conn.prepareStatement("INSERT INTO " + this.getMessageContentTableName() + "( message_id, content ) values (?, ?)");
            stmt.setLong(1, messageId);
            stmt.setBinaryStream(2, (InputStream)new ByteArrayInputStream(data), data.length);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                JdbcUtils.closeConnection(conn, this.getLogger());
                throw new StoreException("Error adding content for message " + messageId + ": " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closePreparedStatement(stmt, this.getLogger());
                throw throwable;
            }
        }
        JdbcUtils.closePreparedStatement(stmt, this.getLogger());
    }

    Collection<QpidByteBuffer> getAllContent(long messageId) throws StoreException {
        PreparedStatement stmt;
        Connection conn;
        block6: {
            conn = null;
            stmt = null;
            this.getLogger().debug("Message Id: {} Getting content body", (Object)messageId);
            conn = this.newAutoCommitConnection();
            stmt = conn.prepareStatement("SELECT content FROM " + this.getMessageContentTableName() + " WHERE message_id = ?");
            stmt.setLong(1, messageId);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) break block6;
            byte[] data = this.getBlobAsBytes(rs, 1);
            int offset = 0;
            int length = data.length;
            Collection buffers = QpidByteBuffer.allocateDirectCollection((int)length);
            for (QpidByteBuffer buf : buffers) {
                int bufSize = buf.remaining();
                buf.put(data, offset, bufSize);
                buf.flip();
                offset += bufSize;
            }
            Collection collection = buffers;
            JdbcUtils.closePreparedStatement(stmt, this.getLogger());
            JdbcUtils.closeConnection(conn, this.getLogger());
            return collection;
        }
        try {
            try {
                throw new StoreException("Unable to find message with id " + messageId);
            }
            catch (SQLException e) {
                throw new StoreException("Error retrieving content for message " + messageId + ": " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closePreparedStatement(stmt, this.getLogger());
            JdbcUtils.closeConnection(conn, this.getLogger());
            throw throwable;
        }
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public long getBytesEvacuatedFromMemory() {
        return this._bytesEvacuatedFromMemory.get();
    }

    @Override
    public void addEventListener(EventListener eventListener, Event ... events) {
        this._eventManager.addEventListener(eventListener, events);
    }

    @Override
    public MessageStore.MessageStoreReader newMessageStoreReader() {
        return new JDBCMessageStoreReader();
    }

    private StorableMessageMetaData getStorableMessageMetaData(byte[] dataAsBytes) {
        QpidByteBuffer buf;
        if (dataAsBytes.length > QpidByteBuffer.getPooledBufferSize()) {
            buf = QpidByteBuffer.wrap((byte[])dataAsBytes);
        } else {
            buf = QpidByteBuffer.allocateDirect((int)dataAsBytes.length);
            buf.put(dataAsBytes);
            buf.flip();
        }
        buf.position(1);
        QpidByteBuffer slice = buf.slice();
        int typeOrdinal = dataAsBytes[0] & 0xFF;
        MessageMetaDataType type = MessageMetaDataTypeRegistry.fromOrdinal(typeOrdinal);
        Object metaData = type.createMetaData(slice);
        slice.dispose();
        buf.dispose();
        return metaData;
    }

    protected abstract void storedSizeChange(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDelete(ConfiguredObject<?> parent) {
        try (Connection conn = this.newAutoCommitConnection();){
            for (String tableName : this.getTableNames()) {
                try (Statement stmt = conn.createStatement();){
                    stmt.execute("DROP TABLE " + tableName);
                }
            }
        }
        catch (SQLException e) {
            this.getLogger().error("Exception while deleting store tables", (Throwable)e);
        }
    }

    public List<String> getTableNames() {
        return Arrays.asList(this.getDbVersionTableName(), this.getMetaDataTableName(), this.getMessageContentTableName(), this.getQueueEntryTableName(), this.getXidTableName(), this.getXidActionsTableName());
    }

    private static class JDBCEnqueueRecord
    implements MessageEnqueueRecord {
        private final UUID _queueId;
        private final long _messageNumber;

        public JDBCEnqueueRecord(UUID queueId, long messageNumber) {
            this._queueId = queueId;
            this._messageNumber = messageNumber;
        }

        @Override
        public UUID getQueueId() {
            return this._queueId;
        }

        @Override
        public long getMessageNumber() {
            return this._messageNumber;
        }
    }

    private class JDBCMessageStoreReader
    implements MessageStore.MessageStoreReader {
        private JDBCMessageStoreReader() {
        }

        @Override
        public StoredMessage<?> getMessage(long messageId) throws StoreException {
            AbstractJDBCMessageStore.this.checkMessageStoreOpen();
            Connection conn = null;
            try {
                StoredJDBCMessage<StorableMessageMetaData> message;
                conn = AbstractJDBCMessageStore.this.newAutoCommitConnection();
                try (PreparedStatement stmt = conn.prepareStatement("SELECT message_id, meta_data FROM " + AbstractJDBCMessageStore.this.getMetaDataTableName() + " WHERE message_id = ?");){
                    stmt.setLong(1, messageId);
                    try (ResultSet rs = stmt.executeQuery();){
                        if (rs.next()) {
                            byte[] dataAsBytes = AbstractJDBCMessageStore.this.getBlobAsBytes(rs, 2);
                            StorableMessageMetaData metaData = AbstractJDBCMessageStore.this.getStorableMessageMetaData(dataAsBytes);
                            message = AbstractJDBCMessageStore.this.createStoredJDBCMessage(messageId, metaData, true);
                        } else {
                            message = null;
                        }
                    }
                }
                stmt = message;
                return stmt;
            }
            catch (SQLException e) {
                throw new StoreException("Error encountered when visiting messages", e);
            }
            finally {
                JdbcUtils.closeConnection(conn, AbstractJDBCMessageStore.this.getLogger());
            }
        }

        @Override
        public void close() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitMessages(MessageHandler handler) throws StoreException {
            AbstractJDBCMessageStore.this.checkMessageStoreOpen();
            Connection conn = null;
            try {
                conn = AbstractJDBCMessageStore.this.newAutoCommitConnection();
                try (Statement stmt = conn.createStatement();
                     ResultSet rs = stmt.executeQuery("SELECT message_id, meta_data FROM " + AbstractJDBCMessageStore.this.getMetaDataTableName());){
                    while (rs.next()) {
                        long messageId = rs.getLong(1);
                        byte[] dataAsBytes = AbstractJDBCMessageStore.this.getBlobAsBytes(rs, 2);
                        QpidByteBuffer buf = QpidByteBuffer.wrap((byte[])dataAsBytes);
                        buf.position(1);
                        buf = buf.slice();
                        MessageMetaDataType type = MessageMetaDataTypeRegistry.fromOrdinal(dataAsBytes[0] & 0xFF);
                        Object metaData = type.createMetaData(buf);
                        buf.dispose();
                        StoredJDBCMessage message = AbstractJDBCMessageStore.this.createStoredJDBCMessage(messageId, metaData, true);
                        if (handler.handle(message)) continue;
                        break;
                    }
                }
            }
            catch (SQLException e) {
                throw new StoreException("Error encountered when visiting messages", e);
            }
            finally {
                JdbcUtils.closeConnection(conn, AbstractJDBCMessageStore.this.getLogger());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitMessageInstances(TransactionLogResource queue, MessageInstanceHandler handler) throws StoreException {
            AbstractJDBCMessageStore.this.checkMessageStoreOpen();
            Connection conn = null;
            try {
                CachingUUIDFactory uuidFactory = new CachingUUIDFactory();
                conn = AbstractJDBCMessageStore.this.newAutoCommitConnection();
                try (PreparedStatement stmt = conn.prepareStatement("SELECT queue_id, message_id FROM " + AbstractJDBCMessageStore.this.getQueueEntryTableName() + " WHERE queue_id = ? ORDER BY queue_id, message_id");){
                    stmt.setString(1, queue.getId().toString());
                    try (ResultSet rs = stmt.executeQuery();){
                        while (rs.next()) {
                            String id = rs.getString(1);
                            long messageId = rs.getLong(2);
                            UUID uuid = uuidFactory.createUuidFromString(id);
                            if (handler.handle(new JDBCEnqueueRecord(uuid, messageId))) continue;
                            break;
                        }
                    }
                }
            }
            catch (SQLException e) {
                try {
                    throw new StoreException("Error encountered when visiting message instances", e);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeConnection(conn, AbstractJDBCMessageStore.this.getLogger());
                    throw throwable;
                }
            }
            JdbcUtils.closeConnection(conn, AbstractJDBCMessageStore.this.getLogger());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitMessageInstances(MessageInstanceHandler handler) throws StoreException {
            AbstractJDBCMessageStore.this.checkMessageStoreOpen();
            Connection conn = null;
            try {
                CachingUUIDFactory uuidFactory = new CachingUUIDFactory();
                conn = AbstractJDBCMessageStore.this.newAutoCommitConnection();
                try (Statement stmt = conn.createStatement();
                     ResultSet rs = stmt.executeQuery("SELECT queue_id, message_id FROM " + AbstractJDBCMessageStore.this.getQueueEntryTableName() + " ORDER BY queue_id, message_id");){
                    while (rs.next()) {
                        String id = rs.getString(1);
                        long messageId = rs.getLong(2);
                        UUID queueId = uuidFactory.createUuidFromString(id);
                        if (handler.handle(new JDBCEnqueueRecord(queueId, messageId))) continue;
                        break;
                    }
                }
            }
            catch (SQLException e) {
                try {
                    throw new StoreException("Error encountered when visiting message instances", e);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeConnection(conn, AbstractJDBCMessageStore.this.getLogger());
                    throw throwable;
                }
            }
            JdbcUtils.closeConnection(conn, AbstractJDBCMessageStore.this.getLogger());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitDistributedTransactions(DistributedTransactionHandler handler) throws StoreException {
            AbstractJDBCMessageStore.this.checkMessageStoreOpen();
            Connection conn = null;
            try {
                conn = AbstractJDBCMessageStore.this.newAutoCommitConnection();
                ArrayList<Xid> xids = new ArrayList<Xid>();
                try (Statement stmt = conn.createStatement();
                     ResultSet rs = stmt.executeQuery("SELECT format, global_id, branch_id FROM " + AbstractJDBCMessageStore.this.getXidTableName());){
                    while (rs.next()) {
                        long format = rs.getLong(1);
                        byte[] globalId = rs.getBytes(2);
                        byte[] branchId = rs.getBytes(3);
                        xids.add(new Xid(format, globalId, branchId));
                    }
                }
                for (Xid xid : xids) {
                    CachingUUIDFactory uuidFactory = new CachingUUIDFactory();
                    ArrayList<RecordImpl> enqueues = new ArrayList<RecordImpl>();
                    ArrayList dequeues = new ArrayList();
                    try (PreparedStatement pstmt = conn.prepareStatement("SELECT action_type, queue_id, message_id FROM " + AbstractJDBCMessageStore.this.getXidActionsTableName() + " WHERE format = ? and global_id = ? and branch_id = ?");){
                        pstmt.setLong(1, xid.getFormat());
                        pstmt.setBytes(2, xid.getGlobalId());
                        pstmt.setBytes(3, xid.getBranchId());
                        try (ResultSet rs = pstmt.executeQuery();){
                            while (rs.next()) {
                                String actionType = rs.getString(1);
                                UUID queueId = uuidFactory.createUuidFromString(rs.getString(2));
                                long messageId = rs.getLong(3);
                                RecordImpl record = new RecordImpl(queueId, messageId);
                                ArrayList<RecordImpl> records = "E".equals(actionType) ? enqueues : dequeues;
                                records.add(record);
                            }
                        }
                    }
                    if (handler.handle(new JDBCStoredXidRecord(xid.getFormat(), xid.getGlobalId(), xid.getBranchId()), enqueues.toArray(new RecordImpl[enqueues.size()]), dequeues.toArray(new RecordImpl[dequeues.size()]))) continue;
                    break;
                }
            }
            catch (SQLException e) {
                throw new StoreException("Error encountered when visiting distributed transactions", e);
            }
            finally {
                JdbcUtils.closeConnection(conn, AbstractJDBCMessageStore.this.getLogger());
            }
        }
    }

    private class StoredJDBCMessage<T extends StorableMessageMetaData>
    implements StoredMessage<T>,
    MessageHandle<T> {
        private final long _messageId;
        private MessageDataRef<T> _messageDataRef;
        final /* synthetic */ AbstractJDBCMessageStore this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        StoredJDBCMessage(long metaData, T t) {
            this((AbstractJDBCMessageStore)l, (long)messageId, (StorableMessageMetaData)metaData, false);
            void messageId;
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        StoredJDBCMessage(long metaData, T t, boolean bl) {
            void isRecovered;
            void messageId;
            this.this$0 = (AbstractJDBCMessageStore)l;
            this._messageId = messageId;
            this._messageDataRef = isRecovered == false ? new MessageDataHardRef((StorableMessageMetaData)metaData, null) : new MessageDataSoftRef((StorableMessageMetaData)metaData, null, null);
        }

        @Override
        public synchronized T getMetaData() {
            if (this._messageDataRef == null) {
                return null;
            }
            Object metaData = this._messageDataRef.getMetaData();
            if (metaData == null) {
                this.this$0.checkMessageStoreOpen();
                try {
                    metaData = this.this$0.getMetaData(this._messageId);
                    this._messageDataRef = new MessageDataSoftRef((StorableMessageMetaData)metaData, this._messageDataRef.getData(), null);
                }
                catch (SQLException e) {
                    throw new StoreException("Failed to get metadata for message id: " + this._messageId, e);
                }
            }
            return metaData;
        }

        @Override
        public long getMessageNumber() {
            return this._messageId;
        }

        @Override
        public synchronized void addContent(QpidByteBuffer src) {
            src = src.slice();
            Collection<QpidByteBuffer> data = this._messageDataRef.getData();
            if (data == null) {
                this._messageDataRef.setData(Collections.singleton(src));
            } else {
                ArrayList<QpidByteBuffer> newCollection = new ArrayList<QpidByteBuffer>(data.size() + 1);
                newCollection.addAll(data);
                newCollection.add(src);
                this._messageDataRef.setData(Collections.unmodifiableCollection(newCollection));
            }
        }

        @Override
        public StoredMessage<T> allContentAdded() {
            return this;
        }

        private Collection<QpidByteBuffer> getContentAsByteBuffer() {
            Collection<Object> data;
            Collection<QpidByteBuffer> collection = data = this._messageDataRef == null ? Collections.emptyList() : this._messageDataRef.getData();
            if (data == null) {
                if (this.stored()) {
                    this.this$0.checkMessageStoreOpen();
                    data = this.this$0.getAllContent(this._messageId);
                    this._messageDataRef.setData(data);
                } else {
                    data = Collections.emptyList();
                }
            }
            return data;
        }

        @Override
        public synchronized Collection<QpidByteBuffer> getContent(int offset, int length) {
            Collection<QpidByteBuffer> bufs = this.getContentAsByteBuffer();
            ArrayList<QpidByteBuffer> content = new ArrayList<QpidByteBuffer>(bufs.size());
            int pos = 0;
            for (QpidByteBuffer buf : bufs) {
                if (length <= 0) continue;
                int bufRemaining = buf.remaining();
                if (pos + bufRemaining <= offset) {
                    pos += bufRemaining;
                    continue;
                }
                if (pos >= offset) {
                    buf = buf.duplicate();
                    if (bufRemaining <= length) {
                        length -= bufRemaining;
                    } else {
                        buf.limit(length);
                        length = 0;
                    }
                    content.add(buf);
                    pos += buf.remaining();
                    continue;
                }
                int offsetInBuf = offset - pos;
                int limit = length < bufRemaining - offsetInBuf ? length : bufRemaining - offsetInBuf;
                QpidByteBuffer bufView = buf.view(offsetInBuf, limit);
                content.add(bufView);
                length -= limit;
                pos += limit + offsetInBuf;
            }
            return content;
        }

        synchronized void store(Connection conn) throws SQLException {
            if (!this.stored()) {
                this.this$0.storeMetaData(conn, this._messageId, this._messageDataRef.getMetaData());
                this.this$0.addContent(conn, this._messageId, this._messageDataRef.getData() == null ? Collections.emptySet() : this._messageDataRef.getData());
                this.this$0.getLogger().debug("Storing message {} to store", (Object)this._messageId);
                MessageDataRef<T> hardRef = this._messageDataRef;
                MessageDataSoftRef messageDataSoftRef = new MessageDataSoftRef((StorableMessageMetaData)hardRef.getMetaData(), hardRef.getData(), null);
                this._messageDataRef = messageDataSoftRef;
            }
        }

        synchronized ListenableFuture<Void> flushToStore() {
            if (this._messageDataRef != null && !this.stored()) {
                try (Connection conn = this.this$0.newConnection();){
                    this.store(conn);
                    conn.commit();
                    this.this$0.storedSizeChange(this.getMetaData().getContentSize());
                }
                catch (SQLException e) {
                    throw new StoreException("Failed to flow to disk", e);
                }
            }
            return Futures.immediateFuture(null);
        }

        @Override
        public synchronized void remove() {
            this.this$0.getLogger().debug("REMOVE called on message: {}", (Object)this._messageId);
            this.this$0.checkMessageStoreOpen();
            Collection<QpidByteBuffer> data = this._messageDataRef.getData();
            T metaData = this.getMetaData();
            int delta = metaData.getContentSize();
            this.this$0._messages.remove(this);
            if (this.stored()) {
                this.this$0.removeMessage(this._messageId);
                this.this$0.storedSizeChange(-delta);
            }
            if (data != null) {
                this._messageDataRef.setData(null);
                for (QpidByteBuffer buf : data) {
                    buf.dispose();
                }
            }
            metaData.dispose();
            this._messageDataRef = null;
        }

        @Override
        public synchronized boolean isInMemory() {
            return this._messageDataRef != null && (this._messageDataRef.isHardRef() || this._messageDataRef.getData() != null);
        }

        private boolean stored() {
            return this._messageDataRef != null && !this._messageDataRef.isHardRef();
        }

        @Override
        public synchronized boolean flowToDisk() {
            this.flushToStore();
            if (this._messageDataRef != null && !this._messageDataRef.isHardRef()) {
                long bytesCleared = ((MessageDataSoftRef)this._messageDataRef).clear();
                this.this$0._bytesEvacuatedFromMemory.addAndGet(bytesCleared);
            }
            return true;
        }

        public synchronized void clear() {
            if (this._messageDataRef != null) {
                this._messageDataRef.clear();
            }
        }

        public String toString() {
            return this.getClass() + "[messageId=" + this._messageId + "]";
        }
    }

    private static final class MessageDataSoftRef<T extends StorableMessageMetaData>
    implements MessageDataRef<T> {
        private T _metaData;
        private volatile Collection<QpidByteBuffer> _data;

        private MessageDataSoftRef(T metaData, Collection<QpidByteBuffer> data) {
            this._metaData = metaData;
            this._data = data;
        }

        @Override
        public T getMetaData() {
            return this._metaData;
        }

        @Override
        public Collection<QpidByteBuffer> getData() {
            return this._data;
        }

        @Override
        public void setData(Collection<QpidByteBuffer> data) {
            this._data = data;
        }

        @Override
        public long clear() {
            long bytesCleared = 0L;
            if (this._metaData != null) {
                bytesCleared += (long)this._metaData.getStorableSize();
                this._metaData.clearEncodedForm();
                this._metaData = null;
            }
            if (this._data != null) {
                for (QpidByteBuffer buf : this._data) {
                    bytesCleared += (long)buf.remaining();
                    buf.dispose();
                }
                this._data = null;
            }
            return bytesCleared;
        }

        @Override
        public boolean isHardRef() {
            return false;
        }

        /* synthetic */ MessageDataSoftRef(StorableMessageMetaData x0, Collection x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static final class MessageDataHardRef<T extends StorableMessageMetaData>
    implements MessageDataRef<T> {
        private final T _metaData;
        private volatile Collection<QpidByteBuffer> _data;

        private MessageDataHardRef(T metaData) {
            this._metaData = metaData;
        }

        @Override
        public T getMetaData() {
            return this._metaData;
        }

        @Override
        public Collection<QpidByteBuffer> getData() {
            return this._data;
        }

        @Override
        public void setData(Collection<QpidByteBuffer> data) {
            this._data = data;
        }

        @Override
        public long clear() {
            long bytesCleared = 0L;
            if (this._metaData != null) {
                bytesCleared += (long)this._metaData.getStorableSize();
                this._metaData.clearEncodedForm();
            }
            if (this._data != null) {
                for (QpidByteBuffer buf : this._data) {
                    bytesCleared += (long)buf.remaining();
                    buf.dispose();
                }
                this._data = null;
            }
            return bytesCleared;
        }

        @Override
        public boolean isHardRef() {
            return true;
        }

        /* synthetic */ MessageDataHardRef(StorableMessageMetaData x0, 1 x1) {
            this(x0);
        }
    }

    static interface MessageDataRef<T extends StorableMessageMetaData> {
        public T getMetaData();

        public Collection<QpidByteBuffer> getData();

        public void setData(Collection<QpidByteBuffer> var1);

        public boolean isHardRef();

        public long clear();
    }

    private static class JDBCStoredXidRecord
    implements Transaction.StoredXidRecord {
        private final long _format;
        private final byte[] _globalId;
        private final byte[] _branchId;

        public JDBCStoredXidRecord(long format, byte[] globalId, byte[] branchId) {
            this._format = format;
            this._globalId = globalId;
            this._branchId = branchId;
        }

        @Override
        public long getFormat() {
            return this._format;
        }

        @Override
        public byte[] getGlobalId() {
            return this._globalId;
        }

        @Override
        public byte[] getBranchId() {
            return this._branchId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JDBCStoredXidRecord that = (JDBCStoredXidRecord)o;
            return this._format == that._format && Arrays.equals(this._globalId, that._globalId) && Arrays.equals(this._branchId, that._branchId);
        }

        public int hashCode() {
            int result = (int)(this._format ^ this._format >>> 32);
            result = 31 * result + Arrays.hashCode(this._globalId);
            result = 31 * result + Arrays.hashCode(this._branchId);
            return result;
        }
    }

    protected class JDBCTransaction
    implements Transaction {
        private final ConnectionWrapper _connWrapper;
        private int _storeSizeIncrease;
        private final List<Runnable> _preCommitActions = new ArrayList<Runnable>();
        private final List<Runnable> _postCommitActions = new ArrayList<Runnable>();

        protected JDBCTransaction() {
            try {
                this._connWrapper = new ConnectionWrapper(AbstractJDBCMessageStore.this.newConnection());
            }
            catch (SQLException e) {
                throw new StoreException(e);
            }
        }

        @Override
        public MessageEnqueueRecord enqueueMessage(TransactionLogResource queue, EnqueueableMessage message) {
            AbstractJDBCMessageStore.this.checkMessageStoreOpen();
            final StoredMessage storedMessage = message.getStoredMessage();
            if (storedMessage instanceof StoredJDBCMessage) {
                this._preCommitActions.add(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ((StoredJDBCMessage)storedMessage).store(JDBCTransaction.this._connWrapper.getConnection());
                            JDBCTransaction.this._storeSizeIncrease += storedMessage.getMetaData().getContentSize();
                        }
                        catch (SQLException e) {
                            throw new StoreException("Exception on enqueuing message into message store" + AbstractJDBCMessageStore.this._messageId, e);
                        }
                    }
                });
            }
            AbstractJDBCMessageStore.this.enqueueMessage(this._connWrapper, queue, message.getMessageNumber());
            return new JDBCEnqueueRecord(queue.getId(), message.getMessageNumber());
        }

        @Override
        public void dequeueMessage(MessageEnqueueRecord enqueueRecord) {
            AbstractJDBCMessageStore.this.checkMessageStoreOpen();
            AbstractJDBCMessageStore.this.dequeueMessage(this._connWrapper, enqueueRecord.getQueueId(), enqueueRecord.getMessageNumber());
        }

        @Override
        public void commitTran() {
            AbstractJDBCMessageStore.this.checkMessageStoreOpen();
            this.doPreCommitActions();
            AbstractJDBCMessageStore.this.commitTran(this._connWrapper);
            AbstractJDBCMessageStore.this.storedSizeChange(this._storeSizeIncrease);
            this.doPostCommitActions();
        }

        @Override
        public <X> ListenableFuture<X> commitTranAsync(X val) {
            AbstractJDBCMessageStore.this.checkMessageStoreOpen();
            this.doPreCommitActions();
            ListenableFuture futureResult = AbstractJDBCMessageStore.this.commitTranAsync(this._connWrapper, val);
            AbstractJDBCMessageStore.this.storedSizeChange(this._storeSizeIncrease);
            this.doPostCommitActions();
            return futureResult;
        }

        private void doPreCommitActions() {
            for (Runnable action : this._preCommitActions) {
                action.run();
            }
            this._preCommitActions.clear();
        }

        private void doPostCommitActions() {
            if (!this._postCommitActions.isEmpty()) {
                for (Runnable action : this._postCommitActions) {
                    action.run();
                }
                this._postCommitActions.clear();
            }
        }

        @Override
        public void abortTran() {
            AbstractJDBCMessageStore.this.checkMessageStoreOpen();
            this._preCommitActions.clear();
            AbstractJDBCMessageStore.this.abortTran(this._connWrapper);
        }

        @Override
        public void removeXid(Transaction.StoredXidRecord record) {
            AbstractJDBCMessageStore.this.checkMessageStoreOpen();
            AbstractJDBCMessageStore.this.removeXid(this._connWrapper, record.getFormat(), record.getGlobalId(), record.getBranchId());
        }

        @Override
        public Transaction.StoredXidRecord recordXid(long format, byte[] globalId, byte[] branchId, Transaction.EnqueueRecord[] enqueues, Transaction.DequeueRecord[] dequeues) {
            AbstractJDBCMessageStore.this.checkMessageStoreOpen();
            this._postCommitActions.addAll(AbstractJDBCMessageStore.this.recordXid(this._connWrapper, format, globalId, branchId, enqueues, dequeues));
            return new JDBCStoredXidRecord(format, globalId, branchId);
        }
    }

    private static class RecordImpl
    implements Transaction.EnqueueRecord,
    Transaction.DequeueRecord,
    TransactionLogResource,
    EnqueueableMessage {
        private final JDBCEnqueueRecord _record;
        private long _messageNumber;
        private UUID _queueId;

        public RecordImpl(UUID queueId, long messageNumber) {
            this._messageNumber = messageNumber;
            this._queueId = queueId;
            this._record = new JDBCEnqueueRecord(queueId, messageNumber);
        }

        @Override
        public MessageEnqueueRecord getEnqueueRecord() {
            return this._record;
        }

        @Override
        public TransactionLogResource getResource() {
            return this;
        }

        @Override
        public EnqueueableMessage getMessage() {
            return this;
        }

        @Override
        public long getMessageNumber() {
            return this._messageNumber;
        }

        @Override
        public boolean isPersistent() {
            return true;
        }

        public StoredMessage getStoredMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            return this._queueId.toString();
        }

        @Override
        public UUID getId() {
            return this._queueId;
        }

        @Override
        public MessageDurability getMessageDurability() {
            return MessageDurability.DEFAULT;
        }
    }

    private static final class ConnectionWrapper {
        private final Connection _connection;

        public ConnectionWrapper(Connection conn) {
            this._connection = conn;
        }

        public Connection getConnection() {
            return this._connection;
        }
    }
}

