/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectJacksonModule;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.JdbcUtils;
import org.apache.qpid.server.store.MessageStoreProvider;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.handler.ConfiguredObjectRecordHandler;
import org.slf4j.Logger;

public abstract class AbstractJDBCConfigurationStore
implements MessageStoreProvider,
DurableConfigurationStore {
    private static final String CONFIGURATION_VERSION_TABLE_NAME_SUFFIX = "QPID_CONFIG_VERSION";
    private static final String CONFIGURED_OBJECTS_TABLE_NAME_SUFFIX = "QPID_CONFIGURED_OBJECTS";
    private static final String CONFIGURED_OBJECT_HIERARCHY_TABLE_NAME_SUFFIX = "QPID_CONFIGURED_OBJECT_HIERARCHY";
    private static final int DEFAULT_CONFIG_VERSION = 0;
    private State _state = State.CLOSED;
    private final Object _lock = new Object();
    private String _tableNamePrefix = "";

    protected void setTableNamePrefix(String tableNamePrefix) {
        this._tableNamePrefix = tableNamePrefix == null ? "" : tableNamePrefix;
    }

    @Override
    public boolean openConfigurationStore(ConfiguredObjectRecordHandler handler, ConfiguredObjectRecord ... initialRecords) {
        this.changeState(State.CONFIGURED, State.OPEN);
        try {
            Collection<ConfiguredObjectRecordImpl> records = this.doVisitAllConfiguredObjectRecords(handler);
            boolean isNew = records.isEmpty();
            if (isNew) {
                records = Arrays.asList(initialRecords);
                try {
                    Throwable throwable = null;
                    try (Connection conn = this.newConnection();){
                        for (ConfiguredObjectRecord configuredObjectRecord : records) {
                            this.updateConfiguredObject(configuredObjectRecord, true, conn);
                        }
                        conn.commit();
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                }
                catch (SQLException e) {
                    throw new StoreException("Error updating configured objects in database: " + e.getMessage(), e);
                }
            }
            for (ConfiguredObjectRecord configuredObjectRecord : records) {
                handler.handle(configuredObjectRecord);
            }
            return isNew;
        }
        catch (SQLException e) {
            throw new StoreException("Cannot visit configured object records", e);
        }
    }

    @Override
    public void reload(ConfiguredObjectRecordHandler handler) throws StoreException {
        this.assertState(State.OPEN);
        try {
            Collection<ConfiguredObjectRecordImpl> records = this.doVisitAllConfiguredObjectRecords(handler);
            for (ConfiguredObjectRecord configuredObjectRecord : records) {
                handler.handle(configuredObjectRecord);
            }
        }
        catch (SQLException e) {
            throw new StoreException("Cannot visit configured object records", e);
        }
    }

    private String getConfigurationVersionTableName() {
        return this._tableNamePrefix + CONFIGURATION_VERSION_TABLE_NAME_SUFFIX;
    }

    private String getConfiguredObjectsTableName() {
        return this._tableNamePrefix + CONFIGURED_OBJECTS_TABLE_NAME_SUFFIX;
    }

    private String getConfiguredObjectHierarchyTableName() {
        return this._tableNamePrefix + CONFIGURED_OBJECT_HIERARCHY_TABLE_NAME_SUFFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ConfiguredObjectRecordImpl> doVisitAllConfiguredObjectRecords(ConfiguredObjectRecordHandler handler) throws SQLException {
        HashMap<UUID, ConfiguredObjectRecordImpl> configuredObjects = new HashMap<UUID, ConfiguredObjectRecordImpl>();
        ObjectMapper objectMapper = new ObjectMapper();
        try (Connection conn = this.newAutoCommitConnection();){
            ResultSet rs;
            try (PreparedStatement stmt = conn.prepareStatement("SELECT id, object_type, attributes FROM " + this.getConfiguredObjectsTableName());){
                rs = stmt.executeQuery();
                try {
                    while (rs.next()) {
                        String id = rs.getString(1);
                        String objectType = rs.getString(2);
                        String attributes = this.getBlobAsString(rs, 3);
                        ConfiguredObjectRecordImpl configuredObjectRecord = new ConfiguredObjectRecordImpl(UUID.fromString(id), objectType, (Map)objectMapper.readValue(attributes, Map.class));
                        configuredObjects.put(configuredObjectRecord.getId(), configuredObjectRecord);
                    }
                }
                catch (IOException e) {
                    throw new StoreException("Error recovering persistent state: " + e.getMessage(), e);
                }
                finally {
                    rs.close();
                }
            }
            stmt = conn.prepareStatement("SELECT child_id, parent_type, parent_id FROM " + this.getConfiguredObjectHierarchyTableName());
            try {
                rs = stmt.executeQuery();
                Throwable throwable = null;
                try {
                    while (rs.next()) {
                        UUID childId = UUID.fromString(rs.getString(1));
                        String parentType = rs.getString(2);
                        UUID parentId = UUID.fromString(rs.getString(3));
                        ConfiguredObjectRecordImpl child = (ConfiguredObjectRecordImpl)configuredObjects.get(childId);
                        ConfiguredObjectRecordImpl parent = (ConfiguredObjectRecordImpl)configuredObjects.get(parentId);
                        if (child == null || parent == null) continue;
                        child.addParent(parentType, parent);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            finally {
                stmt.close();
            }
        }
        return configuredObjects.values();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void upgradeIfNecessary(ConfiguredObject<?> parent) throws StoreException {
        Connection connection = null;
        try {
            connection = this.newAutoCommitConnection();
            boolean tableExists = this.tableExists(this.getConfigurationVersionTableName(), connection);
            if (!tableExists) return;
            int configVersion = this.getConfigVersion(connection);
            this.getLogger().debug("Upgrader read existing config version {}", (Object)configVersion);
            switch (configVersion) {
                case 7: {
                    this.upgradeFromV7(parent);
                    return;
                }
                default: {
                    throw new UnsupportedOperationException("Cannot upgrade from configuration version : " + configVersion);
                }
            }
        }
        catch (SQLException se) {
            throw new StoreException("Failed to upgrade database", se);
        }
        finally {
            JdbcUtils.closeConnection(connection, this.getLogger());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeFromV7(ConfiguredObject<?> parent) throws SQLException {
        HashMap<String, String> defaultExchanges = new HashMap<String, String>(){
            {
                this.put("amq.direct", "direct");
                this.put("amq.topic", "topic");
                this.put("amq.fanout", "fanout");
                this.put("amq.match", "headers");
            }
        };
        try (Connection connection = this.newConnection();){
            UUID id;
            String virtualHostName = parent.getName();
            UUID virtualHostId = UUIDGenerator.generateVhostUUID(virtualHostName);
            String stringifiedConfigVersion = "0.0";
            boolean tableExists = this.tableExists(this.getConfigurationVersionTableName(), connection);
            if (tableExists) {
                int configVersion = this.getConfigVersion(connection);
                this.getLogger().debug("Upgrader read existing config version {}", (Object)configVersion);
                stringifiedConfigVersion = "0." + configVersion;
            }
            HashMap<String, String> virtualHostAttributes = new HashMap<String, String>();
            virtualHostAttributes.put("modelVersion", stringifiedConfigVersion);
            virtualHostAttributes.put("name", virtualHostName);
            ConfiguredObjectRecordImpl virtualHostRecord = new ConfiguredObjectRecordImpl(virtualHostId, "VirtualHost", virtualHostAttributes);
            this.insertConfiguredObject(virtualHostRecord, connection);
            this.getLogger().debug("Upgrader created VirtualHost configuration entry with config version {}", (Object)stringifiedConfigVersion);
            HashMap<UUID, Map> bindingsToUpdate = new HashMap<UUID, Map>();
            ArrayList<UUID> others = new ArrayList<UUID>();
            ObjectMapper objectMapper = ConfiguredObjectJacksonModule.newObjectMapper();
            try (PreparedStatement stmt = connection.prepareStatement("SELECT id, object_type, attributes FROM " + this.getConfiguredObjectsTableName());){
                try {
                    Throwable throwable = null;
                    try (ResultSet rs = stmt.executeQuery();){
                        while (rs.next()) {
                            id = UUID.fromString(rs.getString(1));
                            String objectType = rs.getString(2);
                            if ("VirtualHost".equals(objectType)) continue;
                            Map attributes = (Map)objectMapper.readValue(this.getBlobAsString(rs, 3), Map.class);
                            if (objectType.endsWith("Binding")) {
                                bindingsToUpdate.put(id, attributes);
                                continue;
                            }
                            if (objectType.equals("Exchange")) {
                                defaultExchanges.remove((String)attributes.get("name"));
                            }
                            others.add(id);
                        }
                    }
                    catch (Throwable x2) {
                        Throwable throwable2 = x2;
                        throw x2;
                    }
                }
                catch (IOException e) {
                    throw new StoreException("Error recovering persistent state: " + e.getMessage(), e);
                }
            }
            stmt = connection.prepareStatement("INSERT INTO " + this.getConfiguredObjectHierarchyTableName() + " ( child_id, parent_type, parent_id) VALUES (?,?,?)");
            try {
                for (UUID uUID : others) {
                    stmt.setString(1, uUID.toString());
                    stmt.setString(2, "VirtualHost");
                    stmt.setString(3, virtualHostId.toString());
                    stmt.execute();
                }
                for (Map.Entry entry : bindingsToUpdate.entrySet()) {
                    stmt.setString(1, ((UUID)entry.getKey()).toString());
                    stmt.setString(2, "Queue");
                    stmt.setString(3, ((Map)entry.getValue()).remove("queue").toString());
                    stmt.execute();
                    stmt.setString(1, ((UUID)entry.getKey()).toString());
                    stmt.setString(2, "Exchange");
                    stmt.setString(3, ((Map)entry.getValue()).remove("exchange").toString());
                    stmt.execute();
                }
            }
            finally {
                stmt.close();
            }
            for (Map.Entry entry : defaultExchanges.entrySet()) {
                id = UUIDGenerator.generateExchangeUUID((String)entry.getKey(), virtualHostName);
                HashMap<String, Object> exchangeAttributes = new HashMap<String, Object>();
                exchangeAttributes.put("name", entry.getKey());
                exchangeAttributes.put("type", entry.getValue());
                exchangeAttributes.put("lifetimePolicy", "PERMANENT");
                Map<String, UUID> parents = Collections.singletonMap("VirtualHost", virtualHostRecord.getId());
                org.apache.qpid.server.store.ConfiguredObjectRecordImpl exchangeRecord = new org.apache.qpid.server.store.ConfiguredObjectRecordImpl(id, "Exchange", exchangeAttributes, parents);
                this.insertConfiguredObject(exchangeRecord, connection);
            }
            stmt = connection.prepareStatement("UPDATE " + this.getConfiguredObjectsTableName() + " set object_type =?, attributes = ? where id = ?");
            try {
                for (Map.Entry entry : bindingsToUpdate.entrySet()) {
                    stmt.setString(1, "Binding");
                    byte[] attributesAsBytes = objectMapper.writeValueAsBytes(entry.getValue());
                    ByteArrayInputStream bis = new ByteArrayInputStream(attributesAsBytes);
                    stmt.setBinaryStream(2, (InputStream)bis, attributesAsBytes.length);
                    stmt.setString(3, ((UUID)entry.getKey()).toString());
                    stmt.execute();
                }
            }
            catch (IOException e) {
                throw new StoreException("Error recovering persistent state: " + e.getMessage(), e);
            }
            finally {
                stmt.close();
            }
            if (tableExists) {
                this.dropConfigVersionTable(connection);
            }
            connection.commit();
        }
    }

    protected abstract Logger getLogger();

    protected abstract String getSqlBlobType();

    protected abstract String getSqlVarBinaryType(int var1);

    protected abstract String getSqlBigIntType();

    protected void createOrOpenConfigurationStoreDatabase() throws StoreException {
        Connection conn = null;
        try {
            conn = this.newAutoCommitConnection();
            this.createConfiguredObjectsTable(conn);
            this.createConfiguredObjectHierarchyTable(conn);
        }
        catch (SQLException e) {
            throw new StoreException("Unable to open configuration tables", e);
        }
        finally {
            JdbcUtils.closeConnection(conn, this.getLogger());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropConfigVersionTable(Connection conn) throws SQLException {
        if (!this.tableExists(this.getConfigurationVersionTableName(), conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("DROP TABLE " + this.getConfigurationVersionTableName());
            }
        }
    }

    private void createConfiguredObjectsTable(Connection conn) throws SQLException {
        if (!this.tableExists(this.getConfiguredObjectsTableName(), conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE " + this.getConfiguredObjectsTableName() + " ( id VARCHAR(36) not null, object_type varchar(255), attributes " + this.getSqlBlobType() + ",  PRIMARY KEY (id))");
            }
        }
    }

    private void createConfiguredObjectHierarchyTable(Connection conn) throws SQLException {
        if (!this.tableExists(this.getConfiguredObjectHierarchyTableName(), conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE " + this.getConfiguredObjectHierarchyTableName() + " ( child_id VARCHAR(36) not null, parent_type varchar(255), parent_id VARCHAR(36),  PRIMARY KEY (child_id, parent_type))");
            }
        }
    }

    protected boolean tableExists(String tableName, Connection conn) throws SQLException {
        return JdbcUtils.tableExists(tableName, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getConfigVersion(Connection conn) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            ResultSet rs;
            block8: {
                int n;
                rs = stmt.executeQuery("SELECT version FROM " + this.getConfigurationVersionTableName());
                try {
                    if (!rs.next()) break block8;
                    n = rs.getInt(1);
                }
                catch (Throwable throwable) {
                    rs.close();
                    throw throwable;
                }
                rs.close();
                return n;
            }
            int n = 0;
            rs.close();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(ConfiguredObjectRecord object) throws StoreException {
        this.assertState(State.OPEN);
        try (Connection conn = this.newConnection();){
            this.insertConfiguredObject(object, conn);
            conn.commit();
        }
        catch (SQLException e) {
            throw new StoreException("Error creating ConfiguredObject " + object, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection newAutoCommitConnection() throws SQLException {
        Connection connection = this.newConnection();
        try {
            connection.setAutoCommit(true);
        }
        catch (SQLException sqlEx) {
            try {
                connection.close();
            }
            finally {
                throw sqlEx;
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection newConnection() throws SQLException {
        Connection connection = this.getConnection();
        try {
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(2);
        }
        catch (SQLException sqlEx) {
            try {
                connection.close();
            }
            finally {
                throw sqlEx;
            }
        }
        return connection;
    }

    protected abstract Connection getConnection() throws SQLException;

    private void insertConfiguredObject(ConfiguredObjectRecord configuredObject, Connection conn) throws StoreException {
        block41: {
            try (PreparedStatement stmt = conn.prepareStatement("SELECT object_type, attributes FROM " + this.getConfiguredObjectsTableName() + " where id = ?");){
                boolean exists;
                stmt.setString(1, configuredObject.getId().toString());
                try (ResultSet rs = stmt.executeQuery();){
                    exists = rs.next();
                }
                if (exists) break block41;
                var7_7 = null;
                try (PreparedStatement insertStmt = conn.prepareStatement("INSERT INTO " + this.getConfiguredObjectsTableName() + " ( id, object_type, attributes) VALUES (?,?,?)");){
                    insertStmt.setString(1, configuredObject.getId().toString());
                    insertStmt.setString(2, configuredObject.getType());
                    if (configuredObject.getAttributes() == null) {
                        insertStmt.setNull(3, 2004);
                    } else {
                        Map<String, Object> attributes = configuredObject.getAttributes();
                        ObjectMapper objectMapper = ConfiguredObjectJacksonModule.newObjectMapper();
                        byte[] attributesAsBytes = objectMapper.writeValueAsBytes(attributes);
                        ByteArrayInputStream bis = new ByteArrayInputStream(attributesAsBytes);
                        insertStmt.setBinaryStream(3, (InputStream)bis, attributesAsBytes.length);
                    }
                    insertStmt.execute();
                }
                catch (Throwable throwable) {
                    var7_7 = throwable;
                    throw throwable;
                }
                this.writeHierarchy(configuredObject, conn);
            }
            catch (IOException | SQLException e) {
                throw new StoreException("Error inserting of configured object " + configuredObject + " into database: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public UUID[] remove(ConfiguredObjectRecord ... objects) throws StoreException {
        this.assertState(State.OPEN);
        ArrayList<UUID> removed = new ArrayList<UUID>(objects.length);
        try (Connection conn = this.newAutoCommitConnection();){
            for (ConfiguredObjectRecord record : objects) {
                if (this.removeConfiguredObject(record.getId(), conn) == 0) continue;
                removed.add(record.getId());
            }
        }
        catch (SQLException e) {
            throw new StoreException("Error deleting of configured objects " + Arrays.asList(objects) + " from database: " + e.getMessage(), e);
        }
        return removed.toArray(new UUID[removed.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeConfiguredObject(UUID id, Connection conn) throws SQLException {
        int results;
        try (PreparedStatement stmt = conn.prepareStatement("DELETE FROM " + this.getConfiguredObjectsTableName() + " where id = ?");){
            stmt.setString(1, id.toString());
            results = stmt.executeUpdate();
        }
        stmt = conn.prepareStatement("DELETE FROM " + this.getConfiguredObjectHierarchyTableName() + " where child_id = ?");
        try {
            stmt.setString(1, id.toString());
            stmt.executeUpdate();
        }
        finally {
            stmt.close();
        }
        return results;
    }

    @Override
    public void update(boolean createIfNecessary, ConfiguredObjectRecord ... records) throws StoreException {
        this.assertState(State.OPEN);
        try (Connection conn = this.newConnection();){
            for (ConfiguredObjectRecord record : records) {
                this.updateConfiguredObject(record, createIfNecessary, conn);
            }
            conn.commit();
        }
        catch (SQLException e) {
            throw new StoreException("Error updating configured objects in database: " + e.getMessage(), e);
        }
    }

    private void updateConfiguredObject(ConfiguredObjectRecord configuredObject, boolean createIfNecessary, Connection conn) throws SQLException, StoreException {
        block55: {
            try (PreparedStatement stmt = conn.prepareStatement("SELECT object_type, attributes FROM " + this.getConfiguredObjectsTableName() + " where id = ?");){
                stmt.setString(1, configuredObject.getId().toString());
                try (ResultSet rs = stmt.executeQuery();){
                    ObjectMapper objectMapper = ConfiguredObjectJacksonModule.newObjectMapper();
                    if (rs.next()) {
                        try (PreparedStatement stmt2 = conn.prepareStatement("UPDATE " + this.getConfiguredObjectsTableName() + " set object_type =?, attributes = ? where id = ?");){
                            stmt2.setString(1, configuredObject.getType());
                            if (configuredObject.getAttributes() != null) {
                                byte[] attributesAsBytes = objectMapper.writeValueAsBytes(configuredObject.getAttributes());
                                ByteArrayInputStream bis = new ByteArrayInputStream(attributesAsBytes);
                                stmt2.setBinaryStream(2, (InputStream)bis, attributesAsBytes.length);
                            } else {
                                stmt2.setNull(2, 2004);
                            }
                            stmt2.setString(3, configuredObject.getId().toString());
                            stmt2.execute();
                            break block55;
                        }
                    }
                    if (!createIfNecessary) break block55;
                    try (PreparedStatement insertStmt = conn.prepareStatement("INSERT INTO " + this.getConfiguredObjectsTableName() + " ( id, object_type, attributes) VALUES (?,?,?)");){
                        insertStmt.setString(1, configuredObject.getId().toString());
                        insertStmt.setString(2, configuredObject.getType());
                        if (configuredObject.getAttributes() == null) {
                            insertStmt.setNull(3, 2004);
                        } else {
                            Map<String, Object> attributes = configuredObject.getAttributes();
                            byte[] attributesAsBytes = objectMapper.writeValueAsBytes(attributes);
                            ByteArrayInputStream bis = new ByteArrayInputStream(attributesAsBytes);
                            insertStmt.setBinaryStream(3, (InputStream)bis, attributesAsBytes.length);
                        }
                        insertStmt.execute();
                    }
                    this.writeHierarchy(configuredObject, conn);
                }
            }
            catch (IOException e) {
                throw new StoreException("Error updating configured object " + configuredObject + " in database: " + e.getMessage(), e);
            }
        }
    }

    private void writeHierarchy(ConfiguredObjectRecord configuredObject, Connection conn) throws SQLException, StoreException {
        try (PreparedStatement insertStmt = conn.prepareStatement("INSERT INTO " + this.getConfiguredObjectHierarchyTableName() + " ( child_id, parent_type, parent_id) VALUES (?,?,?)");){
            for (Map.Entry<String, UUID> parentEntry : configuredObject.getParents().entrySet()) {
                insertStmt.setString(1, configuredObject.getId().toString());
                insertStmt.setString(2, parentEntry.getKey());
                insertStmt.setString(3, parentEntry.getValue().toString());
                insertStmt.execute();
            }
        }
    }

    protected abstract String getBlobAsString(ResultSet var1, int var2) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDelete(ConfiguredObject<?> parent) {
        try (Connection conn = this.newAutoCommitConnection();){
            for (String tableName : Arrays.asList(this.getConfiguredObjectsTableName(), this.getConfiguredObjectHierarchyTableName())) {
                try (Statement stmt = conn.createStatement();){
                    stmt.execute("DROP TABLE " + tableName);
                }
            }
        }
        catch (SQLException e) {
            this.getLogger().error("Exception while deleting store tables", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void assertState(State state) {
        Object object = this._lock;
        synchronized (object) {
            if (this._state != state) {
                throw new IllegalStateException("The store must be in state " + (Object)((Object)state) + " to perform this operation, but it is in state " + (Object)((Object)this._state) + " instead");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void changeState(State oldState, State newState) {
        Object object = this._lock;
        synchronized (object) {
            this.assertState(oldState);
            this._state = newState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setState(State newState) {
        Object object = this._lock;
        synchronized (object) {
            this._state = newState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doIfNotState(State state, Runnable action) {
        Object object = this._lock;
        synchronized (object) {
            if (this._state != state) {
                action.run();
            }
        }
    }

    private static final class ConfiguredObjectRecordImpl
    implements ConfiguredObjectRecord {
        private final UUID _id;
        private final String _type;
        private final Map<String, Object> _attributes;
        private final Map<String, UUID> _parents = new HashMap<String, UUID>();

        private ConfiguredObjectRecordImpl(UUID id, String type, Map<String, Object> attributes) {
            this._id = id;
            this._type = type;
            this._attributes = Collections.unmodifiableMap(attributes);
        }

        @Override
        public UUID getId() {
            return this._id;
        }

        @Override
        public String getType() {
            return this._type;
        }

        private void addParent(String parentType, ConfiguredObjectRecord parent) {
            this._parents.put(parentType, parent.getId());
        }

        @Override
        public Map<String, Object> getAttributes() {
            return this._attributes;
        }

        @Override
        public Map<String, UUID> getParents() {
            return Collections.unmodifiableMap(this._parents);
        }

        public String toString() {
            return "ConfiguredObjectRecordImpl [_id=" + this._id + ", _type=" + this._type + ", _attributes=" + this._attributes + ", _parents=" + this._parents + "]";
        }
    }

    public static enum State {
        CLOSED,
        CONFIGURED,
        OPEN;

    }
}

