/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.stats;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsCounter {
    private static final Logger _log = LoggerFactory.getLogger(StatisticsCounter.class);
    public static final long DEFAULT_SAMPLE_PERIOD = Long.getLong("qpid.statistics.samplePeriod", 2000L);
    private static final String COUNTER = "counter";
    private static final AtomicLong _counterIds = new AtomicLong(0L);
    private final long _period;
    private final String _name;
    private AtomicReference<Sample> _currentSample = new AtomicReference();

    public StatisticsCounter() {
        this(COUNTER);
    }

    public StatisticsCounter(String name) {
        this(name, DEFAULT_SAMPLE_PERIOD);
    }

    public StatisticsCounter(String name, long period) {
        this._period = period;
        this._name = name + "-" + _counterIds.incrementAndGet();
        this._currentSample.set(new Sample(period));
    }

    public void registerEvent(long value) {
        this.registerEvent(value, System.currentTimeMillis());
    }

    public void registerEvent(long value, long timestamp) {
        Sample currentSample;
        while (!(currentSample = this.getSample()).add(value, timestamp)) {
            Sample nextSample = new Sample(timestamp, currentSample);
            this._currentSample.compareAndSet(currentSample, nextSample);
        }
    }

    private void update() {
        this.registerEvent(0L, System.currentTimeMillis());
    }

    public void reset() {
        _log.info("Resetting statistics for counter: " + this._name);
        this._currentSample.set(new Sample(this._period));
    }

    public double getPeak() {
        this.update();
        return (double)this.getSample().getPeakSampleTotal() / ((double)this._period / 1000.0);
    }

    private Sample getSample() {
        return this._currentSample.get();
    }

    public double getRate() {
        this.update();
        return (double)this.getSample().getPreviousSampleTotal() / ((double)this._period / 1000.0);
    }

    public long getTotal() {
        return this.getSample().getCumulativeTotal();
    }

    public long getStart() {
        return this.getSample().getStart();
    }

    public String getName() {
        return this._name;
    }

    public long getPeriod() {
        return this._period;
    }

    private static final class Sample {
        private final long _sampleId;
        private final AtomicLong _sampleTotal = new AtomicLong();
        private final AtomicLong _cumulativeTotal;
        private final long _peakTotal;
        private final long _previousSampleTotal;
        private final long _start;
        private final long _period;

        private Sample(long period) {
            this._period = period;
            this._cumulativeTotal = new AtomicLong();
            this._peakTotal = 0L;
            this._previousSampleTotal = 0L;
            this._start = System.currentTimeMillis();
            this._sampleId = 0L;
        }

        private Sample(long timestamp, Sample priorSample) {
            this._period = priorSample._period;
            this._cumulativeTotal = priorSample._cumulativeTotal;
            this._peakTotal = priorSample.getSampleTotal() > priorSample.getPeakSampleTotal() ? priorSample.getSampleTotal() : priorSample.getPeakSampleTotal();
            this._previousSampleTotal = priorSample.getSampleTotal();
            this._start = priorSample._start;
            this._sampleId = (timestamp - this._start) / this._period;
        }

        public long getCumulativeTotal() {
            return this._cumulativeTotal.get();
        }

        public long getSampleTotal() {
            return this._sampleTotal.get();
        }

        public long getPeakSampleTotal() {
            return this._peakTotal;
        }

        public long getPreviousSampleTotal() {
            return this._previousSampleTotal;
        }

        public long getStart() {
            return this._start;
        }

        public boolean add(long value, long timestamp) {
            if (timestamp >= this._start) {
                long eventSampleId = (timestamp - this._start) / this._period;
                if (eventSampleId > this._sampleId) {
                    return false;
                }
                this._cumulativeTotal.addAndGet(value);
                if (eventSampleId == this._sampleId) {
                    this._sampleTotal.addAndGet(value);
                }
                return true;
            }
            return true;
        }
    }
}

