/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.group;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Group;
import org.apache.qpid.server.model.GroupMember;
import org.apache.qpid.server.model.GroupProvider;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;

@ManagedObject(category=false, type="ManagedGroup")
public class GroupImpl
extends AbstractConfiguredObject<GroupImpl>
implements Group<GroupImpl> {
    public static final String CONFIG_TYPE = "ManagedGroup";

    @ManagedObjectFactoryConstructor
    public GroupImpl(Map<String, Object> attributes, GroupProvider<?> provider) {
        super(GroupImpl.parentsMap(provider), attributes);
    }

    @Override
    protected <C extends ConfiguredObject> ListenableFuture<C> addChildAsync(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        if (childClass == GroupMember.class) {
            return this.getObjectFactory().createAsync(childClass, attributes, this);
        }
        return super.addChildAsync(childClass, attributes, otherParents);
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.QUIESCED, State.ERRORED}, desiredState=State.ACTIVE)
    private ListenableFuture<Void> activate() {
        this.setState(State.ACTIVE);
        return Futures.immediateFuture(null);
    }

    @StateTransition(currentState={State.ACTIVE}, desiredState=State.DELETED)
    private ListenableFuture<Void> doDelete() {
        this.deleted();
        return Futures.immediateFuture(null);
    }
}

