/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.sasl.scram;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.security.sasl.SaslException;
import org.apache.qpid.server.security.auth.sasl.scram.ScramSaslServerSource;

public class ScramSaslServerSourceAdapter
implements ScramSaslServerSource {
    private static final byte[] INT_1 = new byte[]{0, 0, 0, 1};
    private final int _iterationCount;
    private final String _hmacName;
    private final SecureRandom _random = new SecureRandom();
    private final PasswordSource _passwordSource;
    private final String _digestName;

    public ScramSaslServerSourceAdapter(int iterationCount, String hmacName, String digestName, PasswordSource passwordSource) {
        this._iterationCount = iterationCount;
        this._hmacName = hmacName;
        this._passwordSource = passwordSource;
        this._digestName = digestName;
    }

    @Override
    public int getIterationCount() {
        return this._iterationCount;
    }

    private Mac createShaHmac(byte[] keyBytes) {
        try {
            SecretKeySpec key = new SecretKeySpec(keyBytes, this._hmacName);
            Mac mac = Mac.getInstance(this._hmacName);
            mac.init(key);
            return mac;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private byte[] computeHmac(byte[] key, String string) {
        Mac mac = this.createShaHmac(key);
        mac.update(string.getBytes(StandardCharsets.US_ASCII));
        return mac.doFinal();
    }

    @Override
    public ScramSaslServerSource.SaltAndPasswordKeys getSaltAndPasswordKeys(String username) {
        byte[] serverKey;
        byte[] storedKey;
        char[] password = this._passwordSource.getPassword(username);
        final byte[] salt = new byte[32];
        final int iterationCount = this.getIterationCount();
        this._random.nextBytes(salt);
        if (password != null) {
            try {
                byte[] passwordAsBytes = new byte[password.length];
                for (int i = 0; i < password.length; ++i) {
                    passwordAsBytes[i] = (byte)password[i];
                }
                Mac mac = this.createShaHmac(passwordAsBytes);
                mac.update(salt);
                mac.update(INT_1);
                byte[] saltedPassword = mac.doFinal();
                byte[] previous = null;
                for (int i = 1; i < iterationCount; ++i) {
                    mac.update(previous != null ? previous : saltedPassword);
                    previous = mac.doFinal();
                    for (int x = 0; x < saltedPassword.length; ++x) {
                        int n = x;
                        saltedPassword[n] = (byte)(saltedPassword[n] ^ previous[x]);
                    }
                }
                byte[] clientKey = this.computeHmac(saltedPassword, "Client Key");
                storedKey = MessageDigest.getInstance(this._digestName).digest(clientKey);
                serverKey = this.computeHmac(saltedPassword, "Server Key");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            storedKey = null;
            serverKey = null;
        }
        return new ScramSaslServerSource.SaltAndPasswordKeys(){

            @Override
            public byte[] getSalt() {
                return salt;
            }

            @Override
            public byte[] getStoredKey() throws SaslException {
                if (storedKey == null) {
                    throw new SaslException("Authentication Failed");
                }
                return storedKey;
            }

            @Override
            public byte[] getServerKey() throws SaslException {
                if (serverKey == null) {
                    throw new SaslException("Authentication Failed");
                }
                return serverKey;
            }

            @Override
            public int getIterationCount() throws SaslException {
                return iterationCount;
            }
        };
    }

    public static interface PasswordSource {
        public char[] getPassword(String var1);
    }
}

