/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.sasl.scram;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.xml.bind.DatatypeConverter;
import org.apache.qpid.server.security.auth.sasl.scram.ScramSaslServerSource;
import org.apache.qpid.util.Strings;

public class ScramSaslServer
implements SaslServer {
    public final String _mechanism;
    public final String _hmacName;
    public final String _digestName;
    private static final Charset ASCII = Charset.forName("ASCII");
    private final ScramSaslServerSource _authManager;
    private State _state = State.INITIAL;
    private String _nonce;
    private String _username;
    private byte[] _gs2Header;
    private String _serverFirstMessage;
    private String _clientFirstMessageBare;
    private byte[] _serverSignature;
    private ScramSaslServerSource.SaltAndPasswordKeys _saltAndPassword;

    public ScramSaslServer(ScramSaslServerSource authenticationManager, String mechanism, String hmacName, String digestName) {
        this._authManager = authenticationManager;
        this._mechanism = mechanism;
        this._hmacName = hmacName;
        this._digestName = digestName;
    }

    @Override
    public String getMechanismName() {
        return this._mechanism;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        byte[] challenge;
        switch (this._state) {
            case INITIAL: {
                challenge = this.generateServerFirstMessage(response);
                this._state = State.SERVER_FIRST_MESSAGE_SENT;
                break;
            }
            case SERVER_FIRST_MESSAGE_SENT: {
                challenge = this.generateServerFinalMessage(response);
                this._state = State.COMPLETE;
                break;
            }
            case COMPLETE: {
                if (response == null || response.length == 0) {
                    challenge = new byte[]{};
                    break;
                }
            }
            default: {
                throw new SaslException("No response expected in state " + (Object)((Object)this._state));
            }
        }
        return challenge;
    }

    private byte[] generateServerFirstMessage(byte[] response) throws SaslException {
        String clientFirstMessage = new String(response, ASCII);
        if (!clientFirstMessage.startsWith("n")) {
            throw new SaslException("Cannot parse gs2-header");
        }
        String[] parts = clientFirstMessage.split(",");
        if (parts.length < 4) {
            throw new SaslException("Cannot parse client first message");
        }
        this._gs2Header = ("n," + parts[1] + ",").getBytes(ASCII);
        this._clientFirstMessageBare = clientFirstMessage.substring(this._gs2Header.length);
        if (!parts[2].startsWith("n=")) {
            throw new SaslException("Cannot parse client first message");
        }
        this._username = this.decodeUsername(parts[2].substring(2));
        if (!parts[3].startsWith("r=")) {
            throw new SaslException("Cannot parse client first message");
        }
        this._nonce = parts[3].substring(2) + UUID.randomUUID().toString();
        this._saltAndPassword = this._authManager.getSaltAndPasswordKeys(this._username);
        this._serverFirstMessage = "r=" + this._nonce + ",s=" + DatatypeConverter.printBase64Binary((byte[])this._saltAndPassword.getSalt()) + ",i=" + this._saltAndPassword.getIterationCount();
        return this._serverFirstMessage.getBytes(ASCII);
    }

    private String decodeUsername(String username) throws SaslException {
        if (username.contains("=")) {
            String check = username;
            while (check.contains("=")) {
                if ((check = check.substring(check.indexOf(61) + 1)).startsWith("2C") || check.startsWith("3D")) continue;
                throw new SaslException("Invalid username");
            }
            username = username.replace("=2C", ",");
            username = username.replace("=3D", "=");
        }
        return username;
    }

    private byte[] generateServerFinalMessage(byte[] response) throws SaslException {
        try {
            String clientFinalMessage = new String(response, ASCII);
            String[] parts = clientFinalMessage.split(",");
            if (!parts[0].startsWith("c=")) {
                throw new SaslException("Cannot parse client final message");
            }
            if (!Arrays.equals(this._gs2Header, Strings.decodeBase64((String)parts[0].substring(2)))) {
                throw new SaslException("Client final message channel bind data invalid");
            }
            if (!parts[1].startsWith("r=")) {
                throw new SaslException("Cannot parse client final message");
            }
            if (!parts[1].substring(2).equals(this._nonce)) {
                throw new SaslException("Client final message has incorrect nonce value");
            }
            if (!parts[parts.length - 1].startsWith("p=")) {
                throw new SaslException("Client final message does not have proof");
            }
            String clientFinalMessageWithoutProof = clientFinalMessage.substring(0, clientFinalMessage.length() - (1 + parts[parts.length - 1].length()));
            byte[] proofBytes = Strings.decodeBase64((String)parts[parts.length - 1].substring(2));
            String authMessage = this._clientFirstMessageBare + "," + this._serverFirstMessage + "," + clientFinalMessageWithoutProof;
            byte[] storedKey = this._saltAndPassword.getStoredKey();
            byte[] clientSignature = this.computeHmac(storedKey, authMessage);
            for (int i = 0; i < proofBytes.length; ++i) {
                int n = i;
                proofBytes[n] = (byte)(proofBytes[n] ^ clientSignature[i]);
            }
            byte[] storedKeyFromClient = MessageDigest.getInstance(this._digestName).digest(proofBytes);
            if (!Arrays.equals(storedKeyFromClient, storedKey)) {
                throw new SaslException("Authentication failed");
            }
            byte[] serverKey = this._saltAndPassword.getServerKey();
            String finalResponse = "v=" + DatatypeConverter.printBase64Binary((byte[])this.computeHmac(serverKey, authMessage));
            return finalResponse.getBytes(ASCII);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SaslException(e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SaslException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isComplete() {
        return this._state == State.COMPLETE;
    }

    @Override
    public String getAuthorizationID() {
        return this._username;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        throw new IllegalStateException("No security layer supported");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        throw new IllegalStateException("No security layer supported");
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    @Override
    public void dispose() throws SaslException {
    }

    private byte[] computeHmac(byte[] key, String string) throws SaslException, UnsupportedEncodingException {
        Mac mac = this.createShaHmac(key);
        mac.update(string.getBytes(ASCII));
        return mac.doFinal();
    }

    private Mac createShaHmac(byte[] keyBytes) throws SaslException {
        try {
            SecretKeySpec key = new SecretKeySpec(keyBytes, this._hmacName);
            Mac mac = Mac.getInstance(this._hmacName);
            mac.init(key);
            return mac;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SaslException(e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new SaslException(e.getMessage(), e);
        }
    }

    static enum State {
        INITIAL,
        SERVER_FIRST_MESSAGE_SENT,
        COMPLETE;

    }
}

