/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.sasl.plain;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.sasl.plain.PlainPasswordCallback;

public class PlainSaslServer
implements SaslServer {
    public static final String MECHANISM = "PLAIN";
    public static final String AUTHENTICATION_RESULT = "authentication-result";
    private CallbackHandler _cbh;
    private String _authorizationId;
    private boolean _complete = false;
    private volatile AuthenticationResult _authenticationResult;

    public PlainSaslServer(CallbackHandler cbh) {
        this._cbh = cbh;
    }

    @Override
    public String getMechanismName() {
        return MECHANISM;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        AuthenticationResultPreservingAuthorizeCallback authzCb;
        PlainPasswordCallback passwordCb;
        int authzidNullPosition = this.findNullPosition(response, 0);
        if (authzidNullPosition < 0) {
            throw new SaslException("Invalid PLAIN encoding, authzid null terminator not found");
        }
        int authcidNullPosition = this.findNullPosition(response, authzidNullPosition + 1);
        if (authcidNullPosition < 0) {
            throw new SaslException("Invalid PLAIN encoding, authcid null terminator not found");
        }
        try {
            String authzid = new String(response, authzidNullPosition + 1, authcidNullPosition - authzidNullPosition - 1, "utf8");
            int passwordLen = response.length - authcidNullPosition - 1;
            String pwd = new String(response, authcidNullPosition + 1, passwordLen, "utf8");
            NameCallback nameCb = new NameCallback("prompt", authzid);
            passwordCb = new PlainPasswordCallback("prompt", false, pwd);
            authzCb = new AuthenticationResultPreservingAuthorizeCallback(authzid, authzid);
            Callback[] callbacks = new Callback[]{nameCb, passwordCb, authzCb};
            this._cbh.handle(callbacks);
            this._authenticationResult = authzCb.getAuthenticationResult();
        }
        catch (IOException e) {
            if (e instanceof SaslException) {
                throw (SaslException)e;
            }
            throw new SaslException("Error processing data: " + e, e);
        }
        catch (UnsupportedCallbackException e) {
            throw new SaslException("Unable to obtain data from callback handler: " + e, e);
        }
        catch (IllegalArgumentException e) {
            throw new SaslException("Error processing SASL response: " + e.getMessage(), e);
        }
        if (passwordCb.isAuthenticated()) {
            this._complete = true;
        }
        if (authzCb.isAuthorized() && this._complete) {
            this._authorizationId = authzCb.getAuthenticationID();
            return null;
        }
        throw new SaslException("Authentication failed");
    }

    private int findNullPosition(byte[] response, int startPosition) {
        for (int position = startPosition; position < response.length; ++position) {
            if (response[position] != 0) continue;
            return position;
        }
        return -1;
    }

    @Override
    public boolean isComplete() {
        return this._complete;
    }

    @Override
    public String getAuthorizationID() {
        return this._authorizationId;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        throw new SaslException("Unsupported operation");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        throw new SaslException("Unsupported operation");
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (AUTHENTICATION_RESULT.equals(propName)) {
            return this._authenticationResult;
        }
        return null;
    }

    @Override
    public void dispose() throws SaslException {
        this._cbh = null;
    }

    public static class AuthenticationResultPreservingAuthorizeCallback
    extends AuthorizeCallback {
        private volatile AuthenticationResult _authenticationResult;

        public AuthenticationResultPreservingAuthorizeCallback(String authnID, String authzID) {
            super(authnID, authzID);
        }

        public AuthenticationResult getAuthenticationResult() {
            return this._authenticationResult;
        }

        public void setAuthenticationResult(AuthenticationResult authenticationResult) {
            this._authenticationResult = authenticationResult;
        }
    }
}

